/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.mbeans.AutoclassifyMBean;
import com.sun.portal.search.autoclassify.AutoclassifyContext;
import com.sun.portal.search.util.DateParser;
import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class Autoclassify
extends PSResource
implements AutoclassifyMBean {
    private ObjectName objectName = null;
    private String host = null;
    private String serverURL = null;
    private String serverRoot = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$mbeans$Autoclassify == null ? (class$com$sun$portal$search$admin$mbeans$Autoclassify = Autoclassify.class$("com.sun.portal.search.admin.mbeans.Autoclassify")) : class$com$sun$portal$search$admin$mbeans$Autoclassify));
    private com.sun.portal.search.autoclassify.Autoclassify ac = null;
    static /* synthetic */ Class class$com$sun$portal$search$admin$mbeans$Autoclassify;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer.Autoclassify", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.SearchServer.Autoclassify", path, "Host");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        try {
            MBeanServer ms = PASModule.getMBeanServer();
            LinkedList serverpath = new LinkedList();
            serverpath.addFirst(path.get(2));
            serverpath.addFirst(path.get(1));
            ObjectName searchServer = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", serverpath);
            this.serverRoot = (String)ms.getAttribute(searchServer, "SearchServerRoot");
            String searchServerURL = (String)ms.getAttribute(searchServer, "SearchServerURL");
            this.serverURL = searchServerURL + File.separator + "search";
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
    }

    public HashMap getConfig() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                HashMap result = (HashMap)msc.getAttribute(this.objectName, "Config");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Autoclassify:getConfig", e.toString(), (Throwable)e);
            }
        }
        String logPath = null;
        String dbPath = null;
        String hashSize = null;
        try {
            logPath = this.getConfigString("logPath");
            dbPath = this.getConfigString("dbPath");
            hashSize = this.getConfigString("cacheSize");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.autoclassify.config", "Autoclassify.getConfig()", (Throwable)e);
        }
        HashMap<String, String> autoclass = new HashMap<String, String>();
        autoclass.put("LogPath", logPath);
        autoclass.put("DbPath", dbPath);
        autoclass.put("HashSize", hashSize);
        return autoclass;
    }

    public Boolean setConfig(String logPath, String dbPath, String cacheSize) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{logPath, dbPath, cacheSize};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "setConfig", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Autoclassify:setConfig", e.toString(), (Throwable)e);
            }
        }
        try {
            MBeanServer ms = PASModule.getMBeanServer();
            LinkedList serverpath = new LinkedList();
            serverpath.addFirst(this.path.get(2));
            serverpath.addFirst(this.path.get(1));
            ObjectName objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", serverpath);
            String[] signature = new String[]{"java.lang.String", "java.lang.String"};
            if (logPath != null && !logPath.equals("")) {
                Object[] params1 = new Object[]{"autoclass-logfilepath", logPath};
                ms.invoke(objName, "setConfigValue", params1, signature);
            }
            if (dbPath != null && !dbPath.equals("")) {
                Object[] params2 = new Object[]{"autoclass-dbfilepath", dbPath};
                ms.invoke(objName, "setConfigValue", params2, signature);
            }
            if (cacheSize != null && !cacheSize.equals("")) {
                Object[] params3 = new Object[]{"autoclass-rdsinmemory", cacheSize};
                ms.invoke(objName, "setConfigValue", params3, signature);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.autoclassify.config", "Autoclassify.setConfig()", (Throwable)e);
        }
        return Boolean.TRUE;
    }

    public String runAutoclassify(ArrayList dbs, String localeStr, String startDate) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{dbs, localeStr, startDate};
                String[] signatures = new String[]{"java.util.ArrayList", "java.lang.String", "java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "runAutoclassify", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Autoclassify:runAutoclassify", e.toString(), (Throwable)e);
            }
        }
        StringBuffer sb = new StringBuffer();
        if (dbs != null) {
            for (int i = 0; i < dbs.size(); ++i) {
                String name = (String)dbs.get(i);
                sb.append(this.runAutoclassify(name, localeStr, startDate));
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public String runAutoclassify(String dbname, String localeStr, String startDate) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{dbname, localeStr, startDate};
                String[] signatures = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "runAutoclassify", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Autoclassify:runAutoclassify", e.toString(), (Throwable)e);
            }
        }
        String result = null;
        if (localeStr == null || localeStr.equals("")) {
            localeStr = "en_US";
        }
        if (this.serverRoot == null || this.serverURL == null) {
            Object[] tokens = new Object[]{"Autoclassify.runAutoclassify(): cannot run autoclassify because serverRoot or serverURL is null."};
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0002", tokens);
            return "";
        }
        String[] codes = this.split(localeStr, "_");
        Locale locale = codes.length >= 2 ? new Locale(codes[0], codes[1]) : Locale.getDefault();
        AutoclassifyContext context = new AutoclassifyContext();
        ResourceBundle rb = ResourceBundle.getBundle("autoclassify", locale);
        context.setResourceBundle(rb);
        context.setUILocale(locale);
        try {
            Date lastRun = null;
            if (startDate != null && !startDate.equals("")) {
                lastRun = DateParser.parse((String)startDate);
            }
            this.ac = new com.sun.portal.search.autoclassify.Autoclassify(context, this.serverRoot, lastRun, this.serverURL);
            String logPath = this.getConfigString("LogPath");
            String dbPath = this.getConfigString("dbPath");
            String hashSize = this.getConfigString("cacheSize");
            result = this.ac.doAutoclassify(this.serverRoot, dbname, dbPath, Integer.parseInt(hashSize));
            this.ac.shutdown();
        }
        catch (PSMBeanException e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
        }
        return result;
    }

    public String getConfigString(String config) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{config};
                String[] signatures = new String[]{"java.lang.String"};
                String result = (String)msc.invoke(this.objectName, "getConfigString", params, signatures);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
                throw new PSMBeanException("Autoclassify:getConfigString", e.toString(), (Throwable)e);
            }
        }
        try {
            MBeanServer ms = PASModule.getMBeanServer();
            LinkedList serverpath = new LinkedList();
            serverpath.addFirst(this.path.get(2));
            serverpath.addFirst(this.path.get(1));
            ObjectName objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", serverpath);
            String[] signature = new String[]{"java.lang.String"};
            if (config.equalsIgnoreCase("logPath")) {
                Object[] params1 = new Object[]{"autoclass-logfilepath"};
                String logPath = (String)ms.invoke(objName, "getConfigValue", params1, signature);
                if (logPath == null) {
                    String logDir = (String)ms.getAttribute(objName, "LogDir");
                    logPath = logDir + File.separator + "autoclassify.log";
                }
                return logPath;
            }
            if (config.equalsIgnoreCase("dbPath")) {
                Object[] params2 = new Object[]{"autoclass-dbfilepath"};
                String dbPath = (String)ms.invoke(objName, "getConfigValue", params2, signature);
                if (dbPath == null) {
                    String tmpDir = (String)ms.getAttribute(objName, "TmpDir");
                    dbPath = tmpDir + File.separator + "RDStore.db";
                }
                return dbPath;
            }
            if (config.equalsIgnoreCase("cacheSize")) {
                Object[] params3 = new Object[]{"autoclass-rdsinmemory"};
                String hashSize = (String)ms.invoke(objName, "getConfigValue", params3, signature);
                if (hashSize == null) {
                    hashSize = Integer.toString(10000);
                }
                return hashSize;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSSH_CSPSAMB0003", e);
            throw new PSMBeanException("errorcode.search.autoclassify.config", "Autoclassify.getConfigString()", (Throwable)e);
        }
        return null;
    }

    private String[] split(String str, String deli) {
        StringTokenizer st = new StringTokenizer(str, deli);
        ArrayList<String> list = new ArrayList<String>();
        boolean index = false;
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        return list.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

