/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.util.SearchConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;

public class RunImportAgent {
    public static final String IMPORTMGR_CMD = "importmgr";
    private String[] r_env = null;
    private boolean isValid = false;
    private boolean isRunning = false;
    private boolean isQuery = false;
    static final String rCmd = "cmd";
    static final String rQuery = "query";
    private String binDir = "";
    private String libDir = "";
    private String libPath = "";
    private String serverRoot = "";
    private String configDir = "";
    private String logDir = "";
    private boolean wait = true;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$cli$RunImportAgent == null ? (class$com$sun$portal$search$admin$cli$RunImportAgent = RunImportAgent.class$("com.sun.portal.search.admin.cli.RunImportAgent")) : class$com$sun$portal$search$admin$cli$RunImportAgent));
    static /* synthetic */ Class class$com$sun$portal$search$admin$cli$RunImportAgent;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage:RunImportAgent server_root action");
            return;
        }
        CSConfig.init(args[0]);
        RunImportAgent impAgent = new RunImportAgent(CSConfig.getServerRoot(), CSConfig.getBinPath(), CSConfig.getLibDir(), CSConfig.getLibPath(), null, null);
        impAgent.command(args[1]);
    }

    public RunImportAgent(String in_serverRootPath, String in_binPath, String in_libDir, String in_libPath, String in_configPath, String in_logPath) {
        SearchConfig csidConf = SearchConfig.getSearchConfig();
        if (in_serverRootPath != null) {
            this.serverRoot = in_serverRootPath;
            if (in_binPath != null) {
                this.binDir = in_binPath;
            }
            if (in_libPath != null) {
                this.libPath = in_libPath;
            }
            if (in_libDir != null) {
                this.libDir = in_libDir;
            }
        } else {
            this.serverRoot = CSConfig.getServerRoot();
            this.binDir = CSConfig.getBinPath();
            this.libDir = CSConfig.getLibDir();
            this.libPath = CSConfig.getLibPath();
        }
        this.configDir = in_configPath != null ? in_configPath : this.serverRoot + File.separator + "config";
        this.logDir = in_logPath != null ? in_logPath : this.serverRoot + File.separator + "logs";
        this.r_env = RunImportAgent.isWindows() ? new String[6] : new String[5];
        this.r_env[0] = "LD_LIBRARY_PATH=" + this.libPath;
        this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
        this.r_env[2] = "CS_LOGDIR=" + this.logDir;
        this.r_env[3] = "PATH=" + this.libPath + ":" + this.binDir;
        this.r_env[4] = "CAT_SERVER_ROOT=" + this.serverRoot;
        if (RunImportAgent.isWindows()) {
            String comSpecKey;
            String comSpecVal;
            String winDir = "C:\\WINNT";
            if (System.getProperty("os.name").equals("Windows XP")) {
                winDir = "C:\\WINDOWS";
            }
            if ((comSpecVal = System.getProperty(comSpecKey = "COMSPEC")) == null || "".equals(comSpecVal.trim())) {
                comSpecVal = winDir + "\\system32\\cmd.exe";
            }
            this.r_env[5] = comSpecKey + "=" + comSpecVal;
        }
    }

    public void command(String action) {
        if (action.compareToIgnoreCase("Run") == 0) {
            this.run(null);
        }
    }

    public synchronized void run(JspWriter out) {
        debugLogger.finer("PSSH_CSPSAC0012");
        SearchConfig.getSearchConfig();
        String csid = SearchConfig.getValue((String)"csid");
        String cmd = this.libDir + File.separator + IMPORTMGR_CMD + " -c " + this.configDir + File.separator + "search.conf" + " " + csid + " run all";
        String[] stringArray = new String[6];
        stringArray[0] = this.libDir + File.separator + IMPORTMGR_CMD;
        stringArray[1] = "-c";
        stringArray[2] = this.configDir + File.separator + "search.conf";
        stringArray[3] = csid;
        stringArray[4] = "run";
        stringArray[5] = "all";
        String[] cmds = stringArray;
        debugLogger.log(Level.FINER, "PSSH_CSPSAC0001", cmd);
        Runtime rt = Runtime.getRuntime();
        try {
            if (out != null) {
                out.flush();
            }
            Process ps = rt.exec(cmds, this.r_env);
            BufferedReader buf = new BufferedReader(new InputStreamReader(ps.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                if (out == null) continue;
                out.println(outLine);
                out.flush();
            }
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
        }
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

