/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.NumberFormat;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RobotController {
    static final String ROBOT_CMD = "robot";
    static final String CATPING_CMD = "catping";
    static final String RDREGISTER_CMD = "rdregister";
    private String[] r_env = null;
    private boolean isValid = false;
    private boolean isRunning = false;
    private boolean isQuery = false;
    static final String rCmd = "cmd";
    static final String rQuery = "query";
    private String binDir = "";
    private String libDir = "";
    private String libPath = "";
    private String serverRoot = "";
    private String configDir = "";
    private String logDir = "";
    private String statusDir = "robot";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$cli$RobotController == null ? (class$com$sun$portal$search$admin$cli$RobotController = RobotController.class$("com.sun.portal.search.admin.cli.RobotController")) : class$com$sun$portal$search$admin$cli$RobotController));
    static /* synthetic */ Class class$com$sun$portal$search$admin$cli$RobotController;

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Usage:RobotController server_root action");
            return;
        }
        CSConfig.init(args[0]);
        RobotController rc = new RobotController(CSConfig.getServerRoot(), CSConfig.getBinPath(), CSConfig.getLibDir(), CSConfig.getLibPath(), null, null, null);
        if (args[1].startsWith("q:")) {
            rc.query(args[1].substring(2));
        } else {
            System.out.print("Executing Robot command:" + args[1] + "....");
            if (rc.command(args[1])) {
                System.out.println("Success.");
            } else {
                System.out.println("Failed.");
            }
        }
    }

    public RobotController(String in_serverRootPath, String in_binPath, String in_libDir, String in_libPath, String in_configPath, String in_logPath, String in_statusPath) {
        if (in_serverRootPath != null) {
            this.serverRoot = in_serverRootPath;
        }
        if (in_binPath != null) {
            this.binDir = in_binPath;
        }
        if (in_libPath != null) {
            this.libPath = in_libPath;
        }
        if (in_libDir != null) {
            this.libDir = in_libDir;
        }
        this.configDir = in_configPath != null ? in_configPath : this.serverRoot + File.separator + "config";
        this.logDir = in_logPath != null ? in_logPath : this.serverRoot + File.separator + "logs";
        if (in_statusPath != null) {
            this.statusDir = in_statusPath;
        } else {
            this.statusDir = CSConfig.getRobotConfig().processConf.get("robot-state-dir");
            if (this.statusDir == null) {
                this.statusDir = this.serverRoot + File.separator + ROBOT_CMD;
            }
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSAC0004", System.getProperty("os.name"));
        if (System.getProperty("os.name").startsWith("Windows")) {
            String winDir = "C:\\WINNT";
            if (System.getProperty("os.name").equals("Windows XP")) {
                winDir = "C:\\WINDOWS";
            }
            this.r_env = new String[6];
            this.r_env[0] = "LD_LIBRARY_PATH=" + this.libPath;
            this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
            this.r_env[2] = "CS_LOGDIR=" + this.logDir;
            this.r_env[3] = "PATH=" + this.libPath + ";" + this.binDir;
            String SYSTEMROOT = "SYSTEMROOT";
            String sysRootVal = System.getProperty(SYSTEMROOT);
            debugLogger.log(Level.FINER, "PSSH_CSPSAC0014", new String[]{SYSTEMROOT, sysRootVal});
            if (sysRootVal == null) {
                sysRootVal = winDir;
            }
            String COMSPEC = "COMSPEC";
            String comSpecVal = System.getProperty(COMSPEC);
            debugLogger.log(Level.FINER, "PSSH_CSPSAC0005", new String[]{COMSPEC, comSpecVal});
            if (comSpecVal == null) {
                comSpecVal = winDir + "\\system32\\cmd.exe";
            }
            this.r_env[4] = SYSTEMROOT + "=" + sysRootVal;
            this.r_env[5] = COMSPEC + "=" + comSpecVal;
        } else {
            this.r_env = new String[4];
            this.r_env[0] = "LD_LIBRARY_PATH=/usr/lib:" + this.libPath;
            this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
            this.r_env[2] = "CS_LOGDIR=" + this.logDir;
            this.r_env[3] = "PATH=" + this.libPath + ":" + this.binDir;
        }
    }

    public boolean command(String action) {
        if (action.compareToIgnoreCase("Start") == 0) {
            return this.start();
        }
        if (action.compareToIgnoreCase("Stop") == 0) {
            return this.stop();
        }
        if (action.compareToIgnoreCase("pause") == 0) {
            this.pause();
        } else if (action.compareToIgnoreCase("resume") == 0) {
            this.resume();
        } else if (action.compareToIgnoreCase("freshstart") == 0) {
            this.remove_status_files();
        } else {
            byte[] result = this.robotURLGet(rCmd, action);
            if (result != null) {
                String rs = new String(result);
                System.out.println(rs);
            }
        }
        return true;
    }

    public void query(String action) {
        byte[] result = this.robotURLGet(rQuery, action);
        if (result != null) {
            String rs = new String(result);
            System.out.println(rs);
        }
    }

    public boolean start_rdregister() {
        String rdProcName = RDREGISTER_CMD;
        if (System.getProperty("os.name").startsWith("Windows")) {
            rdProcName = "rdregister.exe";
        }
        if (this.isRunning("rdregister.pid", rdProcName)) {
            return true;
        }
        try {
            File file;
            String robot_path = CSConfig.getRobotConfig().processConf.get("robot-state-dir");
            if (robot_path == null) {
                robot_path = this.serverRoot + File.separator + ROBOT_CMD;
            }
            if (!(file = new File(robot_path)).exists()) {
                debugLogger.log(Level.FINER, "PSSH_CSPSAC0006", robot_path);
                return false;
            }
            Runtime rt = Runtime.getRuntime();
            String cmd = this.libDir + File.separator + RDREGISTER_CMD + " -f " + this.configDir + File.separator + "search.conf" + " -p " + robot_path;
            String[] cmds = new String[]{this.libDir + File.separator + RDREGISTER_CMD, "-f", this.configDir + File.separator + "search.conf", "-p", robot_path};
            try {
                debugLogger.log(Level.FINER, "PSSH_CSPSAC0001", cmd);
                Process ps = rt.exec(cmds, this.r_env, new File(this.serverRoot));
            }
            catch (IOException e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            return false;
        }
        return true;
    }

    public boolean generate_filter_conf_run(String fc, String fcr) {
        try {
            File file = new File(fc);
            if (!file.exists()) {
                return false;
            }
            Runtime rt = Runtime.getRuntime();
            String cmd = this.libDir + File.separator + "rcpp " + fc + " " + fcr;
            String[] cmds = new String[]{this.libDir + File.separator + "rcpp", fc, fcr};
            try {
                Process ps = rt.exec(cmds, this.r_env, new File(this.serverRoot));
                ps.waitFor();
                if (ps.exitValue() != 0) {
                    return false;
                }
            }
            catch (IOException e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
                return false;
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean remove_status_files() {
        debugLogger.finer("PSSH_CSPSAC0007");
        boolean status = true;
        if (this.isRunning()) {
            return false;
        }
        File f = new File(this.statusDir);
        if (f.isDirectory()) {
            RobotStatusFileFilter ff = new RobotStatusFileFilter();
            File[] files = f.listFiles(ff);
            for (int i = 0; i < files.length; ++i) {
                if (files[i].delete()) continue;
                status = false;
            }
        }
        return status;
    }

    public synchronized boolean start() {
        debugLogger.finer("PSSH_CSPSAC0008");
        if (this.isRunning()) {
            return true;
        }
        if (!this.generate_filter_conf_run(this.configDir + File.separator + "filter.conf", this.configDir + File.separator + "filter.conf.run")) {
            debugLogger.finer("PSSH_CSPSAC0009");
            return false;
        }
        if (!this.start_rdregister()) {
            debugLogger.finer("PSSH_CSPSAC0010");
            return false;
        }
        Runtime rt = Runtime.getRuntime();
        try {
            String[] cmds = new String[]{this.libDir + File.separator + ROBOT_CMD};
            rt.exec(cmds, this.r_env, new File(this.serverRoot));
            for (int i = 0; i < 10; ++i) {
                byte[] result;
                try {
                    this.wait(1000L);
                }
                catch (Exception e) {
                    debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
                }
                if (!this.isRunning() || (result = this.robotURLGet(rQuery, "run-status")) == null) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            return false;
        }
    }

    private String Read1stLine(String filename) {
        try {
            FileReader in = new FileReader(CSConfig.getServerRoot() + File.separator + "logs" + File.separator + filename);
            BufferedReader lr = new BufferedReader(in);
            String firstLine = lr.readLine();
            return firstLine;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            return null;
        }
    }

    public boolean isPaused() {
        byte[] result = this.robotURLGet(rQuery, "run-status");
        if (result == null) {
            return false;
        }
        String rs = new String(result);
        int ndx = rs.indexOf("Robot Status:");
        if (ndx > 0) {
            String status = rs.substring(ndx + 14);
            return status.startsWith("Paused");
        }
        return false;
    }

    public boolean isRunning() {
        String robotProcName = "robot.exe";
        if (System.getProperty("os.name").startsWith("Windows")) {
            robotProcName = "robot.exe";
        }
        return this.isRunning("robot.pid", robotProcName);
    }

    public boolean isRunning(String pidFilePath, String cmd) {
        String pid = this.Read1stLine(pidFilePath);
        String catping = null;
        if (pid == null) {
            debugLogger.log(Level.FINER, "PSSH_CSPSAC0011", "null");
            return false;
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSAC0011", pid);
        Runtime rt = Runtime.getRuntime();
        try {
            catping = this.libDir + File.separator + CATPING_CMD + " " + pid + " " + cmd;
            String[] cmds = new String[]{this.libDir + File.separator + CATPING_CMD, pid, cmd};
            Process p = rt.exec(cmds, this.r_env);
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            int exitValue = p.exitValue();
            debugLogger.log(Level.FINER, "PSSH_CSPSAC0013", Integer.toString(exitValue));
            if (exitValue == 1) {
                return false;
            }
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            return false;
        }
        return true;
    }

    public synchronized boolean stop() {
        byte[] result = this.robotURLGet(rCmd, "stop");
        if (result != null) {
            String rs = new String(result);
        }
        for (int i = 0; i < 10; ++i) {
            try {
                this.wait(1000L);
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            }
            if (this.isRunning()) continue;
            return true;
        }
        return false;
    }

    public void pause() {
        byte[] result = this.robotURLGet(rCmd, "pause");
        if (result != null) {
            String rs = new String(result);
            System.out.println(rs);
        }
    }

    public void resume() {
        byte[] result = this.robotURLGet(rCmd, "resume");
        if (result != null) {
            String rs = new String(result);
            System.out.println(rs);
        }
    }

    public String[] getRobotStates() {
        String[] states = new String[]{"", "", "", "", "", "", "", "", "", "", "", ""};
        int url_waiting = 0;
        int processed = 0;
        int retrieved = 0;
        int rej_filter = 0;
        int rej_error = 0;
        int generated = 0;
        long generated_bytes = 0L;
        long run_time = 0L;
        byte[] result = this.robotURLGet(rQuery, "robot-states");
        if (result != null) {
            String rs = new String(result);
            StringTokenizer st = new StringTokenizer(rs, "\n");
            while (st.hasMoreTokens()) {
                String t = st.nextToken();
                if (t.startsWith("Robot Status:")) {
                    states[11] = t.substring(13).trim();
                    continue;
                }
                if (t.startsWith("url-waiting=")) {
                    url_waiting = Integer.parseInt(t.substring(12));
                    continue;
                }
                if (t.startsWith("processed=")) {
                    processed = Integer.parseInt(t.substring(10));
                    continue;
                }
                if (t.startsWith("retrieved=")) {
                    retrieved = Integer.parseInt(t.substring(10));
                    continue;
                }
                if (t.startsWith("reject-by-filter=")) {
                    rej_filter = Integer.parseInt(t.substring(17));
                    continue;
                }
                if (t.startsWith("reject-by-error=")) {
                    rej_error = Integer.parseInt(t.substring(16));
                    continue;
                }
                if (t.startsWith("generated=")) {
                    generated = Integer.parseInt(t.substring(10));
                    continue;
                }
                if (t.startsWith("generated-bytes=")) {
                    generated_bytes = Long.parseLong(t.substring(16));
                    continue;
                }
                if (!t.startsWith("run-time=")) continue;
                run_time = Long.parseLong(t.substring(9));
            }
        }
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMaximumFractionDigits(2);
        states[0] = nf.format(url_waiting);
        if (run_time > 0L) {
            states[1] = nf.format((float)retrieved / (float)run_time);
            states[3] = nf.format((float)generated / (float)run_time);
        }
        states[2] = nf.format(rej_filter + rej_error);
        states[4] = nf.format(rej_filter);
        states[5] = nf.format(rej_error);
        states[6] = nf.format(generated);
        states[7] = Long.toString(generated_bytes);
        states[8] = nf.format(retrieved);
        if (generated > 0) {
            states[9] = nf.format((float)generated_bytes / (float)generated);
        }
        states[10] = Long.toString(run_time);
        return states;
    }

    public byte[] robotURLGet(String cmd, String fn) {
        return this.robotURLGet(cmd + "?fn=" + fn);
    }

    public byte[] robotURLGet(String cmd) {
        try {
            BufferedInputStream in;
            debugLogger.log(Level.FINER, "PSSH_CSPSAC0001", cmd);
            String base = this.Read1stLine("robotbase.cmd");
            if (base == null) {
                return null;
            }
            URL command_url = new URL("http://" + base + "/robot/" + cmd);
            URLConnection url_conn = command_url.openConnection();
            int len = 1024;
            boolean offset = false;
            byte[] buff = new byte[len];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                in = new BufferedInputStream(url_conn.getInputStream());
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
                return null;
            }
            try {
                int n;
                while ((n = ((InputStream)in).read(buff, 0, len)) >= 0) {
                    bos.write(buff, 0, n);
                }
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
                return null;
            }
            try {
                ((InputStream)in).close();
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
                return null;
            }
            return bos.toByteArray();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RobotStatusFileFilter
    implements FileFilter {
        RobotStatusFileFilter() {
        }

        public boolean accept(File path) {
            return path.getName().startsWith("__db.") || path.getName().endsWith(".db");
        }
    }
}

