/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.jsp.JspWriter;

public class CronController {
    private String[] r_env = null;
    private boolean isValid = false;
    private boolean isRunning = false;
    private boolean isQuery = false;
    static final String rCmd = "cmd";
    static final String rQuery = "query";
    private String binDir = "";
    private String libDir = "";
    private String serverRoot = "";
    private String configDir = "";
    private String logDir = "";
    private boolean wait = true;
    static String pscronctl = "pscronctl";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$cli$CronController == null ? (class$com$sun$portal$search$admin$cli$CronController = CronController.class$("com.sun.portal.search.admin.cli.CronController")) : class$com$sun$portal$search$admin$cli$CronController));
    static /* synthetic */ Class class$com$sun$portal$search$admin$cli$CronController;

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage:CronController server_root action");
            return;
        }
        CSConfig.init(args[0]);
        CronController cronControl = new CronController(CSConfig.getServerRoot(), CSConfig.getBinPath(), CSConfig.getLibPath(), null, null);
        cronControl.action(null, args[1]);
    }

    public CronController(String serverRootPath, String binPath, String libPath, String configPath, String logPath) {
        if (serverRootPath != null) {
            this.serverRoot = serverRootPath;
            if (binPath != null) {
                this.binDir = binPath;
            }
            if (libPath != null) {
                this.libDir = libPath;
            }
        } else {
            this.serverRoot = CSConfig.getServerRoot();
            this.binDir = CSConfig.getBinPath();
            this.libDir = CSConfig.getLibPath();
        }
        this.configDir = configPath != null ? configPath : this.serverRoot + File.separator + "config";
        this.logDir = logPath != null ? logPath : this.serverRoot + File.separator + "logs";
        this.r_env = new String[4];
        this.r_env[0] = "LD_LIBRARY_PATH=" + this.libDir;
        this.r_env[1] = "CS_CONFIG_PATH=" + this.configDir;
        this.r_env[2] = "SERVER_ROOT=" + this.serverRoot;
        this.r_env[3] = "BINDIR=" + this.libDir;
    }

    public void action(JspWriter out, String action) {
        if (action.compareToIgnoreCase("start") == 0) {
            this.execute(out, "start");
        } else if (action.compareToIgnoreCase("stop") == 0) {
            this.execute(out, "stop");
        } else if (action.compareToIgnoreCase("restart") == 0) {
            this.execute(out, "restart");
        } else if (action.compareToIgnoreCase("status") == 0) {
            if (out != null) {
                this.execute(out, "status");
            } else {
                System.out.println(this.isRunning() ? "running" : "off");
            }
        }
    }

    public boolean isRunning() {
        Runtime rt = Runtime.getRuntime();
        String cmd = this.libDir + File.separator + pscronctl + " status";
        debugLogger.log(Level.FINER, "PSSH_CSPSAC0001", cmd);
        try {
            Process process = rt.exec(cmd, this.r_env);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                debugLogger.log(Level.FINEST, "PSSH_CSPSAC0002", outLine);
                if (outLine.compareToIgnoreCase("running") != 0) continue;
                return true;
            }
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
        }
        return false;
    }

    public synchronized void execute(JspWriter out, String action) {
        Runtime rt = Runtime.getRuntime();
        String cmd = this.libDir + File.separator + pscronctl + " " + action;
        debugLogger.log(Level.FINER, "PSSH_CSPSAC0001", cmd);
        try {
            if (out != null) {
                out.flush();
            }
            Process process = rt.exec(cmd, this.r_env);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                if (out == null) continue;
                debugLogger.log(Level.FINEST, "PSSH_CSPSAC0002", outLine);
                out.println(outLine);
                out.flush();
            }
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
        }
    }

    public synchronized String execute(String action) {
        String outText = "";
        Runtime rt = Runtime.getRuntime();
        String cmd = this.libDir + File.separator + pscronctl + " " + action;
        debugLogger.log(Level.FINER, "PSSH_CSPSAC0001", cmd);
        try {
            Process process = rt.exec(cmd, this.r_env);
            BufferedReader buf = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String outLine = null;
            while ((outLine = buf.readLine()) != null) {
                outText = outText + outLine;
                debugLogger.log(Level.FINEST, "PSSH_CSPSAC0002", outLine);
            }
        }
        catch (IOException e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0003", e.getMessage());
        }
        return outText;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

