/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.model.TreeModel;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTreeViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.HREF;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSViewBeanBase;
import com.sun.portal.search.admin.TaxonomyBrowserView;
import com.sun.portal.search.admin.model.TaxonomyTreeModel;
import com.sun.portal.search.rdm.RDMClassification;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;

public class TaxonomyBrowserTreeView
extends RequestHandlingTreeViewBase {
    public static final String CHILD_NAME = "name";
    public static final String CHILD_HREF = "Href1";
    public static final String NODE_ID = "nodeId";
    public int currentPage = 1;
    public int nbPages = 1;
    public int nbDisplayable = -1;
    public int maxNbNodesDisplayed;
    public int displayableNodeCounter = 0;
    private int displayedPage = -1;
    private int editedCategory = -1;
    private String editTimeStamp = null;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$TaxonomyBrowserTreeView == null ? (class$com$sun$portal$search$admin$TaxonomyBrowserTreeView = TaxonomyBrowserTreeView.class$("com.sun.portal.search.admin.TaxonomyBrowserTreeView")) : class$com$sun$portal$search$admin$TaxonomyBrowserTreeView));
    static /* synthetic */ Class class$com$sun$portal$search$admin$TaxonomyBrowserTreeView;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$HREF;

    public TaxonomyBrowserTreeView(View parent, String name) throws ModelControlException {
        super(parent, name);
        try {
            this.setPrimaryModel((TreeModel)this.getTaxonomyTreeModel());
            this.registerChildren();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            throw new ModelControlException(e.getMessage());
        }
    }

    protected void registerChildren() {
        try {
            this.registerChild(CHILD_NAME, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = TaxonomyBrowserTreeView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
            this.registerChild(CHILD_HREF, class$com$iplanet$jato$view$html$HREF == null ? (class$com$iplanet$jato$view$html$HREF = TaxonomyBrowserTreeView.class$("com.iplanet.jato.view.html.HREF")) : class$com$iplanet$jato$view$html$HREF);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
    }

    protected View createChild(String name) {
        try {
            StaticTextField child = null;
            if (name.equals(CHILD_NAME)) {
                child = new StaticTextField((View)this, (Model)this.getTaxonomyTreeModel(), CHILD_NAME, CHILD_NAME, (Object)"", null);
                return child;
            }
            if (name.equals(CHILD_HREF)) {
                child = new HREF((ContainerView)this, CHILD_HREF, (Object)"");
                return child;
            }
            debugLogger.log(Level.INFO, "PSSH_CSPSA0002", name);
            if (name != null) {
                throw new IllegalArgumentException("Invalid child name [" + name + "]");
            }
            throw new IllegalArgumentException("Invalid child name [<NULL>]");
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            if (name != null) {
                throw new IllegalArgumentException("Invalid child name [" + name + "]");
            }
            throw new IllegalArgumentException("Invalid child name [<NULL>]");
        }
    }

    public boolean beginDisplayedNodeDisplay(ChildDisplayEvent event) {
        ++this.displayableNodeCounter;
        if (this.maxNbNodesDisplayed != -1) {
            return this.displayableNodeCounter >= this.currentPage && this.displayableNodeCounter < this.currentPage + this.maxNbNodesDisplayed;
        }
        return true;
    }

    public void beginDisplay(DisplayEvent event) {
        try {
            super.beginDisplay(event);
            ViewBean pvb = this.getParentViewBean();
            String editTimeStamp = (String)pvb.getPageSessionAttribute("editTimeStamp");
            if (editTimeStamp == null && (editTimeStamp = this.getRequestContext().getRequest().getParameter("editTimeStamp")) != null) {
                pvb.setPageSessionAttribute("editTimeStamp", (Serializable)((Object)editTimeStamp));
            }
        }
        catch (ModelControlException e) {
            // empty catch block
        }
        TaxonomyBrowserView pv = (TaxonomyBrowserView)this.getParent();
        ViewBean pvb = this.getParentViewBean();
        this.nbPages = pv.nbPages;
        this.maxNbNodesDisplayed = TaxonomyBrowserView.maxNbNodesDisplayed;
        this.currentPage = pv.currentPage;
    }

    public boolean beginIsRootNodeDisplay(ChildDisplayEvent event) {
        boolean b = false;
        try {
            RDMClassification currentNode = (RDMClassification)this.getTaxonomyTreeModel().getCurrentNode();
            b = currentNode.getParentId() == null;
            return b;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            return b;
        }
    }

    public boolean beginIsNotRootNodeDisplay(ChildDisplayEvent event) {
        boolean b = !this.beginIsRootNodeDisplay(event);
        return b;
    }

    public boolean beginHrefDisplay(ChildDisplayEvent event, HREF href, String action) {
        try {
            RDMClassification currentNode = (RDMClassification)this.getTaxonomyTreeModel().getCurrentNode();
            href.setValue((Object)String.valueOf(this.displayableNodeCounter));
            return true;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0066", new String[]{event.toString(), href.toString(), action, e.getMessage()});
            return false;
        }
    }

    public boolean beginHref1Display(ChildDisplayEvent event) {
        try {
            return this.beginHrefDisplay(event, (HREF)this.getDisplayField(CHILD_HREF), "edit");
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0061", new String[]{event.toString(), e.getMessage()});
            return false;
        }
    }

    public TaxonomyTreeModel getTaxonomyTreeModel() {
        try {
            CSViewBeanBase pvb = (CSViewBeanBase)this.getParentViewBean();
            ServletContext sc = this.getRequestContext().getServletContext();
            Locale locale = pvb.getUserLocale();
            TaxonomyTreeModel model = (TaxonomyTreeModel)sc.getAttribute("TaxonomyTreeModel." + locale.toString());
            if (model == null) {
                model = new TaxonomyTreeModel();
                model.userLocale = locale;
                sc.setAttribute("TaxonomyTreeModel." + locale.toString(), (Object)model);
            }
            return model;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            return null;
        }
    }

    public void handleHref1Request(RequestInvocationEvent event) throws ModelControlException {
        debugLogger.finer("PSSH_CSPSA0117");
        int nodeIndex = this.getDisplayFieldIntValue(CHILD_HREF);
        ViewBean pvb = this.getParentViewBean();
        String taxName = this.getTaxByIndex(nodeIndex);
        debugLogger.log(Level.FINER, "PSSH_CSPSA0118", taxName);
        String editTimeStamp = (String)pvb.getPageSessionAttribute("editTimeStamp");
        debugLogger.log(Level.FINER, "PSSH_CSPSA0089", editTimeStamp);
        if (taxName != null && !taxName.equals("ROOT")) {
            Object selTaxObj = pvb.getRequestContext().getRequest().getSession().getAttribute("SelectedTax" + editTimeStamp);
            if (selTaxObj != null) {
                debugLogger.finer("PSSH_CSPSA0119");
                if (selTaxObj.getClass().isArray()) {
                    debugLogger.finer("PSSH_CSPSA0120");
                    String[] selTax = (String[])selTaxObj;
                    String[] newSelTax = new String[selTax.length + 1];
                    for (int i = 0; i < selTax.length; ++i) {
                        newSelTax[i] = selTax[i];
                    }
                    newSelTax[i] = taxName;
                    pvb.getRequestContext().getRequest().getSession().setAttribute("SelectedTax" + editTimeStamp, (Object)newSelTax);
                } else {
                    debugLogger.log(Level.FINER, "PSSH_CSPSA0121", taxName);
                    pvb.getRequestContext().getRequest().getSession().setAttribute("SelectedTax" + editTimeStamp, (Object)taxName);
                }
            } else {
                debugLogger.finer("PSSH_CSPSA0122");
            }
        }
        pvb.forwardTo(this.getRequestContext());
    }

    public String getTaxByIndex(int index) {
        try {
            int i;
            this.resetNodeLocation();
            for (i = 1; this.nextNode() && i < index; ++i) {
            }
            if (i == index) {
                RDMClassification node = (RDMClassification)((TaxonomyTreeModel)this.getPrimaryModel()).getCurrentNode();
                return node.getId();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getIndexByTax(String taxName) {
        try {
            debugLogger.log(Level.FINER, "PSSH_CSPSA0123", taxName);
            this.resetNodeLocation();
            int i = 1;
            while (this.nextNode()) {
                RDMClassification node = (RDMClassification)((TaxonomyTreeModel)this.getPrimaryModel()).getCurrentNode();
                if (taxName.equals(node.getId())) {
                    debugLogger.log(Level.FINER, "PSSH_CSPSA0124", Integer.toString(i));
                    return i;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public int getNbDisplay(int numPerPage, ArrayList pageNodeList) {
        int numNode = 0;
        boolean numPage = true;
        try {
            this.resetNodeLocation();
            int currPageNodeCount = 0;
            pageNodeList.clear();
            while (this.nextNode()) {
                ++numNode;
                if (currPageNodeCount == 0) {
                    RDMClassification node = (RDMClassification)((TaxonomyTreeModel)this.getPrimaryModel()).getCurrentNode();
                    if (node.getParent() != null) {
                        pageNodeList.add(node.getParentId() + ":" + node.getId());
                    } else {
                        pageNodeList.add(this.getTaxonomyTreeModel().getNodeName("ROOT"));
                    }
                }
                ++currPageNodeCount;
                currPageNodeCount %= numPerPage;
            }
            debugLogger.log(Level.FINER, "PSSH_CSPSA0125", Integer.toString(numNode));
        }
        catch (Exception e) {
            // empty catch block
        }
        return numNode;
    }

    public void expandAll() {
        try {
            this.resetNodeLocation();
            while (this.nextNode()) {
                if (!this.isParentNode() || this.isNodeExpanded()) continue;
                this.getStateData().setNodeExpanded(this.getPrimaryModel().getNodeID(), true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void collapseAll() {
        try {
            this.resetNodeLocation();
            while (this.nextNode()) {
                if (!this.isParentNode() || !this.isNodeExpanded()) continue;
                this.getStateData().setNodeExpanded(this.getPrimaryModel().getNodeID(), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

