/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.db.SToken;
import com.sun.portal.search.rdm.RDMHeader;
import com.sun.portal.search.rdm.RDMQuery;
import com.sun.portal.search.rdmserver.RDMUIBridge;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFBuffer;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RDSearch {
    public int RDM_Results = 0;
    public int RDM_Hits = 0;
    public int RDM_Documents = 0;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$RDSearch == null ? (class$com$sun$portal$search$admin$RDSearch = RDSearch.class$("com.sun.portal.search.admin.RDSearch")) : class$com$sun$portal$search$admin$RDSearch));
    static /* synthetic */ Class class$com$sun$portal$search$admin$RDSearch;

    public ArrayList search(String database, String queryString, int searchBy, int startHits, int viewHits) throws Exception {
        return this.search(database, queryString, searchBy, startHits, viewHits, null);
    }

    public ArrayList search(String database, String queryString, int searchBy, int startHits, int viewHits, SToken st) throws Exception {
        return this.search(database, queryString, searchBy, startHits, viewHits, st, null);
    }

    public ArrayList search(String database, String queryString, int searchBy, int startHits, int viewHits, SToken st, String view) throws Exception {
        debugLogger.log(Level.FINER, "PSSH_CSPSA0087", new String[]{Integer.toString(searchBy), queryString});
        String type = "rd-request";
        String ql = "search";
        String scope = queryString;
        switch (searchBy) {
            case 1: {
                scope = "*";
                break;
            }
            case 2: {
                scope = "<not> (CLASSIFICATION!=\"\")";
                break;
            }
            case 3: {
                scope = "(Classification!=\"\")";
                break;
            }
            case 4: {
                scope = "(Classification=\"" + queryString + "\")";
                break;
            }
            case 5: {
                ql = "url";
                break;
            }
        }
        RDMHeader hdr = null;
        try {
            hdr = new RDMHeader(type, null, ql, null);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
        String hits = startHits + ".." + (startHits + viewHits - 1);
        RDMQuery qry = new RDMQuery(scope);
        qry.setViewHits(hits);
        if (searchBy != 5) {
            qry.setViewAttr("url,title");
        }
        if (view != null) {
            qry.setViewAttr(view);
        }
        if (database != null) {
            qry.setDatabase(database);
        }
        SOIFBuffer sb = new SOIFBuffer();
        SOIFOutputStream sos = new SOIFOutputStream((OutputStream)sb);
        sos.write(hdr.getSOIF());
        debugLogger.log(Level.FINER, "PSSH_CSPSA0092", hdr.getSOIF());
        sos.write(qry.getSOIF());
        debugLogger.log(Level.FINER, "PSSH_CSPSA0093", qry.getSOIF());
        byte[] ba = RDMUIBridge.rdmui_to_srv((byte[])sb.toByteArray(), (SToken)st);
        SOIFInputStream sis = new SOIFInputStream(ba);
        RDMHeader rdmHeader = new RDMHeader(sis);
        String resp = rdmHeader.getResponseInterpret();
        try {
            this.RDM_Results = this.getKeyedInt(resp, "result");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.RDM_Hits = this.getKeyedInt(resp, "hit");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.RDM_Documents = this.getKeyedInt(resp, "document");
        }
        catch (Exception e) {
            // empty catch block
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSA0094", new String[]{String.valueOf(this.RDM_Results), String.valueOf(this.RDM_Hits), String.valueOf(this.RDM_Documents)});
        ArrayList<SOIF> rs = new ArrayList<SOIF>();
        while (!sis.isEOS()) {
            SOIF ss = sis.readSOIF();
            if (ss == null) continue;
            rs.add(ss);
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSA0095", Integer.toString(rs.size()));
        return rs;
    }

    private int getKeyedInt(String str, String rawkey) throws NumberFormatException {
        int res = 0;
        try {
            String key = " " + rawkey;
            int i = str.indexOf(key);
            if (i <= 0) {
                throw new Exception();
            }
            --i;
            while (i >= 0 && str.charAt(i) == ' ') {
                --i;
            }
            int n2 = i + 1;
            while (i >= 0 && str.charAt(i) != ' ') {
                --i;
            }
            int n1 = i + 1;
            String s1 = str.substring(n1, n2);
            res = Integer.parseInt(s1);
        }
        catch (Exception e) {
            throw new NumberFormatException();
        }
        return res;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

