/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.iplanet.am.console.components.view.html.DynamicGUI;
import com.iplanet.am.console.components.view.html.DynamicGUIComp;
import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSViewBeanBase;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.rdm.RDMSchema;
import com.sun.portal.search.soif.SOIF;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.soif.SOIFOutputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class RDAddView
extends RequestHandlingTiledViewBase
implements TiledView,
RequestHandler {
    public static final String RD_AV_SET = "rdAVSet";
    public static final String TAXBROWSE_BUTTON = "TaxBrowser";
    String database = null;
    private SOIF s = null;
    private RDMSchema schema = null;
    private boolean atClassificationField = false;
    private HashMap storedMap = null;
    private ArrayList fieldList = new ArrayList();
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$RDAddView == null ? (class$com$sun$portal$search$admin$RDAddView = RDAddView.class$("com.sun.portal.search.admin.RDAddView")) : class$com$sun$portal$search$admin$RDAddView));
    static /* synthetic */ Class class$com$sun$portal$search$admin$RDAddView;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$DynamicGUIComp;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$IPlanetButton;

    public RDAddView(View parent, String name) {
        super(parent, name);
        this.setPrimaryModel((DatasetModel)this.getDefaultModel());
        this.registerChildren();
        this.loadSchema();
    }

    protected void registerChildren() {
        this.registerChild(RD_AV_SET, class$com$iplanet$am$console$components$view$html$DynamicGUIComp == null ? (class$com$iplanet$am$console$components$view$html$DynamicGUIComp = RDAddView.class$("com.iplanet.am.console.components.view.html.DynamicGUIComp")) : class$com$iplanet$am$console$components$view$html$DynamicGUIComp);
        this.registerChild(TAXBROWSE_BUTTON, class$com$iplanet$am$console$components$view$html$IPlanetButton == null ? (class$com$iplanet$am$console$components$view$html$IPlanetButton = RDAddView.class$("com.iplanet.am.console.components.view.html.IPlanetButton")) : class$com$iplanet$am$console$components$view$html$IPlanetButton);
    }

    protected View createChild(String name) {
        if (name.equals(RD_AV_SET)) {
            return new DynamicGUIComp((ContainerView)this, RD_AV_SET, null);
        }
        if (name.equals(TAXBROWSE_BUTTON)) {
            IPlanetButton btn = new IPlanetButton((ContainerView)this, TAXBROWSE_BUTTON, (Object)"");
            btn.validate(true);
            return btn;
        }
        throw new IllegalArgumentException("Invalid child name: " + name);
    }

    OptionList getDBListOption() {
        try {
            String[] dbs = DBUtil.getDBStringArray(CSConfig.getServerRoot());
            return new OptionList(dbs, dbs);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            return new OptionList();
        }
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        ViewBean pvb = this.getParentViewBean();
        String editTimeStamp = (String)pvb.getPageSessionAttribute("editTimeStamp");
        this.database = (String)pvb.getPageSessionAttribute("database" + editTimeStamp);
        if (this.database == null) {
            this.database = this.getRequestContext().getRequest().getParameter("database" + editTimeStamp);
            if (this.database != null) {
                pvb.setPageSessionAttribute("database" + editTimeStamp, (Serializable)((Object)this.database));
            }
        }
        this.fieldList.add("Title");
        this.fieldList.add("URL");
        this.fieldList.add("Description");
        this.fieldList.add("Author");
        this.fieldList.add("Keywords");
        this.fieldList.add("Classification");
        this.fieldList.add("ReadACL");
        this.getPrimaryModel().setSize(this.fieldList.size());
        this.storedMap = (HashMap)pvb.getRequestContext().getRequest().getSession().getAttribute("DynamicGUI" + editTimeStamp);
    }

    public boolean beginTaxonomyBrowseDisplay(ChildDisplayEvent event) {
        return this.atClassificationField;
    }

    public boolean nextTile() throws ModelControlException {
        boolean movedToRow = super.nextTile();
        int ndx = this.getTileIndex();
        CSViewBeanBase pvb = (CSViewBeanBase)this.getParentViewBean();
        if (movedToRow) {
            DynamicGUI dg = null;
            DynamicGUIComp dgc = (DynamicGUIComp)this.getChild(RD_AV_SET);
            String name = (String)this.fieldList.get(ndx);
            boolean required = false;
            int attrType = 0;
            int attrSyntax = 1;
            this.setDisplayFieldValue(TAXBROWSE_BUTTON, pvb.getLocalizedString("category.browser.launch"));
            this.atClassificationField = name.equalsIgnoreCase("Classification");
            if (name.equalsIgnoreCase("ReadACL") || name.equalsIgnoreCase("Classification")) {
                attrType = 3;
            }
            String label = name;
            HashSet<String> values = null;
            if (this.storedMap != null) {
                values = (HashSet<String>)this.storedMap.get(name);
            }
            if (attrType == 0) {
                if (attrSyntax == 0) {
                    String trueValue = "true";
                    String falseValue = "false";
                    String value = "";
                    if (values != null) {
                        value = (String)values.iterator().next();
                    }
                    dg = new DynamicGUI(name, label, required, attrType, attrSyntax, trueValue, falseValue, value);
                } else {
                    dg = new DynamicGUI(name, label, required, attrType, attrSyntax, (Set)values);
                }
                if (attrSyntax == 2) {
                    dg.setConfirmPwdLabel("Confirm");
                    dg.setPasswordMessage(label + ": " + "Mismatch");
                }
            } else if (attrType == 3) {
                dg = new DynamicGUI(name, label, required, attrType, attrSyntax, (Set)values);
                dg.setAddButtonStr(pvb.getLocalizedString("add.text"));
                dg.setRemoveButtonStr(pvb.getLocalizedString("remove.text"));
            }
            if (this.atClassificationField) {
                String editTimeStamp = (String)pvb.getPageSessionAttribute("editTimeStamp");
                String[] insTax = (String[])pvb.getRequestContext().getRequest().getSession().getAttribute("SelectedTax" + editTimeStamp);
                if (insTax != null) {
                    pvb.getRequestContext().getRequest().getSession().removeAttribute("SelectedTax" + editTimeStamp);
                    values = new HashSet<String>(insTax.length);
                    for (int i = 0; i < insTax.length; ++i) {
                        values.add(insTax[i]);
                    }
                    dg.setValues(values);
                }
            }
            dgc.setValue(dg);
        }
        return movedToRow;
    }

    public List getDynamicCompList() {
        DynamicGUI dGUI;
        ArrayList<DynamicGUI> dynamicGUIs = new ArrayList<DynamicGUI>(10);
        HttpServletRequest req = this.getRequestContext().getRequest();
        int count = 0;
        while ((dGUI = DynamicGUIComp.createDynamicGUI((HttpServletRequest)req, (String)this.getQualifiedName(), (String)RD_AV_SET, (int)count++)) != null) {
            dynamicGUIs.add(dGUI);
        }
        return dynamicGUIs;
    }

    public void loadSchema() {
        SearchConfig csidconf = SearchConfig.getSearchConfig();
        String schfn = SearchConfig.getValue((String)"schema-description");
        if (schfn == null) {
            debugLogger.finer("PSSH_CSPSA0072");
        }
        debugLogger.log(Level.FINER, "PSSH_CSPSA0073", schfn);
        SOIFInputStream ss = null;
        try {
            ss = new SOIFInputStream(schfn);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0074", schfn);
        }
        try {
            this.schema = new RDMSchema(ss.readSOIF());
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0075", schfn);
        }
    }

    public void addRD() throws Exception {
        ViewBean pvb = this.getParentViewBean();
        String editTimeStamp = (String)pvb.getPageSessionAttribute("editTimeStamp");
        this.database = (String)pvb.getPageSessionAttribute("database" + editTimeStamp);
        List dynList = this.getDynamicCompList();
        String tmpFile = CSConfig.getServerRoot() + File.separator + "tmp" + File.separator + "tmpRDEditor." + Long.toString(System.currentTimeMillis());
        String rdMgrCmd = CSConfig.getServerRoot() + File.separator + "run-cs-cli rdmgr ";
        if (this.database != null) {
            rdMgrCmd = rdMgrCmd + "-y " + this.database + " ";
        }
        this.createOneRD(this.database, dynList, tmpFile);
        rdMgrCmd = rdMgrCmd + "-m -P -q " + tmpFile;
        this.runRDMGR(rdMgrCmd);
    }

    public void createOneRD(String database, List dynList, String tmpFile) throws Exception {
        SOIFOutputStream so = new SOIFOutputStream(tmpFile);
        SOIF newRD = new SOIF();
        newRD.setSchemaName("DOCUMENT");
        for (int i = 0; i < dynList.size(); ++i) {
            DynamicGUI dynGUI = (DynamicGUI)dynList.get(i);
            String name = dynGUI.getName();
            debugLogger.log(Level.FINER, "PSSH_CSPSA0076", name);
            Set vSet = dynGUI.getValues();
            if (vSet.size() == 0) {
                debugLogger.log(Level.FINER, "PSSH_CSPSA0077", name);
                newRD.insert(name, "", 0);
                continue;
            }
            if (name.equalsIgnoreCase("url")) {
                newRD.setURL((String)vSet.iterator().next());
                continue;
            }
            Iterator it = vSet.iterator();
            int ndx = 0;
            while (it.hasNext()) {
                String value = (String)it.next();
                debugLogger.log(Level.FINER, "PSSH_CSPSA0078", value);
                newRD.insert(name, value, ndx++);
            }
        }
        so.write(newRD);
        so.close();
        String rdMgrCmd = CSConfig.getServerRoot() + File.separator + "run-cs-cli rdmgr ";
        if (database != null) {
            rdMgrCmd = rdMgrCmd + "-y " + database + " ";
        }
        rdMgrCmd = rdMgrCmd + "-m " + tmpFile;
        this.runRDMGR(rdMgrCmd);
    }

    public void runRDMGR(String cmdline) throws Exception {
        Runtime rt = Runtime.getRuntime();
        debugLogger.log(Level.FINER, "PSSH_CSPSA0079", cmdline);
        Process p = rt.exec(cmdline);
        p.waitFor();
        int exitValue = p.exitValue();
        if (exitValue == 1) {
            debugLogger.log(Level.FINER, "PSSH_CSPSA0080", Integer.toString(exitValue));
        }
    }

    public void handleTaxBrowserRequest(RequestInvocationEvent event) {
        HashMap<String, Set> map = new HashMap<String, Set>();
        String[] currTax = null;
        List dynList = this.getDynamicCompList();
        for (int i = 0; i < dynList.size(); ++i) {
            DynamicGUI dynGUI = (DynamicGUI)dynList.get(i);
            String name = dynGUI.getName();
            debugLogger.log(Level.FINER, "PSSH_CSPSA0081", dynGUI.toString());
            Set vSet = dynGUI.getValues();
            if (name.equalsIgnoreCase("classification")) {
                if (vSet.isEmpty()) continue;
                currTax = vSet.toArray(new String[0]);
                continue;
            }
            if (vSet.isEmpty()) continue;
            map.put(name, vSet);
        }
        ViewBean pvb = this.getParentViewBean();
        String editTimeStamp = (String)pvb.getPageSessionAttribute("editTimeStamp");
        debugLogger.log(Level.FINER, "PSSH_CSPSA0082", editTimeStamp);
        pvb.getRequestContext().getRequest().getSession().setAttribute("DynamicGUI" + editTimeStamp, map);
        pvb.setPageSessionAttribute("BrowsingMode", (Serializable)((Object)"true"));
        pvb.setPageSessionAttribute("editTimeStamp", (Serializable)((Object)editTimeStamp));
        pvb.getRequestContext().getRequest().getSession().setAttribute("SelectedTax" + editTimeStamp, (Object)(currTax == null ? new String[]{} : currTax));
        debugLogger.finer("PSSH_CSPSA0083");
        pvb.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

