/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.ComboBox;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.jato.view.html.StaticTextField;
import com.iplanet.jato.view.html.TextField;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.CSViewBeanBase;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class LogsViewBean
extends CSViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/ps/searchadmin/Logs.jsp";
    public static final String PAGE_NAME = "Logs";
    public static final String VLOG_COMBO = "VLogCombo";
    public static final String NLINES_TEXT = "NLinesText";
    public static final String LOG_RESULT = "LogResult";
    public static final String LOG_BUTTON = "LOGButton";
    private static final int AVG_BYTES_PER_LINE = 256;
    private static String[] logFNs = new String[]{null, null, null, null, null, null};
    private static final String[] logIndex = new String[]{"0", "1", "2", "3", "4", "5"};
    static /* synthetic */ Class class$com$iplanet$jato$view$html$ComboBox;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$TextField;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$IPlanetButton;

    public LogsViewBean() {
        super(PAGE_NAME);
        this.setDefaultDisplayURL(DEFAULT_DISPLAY_URL);
        this.registerChildren();
    }

    protected void registerChildren() {
        this.registerChild(VLOG_COMBO, class$com$iplanet$jato$view$html$ComboBox == null ? (class$com$iplanet$jato$view$html$ComboBox = LogsViewBean.class$("com.iplanet.jato.view.html.ComboBox")) : class$com$iplanet$jato$view$html$ComboBox);
        this.registerChild(NLINES_TEXT, class$com$iplanet$jato$view$html$TextField == null ? (class$com$iplanet$jato$view$html$TextField = LogsViewBean.class$("com.iplanet.jato.view.html.TextField")) : class$com$iplanet$jato$view$html$TextField);
        this.registerChild(LOG_RESULT, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = LogsViewBean.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(LOG_BUTTON, class$com$iplanet$am$console$components$view$html$IPlanetButton == null ? (class$com$iplanet$am$console$components$view$html$IPlanetButton = LogsViewBean.class$("com.iplanet.am.console.components.view.html.IPlanetButton")) : class$com$iplanet$am$console$components$view$html$IPlanetButton);
    }

    protected View createChild(String name) {
        View Headerchild = super.createChild(name);
        if (Headerchild != null) {
            return Headerchild;
        }
        if (name.equals(VLOG_COMBO)) {
            ComboBox child = new ComboBox((ContainerView)this, VLOG_COMBO, (Object)"");
            OptionList VLogOptions = new OptionList(this.getLocalizedStringArray("log.viewer.loglistlabel", ","), logIndex);
            child.setOptions(VLogOptions);
            return child;
        }
        if (name.equals(NLINES_TEXT)) {
            return new TextField((ContainerView)this, NLINES_TEXT, (Object)"25");
        }
        if (name.equals(LOG_RESULT)) {
            return new StaticTextField((ContainerView)this, LOG_RESULT, (Object)this.getLocalizedString("log.viewer.defaultmsg"));
        }
        if (name.equals(LOG_BUTTON)) {
            return new IPlanetButton((ContainerView)this, LOG_BUTTON, (Object)"");
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    private void getLogFNs() throws Exception {
        String logDir = CSConfig.getServerRoot() + File.separator + "logs" + File.separator;
        if (logFNs[0] == null) {
            LogsViewBean.logFNs[0] = logDir + "filter.log";
        }
        if (logFNs[1] == null) {
            LogsViewBean.logFNs[1] = SearchConfig.getValue((String)"rdmgr-logfile");
        }
        if (logFNs[2] == null) {
            LogsViewBean.logFNs[2] = SearchConfig.getValue((String)"debug-logfile");
        }
        if (logFNs[3] == null) {
            LogsViewBean.logFNs[3] = logDir + "robot.log";
        }
        if (logFNs[4] == null) {
            LogsViewBean.logFNs[4] = SearchConfig.getValue((String)"search-logfile");
        }
        if (logFNs[5] == null) {
            LogsViewBean.logFNs[5] = SearchConfig.getValue((String)"logfile");
        }
    }

    public void beginDisplay(DisplayEvent event) {
        this.setPageEncoding();
        this.setDisplayFieldValue(LOG_BUTTON, this.getLocalizedString("log.viewer.buttontext"));
    }

    public String getLastLines(String logFileName, int showLines) throws Exception {
        byte[] buffer;
        if (showLines <= 0) {
            return null;
        }
        RandomAccessFile raf = new RandomAccessFile(logFileName, "r");
        if (raf.length() == 0L) {
            return "";
        }
        int readSize = showLines * 256;
        int startPosition = 0;
        while (true) {
            int i;
            long tryPosition;
            if ((tryPosition = raf.length() - (long)readSize) < 0L) {
                tryPosition = 0L;
                readSize = (int)raf.length();
            }
            raf.seek(tryPosition);
            buffer = new byte[readSize];
            raf.readFully(buffer);
            int line = -1;
            for (i = readSize - 1; i >= 0 && line < showLines; --i) {
                if (buffer[i] != 10) continue;
                if (i > 0 && buffer[i - 1] == 13) {
                    --i;
                }
                ++line;
            }
            if (line == showLines) {
                startPosition = i + 2;
                break;
            }
            if (tryPosition == 0L) {
                startPosition = 0;
                break;
            }
            readSize += 10000;
        }
        return new String(buffer, startPosition, buffer.length - startPosition, "UTF-8");
    }

    public void handleLOGButtonRequest(RequestInvocationEvent event) {
        int logNdx = this.getDisplayFieldIntValue(VLOG_COMBO);
        try {
            this.getLogFNs();
        }
        catch (Exception e) {
            // empty catch block
        }
        String logFileName = logFNs[logNdx];
        int showLines = 25;
        try {
            showLines = this.getDisplayFieldIntValue(NLINES_TEXT);
            if (showLines <= 0) {
                this.errorMessage = this.getLocalizedString("log.viewer.numberformatexception");
                this.forwardTo();
                return;
            }
        }
        catch (Exception e) {
            this.errorMessage = this.getLocalizedString("log.viewer.numberformatexception");
            this.forwardTo();
            return;
        }
        try {
            String lastLines = this.getLastLines(logFileName, showLines);
            if (lastLines != null) {
                StringBuffer outBuf = new StringBuffer();
                int lineCount = 0;
                StringTokenizer st = new StringTokenizer(lastLines, "\r\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.trim().length() <= 0) continue;
                    outBuf.append("<Font color=gray>" + ++lineCount + " : </font>" + HtmlUtil.escape((String)token) + "<br>\n");
                }
                if (lineCount > 0) {
                    this.setDisplayFieldValue(LOG_RESULT, outBuf);
                } else {
                    this.setDisplayFieldValue(LOG_RESULT, "<font color=red>" + this.getLocalizedString("log.viewer.emptylogmsg") + "</font>");
                }
            }
        }
        catch (Exception e) {
            Object[] args = new String[]{logFileName};
            this.setDisplayFieldValue(LOG_RESULT, "<font color=red>" + this.getLocalizedMessageFormat("log.viewer.noexistlogmsg", args) + "</font>");
        }
        this.forwardTo();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

