/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.util.PBlock;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImportConfig {
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$ImportConfig == null ? (class$com$sun$portal$search$admin$ImportConfig = ImportConfig.class$("com.sun.portal.search.admin.ImportConfig")) : class$com$sun$portal$search$admin$ImportConfig));
    public static final String QL_GATHERER = "gatherer";
    public static final String QL_COMPASS = "compass";
    public static final String QL_SEARCH = "search";
    public static final String TYPE_LOCALFILE = "localfile";
    public static final String TYPE_COMPASS = "cs";
    public static final String CONFDIR = "config";
    public static final String IMPORT_CONF = "import.conf";
    static final String header = "# Written automatically by importmgr -- DO NOT EDIT";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String CSID = "csid";
    public static final String SEARCH_URI = "search-uri";
    public static final String SEARCH_DB = "search-db";
    public static final String LOCAL_DB = "local-db";
    public static final String USE_RDM_INCOMING = "use-rdm-incoming";
    public static final String SRCFILE = "srcfile";
    public static final String RDM_QUERY_LANGUAGE = "rdm-query-language";
    public static final String DESTINATION_CSID = "destination-csid";
    public static final String ENABLE = "enable";
    public static final String TIME_STAMP = "last-collection-time";
    public static final String EMAIL = "email";
    public static final String USER = "user";
    public static final String PASSWORD = "password";
    public static final String VIEW_ATTRIBUTES = "view-attributes";
    public static final String VIEW_HITS = "view-hits";
    public static final String VIEW_ORDER = "view-order";
    public static final String SCOPE = "scope";
    public static final String NICKNAME = "nickname";
    public static final String TIMEOUT = "timeout";
    private static final String[] use4equalFields = new String[]{"csid", "local-db", "srcfile", "rdm-query-language", "view-attributes", "scope"};
    public static final String US_AUTH = "use-auth";
    public static final String AGENT_TYPE = "agent-type";
    public static final String SERVER_PORT = "server";
    public static final String INSTANCE_NAME = "instance-name";
    public static final String IS_SSL = "is-ssl";
    public static final String IS_COMPASS = "is-compass";
    public static final String CHARSET = "charset";
    HashMap valuesMap = new HashMap();
    int id = 0;
    static int lastID = 0;
    static long fileLastModified = 0L;
    static String default_csid;
    static String fileName;
    static ArrayList importAgents;
    static HashMap importAgentsMap;
    static /* synthetic */ Class class$com$sun$portal$search$admin$ImportConfig;

    public static void main(String[] args) {
        try {
            ImportConfig.init(args[0]);
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
        ImportConfig.updateFile(args[0] + ".new");
    }

    private ImportConfig(int id, HashMap map) {
        this.id = id;
        this.valuesMap = map;
    }

    public static void init(String filename) throws Exception {
        fileName = filename;
        try {
            File file = new File(filename);
            fileLastModified = file.lastModified();
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            String line = in.readLine();
            boolean inTag = false;
            HashMap currAgent = null;
            while (line != null) {
                String nline = line.trim();
                if (inTag) {
                    if (nline.startsWith("</Import>")) {
                        String id = (String)currAgent.get(ID);
                        if (id != null) {
                            int currID = Integer.parseInt(id);
                            if (currID > lastID) {
                                lastID = currID;
                            }
                            ImportConfig impCFG = new ImportConfig(Integer.parseInt(id), currAgent);
                            importAgents.add(impCFG);
                            importAgentsMap.put(id, impCFG);
                            inTag = false;
                        }
                    } else {
                        if (nline.startsWith("#")) {
                            line = in.readLine();
                            continue;
                        }
                        PBlock.str2pblock((String)nline, (Map)currAgent);
                    }
                } else if (nline.startsWith("<Import ") && nline.endsWith(">")) {
                    inTag = true;
                    currAgent = new HashMap();
                    String values = nline.substring(8, nline.length() - 1);
                    PBlock.str2pblock((String)values, currAgent);
                }
                line = in.readLine();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void reInit() {
        try {
            File file = new File(fileName);
            long lastmodified = file.lastModified();
            if (lastmodified <= fileLastModified) {
                return;
            }
            lastID = 0;
            importAgents.clear();
            importAgentsMap.clear();
            ImportConfig.init(fileName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void updateFile() {
        ImportConfig.updateFile(fileName);
    }

    public static void updateFile(String filename) {
        PrintWriter out = null;
        try {
            FileOutputStream fout = new FileOutputStream(filename);
            out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fout, "UTF-8")), true);
            out.println(header);
            for (int i = 0; i < importAgents.size(); ++i) {
                ImportConfig impCfg = (ImportConfig)importAgents.get(i);
                impCfg.print(out);
                out.println();
            }
            out.close();
            File file = new File(filename);
            fileLastModified = file.lastModified();
        }
        catch (Exception e) {
            return;
        }
    }

    public static synchronized ImportConfig newImportAgent() {
        HashMap<String, String> map = new HashMap<String, String>();
        int id = lastID + 1;
        map.put(ID, Integer.toString(id));
        ImportConfig imp = new ImportConfig(id, map);
        ++lastID;
        return imp;
    }

    public static boolean addImportAgent(ImportConfig imp) {
        for (int i = 0; i < importAgents.size(); ++i) {
            ImportConfig impc = (ImportConfig)importAgents.get(i);
            if (!impc.isEqualTo(imp)) continue;
            return false;
        }
        importAgents.add(imp);
        importAgentsMap.put(Integer.toString(imp.id), imp);
        return true;
    }

    public static ArrayList getImportAgents() {
        ImportConfig.reInit();
        return importAgents;
    }

    public static ImportConfig getImportConfigByIndex(int i) {
        ImportConfig.reInit();
        if (i >= 0 && i < importAgents.size()) {
            return (ImportConfig)importAgents.get(i);
        }
        return null;
    }

    public static boolean DeleteImportConfigByIndex(int i) {
        ImportConfig imp;
        return i >= 0 && i < importAgents.size() && (imp = (ImportConfig)importAgents.remove(i)) != null && importAgentsMap.remove(imp.getValue(ID)) != null;
    }

    public static boolean DeleteImportConfigByID(String id) {
        ImportConfig imp = (ImportConfig)importAgentsMap.remove(id);
        if (imp != null) {
            importAgents.remove(imp);
            return true;
        }
        return false;
    }

    public static ImportConfig getImportConfigByID(String id) {
        ImportConfig.reInit();
        return (ImportConfig)importAgentsMap.get(id);
    }

    public static int numOfImportConfig() {
        ImportConfig.reInit();
        return importAgents.size();
    }

    public void setDefault(String csid) {
        default_csid = csid;
    }

    public String getDefault() {
        return default_csid;
    }

    public String getID() {
        return this.getValue(ID);
    }

    public String getValue(String param) {
        if (param.compareToIgnoreCase(RDM_QUERY_LANGUAGE) == 0) {
            String value = (String)this.valuesMap.get(RDM_QUERY_LANGUAGE);
            if (value != null && value.compareTo(QL_GATHERER) != 0) {
                return QL_SEARCH;
            }
            return QL_GATHERER;
        }
        if (param.compareToIgnoreCase(US_AUTH) == 0) {
            String value = (String)this.valuesMap.get(USER);
            if (value != null) {
                return "true";
            }
            return "false";
        }
        if (param.compareToIgnoreCase(AGENT_TYPE) == 0) {
            String value = (String)this.valuesMap.get(CSID);
            if (value != null && value.length() > 0) {
                return TYPE_COMPASS;
            }
            return TYPE_LOCALFILE;
        }
        if (param.compareToIgnoreCase(SERVER_PORT) == 0) {
            String value = (String)this.valuesMap.get(CSID);
            if (value != null && value.length() > 0) {
                int start = value.indexOf("//") + 2;
                int end = value.lastIndexOf(47);
                return value.substring(start, end);
            }
            return "";
        }
        if (param.compareToIgnoreCase(INSTANCE_NAME) == 0) {
            String value = (String)this.valuesMap.get(CSID);
            if (value != null && value.length() > 0) {
                int start = value.lastIndexOf(47) + 1;
                return value.substring(start);
            }
            return "";
        }
        if (param.compareToIgnoreCase(IS_COMPASS) == 0) {
            String value = (String)this.valuesMap.get(USE_RDM_INCOMING);
            if (value != null) {
                return "true";
            }
            return "false";
        }
        if (param.compareToIgnoreCase(IS_SSL) == 0) {
            String value = (String)this.valuesMap.get(CSID);
            if (value != null && value.length() > 0 && value.startsWith("x-catalogs")) {
                return "true";
            }
            return "false";
        }
        return (String)this.valuesMap.get(param);
    }

    public void setValue(Object key, Object value) {
        if (this.valuesMap != null) {
            if (this.valuesMap.containsKey(key)) {
                this.valuesMap.remove(key);
            }
            this.valuesMap.put(key, value);
        }
    }

    public void remove(Object key) {
        if (this.valuesMap != null && this.valuesMap.containsKey(key)) {
            this.valuesMap.remove(key);
        }
    }

    public HashMap getMap() {
        return this.valuesMap;
    }

    public void print(PrintWriter out) {
        String id = (String)this.valuesMap.get(ID);
        out.println("<Import id=" + id + ">");
        Iterator it = this.valuesMap.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.compareToIgnoreCase(ID) == 0) continue;
            out.println(key + "=\"" + (String)this.valuesMap.get(key) + "\"");
        }
        out.println("</Import>");
    }

    public boolean isEqualTo(ImportConfig imp) {
        for (int i = 0; i < use4equalFields.length; ++i) {
            String v1 = this.getValue(use4equalFields[i]);
            String v2 = imp.getValue(use4equalFields[i]);
            if (!(v1 == null && v1 != null || v1 != null && v2 == null) && (v1 == null || v2 == null || v1.equals(v2))) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        fileName = null;
        importAgents = new ArrayList();
        importAgentsMap = new HashMap();
    }
}

