/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.search.admin.resources.SearchResource;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Locale;

public class FilterSimulator {
    static String[] h_errmsg = new String[]{"simulator.successdns", "simulator.namenotfound", "simulator.dnsserverfail", "simulator.norecovery", "simulator.dns.noaddress", "simulator.unknownerror"};
    Locale locale = Locale.getDefault();

    public FilterSimulator(Locale locale) {
        this.locale = locale;
    }

    public FilterSimulator() {
    }

    String getI18n(String input) {
        return SearchResource.geti18nString(input, this.locale);
    }

    String accepted() {
        return this.font("green", this.getI18n("simulator.accepted"));
    }

    String rejected() {
        return this.font("red", this.getI18n("simulator.reject"));
    }

    String warning() {
        return this.font("brown", this.getI18n("simulator.warning"));
    }

    String href(String host) {
        return "<a target=_blank href = \"" + host + "\">" + host + "</a>";
    }

    String font(String color, String text) {
        return "<font color=" + color + ">" + text + "</font>";
    }

    String trim_fr(String s) {
        if ((s = s.trim()).startsWith("<URL:")) {
            String host = s.substring(5, s.length() - 1);
            s = this.href(host);
        } else {
            int i = s.indexOf(" -- ");
            if (i > 0) {
                s = s.substring(0, i);
            }
        }
        return s;
    }

    String format(String head, String body) {
        return "<tr><td>" + head + "</td>\n<td>" + body + "</td></tr>\n";
    }

    int getInt(BufferedReader in) throws Exception {
        String s = in.readLine();
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return -1;
        }
    }

    String[] increaseArray(String[] src) {
        if (src == null) {
            return new String[10];
        }
        String[] tmp = new String[src.length + 10];
        System.arraycopy(src, 0, tmp, 0, src.length);
        return tmp;
    }

    boolean sameHost(String url1, String host) {
        if (url1.charAt(0) == '/') {
            return true;
        }
        return url1.indexOf("://" + host) > 0;
    }

    public void getDomainByName(String root, String host) throws Exception {
        HostResult r = this.doGetHostByName(root, host);
        switch (r.h_errno) {
            case 0: {
                throw new Exception(this.getI18n("simulator.sameashostname"));
            }
            case 4: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                throw new Exception(this.getI18n("simulator.namenotfound"));
            }
            default: {
                throw new Exception(this.getI18n("simulator.unknownerror"));
            }
        }
    }

    public String getHostByName(String root, String host) throws Exception {
        HostResult r = this.doGetHostByName(root, host);
        if (r.h_errno != 0) {
            if (r.h_errno > 0 && r.h_errno < h_errmsg.length) {
                throw new Exception(this.getI18n(h_errmsg[r.h_errno]));
            }
            throw new Exception(this.getI18n("simulator.unknownerror"));
        }
        return r.h_cname;
    }

    public HostResult doGetHostByName(String root, String host) throws Exception {
        String s;
        String runCsCli = null;
        runCsCli = FilterSimulator.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
        String cmd = root + File.separator + runCsCli + " hostinfo " + host;
        Process proc = Runtime.getRuntime().exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String cname = null;
        String[] aliases = null;
        String[] ps = null;
        int h_type = 0;
        int h_len = 0;
        int code = -1;
        boolean is_ok = false;
        code = this.getInt(in);
        if (code != 0) {
            String s2;
            if (code == 4) {
                cname = host;
            }
            while ((s2 = in.readLine()) != null) {
            }
            in.close();
            return new HostResult(host, code, cname, 0, 0, null, null);
        }
        cname = in.readLine();
        h_type = this.getInt(in);
        h_len = this.getInt(in);
        int count = 0;
        int len = 0;
        while ((s = in.readLine()) != null && !s.equalsIgnoreCase("ALIASES")) {
            if (len < ++count) {
                ps = this.increaseArray(ps);
                len = ps.length;
            }
            ps[count - 1] = s;
        }
        if (s == null) {
            return new HostResult(host, code, cname, h_type, h_len, ps, null);
        }
        count = 0;
        len = 0;
        while ((s = in.readLine()) != null) {
            if (len < ++count) {
                aliases = this.increaseArray(aliases);
                len = aliases.length;
            }
            aliases[count - 1] = s;
        }
        return new HostResult(host, code, cname, h_type, h_len, ps, aliases);
    }

    public RedirectResult doRedirect(String root, boolean is_visual_server, String url) throws Exception {
        String s;
        String runCsCli = null;
        runCsCli = FilterSimulator.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
        String cmd = root + File.separator + runCsCli + " ufetch ";
        if (!is_visual_server) {
            cmd = cmd + "-d ";
        }
        cmd = cmd + url;
        Process proc = Runtime.getRuntime().exec(cmd);
        BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String host = null;
        String type = null;
        int comp_len = 0;
        int len = 0;
        boolean is_ok = false;
        boolean isredirect = false;
        while ((s = in.readLine()) != null) {
            is_ok = true;
            if (!is_visual_server) {
                if (s.length() > 7 && s.substring(0, 7).equalsIgnoreCase("Server:")) {
                    type = s.substring(7).trim();
                }
                if (s.length() > 15 && s.substring(0, 15).equalsIgnoreCase("Content-length:")) {
                    try {
                        len = Integer.parseInt(s.substring(7).trim());
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (s.length() > 9 && s.substring(0, 9).equalsIgnoreCase("Location:") && !(host = s.substring(9).trim()).equals(url + "/") && !url.equals(host + "/")) {
                    isredirect = true;
                }
            }
            comp_len += s.length();
        }
        in.close();
        if (len == 0) {
            len = comp_len;
        }
        if (!is_ok) {
            return new RedirectResult(-1, "", "", len);
        }
        if (isredirect) {
            return new RedirectResult(1, host, type, len);
        }
        return new RedirectResult(0, null, type, len);
    }

    public String runProb(boolean isSmartHostHeuristics, String root, boolean showDNS, String url) throws Exception {
        String result = "";
        String host = "";
        String protocol = "";
        String uri = "";
        int port = 0;
        try {
            URL urlo = new URL(url);
            host = urlo.getHost();
            protocol = urlo.getProtocol();
            uri = urlo.getFile();
            port = urlo.getPort();
        }
        catch (Exception e) {
            result = this.warning() + " " + this.getI18n("simulator.malformed");
            return result;
        }
        if (port < 1) {
            port = 80;
        }
        result = result + this.getI18n("simulator.checkingurl");
        result = result + "\n<br>";
        HostResult hr = this.doGetHostByName(root, host);
        if (showDNS) {
            result = result + "<pre>\n";
            result = result + hr.toString();
            result = result + "</pre>\n";
        }
        result = result + this.getI18n("simulator.result") + " &nbsp;";
        if (hr.h_errno != 0) {
            String tmp = hr.h_errno == 1 ? "<b>" + host + "</b>:&nbsp;" + this.getI18n("simulator.hostnotfound") : (hr.h_errno == 2 ? "<b>" + host + "</b>:&nbsp;" + this.getI18n("simulator.dnsfailure") : (hr.h_errno == 3 ? "<b>" + host + "</b>:&nbsp;" + this.getI18n("simulator.dnsfailnorecovery") : (hr.h_errno == 4 ? "<b>" + host + "</b>&nbsp;" + this.getI18n("simulator.isdomain") : "<b>" + host + "</b>:&nbsp;" + this.getI18n("simulator.unknownerror"))));
            result = result + tmp;
            return result;
        }
        result = result + "<b>" + host + "</b>&nbsp;" + this.getI18n("simulator.validname");
        result = result + "<br>\n";
        boolean is_alias = false;
        if (hr.h_aliases != null) {
            for (int j = 0; j < hr.h_aliases.length; ++j) {
                if (hr.h_aliases[j].indexOf(host) <= -1) continue;
                is_alias = true;
                break;
            }
        }
        if (is_alias) {
            result = result + this.getI18n("simulator.note");
            result = result + "&nbsp;<b>" + host + "</b>&nbsp;" + this.getI18n("simulator.aliasnamefor") + "&nbsp;<b>" + hr.h_cname + "</b>";
            result = result + "<br>\n";
        } else {
            result = result + this.getI18n("simulator.note");
            result = result + "&nbsp;<b>" + host + "</b>&nbsp;" + this.getI18n("simulator.cnamefor");
            result = result + "<br>\n";
            result = result + this.getI18n("simulator.note");
            result = result + this.getI18n("simulator.nodnstrans");
            result = result + "<br>\n";
            if (!host.equalsIgnoreCase(hr.h_cname)) {
                result = result + this.getI18n("simulator.refername");
                result = result + "&nbsp;<b>" + hr.h_cname + "</b>";
                result = result + "<br>\n";
            }
        }
        boolean is_cname_shh = false;
        if (is_alias && host.startsWith("www.") && hr.h_cname.startsWith("www")) {
            int k;
            for (k = 3; k < hr.h_cname.length() && Character.isDigit(hr.h_cname.charAt(k)); ++k) {
            }
            if (k < hr.h_cname.length() && hr.h_cname.charAt(k) == '.') {
                is_cname_shh = true;
            }
        }
        boolean is_host_shh = false;
        String host_main = "";
        if (is_alias && host.startsWith("www")) {
            int k;
            for (k = 3; k < host.length() && Character.isDigit(host.charAt(k)); ++k) {
            }
            if (k < host.length() && host.charAt(k) == '.') {
                is_host_shh = true;
                host_main = "www" + host.substring(k);
            }
        }
        if (is_cname_shh) {
            if (isSmartHostHeuristics) {
                result = result + this.getI18n("simulator.note");
                result = result + this.getI18n("simulator.smarthoston");
                result = result + "&nbsp;<b>" + host + "</b>&nbsp;";
                result = result + "<br>\n";
            } else {
                result = result + this.getI18n("simulator.note");
                result = result + this.getI18n("simulator.ifsmarthoston");
                result = result + "&nbsp;<b>" + hr.h_cname + "</b>&nbsp;";
                result = result + this.getI18n("simulator.automapto");
                result = result + "&nbsp;<b>" + host + "</b>&nbsp;";
                result = result + "<br>\n";
            }
            result = result + this.getI18n("simulator.note");
            result = result + this.getI18n("simulator.ifhostlike");
            result = result + "&nbsp;<b>" + hr.h_cname + "</b>&nbsp;";
            result = result + this.getI18n("simulator.hasunique");
            result = result + "<br>\n";
        } else if (is_host_shh) {
            if (isSmartHostHeuristics) {
                result = result + this.getI18n("simulator.actionsmarthostison");
                result = result + "&nbsp;'<b>" + host_main + "</b>'.";
            } else {
                result = result + this.getI18n("simulator.note");
                result = result + "&nbsp;<b>" + host + "</b>&nbsp;";
                result = result + this.getI18n("simulator.dnsmirror");
                result = result + "<br>\n";
                result = result + this.getI18n("simulator.heavilyload");
                result = result + "&nbsp;<b>" + host_main + "</b>.&nbsp;";
                result = result + this.getI18n("simulator.enablesmarthost");
                result = result + "&nbsp;<b>" + host + "</b>&nbsp;";
                result = result + "<br>\n";
            }
            result = result + this.getI18n("simulator.note");
            result = result + this.getI18n("simulator.ifhostlike");
            result = result + "&nbsp;<b>" + hr.h_cname + "</b>&nbsp;";
            result = result + this.getI18n("simulator.hasunique");
            result = result + "<br>\n";
        }
        if (!protocol.startsWith("http")) {
            return result;
        }
        result = result + "\n<hr>\n";
        result = result + this.getI18n("simulator.checkredirect");
        result = result + "<br>\n";
        RedirectResult r = this.doRedirect(root, false, url);
        if (r.return_code < 0) {
            result = result + this.getI18n("simulator.failconnect");
            result = result + "&nbsp;" + this.href(url) + "<br>";
            result = result + this.getI18n("simulator.noservice");
            return result;
        }
        if (r.return_code == 0) {
            result = result + this.getI18n("simulator.noredirectat");
            result = result + "&nbsp;" + this.href(url) + "<br>";
        } else {
            result = result + this.href(url) + "&nbsp;";
            result = result + this.getI18n("simulator.isredirect") + "&nbsp;";
            result = r.redirect_url.indexOf("://") > 0 ? result + this.href(r.redirect_url) : result + this.href(protocol + "://" + host + ":" + port + (r.redirect_url.charAt(0) == '/' ? "/" : "") + r.redirect_url);
            result = result + "<br>\n";
            if (this.sameHost(r.redirect_url, host)) {
                result = result + this.getI18n("simulator.redirect2same");
            } else {
                result = result + this.getI18n("simulator.needsite4redirect");
                result = result + "&nbsp;<b>" + this.href(r.redirect_url) + "</b>";
            }
            result = result + "<br>\n";
        }
        result = result + "<hr>\n";
        result = result + this.getI18n("simulator.servertype") + "&nbsp;" + (r.server_type == null ? this.getI18n("simulator.unknowntype") : r.server_type) + "<br>\n";
        if (r.return_code >= 0) {
            result = result + "<hr>\n";
            result = result + this.getI18n("simulator.checkvirtual");
            result = result + "<br>\n";
            RedirectResult r1 = this.doRedirect(root, true, url);
            String url2 = protocol + "://" + hr.h_cname + ":" + port + uri;
            RedirectResult r2 = this.doRedirect(root, true, url2);
            if (r1.return_code < 0) {
                result = result + this.getI18n("simulator.failconnect");
                result = result + "&nbsp;" + this.href(url) + "<br>";
                result = result + this.getI18n("simulator.noservice");
            }
            if (r2.return_code < 0) {
                result = result + this.getI18n("simulator.failconnect");
                result = result + "&nbsp;" + this.href(url2) + "<br>";
                result = result + this.getI18n("simulator.noservice");
            }
            if (r1.content_length < 0) {
                result = result + this.getI18n("simulator.failconnect");
                result = result + "&nbsp;" + this.href(url2) + "<br>";
                result = result + this.getI18n("simulator.noservice");
            }
            if (r2.return_code < 0 || r1.return_code < 0) {
                return result;
            }
            if (r2.content_length == 0) {
                result = result + this.getI18n("simulator.failcontentlength");
                result = result + "&nbsp;" + this.href(url2) + "<br>";
                result = result + this.getI18n("simulator.nocontentlength");
            }
            if (r1.content_length == 0) {
                result = result + this.getI18n("simulator.failcontentlength");
                result = result + "&nbsp;" + this.href(url) + "<br>";
                result = result + this.getI18n("simulator.nocontentlength");
            }
            if (r1.content_length == 0 || r2.content_length == 0) {
                return result;
            }
            if (r1.content_length == r2.content_length) {
                result = result + this.getI18n("simulator.novirtual");
                result = result + "&nbsp;" + this.href(url);
            } else {
                result = result + this.href(url2) + "&nbsp;";
                result = result + this.getI18n("simulator.isvirtual");
                result = result + "&nbsp;" + this.href(url2);
            }
            result = result + "<br>\n";
        }
        return result;
    }

    public String runSimulator(boolean isSmartHostHeuristics, String root, String[] url_list, boolean do_dns, boolean do_redirect) throws Exception {
        String runCsCli = null;
        runCsCli = FilterSimulator.isWindows() ? "run-cs-cli.bat" : "run-cs-cli";
        String cmd = root + File.separator + runCsCli + " frsim -l " + root + File.separator + "config" + File.separator + "filterrules.conf";
        String result = "";
        for (int i = 0; i < url_list.length; ++i) {
            String s;
            boolean is_ok = false;
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader in = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            PrintWriter out = new PrintWriter(proc.getOutputStream());
            out.println(url_list[i]);
            out.flush();
            out.close();
            while ((s = in.readLine()) != null) {
                if (s.substring(0, 9).equalsIgnoreCase("Accepted:")) {
                    is_ok = true;
                    result = result + this.format(this.accepted(), this.trim_fr(s.substring(9)));
                    continue;
                }
                if (s.substring(0, 9).equalsIgnoreCase("Rejected:")) {
                    result = result + this.format(this.rejected(), this.trim_fr(s.substring(9)));
                    continue;
                }
                if (s.substring(0, 8).equalsIgnoreCase("Skipping")) {
                    result = result + this.format(this.warning(), this.trim_fr(s));
                    continue;
                }
                result = result + this.format(this.warning(), s);
            }
            in.close();
            String host = "";
            try {
                URL url = new URL(url_list[i]);
                host = url.getHost();
            }
            catch (Exception e) {
                result = result + this.format(this.warning(), this.getI18n("simulator.malformed"));
                is_ok = false;
            }
            if (is_ok && do_dns) {
                HostResult hr = this.doGetHostByName(root, host);
                if (hr.h_errno != 0) {
                    String tmp = hr.h_errno == 1 ? this.getI18n("simulator.invalidhost") + host : (hr.h_errno == 2 || hr.h_errno == 3 ? this.getI18n("simulator.dnsreterror") : (hr.h_errno == 4 ? this.getI18n("simulator.donmainnothost") : this.getI18n("simulator.unknownerror")));
                    result = result + this.format(this.rejected(), tmp);
                } else if (hr.h_aliases != null) {
                    boolean found = false;
                    boolean ok = false;
                    int j = 0;
                    while (i < hr.h_aliases.length) {
                        if (hr.h_aliases[j].indexOf(host) > -1) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found && isSmartHostHeuristics && hr.h_cname.length() > 4) {
                        char c = hr.h_cname.charAt(4);
                        if (hr.h_cname.startsWith("www") && (c == '.' || Character.isDigit(c))) {
                            ok = true;
                        }
                    }
                    result = ok ? result + this.format(this.accepted(), this.getI18n("simulator.alias") + " " + hr.h_cname + " " + this.getI18n("simulator.aliasallow")) : result + this.format(this.rejected(), this.getI18n("simulator.alias4") + " " + hr.h_cname);
                } else {
                    result = result + this.format(this.accepted(), this.getI18n("simulator.validhostname"));
                }
            }
            if (!is_ok || !do_redirect) continue;
            RedirectResult r = this.doRedirect(root, false, url_list[i]);
            if (r.return_code < 0) {
                result = result + this.format(this.warning(), this.getI18n("simulator.failconnect"));
            }
            result = r.return_code == 0 ? result + this.format(this.accepted(), this.getI18n("simulator.noredirect")) : (this.sameHost(r.redirect_url, host) ? result + this.format(this.warning(), this.getI18n("simulator.rejectbyrule") + host) : result + this.format(this.rejected(), this.getI18n("simulator.redirect2") + this.href(r.redirect_url)));
        }
        return result;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    static void main(String[] args) throws Exception {
        FilterSimulator frsim = new FilterSimulator();
        System.out.println("<html><body>\n");
        String result = frsim.runSimulator(true, args[0], args, true, true);
        System.out.println("\n<hr>Simulator Result is:<hr><table>\n ");
        System.out.println(result);
        System.out.println("</table>\n");
        result = frsim.runProb(true, args[0], true, args[1]);
        System.out.println("\n<hr>Site Prob Result is:<hr><table>\n ");
        System.out.println(result);
        System.out.println("</table>\n");
        System.out.println("</body></html>\n");
    }

    class RedirectResult {
        String redirect_url;
        String server_type;
        int content_length;
        int return_code;

        public RedirectResult(int code, String host, String type, int length) {
            this.redirect_url = host;
            this.server_type = type;
            this.content_length = length;
            this.return_code = code;
        }
    }

    class HostResult {
        String h_cname;
        int h_type;
        int h_errno;
        int h_length;
        String[] h_ips;
        String[] h_aliases;
        String org_url;

        public HostResult(String url, int code, String host, int length, int type, String[] ps, String[] aliases) {
            this.org_url = url;
            this.h_cname = host;
            this.h_length = length;
            this.h_type = type;
            this.h_ips = ps;
            this.h_aliases = aliases;
            this.h_errno = code;
        }

        public String toString() {
            int i;
            String result = "";
            result = result + "GetHostByname() " + FilterSimulator.this.getI18n("simulator.resultfor") + " '" + this.org_url + "'\n";
            result = result + "h_error: " + this.h_errno + " - ";
            switch (this.h_errno) {
                case 0: {
                    result = result + FilterSimulator.this.getI18n("simulator.successdns");
                    break;
                }
                case 1: {
                    result = result + FilterSimulator.this.getI18n("simulator.namenotfound");
                    break;
                }
                case 2: {
                    result = result + FilterSimulator.this.getI18n("simulator.dnsserverfail");
                    break;
                }
                case 3: {
                    result = result + FilterSimulator.this.getI18n("simulator.norecovery");
                    break;
                }
                case 4: {
                    result = result + FilterSimulator.this.getI18n("simulator.samename");
                    break;
                }
                default: {
                    result = result + FilterSimulator.this.getI18n("simulator.unknownerror");
                }
            }
            result = result + "\nName:     " + (this.h_cname != null ? this.h_cname : "");
            if (this.h_aliases != null) {
                for (i = 0; i < this.h_aliases.length && this.h_aliases[i] != null; ++i) {
                    result = result + "\nAliase:   " + this.h_aliases[i];
                }
            }
            result = result + "\naddrtype: " + this.h_type;
            result = result + "\nlength:   " + this.h_length;
            if (this.h_ips != null) {
                for (i = 0; i < this.h_ips.length && this.h_ips[i] != null; ++i) {
                    result = result + "\nip:       " + this.h_ips[i];
                }
            }
            result = result + "\n";
            return result;
        }
    }
}

