/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.DbStatListDBView;
import com.sun.portal.search.admin.model.DbStatModelImpl;
import java.text.NumberFormat;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbStatListProtocolView
extends RequestHandlingTiledViewBase
implements TiledView,
RequestHandler {
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$DbStatListProtocolView == null ? (class$com$sun$portal$search$admin$DbStatListProtocolView = DbStatListProtocolView.class$("com.sun.portal.search.admin.DbStatListProtocolView")) : class$com$sun$portal$search$admin$DbStatListProtocolView));
    public static final String DBSTAT_PROTOCOL_NAME = "DbStatProtocolName";
    public static final String DBSTAT_PROTOCOL_NB_RD = "DbStatProtocolNbRd";
    public static final String DBSTAT_PROTOCOL_PERCENTAGE = "DbStatProtocolPercentage";
    static /* synthetic */ Class class$com$sun$portal$search$admin$DbStatListProtocolView;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;

    public DbStatListProtocolView(View parent, String name) {
        super(parent, name);
        try {
            this.setMaxDisplayTiles(100);
            this.registerChildren();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
    }

    protected void registerChildren() {
        this.registerChild(DBSTAT_PROTOCOL_NAME, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListProtocolView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(DBSTAT_PROTOCOL_NB_RD, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListProtocolView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(DBSTAT_PROTOCOL_PERCENTAGE, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListProtocolView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
    }

    protected View createChild(String name) {
        if (name.equals(DBSTAT_PROTOCOL_NAME)) {
            StaticTextField child = new StaticTextField((ContainerView)this, DBSTAT_PROTOCOL_NAME, (Object)"http");
            if (child == null) {
                debugLogger.finer("PSSH_CSPSA0030");
            }
            return child;
        }
        if (name.equals(DBSTAT_PROTOCOL_NB_RD)) {
            StaticTextField child = new StaticTextField((ContainerView)this, DBSTAT_PROTOCOL_NB_RD, (Object)"3");
            if (child == null) {
                debugLogger.finer("PSSH_CSPSA0031");
            }
            return child;
        }
        if (name.equals(DBSTAT_PROTOCOL_PERCENTAGE)) {
            StaticTextField child = new StaticTextField((ContainerView)this, DBSTAT_PROTOCOL_PERCENTAGE, (Object)"3%");
            if (child == null) {
                debugLogger.finer("PSSH_CSPSA0032");
            }
            return child;
        }
        debugLogger.log(Level.INFO, "PSSH_CSPSA0002", name);
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        DbStatModelImpl dbModel = this.getDbStatModel();
        this.setPrimaryModel((DatasetModel)dbModel);
        if (this.getPrimaryModel() == null) {
            debugLogger.info("PSSH_CSPSA0023");
            throw new ModelControlException("Primary model is null");
        }
        try {
            this.getPrimaryModel().setSize(dbModel.nbProtocols());
            super.beginDisplay(event);
            this.resetTileIndex();
            dbModel.resetProtocols();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
    }

    public boolean nextTile() throws ModelControlException {
        try {
            boolean movedToRow = super.nextTile();
            if (movedToRow) {
                DbStatModelImpl dbModel = this.getDbStatModel();
                if (dbModel.hasMoreProtocol()) {
                    String protocolName = dbModel.nextProtocolName();
                    this.setDisplayFieldValue(DBSTAT_PROTOCOL_NAME, protocolName);
                    String rdCounter = dbModel.nextProtocolRDCounter();
                    this.setDisplayFieldValue(DBSTAT_PROTOCOL_NB_RD, rdCounter);
                    double div = dbModel.getTotalNbRd();
                    double percentage = div != 0.0 ? new Double(rdCounter) / div : 0.0;
                    this.setDisplayFieldValue(DBSTAT_PROTOCOL_PERCENTAGE, NumberFormat.getPercentInstance().format(percentage));
                    return true;
                }
                return false;
            }
            return movedToRow;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            return false;
        }
    }

    public DbStatModelImpl getDbStatModel() {
        DbStatListDBView p = (DbStatListDBView)this.getParent();
        return p.getDbStatModel();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

