/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.iplanet.am.console.components.view.html.IPlanetButton;
import com.iplanet.jato.RequestHandler;
import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.DefaultModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.TiledView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.event.TiledViewRequestInvocationEvent;
import com.iplanet.jato.view.html.HiddenField;
import com.iplanet.jato.view.html.StaticTextField;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.CSConfig;
import com.sun.portal.search.admin.DbStatListProtocolView;
import com.sun.portal.search.admin.DbStatListServerView;
import com.sun.portal.search.admin.DbStatViewBean;
import com.sun.portal.search.admin.model.DbStatModelImpl;
import com.sun.portal.search.admin.util.DBUtil;
import com.sun.portal.search.util.SearchConfig;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpSession;

public class DbStatListDBView
extends RequestHandlingTiledViewBase
implements TiledView,
RequestHandler {
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$DbStatListDBView == null ? (class$com$sun$portal$search$admin$DbStatListDBView = DbStatListDBView.class$("com.sun.portal.search.admin.DbStatListDBView")) : class$com$sun$portal$search$admin$DbStatListDBView));
    public static final String DB_NAME = "DatabaseName";
    public static final String HIDDEN_DB_NAME = "HiddenDatabaseName";
    public static final String DB_STAT_ONFILE_STATUS = "onFileAnalysisStatus";
    public static final String DB_STAT_NB_RD = "DbStatNbRd";
    public static final String DB_STAT_NB_SERVER = "DbStatNbServer";
    public static final String DB_STAT_LIST_SERVER = "DbStatListServerView";
    public static final String DB_STAT_LIST_PROTOCOL = "DbStatListProtocolView";
    public static final String DB_STAT_LAST_UPDATED = "DbStatLastUpdated";
    public static final String DB_STAT_REFRESH = "DbStatRefresh";
    static /* synthetic */ Class class$com$sun$portal$search$admin$DbStatListDBView;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$StaticTextField;
    static /* synthetic */ Class class$com$iplanet$jato$view$html$HiddenField;
    static /* synthetic */ Class class$com$sun$portal$search$admin$DbStatListServerView;
    static /* synthetic */ Class class$com$sun$portal$search$admin$DbStatListProtocolView;
    static /* synthetic */ Class class$com$iplanet$am$console$components$view$html$IPlanetButton;

    public DbStatListDBView(View parent, String name) {
        super(parent, name);
        try {
            this.setPrimaryModel((DatasetModel)this.getDefaultModel());
            this.registerChildren();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
    }

    protected void registerChildren() {
        this.registerChild(DB_NAME, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListDBView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(HIDDEN_DB_NAME, class$com$iplanet$jato$view$html$HiddenField == null ? (class$com$iplanet$jato$view$html$HiddenField = DbStatListDBView.class$("com.iplanet.jato.view.html.HiddenField")) : class$com$iplanet$jato$view$html$HiddenField);
        this.registerChild(DB_STAT_ONFILE_STATUS, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListDBView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(DB_STAT_NB_RD, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListDBView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(DB_STAT_NB_SERVER, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListDBView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(DB_STAT_LIST_SERVER, class$com$sun$portal$search$admin$DbStatListServerView == null ? (class$com$sun$portal$search$admin$DbStatListServerView = DbStatListDBView.class$("com.sun.portal.search.admin.DbStatListServerView")) : class$com$sun$portal$search$admin$DbStatListServerView);
        this.registerChild(DB_STAT_LIST_PROTOCOL, class$com$sun$portal$search$admin$DbStatListProtocolView == null ? (class$com$sun$portal$search$admin$DbStatListProtocolView = DbStatListDBView.class$("com.sun.portal.search.admin.DbStatListProtocolView")) : class$com$sun$portal$search$admin$DbStatListProtocolView);
        this.registerChild(DB_STAT_LAST_UPDATED, class$com$iplanet$jato$view$html$StaticTextField == null ? (class$com$iplanet$jato$view$html$StaticTextField = DbStatListDBView.class$("com.iplanet.jato.view.html.StaticTextField")) : class$com$iplanet$jato$view$html$StaticTextField);
        this.registerChild(DB_STAT_REFRESH, class$com$iplanet$am$console$components$view$html$IPlanetButton == null ? (class$com$iplanet$am$console$components$view$html$IPlanetButton = DbStatListDBView.class$("com.iplanet.am.console.components.view.html.IPlanetButton")) : class$com$iplanet$am$console$components$view$html$IPlanetButton);
    }

    protected View createChild(String name) {
        if (name.equals(DB_NAME)) {
            return new StaticTextField((ContainerView)this, DB_NAME, (Object)DB_NAME);
        }
        if (name.equals(HIDDEN_DB_NAME)) {
            return new HiddenField((ContainerView)this, HIDDEN_DB_NAME, (Object)"");
        }
        if (name.equals(DB_STAT_ONFILE_STATUS)) {
            return new StaticTextField((ContainerView)this, DB_STAT_ONFILE_STATUS, (Object)DB_STAT_ONFILE_STATUS);
        }
        if (name.equals(DB_STAT_NB_RD)) {
            return new StaticTextField((ContainerView)this, DB_STAT_NB_RD, (Object)DB_STAT_NB_RD);
        }
        if (name.equals(DB_STAT_NB_SERVER)) {
            return new StaticTextField((ContainerView)this, DB_STAT_NB_SERVER, (Object)DB_STAT_NB_SERVER);
        }
        if (name.equals(DB_STAT_LIST_SERVER)) {
            return new DbStatListServerView((View)this, DB_STAT_LIST_SERVER);
        }
        if (name.equals(DB_STAT_LIST_PROTOCOL)) {
            return new DbStatListProtocolView((View)this, DB_STAT_LIST_PROTOCOL);
        }
        if (name.equals(DB_STAT_LAST_UPDATED)) {
            return new StaticTextField((ContainerView)this, DB_STAT_LAST_UPDATED, (Object)DB_STAT_LAST_UPDATED);
        }
        if (name.equals(DB_STAT_REFRESH)) {
            DbStatViewBean pvb = (DbStatViewBean)this.getParentViewBean();
            String btnLabel = pvb != null ? pvb.getLocalizedString("db.stat.refreshBtn") : "Refresh";
            IPlanetButton child = new IPlanetButton((ContainerView)this, DB_STAT_REFRESH, (Object)btnLabel);
            return child;
        }
        debugLogger.log(Level.INFO, "PSSH_CSPSA0002", name);
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        this.resetTileIndex();
        this.updateModel();
    }

    private void updateModel() throws ModelControlException {
        DefaultModel model = (DefaultModel)this.getPrimaryModel();
        try {
            model.clear();
            String[] dbNames = DBUtil.getDBStringArray(CSConfig.getServerRoot());
            for (int i = 0; i < dbNames.length; ++i) {
                model.appendRow();
                model.setValue(DB_NAME, (Object)dbNames[i]);
                if (this.getDbStatModel(dbNames[i]) != null) continue;
                debugLogger.log(Level.FINER, "PSSH_CSPSA0026", dbNames[i]);
            }
            this.getPrimaryModel().setSize(dbNames.length);
        }
        catch (Exception e) {
            debugLogger.info("PSSH_CSPSA0027");
            this.getPrimaryModel().setSize(0);
        }
    }

    public boolean nextTile() throws ModelControlException {
        boolean movedToRow = super.nextTile();
        if (movedToRow) {
            String currentDbName = (String)((DefaultModel)this.getPrimaryModel()).getValue(DB_NAME);
            DbStatViewBean pvb = (DbStatViewBean)this.getParentViewBean();
            if (currentDbName == null) {
                currentDbName = SearchConfig.getValue((String)"database-name");
            }
            DbStatModelImpl dbModel = this.getDbStatModel(currentDbName);
            this.setDisplayFieldValue(HIDDEN_DB_NAME, currentDbName);
            this.setDisplayFieldValue(DB_NAME, currentDbName);
            this.setDisplayFieldValue(DB_STAT_NB_RD, dbModel.getTotalNbRd());
            this.setDisplayFieldValue(DB_STAT_NB_SERVER, dbModel.getTotalNbServer());
            Date lastUpdated = dbModel.getLastUpdated();
            DateFormat df = DateFormat.getDateTimeInstance(1, 1, pvb.getUserLocale());
            try {
                this.setDisplayFieldValue(DB_STAT_LAST_UPDATED, df.format(lastUpdated));
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0028", e.getMessage());
                this.setDisplayFieldValue(DB_STAT_LAST_UPDATED, lastUpdated.toString());
            }
            if (dbModel.isOld()) {
                this.setDisplayFieldValue(DB_STAT_ONFILE_STATUS, pvb.getLocalizedString("db.stat.outDated"));
                ((IPlanetButton)this.getChild(DB_STAT_REFRESH, this.getTileIndex())).setEnable(true);
            } else {
                this.setDisplayFieldValue(DB_STAT_ONFILE_STATUS, pvb.getLocalizedString("db.stat.upToDate"));
                ((IPlanetButton)this.getChild(DB_STAT_REFRESH, this.getTileIndex())).setEnable(false);
            }
        }
        return movedToRow;
    }

    DbStatModelImpl getDbStatModel() {
        return this.getDbStatModel((String)this.getPrimaryModel().getValue(DB_NAME));
    }

    private DbStatModelImpl getDbStatModel(String dbName) {
        DbStatModelImpl dbModel = null;
        try {
            HttpSession session = this.getRequestContext().getRequest().getSession();
            dbModel = (DbStatModelImpl)session.getAttribute(dbName);
            if (dbModel == null) {
                dbModel = new DbStatModelImpl(dbName);
                session.setAttribute(dbName, (Object)dbModel);
            }
            return dbModel;
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0029", new String[]{dbName, e.getMessage()});
            return dbModel;
        }
    }

    public void handleDbStatRefreshRequest(RequestInvocationEvent event) {
        try {
            String[] dbNames = DBUtil.getDBStringArray(CSConfig.getServerRoot());
            DbStatModelImpl dbModel = this.getDbStatModel(dbNames[((TiledViewRequestInvocationEvent)event).getTileNumber()]);
            if (dbModel.isOld()) {
                dbModel.retrieve(false);
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

