/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import com.sun.portal.log.common.PortalLogManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.search.admin.ImportConfig;
import com.sun.portal.search.admin.TaxListDumper;
import com.sun.portal.search.admin.resources.SearchResource;
import com.sun.portal.search.rdm.RDMCallback;
import com.sun.portal.search.rdm.RDMTaxonomy;
import com.sun.portal.search.robot.RobotConfig;
import com.sun.portal.search.soif.SOIFInputStream;
import com.sun.portal.search.util.SearchConfig;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CSConfig {
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$search$admin$CSConfig == null ? (class$com$sun$portal$search$admin$CSConfig = CSConfig.class$("com.sun.portal.search.admin.CSConfig")) : class$com$sun$portal$search$admin$CSConfig));
    protected static String P_FILE = null;
    protected static Properties csconfig = null;
    protected static boolean inited = false;
    protected static boolean searchInited = false;
    static RobotConfig robotConf = null;
    private static RDMTaxonomy taxonomy = null;
    private static String taxonomyFileName = null;
    protected static long taxFileLastModified = -1L;
    protected static String[] taxonomyList = null;
    protected static String[] taxonomyLabelList = null;
    protected static String server_root = null;
    protected static String base = "/var/opt/SUNWportal";
    protected static String uri = "/ps";
    protected static String binDir = null;
    protected static String libDir = null;
    protected static String libPath = null;
    protected static ResourceBundle rb = null;
    protected static Locale locale = Locale.US;
    static /* synthetic */ Class class$com$sun$portal$search$admin$CSConfig;

    static void checkConfigRefresh() {
        if (taxFileLastModified == -1L) {
            CSConfig.loadTaxonomy();
        } else {
            try {
                File file = new File(taxonomyFileName);
                long lastmodified = file.lastModified();
                if (lastmodified <= taxFileLastModified) {
                    return;
                }
                CSConfig.loadTaxonomy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void loadTaxonomy() {
        try {
            taxonomyFileName = SearchConfig.getValue((String)"taxonomy-description");
            File file = new File(taxonomyFileName);
            taxFileLastModified = file.lastModified();
            SOIFInputStream ss = new SOIFInputStream(taxonomyFileName);
            taxonomy = new RDMTaxonomy(ss);
        }
        catch (Exception e) {
            taxonomy = new RDMTaxonomy("Search");
        }
        ArrayList taxList = new ArrayList();
        try {
            taxonomy.apply(1, (RDMCallback)new TaxListDumper(taxList));
            String[] a = new String[]{"a"};
            if (taxList.size() == 0) {
                taxonomyList = null;
                taxonomyLabelList = null;
                return;
            }
            taxonomyList = taxList.toArray(a);
            taxonomyLabelList = taxList.toArray(a);
            String ident = null;
            try {
                ResourceBundle rb = SearchResource.getResourceBundle(locale);
                ident = rb.getString("taxonomy.ident.text");
            }
            catch (MissingResourceException e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0014", "searchadminmsgs");
            }
            if (ident == null) {
                ident = "&nbsp;&nbsp;&nbsp;&nbsp;";
            }
            for (int i = 0; taxonomyLabelList != null && i < taxonomyLabelList.length; ++i) {
                StringTokenizer st = new StringTokenizer(taxonomyLabelList[i], ":");
                String last = "";
                int n = 0;
                while (st.hasMoreTokens()) {
                    last = st.nextToken();
                    ++n;
                }
                for (int j = 0; j < n - 1; ++j) {
                    last = ident + last;
                }
                CSConfig.taxonomyLabelList[i] = last;
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
        }
    }

    public static RDMTaxonomy getTaxonomy() {
        CSConfig.checkConfigRefresh();
        return taxonomy;
    }

    public static String[] getTaxonomyNameList() {
        CSConfig.checkConfigRefresh();
        return taxonomyList;
    }

    public static String[] getTaxonomyLabelList() {
        CSConfig.checkConfigRefresh();
        return taxonomyLabelList;
    }

    public static String getBinPath() {
        if (binDir != null) {
            return binDir;
        }
        return "/opt/SUNWportal/bin";
    }

    public static String getLibDir() {
        if (libDir != null) {
            return libDir;
        }
        return "/opt/SUNWportal/lib";
    }

    public static String getLibPath() {
        if (libPath != null) {
            return libPath;
        }
        return "/opt/SUNWportal/lib";
    }

    public static String getServerRoot() {
        return server_root;
    }

    public static void setServerRoot(String root) {
        server_root = root;
    }

    public static void init(String root) {
        server_root = root;
        CSConfig.initConfig();
    }

    public static void initSearch(String searchURL) {
        InputStream in;
        debugLogger.log(Level.FINER, "PSSH_CSPSA0015", searchURL);
        if (searchInited) {
            return;
        }
        try {
            URL command_url = new URL(searchURL);
            URLConnection url_conn = command_url.openConnection();
            in = url_conn.getInputStream();
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0010", e.getMessage());
            return;
        }
        try {
            byte[] buff = new byte[1024];
            int n = in.read(buff, 0, 1024);
            while (n > 0) {
                n = in.read(buff, 0, 1024);
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0016", e.getMessage());
            return;
        }
        searchInited = true;
    }

    public static void initLogging(String serverRoot) {
        PortalLogManager manager = new PortalLogManager();
        String searchLogConfigFile = serverRoot + File.separator + "config" + File.separator + "SearchLogConfig.properties";
        manager.init(SearchConfig.SEARCH_LOGGER, searchLogConfigFile);
    }

    public static void initConfig() {
        inited = true;
        SearchConfig csidConf = SearchConfig.getSearchConfig();
        if (csidConf == null) {
            try {
                SearchConfig.init((String)(server_root + File.separator + "config" + File.separator + "search.conf"));
                csidConf = SearchConfig.getSearchConfig();
            }
            catch (Exception e) {
                debugLogger.log(Level.INFO, "PSSH_CSPSA0017", e.getMessage());
            }
        }
        if (csidConf != null) {
            binDir = SearchConfig.getValue((String)"bindir");
            libDir = SearchConfig.getValue((String)"libdir");
            libPath = SearchConfig.getValue((String)"libpath");
            String debug = SearchConfig.getValue((String)"admin-debug");
        }
        robotConf = new RobotConfig(server_root + File.separator + "config");
        try {
            ImportConfig.init(server_root + File.separator + "config" + File.separator + "import.conf");
        }
        catch (Exception e) {
            debugLogger.log(Level.INFO, "PSSH_CSPSA0018", e.getMessage());
        }
    }

    public static void setAdminLocale(Locale adminLocale) {
        locale = adminLocale;
    }

    public static Locale getAdminLocale() {
        return locale;
    }

    public static RobotConfig getRobotConfig() {
        return robotConf;
    }

    public static void main(String[] args) {
        CSConfig.init(args[0]);
        for (int i = 0; i < taxonomyList.length; ++i) {
            System.out.println(taxonomyLabelList[i] + "[" + taxonomyList[i] + "]");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

