/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.search.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class AdminMenu {
    private static HashMap menus = new HashMap();
    public static String default_menutext = "Server|Server,Robot|Control,Database|ImportAgents,Categories|Reindex,Reports|RobotAdvancedReport";
    public static String[] default_submenus = new String[]{"Settings|Server, Advanced|AdvancedLog", "Control, Sites|Sites, Filters|Filters, Crawling|Crawling, Indexing|Indexing, Simulator|Simulator, Site Probe|SiteProbe, Schedule|RobotSchedule", "Import|ImportAgents, Edit|RDEditor, Schema|SchemaEditor, Partition|Partition, Reindex|Reindex, Purge|Purge, Analysis|DbStat, Schedule|ImportSchedule", "Category Editor|TaxonomyEditor, Classification Rules Editor|RobotCnRules, Reindex|Reindex", "Starting Points|StartPoints, Excluded URLs|ExcludedURLs, Robot Advanced Reports|RobotAdvancedReport, View Log Files|Logs"};
    private MenuPair[] main_mps = null;
    private Hashtable sub_menus = null;
    private Hashtable sub2main = null;

    public static void main(String[] args) {
        AdminMenu m = AdminMenu.getMenu(Locale.getDefault());
        for (int i = 0; i < m.main_mps.length; ++i) {
            System.out.println("menu:" + m.main_mps[i].name);
        }
    }

    public static AdminMenu getMenu(Locale locale) {
        AdminMenu menu = (AdminMenu)menus.get(locale);
        if (menu == null) {
            menu = new AdminMenu(locale);
            menus.put(locale, menu);
        }
        return menu;
    }

    public AdminMenu(Locale locale) {
        ResourceBundle adminMenu;
        try {
            adminMenu = ResourceBundle.getBundle("searchadminmenu", locale);
        }
        catch (Exception e) {
            return;
        }
        this.sub_menus = new Hashtable();
        this.sub2main = new Hashtable();
        String ms = adminMenu.getString("csmenu.list");
        if (ms != null) {
            this.main_mps = this.menuTexts2MenuPairArray(ms);
            for (int i = 0; i < this.main_mps.length; ++i) {
                try {
                    ms = adminMenu.getString("submenu." + this.main_mps[i].handle);
                    if (ms == null) continue;
                    MenuPair[] sub_mps = this.menuTexts2MenuPairArray(ms);
                    this.sub_menus.put(this.main_mps[i].handle, sub_mps);
                    for (int j = 0; j < sub_mps.length; ++j) {
                        this.sub2main.put(sub_mps[j].handle, this.main_mps[i].handle);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        } else {
            this.main_mps = this.menuTexts2MenuPairArray(default_menutext);
            for (int i = 0; i < this.main_mps.length; ++i) {
                MenuPair[] sub_mps = this.menuTexts2MenuPairArray(default_submenus[i]);
                this.sub_menus.put(this.main_mps[i].handle, sub_mps);
                for (int j = 0; j < sub_mps.length; ++j) {
                    this.sub2main.put(sub_mps[j].handle, this.main_mps[i].handle);
                }
            }
        }
    }

    protected MenuPair[] menuTexts2MenuPairArray(String ms) {
        if (ms != null && ms.length() > 0) {
            ArrayList<MenuPair> menu_list = new ArrayList<MenuPair>();
            StringTokenizer st = new StringTokenizer(ms, ",");
            while (st.hasMoreTokens()) {
                String m = st.nextToken();
                MenuPair mp = new MenuPair(m);
                menu_list.add(mp);
            }
            MenuPair[] b = new MenuPair[1];
            return menu_list.toArray(b);
        }
        return null;
    }

    public int numOfMainMenu() {
        if (this.main_mps != null) {
            return this.main_mps.length;
        }
        return 0;
    }

    public int numOfSubMenu(String mainKey) {
        MenuPair[] sub_mps = (MenuPair[])this.sub_menus.get(mainKey);
        if (sub_mps != null) {
            return sub_mps.length;
        }
        return 0;
    }

    public String getFirstSubHandle(String mainKey) {
        MenuPair[] sub_mps = (MenuPair[])this.sub_menus.get(mainKey);
        if (sub_mps != null && sub_mps.length > 0) {
            return sub_mps[0].handle;
        }
        return mainKey;
    }

    public String getMainMenuTextByIndex(int index) {
        return this.main_mps[index].name;
    }

    public String getSubMenuTextByIndex(String mainKey, int index) {
        MenuPair[] sub_mps = (MenuPair[])this.sub_menus.get(mainKey);
        return sub_mps[index].name;
    }

    public String getSubMenuHandleByIndex(String mainKey, int index) {
        MenuPair[] sub_mps = (MenuPair[])this.sub_menus.get(mainKey);
        if (sub_mps != null) {
            return sub_mps[index].handle;
        }
        return mainKey;
    }

    public String getMainMenuHandleByIndex(int index) {
        return this.main_mps[index].handle;
    }

    private Object[] getSubList(String id) {
        if (this.sub_menus == null) {
            return null;
        }
        return (Object[])this.sub_menus.get(id);
    }

    public String getMainHandleBySubHandle(String sub) {
        String handle = (String)this.sub2main.get(sub);
        if (handle == null) {
            handle = sub;
        }
        return handle;
    }

    public static String menuURL(String text) {
        int ndx = text.indexOf(124);
        if (ndx > 0) {
            return text.substring(ndx + 1);
        }
        return text;
    }

    public static String menuText(String text) {
        int ndx = text.indexOf(124);
        if (ndx > 0) {
            return text.substring(0, ndx);
        }
        return text;
    }

    class MenuPair {
        String name = null;
        String handle = null;

        public MenuPair() {
        }

        public MenuPair(String text) {
            int ndx = text.indexOf(124);
            if (ndx > 0) {
                this.name = text.substring(0, ndx);
                this.handle = text.substring(ndx + 1).trim();
            } else {
                this.name = text.trim();
                this.handle = text.trim();
            }
        }
    }
}

