/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.wssso.portlet;

import com.sun.portal.jspportlet.JspPortlet;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.wssso.common.SSOConfiguration;
import com.sun.portal.wsrp.wssso.common.SSOConfigurationException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.servlet.http.HttpServletRequest;

public class WSSSOPortlet
extends JspPortlet {
    public static final String USERINFO_CONTENT_PAGE = "wsssoContentPage";
    public static final String USERINFO_EDIT_PAGE = "wsssoEditPage";
    public static final String USERINFO_HELP_PAGE = "wsssoHelpPage";
    private ResourceBundle bundle = null;
    private static final String bundleName = "WSSSOPortlet";
    public static final String RENDER_PARAM_ERROR = "render_param_error";
    public static final String CANCEL = "Cancel";
    public static final String FINISHED = "Finished";
    public static final String RESOURCE_COUNT = "resourceCount";
    public static final String RESOURCE_NAME = "resourceName";
    public static final String RESOURCE_URL = "webserviceURL";
    public static final String RESOURCE_PASSWORD = "resourcePassword";
    public static final String ADD_RESOURCE = "addResource";
    public static final String HTTP_REQ_KEY = "javax.portlet.portletc.httpServletRequest";
    private PortletContext pContext;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$wssso$portlet$WSSSOPortlet == null ? (class$com$sun$portal$wsrp$wssso$portlet$WSSSOPortlet = WSSSOPortlet.class$("com.sun.portal.wsrp.wssso.portlet.WSSSOPortlet")) : class$com$sun$portal$wsrp$wssso$portlet$WSSSOPortlet));
    static /* synthetic */ Class class$com$sun$portal$wsrp$wssso$portlet$WSSSOPortlet;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.pContext = config.getPortletContext();
    }

    public void processAction(ActionRequest req, ActionResponse res) throws PortletException, IOException {
        if (this.isAction(req, CANCEL)) {
            res.setPortletMode(PortletMode.VIEW);
            return;
        }
        if (this.isAction(req, FINISHED)) {
            res.setPortletMode(PortletMode.VIEW);
            this.handleFinished(req);
        }
        Enumeration en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String value = en.nextElement().toString();
        }
        if (this.isAction(req, ADD_RESOURCE)) {
            res.setPortletMode(PortletMode.EDIT);
            this.handleAddResource(req);
        }
    }

    protected String getContentJSP(RenderRequest request) throws PortletException {
        PortletPreferences pref = request.getPreferences();
        String contentPage = pref.getValue(USERINFO_CONTENT_PAGE, "");
        return this.getLocalizedJSP(request.getLocale(), contentPage);
    }

    protected String getEditJSP(RenderRequest request) throws PortletException {
        PortletPreferences pref = request.getPreferences();
        String editPage = pref.getValue(USERINFO_EDIT_PAGE, "");
        return this.getLocalizedJSP(request.getLocale(), editPage);
    }

    protected String getHelpJSP(RenderRequest request) throws PortletException {
        PortletPreferences pref = request.getPreferences();
        String helpPage = pref.getValue(USERINFO_HELP_PAGE, "");
        return this.getLocalizedJSP(request.getLocale(), helpPage);
    }

    private boolean isAction(ActionRequest request, String action) {
        return request.getParameter(action) != null;
    }

    private void handleAddResource(ActionRequest req) {
        String newName = req.getParameter(RESOURCE_NAME);
        String newURL = req.getParameter(RESOURCE_URL);
        String newPassword = req.getParameter(RESOURCE_PASSWORD);
        HttpServletRequest httpReq = (HttpServletRequest)req.getAttribute(HTTP_REQ_KEY);
        try {
            SSOConfiguration ssoconfig = new SSOConfiguration(httpReq);
            ssoconfig.createConfiguration(newURL, newName, newPassword);
        }
        catch (SSOConfigurationException soe) {
            debugLogger.log(Level.SEVERE, "", soe);
        }
    }

    private void handleFinished(ActionRequest request) {
        this.checkDeleteFlag(request);
    }

    private void checkDeleteFlag(ActionRequest request) {
        String rc = request.getParameter(RESOURCE_COUNT);
        int resourceCount = Integer.parseInt(rc);
        for (int i = 0; i < resourceCount; ++i) {
            String checkBoxValue = request.getParameter("remove" + i);
            Integer removeFlag = null;
            removeFlag = checkBoxValue == null ? Integer.valueOf("0") : Integer.valueOf(checkBoxValue);
            if (removeFlag != 1) continue;
            String nameString = "username" + i;
            String urlString = "producerURL" + i;
            String name = request.getParameter(nameString);
            String url = request.getParameter(urlString);
            try {
                HttpServletRequest httpReq = (HttpServletRequest)request.getAttribute(HTTP_REQ_KEY);
                SSOConfiguration ssoconfig = new SSOConfiguration(httpReq);
                ssoconfig.deleteConfiguration(url);
                continue;
            }
            catch (SSOConfigurationException soe) {
                debugLogger.log(Level.SEVERE, "", soe);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

