/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.wssso.handler;

import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.wsrp.common.IdentityPropagationConstants;
import com.sun.portal.wsrp.common.OASISUsernameTokenProfile;
import com.sun.portal.wsrp.wssso.common.SSOConfiguration;
import com.sun.portal.wsrp.wssso.common.SSOConfigurationException;
import com.sun.xml.wss.impl.callback.DynamicPolicyCallback;
import com.sun.xml.wss.impl.configuration.DynamicApplicationContext;
import com.sun.xml.wss.impl.policy.MLSPolicy;
import com.sun.xml.wss.impl.policy.PolicyGenerationException;
import com.sun.xml.wss.impl.policy.SecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.AuthenticationTokenPolicy;
import com.sun.xml.wss.impl.policy.mls.DynamicSecurityPolicy;
import com.sun.xml.wss.impl.policy.mls.MessagePolicy;
import com.sun.xml.wss.impl.policy.mls.WSSPolicyGenerator;
import java.util.HashMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;

public class ClientHandler
implements CallbackHandler,
IdentityPropagationConstants {
    private UnsupportedCallbackException unsupported = new UnsupportedCallbackException(null, "Unsupported Callback Type Encountered");
    public static final String END_POINT_URL_KEY = "javax.xml.rpc.service.endpoint.address";

    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof DynamicPolicyCallback)) continue;
            DynamicPolicyCallback dpc = (DynamicPolicyCallback)callbacks[i];
            DynamicApplicationContext dac = (DynamicApplicationContext)dpc.getDynamicContext();
            HashMap map = dac.getRuntimeProperties();
            String markupURL = map.get(END_POINT_URL_KEY).toString();
            SSOConfiguration config = this.getSSOConfiguration(markupURL);
            if (config == null) {
                this.handleDefaultMessageCallback(dpc);
                return;
            }
            boolean inbound = dac.inBoundMessage();
            if (inbound) {
                this.handleDefaultMessageCallback(dpc);
                return;
            }
            this.handleOutBoundMessageCallback(dpc, config, markupURL);
        }
    }

    private void handleDefaultMessageCallback(DynamicPolicyCallback dpc) {
        DynamicSecurityPolicy policy = (DynamicSecurityPolicy)dpc.getSecurityPolicy();
        WSSPolicyGenerator generator = (WSSPolicyGenerator)policy.policyGenerator();
        MessagePolicy mPolicy = new MessagePolicy();
        mPolicy.dumpMessages(false);
        dpc.setSecurityPolicy((SecurityPolicy)mPolicy);
    }

    private void handleOutBoundMessageCallback(DynamicPolicyCallback dpc, SSOConfiguration config, String markupURL) {
        DynamicSecurityPolicy dsp = (DynamicSecurityPolicy)dpc.getSecurityPolicy();
        WSSPolicyGenerator generator = (WSSPolicyGenerator)dsp.policyGenerator();
        AuthenticationTokenPolicy.UsernameTokenBinding utb = null;
        try {
            String identityPropagationType = this.getIdentityPropagationType(config, markupURL);
            if (identityPropagationType == null || !this.isOASISTokenProfileEnabled(identityPropagationType)) {
                this.handleDefaultMessageCallback(dpc);
                return;
            }
            OASISUsernameTokenProfile profile = this.getUsernameTokenProfile(config, markupURL);
            if (profile.getUsername() == null) {
                this.handleDefaultMessageCallback(dpc);
                return;
            }
            AuthenticationTokenPolicy atp = generator.newAuthenticationTokenPolicy();
            utb = (AuthenticationTokenPolicy.UsernameTokenBinding)atp.newUsernameTokenFeatureBinding();
            if (this.isDigestEnabled(identityPropagationType)) {
                utb.setDigestOn(true);
            } else {
                utb.setDigestOn(false);
            }
            utb.setUsername(profile.getUsername());
            if (this.isPasswordEnabled(identityPropagationType)) {
                utb.setPassword(profile.getPassword());
            } else {
                utb.setPassword(null);
            }
            atp.setFeatureBinding((MLSPolicy)utb);
            MessagePolicy mPolicy = new MessagePolicy();
            mPolicy.dumpMessages(false);
            mPolicy.append((SecurityPolicy)atp);
            dpc.setSecurityPolicy((SecurityPolicy)mPolicy);
        }
        catch (PolicyGenerationException pge) {
            pge.printStackTrace();
            System.out.println((Object)pge);
        }
    }

    private OASISUsernameTokenProfile getUsernameTokenProfile(SSOConfiguration config, String markupURL) {
        OASISUsernameTokenProfile profile = null;
        try {
            profile = config.getUserConfigurationFromMarkupURL(markupURL);
        }
        catch (SSOConfigurationException ssoe) {
            profile = new OASISUsernameTokenProfile();
        }
        return profile;
    }

    private SSOConfiguration getSSOConfiguration(String markupURL) {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        try {
            SSOConfiguration config = new SSOConfiguration(req);
            return config;
        }
        catch (SSOConfigurationException ssoe) {
            return null;
        }
    }

    private boolean isOASISTokenProfileEnabled(String identityPropagationType) {
        return !identityPropagationType.equals("com.sun.portal.wsrp.identity.none") && !identityPropagationType.equals("com.sun.portal.wsrp.identity.ssotoken");
    }

    private boolean isPasswordEnabled(String identityPropagationType) {
        boolean passwordEnabled = false;
        if (identityPropagationType.equals("org.oasis.wss.username.token.profile.passwordtext") || identityPropagationType.equals("org.oasis.wss.username.token.profile.passworddigest")) {
            passwordEnabled = true;
        }
        return passwordEnabled;
    }

    private boolean isDigestEnabled(String identityPropagationType) {
        boolean digestEnabled = false;
        if (identityPropagationType.equals("org.oasis.wss.username.token.profile.passworddigest")) {
            digestEnabled = true;
        }
        return digestEnabled;
    }

    private String getIdentityPropagationType(SSOConfiguration config, String markupURL) {
        return config.getIdentityPropagationTypeFromMarkupURL(markupURL);
    }
}

