/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.wssso.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerBootstrap;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class UserProducers {
    private String wsrpConsumerConfigFileName = "wsrpconsumerconfig.properties";
    private String portalId = null;
    private String orgDN = null;
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$wssso$common$UserProducers == null ? (class$com$sun$portal$wsrp$wssso$common$UserProducers = UserProducers.class$("com.sun.portal.wsrp.wssso.common.UserProducers")) : class$com$sun$portal$wsrp$wssso$common$UserProducers));
    static /* synthetic */ Class class$com$sun$portal$wsrp$wssso$common$UserProducers;

    public UserProducers(HttpServletRequest httpReq) throws Exception {
        this.portalId = System.getProperty("com.sun.portal.portal.id");
        this.orgDN = this.getUserOrganization(httpReq);
        WSRPConsumerBootstrap.cliInitialized(this.wsrpConsumerConfigFileName, this.portalId);
    }

    public UserProducers(String portalId, String orgDN) {
        this.portalId = portalId;
        this.orgDN = orgDN;
        WSRPConsumerBootstrap.cliInitialized(this.wsrpConsumerConfigFileName, portalId);
    }

    public List getProducerNamesFromMarkupURL(String markupURL) {
        try {
            URL inputURL = new URL(markupURL);
            URL comparisonURL = null;
            ArrayList<String> result = new ArrayList<String>();
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getAdminSSOToken(), this.portalId, this.orgDN);
            Set producerEntityIds = pem.getProducerEntityIds();
            if (producerEntityIds != null && producerEntityIds.size() > 0) {
                Iterator i = producerEntityIds.iterator();
                while (i.hasNext()) {
                    String producerEntityId = (String)i.next();
                    ProducerEntity pe = pem.getProducerEntity(producerEntityId);
                    comparisonURL = new URL(pe.getMarkupEndpoint().toString());
                    if (!inputURL.equals(comparisonURL)) continue;
                    result.add(pe.getName());
                }
            }
            return result;
        }
        catch (WSRPConsumerException we) {
            debugLogger.log(Level.SEVERE, "", (Throwable)((Object)we));
        }
        catch (MalformedURLException me) {
            debugLogger.log(Level.SEVERE, "", me);
        }
        return null;
    }

    public List getProducerNamesFromProducerURL(String producerURL) {
        try {
            URL inputURL = new URL(producerURL);
            URL comparisonURL = null;
            ArrayList<String> result = new ArrayList<String>();
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getAdminSSOToken(), this.portalId, this.orgDN);
            Set producerEntityIds = pem.getProducerEntityIds();
            if (producerEntityIds != null && producerEntityIds.size() > 0) {
                Iterator i = producerEntityIds.iterator();
                while (i.hasNext()) {
                    String producerEntityId = (String)i.next();
                    ProducerEntity pe = pem.getProducerEntity(producerEntityId);
                    comparisonURL = pe.getURL();
                    if (!inputURL.equals(comparisonURL)) continue;
                    result.add(pe.getName());
                }
            }
            return result;
        }
        catch (WSRPConsumerException we) {
            debugLogger.log(Level.SEVERE, "", (Throwable)((Object)we));
        }
        catch (MalformedURLException me) {
            debugLogger.log(Level.SEVERE, "", me);
        }
        return null;
    }

    public List listUniqueConfiguredProducers() {
        try {
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getAdminSSOToken(), this.portalId, this.orgDN);
            Set producerEntityIds = pem.getProducerEntityIds();
            ArrayList<String> result = null;
            if (producerEntityIds != null && producerEntityIds.size() > 0) {
                result = new ArrayList<String>(producerEntityIds.size());
                Iterator i = producerEntityIds.iterator();
                while (i.hasNext()) {
                    String producerEntityId = (String)i.next();
                    ProducerEntity pe = pem.getProducerEntity(producerEntityId);
                    String producerURL = pe.getURL().toString();
                    if (pe.getIdentityPropagationType() == "com.sun.portal.wsrp.identity.none" || pe.getIdentityPropagationType() == "com.sun.portal.wsrp.identity.ssotoken" || result.contains(producerURL)) continue;
                    result.add(producerURL);
                }
            }
            return result;
        }
        catch (WSRPConsumerException e) {
            debugLogger.log(Level.SEVERE, "", (Throwable)((Object)e));
            return null;
        }
    }

    public List listAllConfiguredProducers() {
        try {
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getAdminSSOToken(), this.portalId, this.orgDN);
            Set producerEntityIds = pem.getProducerEntityIds();
            ArrayList<String> result = null;
            if (producerEntityIds != null && producerEntityIds.size() > 0) {
                result = new ArrayList<String>(producerEntityIds.size());
                Iterator i = producerEntityIds.iterator();
                while (i.hasNext()) {
                    String producerEntityId = (String)i.next();
                    ProducerEntity pe = pem.getProducerEntity(producerEntityId);
                    String producerURL = pe.getURL().toString();
                    if (pe.getIdentityPropagationType() == "com.sun.portal.wsrp.identity.none" || pe.getIdentityPropagationType() == "com.sun.portal.wsrp.identity.ssotoken" || result.contains(producerURL)) continue;
                    result.add(producerURL);
                }
            }
            return result;
        }
        catch (WSRPConsumerException e) {
            debugLogger.log(Level.SEVERE, "", (Throwable)((Object)e));
            return null;
        }
    }

    public String getIdentityPropagationTypeFromMarkupURL(String markupURL) {
        try {
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getAdminSSOToken(), this.portalId, this.orgDN);
            URL inputURL = new URL(markupURL);
            URL comparisonURL = null;
            Set producerEntityIds = pem.getProducerEntityIds();
            if (producerEntityIds != null && producerEntityIds.size() > 0) {
                Iterator i = producerEntityIds.iterator();
                while (i.hasNext()) {
                    String producerEntityId = (String)i.next();
                    ProducerEntity pe = pem.getProducerEntity(producerEntityId);
                    comparisonURL = new URL(pe.getMarkupEndpoint().toString());
                    if (!inputURL.equals(comparisonURL)) continue;
                    return pe.getIdentityPropagationType();
                }
            }
        }
        catch (WSRPConsumerException we) {
            debugLogger.log(Level.SEVERE, "", (Throwable)((Object)we));
        }
        catch (MalformedURLException me) {
            debugLogger.log(Level.SEVERE, "", me);
        }
        return null;
    }

    private SSOToken getAdminSSOToken() {
        return SSOUtil.getAdminSSOToken();
    }

    private SSOToken getUserSSOToken(HttpServletRequest req) throws SSOException {
        SSOTokenManager mgr = SSOTokenManager.getInstance();
        SSOToken token = mgr.createSSOToken(req);
        return token;
    }

    private String getUserOrganization(HttpServletRequest req) throws SSOException, AMException {
        SSOToken token = this.getUserSSOToken(req);
        String userDN = token.getPrincipal().getName();
        AMStoreConnection amsc = new AMStoreConnection(this.getAdminSSOToken());
        AMUser user = amsc.getUser(userDN);
        return user.getOrganizationDN();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

