/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.wssso.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.wsrp.common.OASISUsernameTokenProfile;
import com.sun.portal.wsrp.wssso.common.SSOConfigurationException;
import com.sun.portal.wsrp.wssso.common.UserProducers;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import com.sun.ssoadapter.SSOAdapterSession;
import com.sun.ssoadapter.config.ConfigurationFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class SSOConfiguration {
    public static final String WEBSERIVCE_WSDL_URL = "WebServiceURL";
    public static final String USERNAME = "WSUsername";
    public static final String PASSWORD = "WSPassword";
    public static final String SSOADAPTER_TEMPLATE_NAME = "OASIS-Username-Token-Profile";
    public static final String SEPARATOR = "_";
    public static final String portalId = System.getProperty("com.sun.portal.portal.id");
    private HttpServletRequest req = null;
    private SSOAdapterFactory adapterFactory = null;
    private UserProducers producers = null;
    private static final String CHANNEL_NAME = "channelName";
    private static final String ATTR_CONFIGURATIONS_NAME = "sunSSOAdapterConfigurations";
    private static final String ATTR_TEMPLATES_NAME = "sunConfigurationTemplates";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$wssso$common$SSOConfiguration == null ? (class$com$sun$portal$wsrp$wssso$common$SSOConfiguration = SSOConfiguration.class$("com.sun.portal.wsrp.wssso.common.SSOConfiguration")) : class$com$sun$portal$wsrp$wssso$common$SSOConfiguration));
    static /* synthetic */ Class class$com$sun$portal$wsrp$wssso$common$SSOConfiguration;

    public SSOConfiguration(HttpServletRequest req) throws SSOConfigurationException {
        this.req = req;
        this.adapterFactory = SSOAdapterFactory.getInstance();
        String orgDN = null;
        try {
            SSOToken token = this.getUserSSOToken(req);
            orgDN = this.getUserOrganization(token);
        }
        catch (SSOException soe) {
            debugLogger.log(Level.SEVERE, "", soe);
            throw new SSOConfigurationException("Failed to initialize SSOConfiguration", soe);
        }
        catch (AMException ame) {
            debugLogger.log(Level.SEVERE, "", ame);
            throw new SSOConfigurationException("Failed to initialize SSOConfiguration", ame);
        }
        this.producers = new UserProducers(portalId, orgDN);
    }

    public Map getUserConfigurations() throws SSOConfigurationException {
        try {
            HashMap<String, String> result = new HashMap<String, String>();
            SSOAdapter ssoAdapter = null;
            String username = null;
            String webserviceURL = null;
            String ssoAdapterName = null;
            Iterator ssoAdapterNames = this.getPossibleSSOAdapterNames().iterator();
            while (ssoAdapterNames.hasNext()) {
                ssoAdapterName = ssoAdapterNames.next().toString();
                try {
                    SSOAdapterSession session = new SSOAdapterSession(this.req);
                    ssoAdapter = this.adapterFactory.getSSOAdapter(ssoAdapterName, session);
                }
                catch (SSOAdapterException soe) {
                    ssoAdapter = null;
                }
                if (ssoAdapter == null) continue;
                Properties props = ssoAdapter.getProperties();
                List userPropertiesList = ssoAdapter.getUserPropertiesList();
                Object temp = props.get(WEBSERIVCE_WSDL_URL);
                if (temp != null) {
                    webserviceURL = temp.toString();
                }
                if ((temp = props.get(USERNAME)) != null) {
                    username = temp.toString();
                }
                result.put(webserviceURL, username);
            }
            return result;
        }
        catch (Exception e) {
            debugLogger.log(Level.SEVERE, "", e);
            throw new SSOConfigurationException(e);
        }
    }

    public OASISUsernameTokenProfile getUserConfigurationFromMarkupURL(String markupURL) throws SSOConfigurationException {
        List ssoAdapterConfigs = this.getSSOAdapterConfigurationNamesFromMarkupURL(markupURL);
        if (ssoAdapterConfigs == null || ssoAdapterConfigs.size() == 0) {
            return new OASISUsernameTokenProfile();
        }
        Iterator it = ssoAdapterConfigs.iterator();
        while (it.hasNext()) {
            String configName = "OASIS-Username-Token-Profile_" + it.next().toString();
            SSOAdapter ssoAdapter = null;
            try {
                SSOAdapterSession session = new SSOAdapterSession(this.req);
                ssoAdapter = this.adapterFactory.getSSOAdapter(configName, session);
            }
            catch (SSOAdapterException soe) {
                continue;
            }
            String username = null;
            String password = null;
            Properties props = ssoAdapter.getProperties();
            markupURL = props.get(WEBSERIVCE_WSDL_URL).toString();
            username = props.get(USERNAME).toString();
            Object password1 = props.get(PASSWORD);
            if (password1 != null) {
                password = password1.toString();
            }
            return new OASISUsernameTokenProfile(username, password);
        }
        return new OASISUsernameTokenProfile();
    }

    public void createConfiguration(String webserviceURL, String userName, String password) throws SSOConfigurationException {
        try {
            SSOAdapter ssoAdapter = null;
            SSOAdapterSession session = new SSOAdapterSession(this.req);
            List ssoAdapterConfigs = this.getSSOAdapterConfigurationNamesFromProducerURL(webserviceURL);
            if (ssoAdapterConfigs != null && ssoAdapterConfigs.size() > 0) {
                Iterator it = ssoAdapterConfigs.iterator();
                while (it.hasNext()) {
                    String ssoAdapterConfigName = "OASIS-Username-Token-Profile_" + it.next().toString();
                    try {
                        ssoAdapter = this.adapterFactory.getSSOAdapter(ssoAdapterConfigName, session);
                        break;
                    }
                    catch (SSOAdapterException soe) {
                    }
                }
                if (ssoAdapter != null) {
                    Properties props = new Properties();
                    props.put(WEBSERIVCE_WSDL_URL, webserviceURL);
                    props.put(USERNAME, userName);
                    props.put(PASSWORD, password);
                    SSOAdapter newssoAdapter = this.adapterFactory.setSSOAdapter(ssoAdapter, props, session);
                    return;
                }
            }
            if ((ssoAdapter = this.adapterFactory.getSSOAdapter(SSOADAPTER_TEMPLATE_NAME, session)) != null) {
                Properties props = new Properties();
                props.put(WEBSERIVCE_WSDL_URL, webserviceURL);
                props.put(USERNAME, userName);
                props.put(PASSWORD, password);
                String newSSOAdapterName = this.getSSOAdapterConfigurationNameFromProducerURL(webserviceURL);
                props.put(CHANNEL_NAME, newSSOAdapterName);
                SSOAdapter newssoAdapter = this.adapterFactory.setSSOAdapter(ssoAdapter, props, session);
            }
        }
        catch (Exception e) {
            debugLogger.log(Level.SEVERE, "", e);
            throw new SSOConfigurationException(e);
        }
    }

    public void deleteConfiguration(String webserviceURL) throws SSOConfigurationException {
        block5: {
            try {
                ConfigurationFactory ssoConfigFactory = ConfigurationFactory.getInstance((String)"SunSSOAdapterService", (String)ATTR_CONFIGURATIONS_NAME, (String)ATTR_TEMPLATES_NAME);
                List ssoAdapterConfigs = this.getSSOAdapterConfigurationNamesFromProducerURL(webserviceURL);
                if (ssoAdapterConfigs == null || ssoAdapterConfigs.size() <= 0) break block5;
                Iterator it = ssoAdapterConfigs.iterator();
                while (it.hasNext()) {
                    String ssoAdapterConfigName = "OASIS-Username-Token-Profile_" + it.next().toString();
                    try {
                        SSOAdapterSession session = new SSOAdapterSession(this.req);
                        SSOAdapter ssoAdapter = this.adapterFactory.getSSOAdapter(ssoAdapterConfigName, session);
                    }
                    catch (SSOAdapterException soe) {
                        continue;
                    }
                    ssoConfigFactory.removeConfiguration(ssoAdapterConfigName, new SSOAdapterSession(this.req));
                    break;
                }
            }
            catch (Exception e) {
                debugLogger.log(Level.SEVERE, "", e);
                throw new SSOConfigurationException(e);
            }
        }
    }

    public String getIdentityPropagationTypeFromMarkupURL(String markupURL) {
        return this.producers.getIdentityPropagationTypeFromMarkupURL(markupURL);
    }

    private List getSSOAdapterConfigurationNamesFromMarkupURL(String markupURL) {
        List producerNames = this.producers.getProducerNamesFromMarkupURL(markupURL);
        return this.generateSSOAdapterNames(producerNames);
    }

    private List generateSSOAdapterNames(List producerNames) {
        ArrayList<String> result = new ArrayList<String>();
        if (producerNames == null || producerNames.size() == 0) {
            return result;
        }
        Iterator it = producerNames.iterator();
        String ssoAdapterName = null;
        String producerName = null;
        while (it.hasNext()) {
            producerName = it.next().toString();
            ssoAdapterName = portalId + SEPARATOR + producerName;
            result.add(ssoAdapterName);
        }
        return result;
    }

    private List getSSOAdapterConfigurationNamesFromProducerURL(String webserviceURL) {
        List producerNames = this.producers.getProducerNamesFromProducerURL(webserviceURL);
        return this.generateSSOAdapterNames(producerNames);
    }

    private String getSSOAdapterConfigurationNameFromProducerURL(String webserviceURL) {
        List producerNames = this.producers.getProducerNamesFromProducerURL(webserviceURL);
        if (producerNames != null && producerNames.size() != 0) {
            return this.generateSSOAdapterName(producerNames.get(0).toString());
        }
        return null;
    }

    private String generateSSOAdapterName(String producerName) {
        return portalId + SEPARATOR + producerName;
    }

    private SSOToken getUserSSOToken(HttpServletRequest req) throws SSOException {
        SSOTokenManager mgr = SSOTokenManager.getInstance();
        SSOToken token = mgr.createSSOToken(req);
        return token;
    }

    private String getUserOrganization(SSOToken token) throws SSOException, AMException {
        String userDN = token.getPrincipal().getName();
        AMStoreConnection amsc = new AMStoreConnection(this.getAdminSSOToken());
        AMUser user = amsc.getUser(userDN);
        return user.getOrganizationDN();
    }

    private SSOToken getAdminSSOToken() {
        return SSOUtil.getAdminSSOToken();
    }

    private List getPossibleSSOAdapterNames() throws SSOException, AMException {
        ArrayList<String> result = new ArrayList<String>();
        List webserviceURLs = this.producers.listAllConfiguredProducers();
        if (webserviceURLs == null || webserviceURLs.size() == 0) {
            return result;
        }
        Iterator it = webserviceURLs.iterator();
        String webserviceURL = null;
        String ssoAdapterConfigName = null;
        while (it.hasNext()) {
            webserviceURL = it.next().toString();
            List configNames = this.getSSOAdapterConfigurationNamesFromProducerURL(webserviceURL);
            if (configNames == null) continue;
            Iterator configs = configNames.iterator();
            while (configs.hasNext()) {
                ssoAdapterConfigName = "OASIS-Username-Token-Profile_" + configs.next().toString();
                result.add(ssoAdapterConfigName);
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

