/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.wsrpwindow;

import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.container.WindowState;
import com.sun.portal.desktop.DesktopRequestThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.ProviderException;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.providers.window.WindowErrorCode;
import com.sun.portal.providers.window.WindowProvider;
import com.sun.portal.providers.window.WindowRequestReader;
import com.sun.portal.wsrp.common.WSRPToContainerMap;
import com.sun.portal.wsrp.common.stubs.LocalizedString;
import com.sun.portal.wsrp.common.stubs.MarkupType;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.ResourceList;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerErrorCode;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerUtil;
import com.sun.portal.wsrp.consumer.markup.MarkupContentException;
import com.sun.portal.wsrp.consumer.markup.MarkupManagerFactory;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import com.sun.portal.wsrp.consumer.wsrpwindow.WSRPWindowChannelURLFactory;
import com.sun.portal.wsrp.consumer.wsrpwindow.WSRPWindowRequestReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class WSRPWindowProvider
extends WindowProvider {
    private static Container _container = MarkupManagerFactory.getInstance();
    private static WindowRequestReader _windowRequestReader = new WSRPWindowRequestReader();
    private static ProducerEntityManagerFactory _pemFactory = ProducerEntityManagerFactory.getInstance();
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$wsrpwindow$WSRPWindowProvider == null ? (class$com$sun$portal$wsrp$consumer$wsrpwindow$WSRPWindowProvider = WSRPWindowProvider.class$("com.sun.portal.wsrp.consumer.wsrpwindow.WSRPWindowProvider")) : class$com$sun$portal$wsrp$consumer$wsrpwindow$WSRPWindowProvider));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$wsrpwindow$WSRPWindowProvider;

    public void init(String n, HttpServletRequest req) throws ProviderException {
        super.init(n, req);
    }

    public String getDefaultTitle() throws ProviderException {
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        ProducerEntity producerEntity = this.getProducerEntity(req);
        String portletHandle = this.getStringProperty("portletID");
        PortletDescription portletDesc = producerEntity.getPortletDescription(portletHandle);
        LocalizedString localizedTitle = portletDesc.getTitle();
        String title = null;
        String lang = null;
        if (localizedTitle != null) {
            String resourceName;
            ResourceList resourceList;
            String titleResource;
            String xmlLocale = WSRPConsumerUtil.getXMLLocale(this.getProviderContext().getLocaleString());
            title = localizedTitle.getValue();
            lang = localizedTitle.getLang();
            if (lang != null && !lang.equals(xmlLocale) && (titleResource = WSRPConsumerUtil.getResource(resourceList = producerEntity.getServiceDescription().getResourceList(), resourceName = localizedTitle.getResourceName(), xmlLocale)) != null) {
                title = titleResource;
            }
        }
        if (title == null) {
            title = "";
            if (logger.isLoggable(Level.WARNING)) {
                Object[] param = new String[]{((Object)producerEntity).toString(), portletHandle};
                logger.log(Level.WARNING, "PSWS_CSPWCW0002", param);
            }
        }
        return title;
    }

    public String getDescription() throws ProviderException {
        String resourceName;
        ResourceList resourceList;
        String descriptionResource;
        String portletHandle;
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        ProducerEntity producerEntity = this.getProducerEntity(req);
        PortletDescription portletDesc = producerEntity.getPortletDescription(portletHandle = this.getStringProperty("portletID"));
        LocalizedString localizedDescription = portletDesc.getDescription();
        if (localizedDescription == null) {
            return null;
        }
        String xmlLocale = WSRPConsumerUtil.getXMLLocale(this.getProviderContext().getLocaleString());
        String description = localizedDescription.getValue();
        if (!localizedDescription.getLang().equals(xmlLocale) && (descriptionResource = WSRPConsumerUtil.getResource(resourceList = producerEntity.getServiceDescription().getResourceList(), resourceName = localizedDescription.getResourceName(), xmlLocale)) != null) {
            description = descriptionResource;
        }
        return description;
    }

    public List getRoleList(HttpServletRequest request) throws ProviderException {
        ArrayList<String> rolesList = null;
        try {
            Map roleMap = this.getConfiguredRoleMap(request);
            if (roleMap != null) {
                Set roles = this.getProviderContext().getRoles();
                if (roles == null || roles.isEmpty()) {
                    rolesList = Collections.EMPTY_LIST;
                } else {
                    rolesList = new ArrayList<String>();
                    Iterator i = roleMap.keySet().iterator();
                    block2: while (i.hasNext()) {
                        String logicalRole = (String)i.next();
                        List physicalRoles = (List)roleMap.get(logicalRole);
                        Iterator j = physicalRoles.iterator();
                        while (j.hasNext()) {
                            String physicalRole = (String)j.next();
                            if (!roles.contains(physicalRole)) continue;
                            rolesList.add(logicalRole);
                            continue block2;
                        }
                    }
                }
            } else {
                rolesList = Collections.EMPTY_LIST;
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("WSRPWindowProvider.getRoleList():", (Throwable)pce);
        }
        return rolesList;
    }

    public Map getUserInfoMap(HttpServletRequest request) throws ProviderException {
        HashMap<String, String> userInfo = null;
        try {
            Map userInfoMap = this.getConfiguredUserInfoMap(request);
            if (userInfoMap != null) {
                userInfo = new HashMap<String, String>();
                Set keys = userInfoMap.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    String portletAttr = (String)i.next();
                    String dsameAttr = (String)userInfoMap.get(portletAttr);
                    String attrValue = this.getProviderContext().getStringAttribute(dsameAttr);
                    if (attrValue == null) continue;
                    userInfo.put(portletAttr, attrValue);
                }
            } else {
                userInfo = Collections.EMPTY_MAP;
            }
        }
        catch (ProviderContextException pce) {
            throw new ProviderException("WSRPWindowProvider.getUserInfoMap():", (Throwable)pce);
        }
        return userInfo;
    }

    private Map getConfiguredRoleMap(HttpServletRequest req) throws ProviderContextException, ProviderException {
        ProducerEntity producerEntity = this.getProducerEntity(req);
        Map ucMap = producerEntity.getUserCategoryMapping();
        HashMap roleMap = null;
        if (ucMap != null && ucMap.size() > 0) {
            String portletHandle = this.getStringProperty("portletID");
            PortletDescription portletDesc = producerEntity.getPortletDescription(portletHandle);
            List<String> userCategories = Arrays.asList(portletDesc.getUserCategories());
            roleMap = new HashMap();
            Iterator i = ucMap.keySet().iterator();
            while (i.hasNext()) {
                String userCategory = (String)i.next();
                if (!userCategories.contains(userCategory)) continue;
                roleMap.put(userCategory, ucMap.get(userCategory));
            }
        }
        return roleMap;
    }

    private Map getConfiguredUserInfoMap(HttpServletRequest req) throws ProviderContextException, ProviderException {
        ProducerEntity producerEntity = this.getProducerEntity(req);
        String consumerId = this.getStringProperty("consumerID");
        String portletHandle = this.getStringProperty("portletID");
        PortletDescription portletDesc = producerEntity.getPortletDescription(portletHandle);
        String[] items = portletDesc.getUserProfileItems();
        Map stdMap = null;
        try {
            ProducerEntityManager pem = _pemFactory.getProducerEntityManager(consumerId, req);
            stdMap = pem.getStandardUserProfileMapping();
        }
        catch (WSRPConsumerException ex) {
            throw new ProviderException(ex.getMessage(), (Throwable)((Object)ex));
        }
        HashMap uiMap = new HashMap();
        if (items != null && stdMap != null) {
            for (int i = 0; i < items.length; ++i) {
                if (!stdMap.containsKey(items[i])) continue;
                uiMap.put(items[i], stdMap.get(items[i]));
            }
        }
        return uiMap;
    }

    public Container getContainer(HttpServletRequest req) {
        return _container;
    }

    public String getEntityID(HttpServletRequest req) throws ProviderException {
        return this.getName();
    }

    public WindowRequestReader getWindowRequestReader() throws ProviderException {
        return _windowRequestReader;
    }

    public ChannelURLFactory getChannelURLFactory(String desktopURLPrefix, HttpServletRequest request) throws ProviderException {
        String securityErrorURL = this.getErrorCodeURL(WSRPConsumerErrorCode.RUNTIME_NOT_IN_SECURE_MODE, request).toString();
        return new WSRPWindowChannelURLFactory(desktopURLPrefix, securityErrorURL);
    }

    private ProducerEntity getProducerEntity(HttpServletRequest req) throws ProviderException {
        String consumerId = this.getStringProperty("consumerID");
        String producerEntityId = this.getStringProperty("producerEntityID");
        String portletID = this.getStringProperty("portletID");
        try {
            ProducerEntityManager pem = _pemFactory.getProducerEntityManager(consumerId, req);
            if (!pem.isActivated()) {
                throw new ProviderException("WSRP Consumer is currently disabled.");
            }
            ProducerEntity producerEntity = pem.getProducerEntity(producerEntityId);
            if (producerEntity == null) {
                throw new ProviderException("Couldn't find the producer entity for the portlet.");
            }
            if (producerEntity.getPortletDescription(portletID) == null) {
                throw new ProviderException("Couldn't find the portletDescription for the portlet.");
            }
            return producerEntity;
        }
        catch (WSRPConsumerException ex) {
            throw new ProviderException(ex.getMessage(), (Throwable)((Object)ex));
        }
    }

    public boolean isMarkupSupported(String contentType, String locale, ChannelMode mode, WindowState windowState) throws ProviderException {
        String portletHandle;
        HttpServletRequest req = DesktopRequestThreadLocalizer.getRequest();
        ProducerEntity producerEntity = this.getProducerEntity(req);
        PortletDescription portletDesc = producerEntity.getPortletDescription(portletHandle = this.getStringProperty("portletID"));
        MarkupType[] markupTypes = portletDesc.getMarkupTypes();
        if (markupTypes == null || markupTypes.length == 0) {
            return false;
        }
        String wsrpMode = WSRPToContainerMap.mapChannelModeToWSRP((ChannelMode)mode);
        String wsrpWindowState = WSRPToContainerMap.mapWindowStateToWSRP((WindowState)windowState);
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"MarkupTypes ID", portletHandle};
            param[0] = "contentType";
            param[1] = contentType;
            logger.log(Level.FINEST, "PSWS_CSPWCW0001", param);
            param[0] = "mode";
            param[1] = wsrpMode;
            logger.log(Level.FINEST, "PSWS_CSPWCW0001", param);
            param[0] = "wsrpWindowState";
            param[1] = wsrpWindowState;
            logger.log(Level.FINEST, "PSWS_CSPWCW0001", param);
            param[0] = "locale";
            param[1] = locale;
            logger.log(Level.FINEST, "PSWS_CSPWCW0001", param);
        }
        for (int i = 0; i < markupTypes.length; ++i) {
            if (!markupTypes[i].getMimeType().equals(contentType) && !markupTypes[i].getMimeType().equals("text/*") && !markupTypes[i].getMimeType().equals("*/*") || !this.exists(wsrpMode, markupTypes[i].getModes(), true) || !this.exists(wsrpWindowState, markupTypes[i].getWindowStates(), true)) continue;
            if (markupTypes[i].getLocales() == null || markupTypes[i].getLocales().length == 0) {
                return true;
            }
            if (!this.exists(locale, markupTypes[i].getLocales(), false)) continue;
            return true;
        }
        return false;
    }

    private boolean exists(String str, String[] values, boolean exactMatch) {
        if (values == null || str == null) {
            return false;
        }
        for (int i = 0; i < values.length; ++i) {
            if (!(exactMatch ? str.equals(values[i]) : str.toLowerCase().indexOf(values[i].toLowerCase()) != -1)) continue;
            return true;
        }
        return false;
    }

    protected ErrorCode getErrorCode(ContentException ex) {
        if (ex instanceof MarkupContentException) {
            return ((MarkupContentException)ex).getErrorCode();
        }
        return WindowErrorCode.CONTENT_EXCEPTION;
    }

    protected StringBuffer getErrorMessageContent(ErrorCode errorCode) throws ProviderException {
        try {
            return new StringBuffer(this.getResourceBundle("WSRPConsumerErrorCode").getString(errorCode.toString()));
        }
        catch (MissingResourceException ex) {
            return super.getErrorMessageContent(errorCode);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

