/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.resourceproxy;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerRewriter;
import com.sun.portal.wsrp.consumer.resourceproxy.CookiesConnectionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ResourceProxyServlet
extends HttpServlet {
    private static final Set DO_NOT_FORWARD_HEADERS = new HashSet();
    private static final Set DO_NOT_FORWARD_BACK_HEADERS = new HashSet();
    private static final Set MIMES_TO_REWRITE = new HashSet();
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$resourceproxy$ResourceProxyServlet == null ? (class$com$sun$portal$wsrp$consumer$resourceproxy$ResourceProxyServlet = ResourceProxyServlet.class$("com.sun.portal.wsrp.consumer.resourceproxy.ResourceProxyServlet")) : class$com$sun$portal$wsrp$consumer$resourceproxy$ResourceProxyServlet));
    private static final int BUFFER_SIZE = 4096;
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$resourceproxy$ResourceProxyServlet;

    public ResourceProxyServlet() {
        DO_NOT_FORWARD_HEADERS.add("host");
        DO_NOT_FORWARD_HEADERS.add("connection");
        DO_NOT_FORWARD_HEADERS.add("cookie");
        DO_NOT_FORWARD_HEADERS.add("content-length");
        DO_NOT_FORWARD_BACK_HEADERS.add("content-length");
        DO_NOT_FORWARD_BACK_HEADERS.add("set-cookie");
        DO_NOT_FORWARD_BACK_HEADERS.add("date");
        DO_NOT_FORWARD_BACK_HEADERS.add("server");
        DO_NOT_FORWARD_BACK_HEADERS.add("transfer-encoding");
        MIMES_TO_REWRITE.add("text/html");
        MIMES_TO_REWRITE.add("text/vnd.wap.wml");
        MIMES_TO_REWRITE.add("text/xml");
    }

    public void init() throws ServletException {
    }

    private String getResourceURL(HttpServletRequest req) {
        return req.getParameter("wsrp_url");
    }

    private boolean hasResourceRewritingOn(HttpServletRequest req) {
        String sResourceRewrite = req.getParameter("wsrp_rewrite");
        return sResourceRewrite != null ? sResourceRewrite.equalsIgnoreCase("true") : false;
    }

    private String getCookieJarKey(HttpServletRequest req) {
        return req.getParameter("cookie_key");
    }

    private String getPortalServerURLPrefix(HttpServletRequest req) {
        return req.getParameter("portal_server_url");
    }

    private String getNamespacePrefix(HttpServletRequest req) {
        return req.getParameter("namespace");
    }

    public void service(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String resourceURL = this.getResourceURL(req);
        boolean resourceRewrite = this.hasResourceRewritingOn(req);
        String cookieJarKey = this.getCookieJarKey(req);
        if (resourceURL == null) {
            res.sendError(404);
        } else {
            try {
                String requestQueryString = req.getQueryString();
                if (logger.isLoggable(Level.FINEST)) {
                    Object[] param = new String[]{"ResourceURL", resourceURL};
                    logger.log(Level.FINEST, "PSWS_CSPWCR0001", param);
                    param[0] = "ResourceRewrite";
                    param[1] = "" + resourceRewrite;
                    logger.log(Level.FINEST, "PSWS_CSPWCR0001", param);
                    param[0] = "cookieJarKey";
                    param[1] = cookieJarKey;
                    logger.log(Level.FINEST, "PSWS_CSPWCR0001", param);
                }
                URL url = new URL(resourceURL);
                URLConnection conn = url.openConnection();
                CookiesConnectionHandler ch = new CookiesConnectionHandler(req, cookieJarKey);
                ch.preConnection(conn);
                conn.setDoInput(true);
                conn.setUseCaches(false);
                this.forwardRequest(req, res, conn);
                this.forwardBackResponse(req, res, conn, resourceRewrite);
                ch.postConnection(conn);
            }
            catch (IOException ex) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSWS_CSPWCR0002", ex);
                }
                throw ex;
            }
            catch (ServletException ex) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSWS_CSPWCR0002", ex);
                }
                throw ex;
            }
        }
    }

    protected void forwardRequest(HttpServletRequest req, HttpServletResponse res, URLConnection conn) throws IOException, ServletException {
        try {
            this.setRequestHeadersIntoConnection(req, conn);
            if (req.getMethod().equals("POST")) {
                int c;
                conn.setDoOutput(true);
                OutputStream output = conn.getOutputStream();
                int count = req.getContentLength();
                ServletInputStream input = req.getInputStream();
                while (count-- > 0 && (c = input.read()) >= 0) {
                    output.write(c);
                }
                output.close();
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCR0003", ex);
            }
            res.sendError(400);
        }
    }

    protected void setRequestHeadersIntoConnection(HttpServletRequest req, URLConnection conn) throws IOException, ServletException {
        Enumeration e = req.getHeaderNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = req.getHeader(name);
            if (DO_NOT_FORWARD_HEADERS.contains(name.toLowerCase())) continue;
            conn.setRequestProperty(name, value);
        }
    }

    protected void forwardBackResponse(HttpServletRequest req, HttpServletResponse res, URLConnection conn, boolean resourceRewrite) throws IOException, ServletException {
        try {
            InputStream input;
            this.setConnectionHeadersIntoResponse(conn, res);
            String responseMime = conn.getContentType();
            if (responseMime == null) {
                resourceRewrite = false;
            } else {
                if (responseMime.indexOf(";") > -1) {
                    responseMime = responseMime.substring(0, responseMime.indexOf(";") - 1);
                }
                boolean bl = resourceRewrite = resourceRewrite && MIMES_TO_REWRITE.contains(responseMime);
            }
            if (logger.isLoggable(Level.FINEST)) {
                Object[] param = new String[]{"Resource rewriting", "" + resourceRewrite};
                logger.log(Level.FINEST, "PSWS_CSPWCR0001", param);
            }
            if (resourceRewrite) {
                input = conn.getInputStream();
                BufferedReader bReader = new BufferedReader(new InputStreamReader(input));
                char[] buffer = new char[4096];
                StringBuffer sBuffer = new StringBuffer(4096);
                int charsRead = bReader.read(buffer, 0, 4096);
                while (charsRead > -1) {
                    sBuffer.append(buffer, 0, charsRead);
                    charsRead = bReader.read(buffer, 0, 4096);
                }
                bReader.close();
                WSRPConsumerRewriter rewriter = new WSRPConsumerRewriter(this.getPortalServerURLPrefix(req), this.getCookieJarKey(req), this.getNamespacePrefix(req));
                String rewrittenMarkup = rewriter.rewrite(sBuffer.toString(), req);
                PrintWriter pWriter = res.getWriter();
                pWriter.write(rewrittenMarkup);
                pWriter.close();
            } else {
                input = conn.getInputStream();
                ServletOutputStream output = res.getOutputStream();
                byte[] buffer = new byte[8192];
                int bytesRead = input.read(buffer, 0, 8192);
                while (bytesRead > -1) {
                    output.write(buffer, 0, bytesRead);
                    bytesRead = input.read(buffer, 0, 8192);
                }
                input.close();
                output.flush();
            }
        }
        catch (Throwable ex) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "", ex);
            }
            res.sendError(400);
        }
    }

    protected void setConnectionHeadersIntoResponse(URLConnection conn, HttpServletResponse res) throws IOException, ServletException {
        int i = 1;
        String name = conn.getHeaderFieldKey(i);
        while (name != null) {
            String value = conn.getHeaderField(i);
            if (!DO_NOT_FORWARD_BACK_HEADERS.contains(name.toLowerCase())) {
                res.addHeader(name, value);
            }
            name = conn.getHeaderFieldKey(++i);
        }
        res.addHeader("Cache-control", "no-store, no-cache, must-revalidate");
        res.addHeader("Pragma", "no-cache");
        res.addHeader("Expires", "Sat, 1 Jan 2000 00:00:00 GMT");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

