/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.producermanager.impl;

import com.iplanet.sso.SSOToken;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.KeyGenerator;
import com.sun.portal.wsrp.common.WSRPFactory;
import com.sun.portal.wsrp.common.stubs.GetServiceDescription;
import com.sun.portal.wsrp.common.stubs.InvalidRegistrationFault;
import com.sun.portal.wsrp.common.stubs.MissingParametersFault;
import com.sun.portal.wsrp.common.stubs.ModifyRegistration;
import com.sun.portal.wsrp.common.stubs.OperationFailedFault;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.common.stubs.RegistrationState;
import com.sun.portal.wsrp.common.stubs.ReturnAny;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_Registration_PortType;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_ServiceDescription_PortType;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManager;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManagerFactory;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ConsumerObjectFactory;
import com.sun.portal.wsrp.consumer.producermanager.InbandRegistrationNotSupportedException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import com.sun.portal.wsrp.consumer.producermanager.impl.ProducerEntityImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class PropertiesProducerEntityManagerImpl
implements ProducerEntityManager {
    protected static RemoteServiceStubManager stubMgr = null;
    private static Map producerEntities = Collections.synchronizedMap(new HashMap());
    protected static Properties globalProperties = null;
    protected static Properties defaultGlobalProperties = null;
    protected static String consumerAgent = PropertiesProducerEntityManagerImpl.getConsumerAgent();
    protected String consumerId = null;
    protected WSRPFactory factory = null;
    protected static ConsumerObjectFactory cofactory = null;
    public static final String DATA_FILE_PATH = "/tmp/wsrp_producers";
    public static final String DATA_FILE_BASENAME = "producer_";
    public static final String DATA_FILE_EXTENSION = ".pd";
    public static final String GLOBAL_DATA_FILENAME = "global.properties";
    public static final String ORG_DATA_FILENAME = "org.properties";
    public static File baseDir = null;
    public static final String COPYRIGHT_HEADER = "\n# Copyright 2003 Sun Microsystems, Inc. All rights reserved\n# Use is subject to license terms.\n#\n";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String URL = "url";
    public static final String PROPAGATION_TYPE = "identityPropagationType";
    public static final String MARKUP_ENDPOINT = "markupEndpoint";
    public static final String STATUS = "status";
    public static final String REGISTRATION_DATA = "registrationData";
    public static final String REGISTRATION_CONTEXT = "registrationContext";
    public static final String SERVICE_DESCRIPTION = "serviceDescription";
    public static final String USER_CATEGORY_MAPPING = "userCategoryMapping";
    public static final String ALLOWED_USER_PROFILE_MAPPING = "allowedUserProfileMapping";
    public static final String CUSTOM_USER_PROFILE_MAPPING = "customUserProfileMapping";
    public static final String SERVICE_DESCRIPTION_LAST_MODIFIED = "serviceDescriptionLastModified";
    public static final String LAST_MODIFIED = "lastModified";
    public static final String ENABLED = "enabled";
    public static final String STANDARD_USER_PROFILE_MAPPING = "standardUserProfileMapping";
    public static final String DEFAULT_REGISTRATION_DATA = "defaultRegistrationData";
    public static final String CONSUMER_NAME = "consumerName";
    public static final String LIST_DELIMITER = ";";
    public static final String MAPPING_DELIMITER = ":";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$producermanager$impl$PropertiesProducerEntityManagerImpl == null ? (class$com$sun$portal$wsrp$consumer$producermanager$impl$PropertiesProducerEntityManagerImpl = PropertiesProducerEntityManagerImpl.class$("com.sun.portal.wsrp.consumer.producermanager.impl.PropertiesProducerEntityManagerImpl")) : class$com$sun$portal$wsrp$consumer$producermanager$impl$PropertiesProducerEntityManagerImpl));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$producermanager$impl$PropertiesProducerEntityManagerImpl;

    public void init(String consumerId, HttpServletRequest request) throws WSRPConsumerException {
        this.doInit(consumerId);
    }

    public void init(String consumerId, String username, String password) throws WSRPConsumerException {
        this.doInit(consumerId);
    }

    public void init(SSOToken ssoToken, String portalId, String consumerId) throws WSRPConsumerException {
        this.doInit(consumerId);
    }

    private void doInit(String consumerId) throws WSRPConsumerException {
        Properties orgProperties;
        this.consumerId = consumerId;
        stubMgr = RemoteServiceStubManagerFactory.getRemoteServiceStubManager();
        try {
            this.factory = WSRPFactory.getInstance();
        }
        catch (WSRPException we) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.init(): failed to get a instance of WSRPFactory.", we);
        }
        cofactory = ConsumerObjectFactory.getInstance();
        String filePath = DATA_FILE_PATH + File.separator + consumerId;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0008", filePath);
        }
        baseDir = new File(filePath);
        globalProperties = this.loadGlobalProperties();
        if (globalProperties == null) {
            this.storeGlobalProperties(defaultGlobalProperties);
            globalProperties = this.loadGlobalProperties();
        }
        if ((orgProperties = this.loadOrgProperties()) == null) {
            orgProperties = new Properties();
            orgProperties.setProperty(CONSUMER_NAME, "WSRP Consumer " + consumerId);
            this.storeOrgProperties(orgProperties);
        }
    }

    public boolean isActivated() {
        boolean activated = false;
        String enabledStr = globalProperties.getProperty(ENABLED);
        if (enabledStr != null && enabledStr.toLowerCase().equals("true")) {
            activated = true;
        }
        return activated;
    }

    public String getConsumerName() throws WSRPConsumerException {
        Properties p = this.loadOrgProperties();
        return p.getProperty(CONSUMER_NAME);
    }

    public ServiceDescription getServiceDescription(URL producerURL) throws WSRPConsumerException {
        return this.getServiceDescription(producerURL, null);
    }

    public ServiceDescription getServiceDescription(URL producerURL, RegistrationContext regContext) throws WSRPConsumerException {
        String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_ServiceDescription_Binding_SOAP");
        WSRP_v1_ServiceDescription_PortType sdPort = stubMgr.getServiceDescriptionPortType(endpoint);
        String[] locales = null;
        ServiceDescription sd = null;
        GetServiceDescription gsd = new GetServiceDescription(regContext, locales);
        try {
            sd = sdPort.getServiceDescription(gsd);
        }
        catch (OperationFailedFault off) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.getServiceDescription(): failed to get ServiceDescription port type.  producerURL=" + producerURL, off);
        }
        catch (InvalidRegistrationFault irf) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.getServiceDescription(): failed to get ServiceDescription port type.  producerURL=" + producerURL, irf);
        }
        catch (RemoteException re) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.getServiceDescription(): failed to get ServiceDescription port type.  producerURL=" + producerURL, re);
        }
        if (sd != null && logger.isLoggable(Level.FINEST)) {
            String sdXML = null;
            try {
                sdXML = this.factory.getServiceDescriptionXML(sd, true);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.getServiceDescription(): failed to serialize service description.  sd=" + sd, we);
            }
            StringBuffer logBuf = new StringBuffer();
            logBuf.append("PRODUCER_WSDL_URL=").append(producerURL);
            if (regContext != null) {
                logBuf.append("\nREG_HANDLE=").append(regContext.getRegistrationHandle());
            } else {
                logBuf.append("\nREG_HANDLE=<none>");
            }
            logBuf.append("\nSERVICE_DESCRIPTION=").append(sdXML);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, logBuf.toString());
            }
        }
        return sd;
    }

    public boolean isInbandRegistrationSupported(URL producerURL) throws WSRPConsumerException {
        String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
        WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
        return regPort != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerEntity getProducerEntity(String producerEntityId) throws WSRPConsumerException {
        ProducerEntity pe = (ProducerEntity)producerEntities.get(producerEntityId);
        if (pe != null) {
            String modified = this.getProducerEntityLastModified(producerEntityId);
            String cacheModified = pe.getLastModified();
            if (cacheModified.compareTo(modified) >= 0) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "PSWS_CSPWCPI0009", producerEntityId);
                }
                return pe;
            }
        }
        Map map = producerEntities;
        synchronized (map) {
            pe = (ProducerEntity)producerEntities.get(producerEntityId);
            String modified = null;
            String cacheModified = null;
            if (pe != null) {
                modified = this.getProducerEntityLastModified(producerEntityId);
                cacheModified = pe.getLastModified();
            }
            if (pe == null || cacheModified.compareTo(modified) < 0) {
                pe = this.loadProducerEntity(producerEntityId);
                producerEntities.put(producerEntityId, pe);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "", producerEntityId);
                }
            }
        }
        return pe;
    }

    public String addProducerEntity(String producerName, URL producerURL, String identityPropagationType, RegistrationData regData, Map userCategories, Map allowedUserProfiles, Map customUserProfiles) throws WSRPConsumerException, InbandRegistrationNotSupportedException {
        ServiceDescription serviceDesc = this.getServiceDescription(producerURL);
        RegistrationContext regContext = null;
        if (serviceDesc.isRequiresRegistration()) {
            String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
            WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
            if (regPort == null) {
                throw new InbandRegistrationNotSupportedException("PropertiesProducerEntityManagerImpl.addProducerEntity(): registration port not available.  producerURL=" + producerURL);
            }
            try {
                regContext = regPort.register(regData);
            }
            catch (MissingParametersFault mpf) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.addProducerEntity(): failed to register.  producerName=" + producerName + ", regData=" + regData, mpf);
            }
            catch (OperationFailedFault off) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.addProducerEntity(): failed to register.  producerName=" + producerName + ", regData=" + regData, off);
            }
            catch (RemoteException re) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.addProducerEntity(): failed to register.  producerName=" + producerName + ", regData=" + regData, re);
            }
            serviceDesc = this.getServiceDescription(producerURL, regContext);
        }
        String producerEntityId = this.addProducerEntity(producerName, producerURL, identityPropagationType, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles);
        return producerEntityId;
    }

    public String addProducerEntity(String producerName, URL producerURL, String identityPropagationType, String regHandle, Map userCategories, Map allowedUserProfiles, Map customUserProfiles) throws WSRPConsumerException {
        RegistrationContext regContext = new RegistrationContext(regHandle, null, null);
        ServiceDescription serviceDesc = this.getServiceDescription(producerURL, regContext);
        String producerEntityId = this.addProducerEntity(producerName, producerURL, identityPropagationType, null, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles);
        return producerEntityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addProducerEntity(String producerName, URL producerURL, String identityPropagationType, RegistrationData regData, RegistrationContext regContext, ServiceDescription serviceDesc, Map userCategories, Map allowedUserProfiles, Map customUserProfiles) throws WSRPConsumerException {
        String producerEntityId = KeyGenerator.generateKey();
        String markupEndpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Markup_Binding_SOAP");
        long now = System.currentTimeMillis();
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, ProducerEntityStatus.OK, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, now, Long.toString(now), identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(pe.getId(), pe);
        }
        return pe.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceDescription(String producerEntityId) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.updateServiceDescription(): invalid producer entity id.  peId=" + producerEntityId);
        }
        URL producerURL = ope.getURL();
        RegistrationContext rc = ope.getRegistrationContext();
        ServiceDescription sd = this.getServiceDescription(producerURL, rc);
        String producerName = ope.getName();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long now = System.currentTimeMillis();
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, sd, userCategories, allowedUserProfiles, customUserProfiles, now, Long.toString(now), identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRegistration(String producerEntityId, RegistrationData regData) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.modifyRegistration(): invalid producer entity id.  peId=" + producerEntityId);
        }
        URL producerURL = ope.getURL();
        RegistrationContext regContext = ope.getRegistrationContext();
        String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
        WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
        if (regPort == null) {
            throw new InbandRegistrationNotSupportedException("PropertiesProducerEntityManagerImpl.modifyRegistration(): registration port not available.  producerrEntityId=" + producerEntityId);
        }
        ModifyRegistration modReg = new ModifyRegistration(regContext, regData);
        RegistrationState regState = null;
        try {
            regState = regPort.modifyRegistration(modReg);
        }
        catch (InvalidRegistrationFault irf) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.modifyProducerEntity(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, irf);
        }
        catch (MissingParametersFault mpf) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.modifyProducerEntity(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, mpf);
        }
        catch (OperationFailedFault off) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.modifyProducerEntity(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, off);
        }
        catch (RemoteException re) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.modifyProducerEntity(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, re);
        }
        if (regState != null) {
            regContext.setRegistrationState(regState.getRegistrationState());
        }
        String producerName = ope.getName();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        ProducerEntityStatus status = ope.getStatus();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    public void removeProducerEntity(String producerEntityId) throws WSRPConsumerException, InbandRegistrationNotSupportedException {
        ProducerEntity pe = this.getProducerEntity(producerEntityId);
        if (pe == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.removeProducerEntity(): invalid producer entity id.  peId=" + producerEntityId);
        }
        if (pe.getServiceDescription().isRequiresRegistration()) {
            URL producerURL = pe.getURL();
            RegistrationContext regContext = pe.getRegistrationContext();
            String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
            WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
            if (regPort == null) {
                throw new InbandRegistrationNotSupportedException("PropertiesProducerEntityManagerImpl.removeProducerEntity(): registration port not available.  producerEntityId=" + producerEntityId);
            }
            ReturnAny ret = null;
            try {
                ret = regPort.deregister(regContext);
            }
            catch (InvalidRegistrationFault irf) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.removeProducerEntity(): failed to deregister from the producer.  producerEntityId=" + producerEntityId + ", regContext=" + regContext, irf);
            }
            catch (OperationFailedFault off) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.removeProducerEntity(): failed to deregister from the producer.  producerEntityId=" + producerEntityId + ", regContext=" + regContext, off);
            }
            catch (RemoteException re) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.removeProducerEntity(): failed to deregister from the producer.  producerEntityId=" + producerEntityId + ", regContext=" + regContext, re);
            }
        }
        this.eliminateProducerEntity(producerEntityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eliminateProducerEntity(String producerEntityId) throws WSRPConsumerException {
        this.deleteProducerEntity(producerEntityId);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    public Set getProducerEntityIds() throws WSRPConsumerException {
        HashSet<String> peIds = new HashSet<String>();
        File[] files = null;
        if (baseDir.exists()) {
            files = baseDir.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.startsWith(PropertiesProducerEntityManagerImpl.DATA_FILE_BASENAME) && name.endsWith(PropertiesProducerEntityManagerImpl.DATA_FILE_EXTENSION);
                }
            });
        }
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String filename = file.getName();
                int endIndex = filename.indexOf(DATA_FILE_EXTENSION);
                String id = filename.substring(DATA_FILE_BASENAME.length(), endIndex);
                peIds.add(id);
            }
        }
        return peIds;
    }

    public Map getStandardUserProfileMapping() throws WSRPConsumerException {
        Map supMap = null;
        String supmString = globalProperties.getProperty(STANDARD_USER_PROFILE_MAPPING);
        if (supmString != null && supmString.length() > 0) {
            supMap = PropertiesProducerEntityManagerImpl.stringToMap(supmString);
        }
        return supMap;
    }

    public RegistrationData getDefaultRegistrationData() throws WSRPConsumerException {
        RegistrationData rd = null;
        String rdXML = globalProperties.getProperty(DEFAULT_REGISTRATION_DATA);
        if (rdXML != null && rdXML.length() > 0) {
            try {
                rd = this.factory.getRegistrationData(rdXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.getDefaultRegistrationData(): failed to unmarshal registration data.  xml=" + rdXML, we);
            }
            String consumerName = this.getConsumerName();
            rd.setConsumerName(consumerName);
            rd.setConsumerAgent(consumerAgent);
        }
        return rd;
    }

    public void setConsumerName(String consumerName) throws WSRPConsumerException {
        Properties orgProperties = this.loadOrgProperties();
        orgProperties.setProperty(CONSUMER_NAME, consumerName);
        this.storeOrgProperties(orgProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String producerEntityId, String name) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setName(): invalid producer entity id.  peId=" + producerEntityId);
        }
        URL producerURL = ope.getURL();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, name, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityPropagationType(String producerEntityId, String type) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setIdentityPropagationType(): invalid producer entity id.  peId=" + producerEntityId);
        }
        URL producerURL = ope.getURL();
        String markupEndpoint = ope.getMarkupEndpoint();
        String name = ope.getName();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, name, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, type);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String producerEntityId, URL url) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setURL(): invalid producer entity id.  peId=" + producerEntityId);
        }
        if (url == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setURL(): url cannot be null.  peId=" + producerEntityId);
        }
        String markupEndpoint = stubMgr.getEndpoint(url, "WSRP_v1_Markup_Binding_SOAP");
        String producerName = ope.getName();
        String identityPropagationType = ope.getIdentityPropagationType();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, url, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String producerEntityId, ProducerEntityStatus status) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setStatus(): invalid producer entity id.  peId=" + producerEntityId);
        }
        String producerName = ope.getName();
        URL producerURL = ope.getURL();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserCategoryMapping(String producerEntityId, Map userCategories) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setUserCategoryMapping(): invalid producer entity id.  peId=" + producerEntityId);
        }
        String producerName = ope.getName();
        URL producerURL = ope.getURL();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedUserProfileMapping(String producerEntityId, Map allowedUserProfiles) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setAllowedUserProfileMapping(): invalid producer entity id.  peId=" + producerEntityId);
        }
        String producerName = ope.getName();
        URL producerURL = ope.getURL();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map customUserProfiles = ope.getCustomUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomUserProfileMapping(String producerEntityId, Map customUserProfiles) throws WSRPConsumerException {
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setCustomUserProfileMapping(): invalid producer entity id.  peId=" + producerEntityId);
        }
        String producerName = ope.getName();
        URL producerURL = ope.getURL();
        String identityPropagationType = ope.getIdentityPropagationType();
        String markupEndpoint = ope.getMarkupEndpoint();
        ProducerEntityStatus status = ope.getStatus();
        RegistrationData regData = ope.getRegistrationData();
        RegistrationContext regContext = ope.getRegistrationContext();
        ServiceDescription serviceDesc = ope.getServiceDescription();
        Map userCategories = ope.getUserCategoryMapping();
        Map allowedUserProfiles = ope.getAllowedUserProfileMapping();
        long serviceDescLastModified = ope.getServiceDescriptionLastModified();
        String lastModified = Long.toString(System.currentTimeMillis());
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(producerEntityId, pe);
        }
    }

    public void setStandardUserProfileMapping(Map standardUserProfileMap) throws WSRPConsumerException {
        if (standardUserProfileMap == null || standardUserProfileMap.size() == 0) {
            return;
        }
        Properties p = new Properties(globalProperties);
        p.setProperty(STANDARD_USER_PROFILE_MAPPING, PropertiesProducerEntityManagerImpl.mapToString(standardUserProfileMap));
        this.storeGlobalProperties(p);
    }

    public void setDefaultRegistrationData(RegistrationData rd) throws WSRPConsumerException {
        if (rd == null) {
            return;
        }
        String rdXML = null;
        try {
            rdXML = this.factory.getRegistrationDataXML(rd);
        }
        catch (WSRPException we) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.setDefaultRegistrationData(): failed to marshal registration data.", we);
        }
        Properties p = new Properties(globalProperties);
        p.setProperty(DEFAULT_REGISTRATION_DATA, rdXML);
        this.storeGlobalProperties(p);
    }

    protected ProducerEntity createProducerEntity(String producerEntityId, String producerName, URL producerURL, String markupEndpoint, ProducerEntityStatus status, RegistrationData regData, RegistrationContext regContext, ServiceDescription serviceDescription, Map userCategories, Map allowedUserProfiles, Map customUserProfiles, long serviceDescLastModified, String lastModified, String identityPropagationType) throws WSRPConsumerException {
        ProducerEntityImpl pe = new ProducerEntityImpl(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDescription, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        return pe;
    }

    protected ProducerEntity loadProducerEntity(String producerEntityId) throws WSRPConsumerException {
        StringBuffer filename = new StringBuffer();
        filename.append(baseDir.toString()).append(File.separator).append(DATA_FILE_BASENAME).append(producerEntityId).append(DATA_FILE_EXTENSION);
        File file = new File(filename.toString());
        return this.loadProducerEntity(file);
    }

    protected ProducerEntity loadProducerEntity(File file) throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0011", file);
        }
        Properties p = this.loadProperties(file);
        String id = p.getProperty(ID);
        String name = p.getProperty(NAME);
        String urlString = p.getProperty(URL);
        String identityPropagationType = p.getProperty(PROPAGATION_TYPE);
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException mfue) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProducerEntity(): failed to create URL urlString=" + urlString, mfue);
        }
        String markupEndpoint = p.getProperty(MARKUP_ENDPOINT);
        ProducerEntityStatus status = ProducerEntityStatus.getProducerEntityStatus(p.getProperty(STATUS));
        String rdXML = p.getProperty(REGISTRATION_DATA);
        RegistrationData rd = null;
        if (rdXML != null && rdXML.length() > 0) {
            try {
                rd = this.factory.getRegistrationData(rdXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProducerEntity(): failed to get registration data.  xml=" + rdXML, we);
            }
        }
        String rcXML = p.getProperty(REGISTRATION_CONTEXT);
        RegistrationContext rc = null;
        if (rcXML != null && rcXML.length() > 0) {
            try {
                rc = this.factory.getRegistrationContext(rcXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProducerEntity(): failed to get registration context.  xml=" + rcXML, we);
            }
        }
        String sdXML = p.getProperty(SERVICE_DESCRIPTION);
        ServiceDescription sd = null;
        if (sdXML != null && sdXML.length() > 0) {
            try {
                sd = this.factory.getServiceDescription(sdXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProducerEntity(): failed to get service description.  xml=" + sdXML, we);
            }
        }
        String ucXML = p.getProperty(USER_CATEGORY_MAPPING);
        Map ucMap = null;
        if (ucXML != null && ucXML.length() > 0) {
            ucMap = cofactory.getMap(ucXML);
        }
        String aupString = p.getProperty(ALLOWED_USER_PROFILE_MAPPING);
        Map aupMap = null;
        if (aupString != null && aupString.length() > 0) {
            aupMap = PropertiesProducerEntityManagerImpl.stringToMap(aupString);
        }
        String cupString = p.getProperty(CUSTOM_USER_PROFILE_MAPPING);
        Map cupMap = null;
        if (cupString != null && cupString.length() > 0) {
            cupMap = PropertiesProducerEntityManagerImpl.stringToMap(cupString);
        }
        long sdLastModified = -1L;
        try {
            String sdLastModifiedString = p.getProperty(SERVICE_DESCRIPTION_LAST_MODIFIED);
            sdLastModified = Long.parseLong(sdLastModifiedString);
        }
        catch (NumberFormatException nfe) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProducerEntity(): ", nfe);
        }
        String lastModified = p.getProperty(LAST_MODIFIED);
        ProducerEntityImpl pe = new ProducerEntityImpl(id, name, url, markupEndpoint, status, rd, rc, sd, ucMap, aupMap, cupMap, sdLastModified, lastModified, identityPropagationType);
        return pe;
    }

    protected String getProducerEntityLastModified(String producerEntityId) throws WSRPConsumerException {
        StringBuffer filename = new StringBuffer();
        filename.append(baseDir.toString()).append(File.separator).append(DATA_FILE_BASENAME).append(producerEntityId).append(DATA_FILE_EXTENSION);
        File file = new File(filename.toString());
        Properties p = this.loadProperties(file);
        return p.getProperty(LAST_MODIFIED);
    }

    protected Properties loadGlobalProperties() throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0012");
        }
        File file = new File(DATA_FILE_PATH + File.separator + GLOBAL_DATA_FILENAME);
        Properties p = null;
        if (file.exists()) {
            p = this.loadProperties(file);
        }
        return p;
    }

    protected Properties loadOrgProperties() throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0013");
        }
        File file = new File(DATA_FILE_PATH + File.separator + this.consumerId + File.separator + ORG_DATA_FILENAME);
        Properties p = null;
        if (file.exists()) {
            p = this.loadProperties(file);
        }
        return p;
    }

    protected Properties loadProperties(File file) throws WSRPConsumerException {
        FileInputStream fis = null;
        Properties p = null;
        try {
            fis = new FileInputStream(file);
            p = new Properties();
            p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProperties(): failed to retrieve producer entity.  file=" + file, fnfe);
        }
        catch (IOException ioe) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.loadProperties(): failed to retrieve producer entity.  file=" + file, ioe);
        }
        return p;
    }

    protected void storeProducerEntity(ProducerEntity pe) throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0014", pe.getId());
        }
        Properties p = new Properties();
        p.setProperty(ID, pe.getId());
        p.setProperty(NAME, pe.getName());
        p.setProperty(URL, pe.getURL().toString());
        p.setProperty(MARKUP_ENDPOINT, pe.getMarkupEndpoint());
        p.setProperty(STATUS, Short.toString(pe.getStatus().getValue()));
        RegistrationData rd = pe.getRegistrationData();
        String rdXML = "";
        if (rd != null) {
            try {
                rdXML = this.factory.getRegistrationDataXML(rd);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.storeProducerEntity(): failed to marshal registration data.  rd=" + rd, we);
            }
        }
        p.setProperty(REGISTRATION_DATA, rdXML);
        RegistrationContext rc = pe.getRegistrationContext();
        String rcXML = "";
        if (rc != null) {
            try {
                rcXML = this.factory.getRegistrationContextXML(rc);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.storeProducerEntity(): failed to marshal registration context.  rc=" + rc, we);
            }
        }
        p.setProperty(REGISTRATION_CONTEXT, rcXML);
        ServiceDescription sd = pe.getServiceDescription();
        String sdXML = "";
        if (sd != null) {
            try {
                sdXML = this.factory.getServiceDescriptionXML(sd);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.storeProducerEntity(): failed to marshal service description.  sd=" + sd, we);
            }
        }
        p.setProperty(SERVICE_DESCRIPTION, sdXML);
        Map ucs = pe.getUserCategoryMapping();
        String ucXML = "";
        if (ucs != null && ucs.size() > 0) {
            ucXML = cofactory.getMultiValueMapXML(ucs);
        }
        p.setProperty(USER_CATEGORY_MAPPING, ucXML);
        Map aups = pe.getAllowedUserProfileMapping();
        String aupString = "";
        if (aups != null && aups.size() > 0) {
            aupString = PropertiesProducerEntityManagerImpl.mapToString(aups);
        }
        p.setProperty(ALLOWED_USER_PROFILE_MAPPING, aupString);
        Map cups = pe.getCustomUserProfileMapping();
        String cupString = "";
        if (cups != null && cups.size() > 0) {
            cupString = PropertiesProducerEntityManagerImpl.mapToString(cups);
        }
        p.setProperty(CUSTOM_USER_PROFILE_MAPPING, cupString);
        p.setProperty(SERVICE_DESCRIPTION_LAST_MODIFIED, Long.toString(pe.getServiceDescriptionLastModified()));
        p.setProperty(LAST_MODIFIED, pe.getLastModified());
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        StringBuffer filename = new StringBuffer();
        filename.append(baseDir.toString()).append(File.separator).append(DATA_FILE_BASENAME).append(pe.getId()).append(DATA_FILE_EXTENSION);
        File file = new File(filename.toString());
        if (file.exists()) {
            file.delete();
        }
        String header = "\n# Copyright 2003 Sun Microsystems, Inc. All rights reserved\n# Use is subject to license terms.\n#\n# WSRP Consumer - Producer Entity Data (id: " + pe.getId() + ")";
        this.storeProperties(p, header, file);
    }

    protected void storeGlobalProperties(Properties p) throws WSRPConsumerException {
        File dir;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0015");
        }
        if (!(dir = new File(DATA_FILE_PATH)).exists()) {
            dir.mkdirs();
        }
        File file = new File(DATA_FILE_PATH + File.separator + GLOBAL_DATA_FILENAME);
        String header = "\n# Copyright 2003 Sun Microsystems, Inc. All rights reserved\n# Use is subject to license terms.\n#\n# WSRP Consumer - Global Data";
        this.storeProperties(p, header, file);
    }

    protected void storeOrgProperties(Properties p) throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0016", this.consumerId);
        }
        if (!baseDir.exists()) {
            baseDir.mkdirs();
        }
        File file = new File(baseDir.toString() + File.separator + ORG_DATA_FILENAME);
        String header = "\n# Copyright 2003 Sun Microsystems, Inc. All rights reserved\n# Use is subject to license terms.\n#\n# WSRP Consumer - Consumer Data (consumerId: " + this.consumerId + ")";
        this.storeProperties(p, header, file);
    }

    protected void storeProperties(Properties p, String header, File file) throws WSRPConsumerException {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, header);
            fos.close();
        }
        catch (FileNotFoundException fnfe) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.storeProperties(): failed to store properties.", fnfe);
        }
        catch (IOException ioe) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.storeProperties(): failed to store properties.", ioe);
        }
    }

    protected void deleteProducerEntity(String producerEntityId) throws WSRPConsumerException {
        StringBuffer filename = new StringBuffer();
        filename.append(baseDir.toString()).append(File.separator).append(DATA_FILE_BASENAME).append(producerEntityId).append(DATA_FILE_EXTENSION);
        File file = new File(filename.toString());
        if (!file.exists()) {
            throw new WSRPConsumerException("PropertiesProducerEntityManagerImpl.deleteProducerEntity(): producer entity does not exist.  consumerOrgDN=" + this.consumerId + ", producerEntityId=" + producerEntityId);
        }
        file.delete();
    }

    protected static String getConsumerAgent() {
        if (consumerAgent == null) {
            ResourceBundle prodRB = PropertyResourceBundle.getBundle("PSversion");
            StringBuffer caBuffer = new StringBuffer();
            caBuffer.append(prodRB.getString("productname")).append(".").append(prodRB.getString("productversion"));
            consumerAgent = caBuffer.toString();
        }
        return consumerAgent;
    }

    protected static Map stringToMap(String mapString) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringTokenizer st = new StringTokenizer(mapString, LIST_DELIMITER);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            int index = item.indexOf(MAPPING_DELIMITER);
            map.put(item.substring(0, index), item.substring(index + 1));
        }
        return map;
    }

    protected static String mapToString(Map map) {
        StringBuffer buf = new StringBuffer();
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            buf.append(key).append(MAPPING_DELIMITER).append(map.get(key));
            if (!i.hasNext()) continue;
            buf.append(LIST_DELIMITER);
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultGlobalProperties = new Properties();
        defaultGlobalProperties.setProperty(ENABLED, "true");
        HashMap<String, String> supMap = new HashMap<String, String>();
        supMap.put("name/prefix", "givenName");
        supMap.put("name/given", "givenName");
        supMap.put("name/family", "sn");
        supMap.put("name/suffix", "generationQualifier");
        supMap.put("employerInfo/department", "departmentNumber");
        supMap.put("employerInfo/jobtitle", "title");
        supMap.put("homeInfo/postal/name", "cn");
        supMap.put("homeInfo/postal/street", "street");
        supMap.put("homeInfo/postal/city", "l");
        supMap.put("homeInfo/postal/stateprov", "st");
        supMap.put("homeInfo/postal/postalcode", "postalCode");
        supMap.put("homeInfo/postal/country", "c");
        supMap.put("homeInfo/postal/organization", "o");
        supMap.put("homeInfo/telecom/telephone/number", "homePhone");
        supMap.put("homeInfo/telecom/fax/number", "fax");
        supMap.put("homeInfo/telecom/mobile/number", "mobile");
        supMap.put("homeInfo/telecom/pager/number", "pager");
        supMap.put("homeInfo/online/email", "mail");
        supMap.put("homeInfo/online/uri", "labeldURI");
        supMap.put("businessInfo/postal/name", "cn");
        supMap.put("businessInfo/postal/street", "street");
        supMap.put("businessInfo/postal/city", "l");
        supMap.put("businessInfo/postal/stateprov", "st");
        supMap.put("businessInfo/postal/postalcode", "postalCode");
        supMap.put("businessInfo/postal/country", "c");
        supMap.put("businessInfo/postal/organization", "o");
        supMap.put("businessInfo/telecom/telephone/number", "telephoneNumber");
        supMap.put("businessInfo/telecom/fax/number", "fax");
        supMap.put("businessInfo/telecom/mobile/number", "mobile");
        supMap.put("businessInfo/telecom/pager/number", "pager");
        supMap.put("businessInfo/online/email", "mail");
        supMap.put("businessInfo/online/uri", "labeldURI");
        defaultGlobalProperties.setProperty(STANDARD_USER_PROFILE_MAPPING, PropertiesProducerEntityManagerImpl.mapToString(supMap));
        defaultGlobalProperties.setProperty(DEFAULT_REGISTRATION_DATA, "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><RegistrationData xmlns=\"urn:oasis:names:tc:wsrp:v1:types\">    <consumerName>Default WSRP Consumer</consumerName>    <consumerAgent>Unknown Agent.X</consumerAgent>    <methodGetSupported>false</methodGetSupported>    <consumerModes>wsrp:view</consumerModes>    <consumerModes>wsrp:edit</consumerModes>    <consumerModes>wsrp:help</consumerModes><!--    <consumerModes>wsrp:preview</consumerModes> -->    <consumerWindowStates>wsrp:normal</consumerWindowStates>    <consumerWindowStates>wsrp:minimize</consumerWindowStates>    <consumerWindowStates>wsrp:maximize</consumerWindowStates>    <consumerWindowStates>wsrp:solo</consumerWindowStates>    <consumerUserScopes>wsrp:perUser</consumerUserScopes>    <consumerUserScopes>wsrp:forAll</consumerUserScopes></RegistrationData>");
    }
}

