/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.producermanager.impl;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.desktop.context.ConfigContext;
import com.sun.portal.desktop.context.DesktopAppContext;
import com.sun.portal.desktop.context.DesktopAppContextThreadLocalizer;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.SSOUtil;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.KeyGenerator;
import com.sun.portal.wsrp.common.Timer;
import com.sun.portal.wsrp.common.WSRPFactory;
import com.sun.portal.wsrp.common.stubs.GetServiceDescription;
import com.sun.portal.wsrp.common.stubs.InvalidRegistrationFault;
import com.sun.portal.wsrp.common.stubs.MissingParametersFault;
import com.sun.portal.wsrp.common.stubs.ModifyRegistration;
import com.sun.portal.wsrp.common.stubs.OperationFailedFault;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.common.stubs.RegistrationState;
import com.sun.portal.wsrp.common.stubs.ReturnAny;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_Registration_PortType;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_ServiceDescription_PortType;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManager;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManagerFactory;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ConsumerObjectFactory;
import com.sun.portal.wsrp.consumer.producermanager.InbandRegistrationNotSupportedException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import com.sun.portal.wsrp.consumer.producermanager.impl.ISConstants;
import com.sun.portal.wsrp.consumer.producermanager.impl.ISConsumerMultiPortalConstants;
import com.sun.portal.wsrp.consumer.producermanager.impl.ProducerEntityImpl;
import com.sun.xml.rpc.wsdl.framework.ParseException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ProducerEntityManagerImpl
implements ProducerEntityManager,
ISConstants {
    private static Map producerEntities = Collections.synchronizedMap(new HashMap());
    private static SSOToken adminSSOToken = null;
    private static AMStoreConnection adminConnection = null;
    private static ServiceSchemaManager serviceSchemaMgr = null;
    private static ConfigContext configContext = null;
    protected static String portalId = null;
    protected static WSRPFactory factory = null;
    protected static ConsumerObjectFactory cofactory = null;
    protected static String consumerAgent = null;
    protected static RemoteServiceStubManager stubMgr = null;
    protected AMStoreConnection userConnection = null;
    protected SSOToken ssoToken = null;
    protected String consumerOrgDN = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$producermanager$impl$ProducerEntityManagerImpl == null ? (class$com$sun$portal$wsrp$consumer$producermanager$impl$ProducerEntityManagerImpl = ProducerEntityManagerImpl.class$("com.sun.portal.wsrp.consumer.producermanager.impl.ProducerEntityManagerImpl")) : class$com$sun$portal$wsrp$consumer$producermanager$impl$ProducerEntityManagerImpl));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$producermanager$impl$ProducerEntityManagerImpl;

    public void init(String consumerId, HttpServletRequest request) throws WSRPConsumerException {
        DesktopAppContext appContext = DesktopAppContextThreadLocalizer.get();
        if (appContext.isAuthless(request)) {
            this.ssoToken = ProducerEntityManagerImpl.getAdminSSOToken();
        } else {
            SSOTokenManager ssoTokenMgr = null;
            try {
                ssoTokenMgr = SSOTokenManager.getInstance();
                this.ssoToken = ssoTokenMgr.createSSOToken(request);
            }
            catch (SSOException se) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.init(): failed to create ssoToken.", se);
            }
        }
        this.doInit(consumerId);
    }

    public void init(String consumerId, String username, String password) throws WSRPConsumerException {
        try {
            this.ssoToken = SSOUtil.createSSOToken((String)username, (String)password);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.init(): failed to create ssoToken.", se);
        }
        this.doInit(consumerId);
    }

    public void init(SSOToken ssoToken, String portalId, String consumerId) throws WSRPConsumerException {
        this.ssoToken = ssoToken;
        ProducerEntityManagerImpl.portalId = portalId;
        this.doInit(consumerId);
    }

    private void doInit(String consumerId) throws WSRPConsumerException {
        stubMgr = RemoteServiceStubManagerFactory.getRemoteServiceStubManager();
        this.consumerOrgDN = consumerId;
        try {
            this.userConnection = new AMStoreConnection(this.ssoToken);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.doInit():", se);
        }
        if (!this.isAccessible()) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.doInit(): security violation.  user does not have access to the given consumer.  dn=" + this.consumerOrgDN);
        }
        if (!this.existsConsumerOU()) {
            this.createConsumerOU();
        }
    }

    public boolean isActivated() throws WSRPConsumerException {
        Timer t = new Timer();
        String serviceEnabled = this.getGlobalStringAttribute("sunPortalWSRPConsumerIsDisabled");
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"elapsed", "" + t.getElapsed()};
            logger.log(Level.FINEST, "PSWS_CSPWCPI0002", param);
        }
        return Boolean.valueOf(serviceEnabled) == false;
    }

    protected boolean isAccessible() throws WSRPConsumerException {
        boolean isAccessible = false;
        String userDN = null;
        try {
            userDN = this.ssoToken.getPrincipal().getName();
        }
        catch (SSOException ssoe) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.isAccessible(): failed to extract user dn from the sso token.", ssoe);
        }
        if (userDN.endsWith(this.consumerOrgDN)) {
            isAccessible = true;
        } else {
            AMOrganization org = null;
            try {
                org = this.userConnection.getOrganization(this.consumerOrgDN);
            }
            catch (Exception ex) {
                isAccessible = false;
            }
            isAccessible = org != null;
        }
        return isAccessible;
    }

    public String getConsumerName() throws WSRPConsumerException {
        String consumerName = null;
        AMTemplate template = this.getOrganizationServiceTemplate(ProducerEntityManagerImpl.getAdminConnection());
        if (template != null) {
            try {
                consumerName = template.getStringAttribute("sunPortalWSRPConsumerName");
            }
            catch (AMException ae) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerName(): failed to retrieve consumer name.", ae);
            }
            catch (SSOException se) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerName(): failed to retrieve consumer name.", se);
            }
        }
        return consumerName;
    }

    public ServiceDescription getServiceDescription(URL producerURL) throws WSRPConsumerException {
        return this.getServiceDescription(producerURL, null);
    }

    public ServiceDescription getServiceDescription(URL producerURL, RegistrationContext regContext) throws WSRPConsumerException {
        String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_ServiceDescription_Binding_SOAP");
        WSRP_v1_ServiceDescription_PortType sdPort = stubMgr.getServiceDescriptionPortType(endpoint);
        String[] locales = null;
        ServiceDescription sd = null;
        GetServiceDescription gsd = new GetServiceDescription(regContext, locales);
        try {
            sd = sdPort.getServiceDescription(gsd);
        }
        catch (OperationFailedFault off) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getServiceDescription(): failed to get service description.  producerURL=" + producerURL, off);
        }
        catch (InvalidRegistrationFault irf) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getServiceDescription(): failed to get service description.  producerURL=" + producerURL, irf);
        }
        catch (RemoteException re) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getServiceDescription(): failed to get service description.  producerURL=" + producerURL, re);
        }
        if (sd != null && logger.isLoggable(Level.FINEST)) {
            String sdXML = null;
            try {
                sdXML = this.getWSRPFactory().getServiceDescriptionXML(sd, true);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getServiceDescription(): failed to serialize service description.  sd=" + sd, we);
            }
            StringBuffer logBuf = new StringBuffer();
            logBuf.append("PRODUCER_WSDL_URL=").append(producerURL);
            if (regContext != null) {
                logBuf.append("\nREG_HANDLE=").append(regContext.getRegistrationHandle());
            } else {
                logBuf.append("\nREG_HANDLE=<none>");
            }
            logBuf.append("\nSERVICE_DESCRIPTION=").append(sdXML);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, logBuf.toString());
            }
        }
        return sd;
    }

    public boolean isInbandRegistrationSupported(URL producerURL) throws WSRPConsumerException {
        String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
        WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
        return regPort != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProducerEntity getProducerEntity(String producerEntityId) throws WSRPConsumerException {
        ProducerEntity pe = (ProducerEntity)producerEntities.get(producerEntityId);
        if (pe != null) {
            String modified = this.getProducerEntityLastModified(producerEntityId);
            String cacheModified = pe.getLastModified();
            if (cacheModified.compareTo(modified) >= 0) {
                return pe;
            }
        }
        Map map = producerEntities;
        synchronized (map) {
            pe = (ProducerEntity)producerEntities.get(producerEntityId);
            String modified = null;
            String cacheModified = null;
            if (pe != null) {
                modified = this.getProducerEntityLastModified(producerEntityId);
                cacheModified = pe.getLastModified();
            }
            if (pe == null || cacheModified.compareTo(modified) < 0) {
                pe = this.loadProducerEntity(producerEntityId);
                producerEntities.put(producerEntityId, pe);
            }
        }
        return pe;
    }

    public String addProducerEntity(String producerName, URL producerURL, String identityPropagationType, RegistrationData regData, Map userCategories, Map allowedUserProfiles, Map customUserProfiles) throws WSRPConsumerException, InbandRegistrationNotSupportedException {
        ServiceDescription serviceDesc = this.getServiceDescription(producerURL);
        RegistrationContext regContext = null;
        if (serviceDesc.isRequiresRegistration()) {
            String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
            WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
            if (regPort == null) {
                throw new InbandRegistrationNotSupportedException("ProducerEntityManagerImpl.addProducerEntity(): registration port not available.  producerURL=" + producerURL);
            }
            try {
                regContext = regPort.register(regData);
            }
            catch (MissingParametersFault mpf) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.addProducerEntity(): failed to register.  producerURL=" + producerURL + ", regData=" + regData, mpf);
            }
            catch (OperationFailedFault off) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.addProducerEntity(): failed to register.  producerURL=" + producerURL + ", regData=" + regData, off);
            }
            catch (RemoteException re) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.addProducerEntity(): failed to register.  producerURL=" + producerURL + ", regData=" + regData, re);
            }
            serviceDesc = this.getServiceDescription(producerURL, regContext);
        }
        String producerEntityId = this.addProducerEntity(producerName, producerURL, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, identityPropagationType);
        return producerEntityId;
    }

    public String addProducerEntity(String producerName, URL producerURL, String identityPropagationType, String regHandle, Map userCategories, Map allowedUserProfiles, Map customUserProfiles) throws WSRPConsumerException {
        RegistrationContext regContext = new RegistrationContext(regHandle, null, null);
        ServiceDescription serviceDesc = this.getServiceDescription(producerURL, regContext);
        String producerEntityId = this.addProducerEntity(producerName, producerURL, null, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, identityPropagationType);
        return producerEntityId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String addProducerEntity(String producerName, URL producerURL, RegistrationData regData, RegistrationContext regContext, ServiceDescription serviceDesc, Map userCategories, Map allowedUserProfiles, Map customUserProfiles, String identityPropagationType) throws WSRPConsumerException {
        String producerEntityId = KeyGenerator.generateKey();
        String markupEndpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Markup_Binding_SOAP");
        long now = System.currentTimeMillis();
        ProducerEntity pe = this.createProducerEntity(producerEntityId, producerName, producerURL, markupEndpoint, ProducerEntityStatus.OK, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, now, Long.toString(now), identityPropagationType);
        this.createProducerEntityOU(pe.getId());
        this.storeProducerEntity(pe);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.put(pe.getId(), pe);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0003");
        }
        return pe.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServiceDescription(String producerEntityId) throws WSRPConsumerException {
        AMOrganizationalUnit peou;
        ProducerEntity pe = this.getProducerEntity(producerEntityId);
        if (pe == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.updateServiceDescription(): invalid producer entity id.  peId=" + producerEntityId);
        }
        URL producerURL = pe.getURL();
        RegistrationContext rc = pe.getRegistrationContext();
        ServiceDescription sd = this.getServiceDescription(producerURL, rc);
        String sdXML = null;
        if (sd != null) {
            try {
                sdXML = this.getWSRPFactory().getServiceDescriptionXML(sd);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to serialize service description.  sd=" + sd, we);
            }
        }
        if ((peou = this.getProducerEntityOU(producerEntityId, this.userConnection)) == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.updateServiceDescription(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerServiceDescription", sdXML);
            peou.setStringAttribute("sunPortalWSRPConsumerServiceDescriptionLastModified", Long.toString(System.currentTimeMillis()));
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.updateServiceDescription(): failed to persist producer entity.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.updateServiceDescription(): failed to persist producer entity.  producerEntityId=" + producerEntityId, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyRegistration(String producerEntityId, RegistrationData regData) throws WSRPConsumerException, InbandRegistrationNotSupportedException {
        AMOrganizationalUnit peou;
        ProducerEntity ope = this.getProducerEntity(producerEntityId);
        if (ope == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): invalid producer entity id.  peId=" + producerEntityId);
        }
        URL producerURL = ope.getURL();
        RegistrationContext regContext = ope.getRegistrationContext();
        String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
        WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
        if (regPort == null) {
            throw new InbandRegistrationNotSupportedException("ProducerEntityManagerImpl.modifyRegistration(): registration port not available.  producerrEntityId=" + producerEntityId);
        }
        ModifyRegistration modReg = new ModifyRegistration(regContext, regData);
        RegistrationState regState = null;
        try {
            regState = regPort.modifyRegistration(modReg);
        }
        catch (InvalidRegistrationFault irf) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, irf);
        }
        catch (MissingParametersFault mpf) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, mpf);
        }
        catch (OperationFailedFault off) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, off);
        }
        catch (RemoteException re) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to modify registration  producerEntityId=" + producerEntityId + ", regData=" + regData, re);
        }
        if (regState != null) {
            regContext.setRegistrationState(regState.getRegistrationState());
        }
        String rdXML = null;
        if (regData != null) {
            try {
                rdXML = this.getWSRPFactory().getRegistrationDataXML(regData);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to serialize registration data.  regData=" + regData, we);
            }
        }
        String rcXML = null;
        if (regContext != null) {
            try {
                rcXML = this.getWSRPFactory().getRegistrationContextXML(regContext);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to serialize registration context.  regContext=" + regContext, we);
            }
        }
        if ((peou = this.getProducerEntityOU(producerEntityId, this.userConnection)) == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerRegistrationData", rdXML);
            peou.setStringAttribute("sunPortalWSRPConsumerRegistrationContext", rcXML);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to persist registration context.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.modifyRegistration(): failed to persist registration context.  producerEntityId=" + producerEntityId, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    public void removeProducerEntity(String producerEntityId) throws WSRPConsumerException, InbandRegistrationNotSupportedException {
        block9: {
            ProducerEntity pe = this.getProducerEntity(producerEntityId);
            if (pe == null) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.removeProducerEntity(): invalid producer entity id.  peId=" + producerEntityId);
            }
            try {
                if (!pe.getServiceDescription().isRequiresRegistration()) break block9;
                URL producerURL = pe.getURL();
                RegistrationContext regContext = pe.getRegistrationContext();
                String endpoint = stubMgr.getEndpoint(producerURL, "WSRP_v1_Registration_Binding_SOAP");
                WSRP_v1_Registration_PortType regPort = stubMgr.getRegistrationPortType(endpoint);
                if (regPort == null) {
                    throw new InbandRegistrationNotSupportedException("ProducerEntityManagerImpl.removeProducerEntity(): registration port not available.  producerEntityId=" + producerEntityId);
                }
                ReturnAny ret = null;
                try {
                    ret = regPort.deregister(regContext);
                }
                catch (InvalidRegistrationFault irf) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, irf.getMessage(), irf);
                    }
                }
                catch (OperationFailedFault off) {
                    throw new WSRPConsumerException("ProducerEntityManagerImpl.removeProducerEntity(): failed to deregister from the producer.  producerEntityId=" + producerEntityId + ", regContext=" + regContext, off);
                }
                catch (RemoteException re) {
                    throw new WSRPConsumerException("ProducerEntityManagerImpl.removeProducerEntity(): failed to deregister from the producer.  producerEntityId=" + producerEntityId + ", regContext=" + regContext, re);
                }
            }
            catch (ParseException e) {
                logger.log(Level.WARNING, "PSWS_CSPWCPI0017", e);
                logger.log(Level.WARNING, "PSWS_CSPWCPI0018");
            }
        }
        this.eliminateProducerEntity(producerEntityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eliminateProducerEntity(String producerEntityId) throws WSRPConsumerException {
        this.purgeProducerEntity(producerEntityId);
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    public Set getProducerEntityIds() throws WSRPConsumerException {
        AMOrganizationalUnit cou = this.getConsumerOU(ProducerEntityManagerImpl.getAdminConnection());
        Set peDNs = null;
        try {
            peDNs = cou.getSubOrganizationalUnits(1);
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityIds(): failed to retrieve sub organizations from dn=" + cou.getDN(), ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityIds(): failed to retrieve sub organizations from dn=" + cou.getDN(), se);
        }
        HashSet<String> peIds = new HashSet<String>();
        Iterator i = peDNs.iterator();
        while (i.hasNext()) {
            String ouRDN;
            int ind;
            String dn = (String)i.next();
            int index = dn.indexOf(44);
            if (index <= 0 || (ind = (ouRDN = dn.substring(0, index)).indexOf(61)) <= 0) continue;
            peIds.add(ouRDN.substring(ind + 1));
        }
        return peIds;
    }

    public Map getStandardUserProfileMapping() throws WSRPConsumerException {
        Timer t = new Timer();
        HashMap<String, String> userProfileMapping = null;
        Set supSet = this.getGlobalAttribute("sunPortalWSRPConsumerUserProfileMapping");
        if (supSet.size() > 0) {
            userProfileMapping = new HashMap<String, String>();
            Iterator i = supSet.iterator();
            while (i.hasNext()) {
                String map = (String)i.next();
                int index = map.indexOf("|");
                userProfileMapping.put(map.substring(0, index), map.substring(index + 1));
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"elapsed", "" + t.getElapsed()};
            logger.log(Level.FINEST, "PSWS_CSPWCPI0002", param);
        }
        return userProfileMapping;
    }

    public RegistrationData getDefaultRegistrationData() throws WSRPConsumerException {
        String consumerName;
        Timer t = new Timer();
        RegistrationData defaultRegistrationData = null;
        Set rdSet = this.getGlobalAttribute("sunPortalWSRPConsumerDefaultRegistrationData");
        if (rdSet.size() > 0) {
            String rdXML = (String)rdSet.iterator().next();
            try {
                defaultRegistrationData = this.getWSRPFactory().getRegistrationData(rdXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getDefaultRegistrationData(): failed to unmarshal registration data.  xml=" + rdXML, we);
            }
        }
        if ((consumerName = this.getConsumerName()) == null || consumerName.length() == 0) {
            consumerName = defaultRegistrationData.getConsumerName();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCPI0004");
            }
        }
        String consumerAgent = ProducerEntityManagerImpl.getConsumerAgent();
        RegistrationData defRegData = new RegistrationData(consumerName, consumerAgent, defaultRegistrationData.isMethodGetSupported(), defaultRegistrationData.getConsumerModes(), defaultRegistrationData.getConsumerWindowStates(), defaultRegistrationData.getConsumerUserScopes(), defaultRegistrationData.getCustomUserProfileData(), defaultRegistrationData.getRegistrationProperties(), defaultRegistrationData.getExtensions());
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"elapsed", "" + t.getElapsed()};
            logger.log(Level.FINEST, "PSWS_CSPWCPI0002", param);
        }
        return defRegData;
    }

    public void setConsumerName(String consumerName) throws WSRPConsumerException {
        AMTemplate template = this.getOrganizationServiceTemplate(this.userConnection);
        if (template != null) {
            try {
                HashMap attrMap = new HashMap();
                HashSet<String> valueSet = new HashSet<String>();
                valueSet.add(consumerName);
                attrMap.put("sunPortalWSRPConsumerName", valueSet);
                template.setAttributes(attrMap);
                template.store();
            }
            catch (AMException ae) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.setConsumerName(): failed to set consumer name.", ae);
            }
            catch (SSOException se) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.setConsumerName(): failed to set consumer name.", se);
            }
        } else {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setConsumerName(): failed to get wsrp consumer service template.  consumerOrgDN=" + this.consumerOrgDN);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setName(String producerEntityId, String name) throws WSRPConsumerException {
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setName(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerProducerName", name);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setName(): failed to set name.  producerEntityId=" + producerEntityId + "name=" + name, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setName(): failed to set name.  producerEntityId=" + producerEntityId + "name=" + name, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentityPropagationType(String producerEntityId, String type) throws WSRPConsumerException {
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setIdentityPropagationType(): invalid producerEntityId=" + producerEntityId);
        }
        if (!(type.equals("com.sun.portal.wsrp.identity.none") || type.equals("org.oasis.wss.username.token.profile.usernameonly") || type.equals("org.oasis.wss.username.token.profile.passworddigest") || type.equals("org.oasis.wss.username.token.profile.passwordtext") || type.equals("com.sun.portal.wsrp.identity.ssotoken"))) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setIdentityPropagationType():Invalid type, type=" + type);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerIdentityPropagationType", type);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setIdentityPropagationType(): failed to set identityPropagationType.  producerEntityId=" + producerEntityId + "type=" + type, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setIdentityPropagationType(): failed to set identityPropagationType.  producerEntityId=" + producerEntityId + "type=" + type, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setURL(String producerEntityId, URL url) throws WSRPConsumerException {
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setURL(): invalid producerEntityId=" + producerEntityId);
        }
        if (url == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setURL(): url cannot be null.  producerEntityId=" + producerEntityId);
        }
        String markupEndpoint = stubMgr.getEndpoint(url, "WSRP_v1_Markup_Binding_SOAP");
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerProducerURL", url.toString());
            peou.setStringAttribute("sunPortalWSRPConsumerProducerMarkupEndpoint", markupEndpoint);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setURL(): failed to set url.  producerEntityId=" + producerEntityId + "url=" + url, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setURL(): failed to set url.  producerEntityId=" + producerEntityId + "url=" + url, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(String producerEntityId, ProducerEntityStatus status) throws WSRPConsumerException {
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setStatus(): invalid producerEntityId=" + producerEntityId);
        }
        if (status == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setStatus(): status cannot be null.  producerEntityId=" + producerEntityId);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerProducerStatus", Short.toString(status.getValue()));
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setStatus(): failed to set status.  producerEntityId=" + producerEntityId + "status=" + status, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setStatus(): failed to set status.  producerEntityId=" + producerEntityId + "status=" + status, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserCategoryMapping(String producerEntityId, Map userCategoryMap) throws WSRPConsumerException {
        String ucXML = this.getConsumerObjectFactory().getMultiValueMapXML(userCategoryMap);
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setUserCategoryMapping(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerUserCategoryMapping", ucXML);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setUserCategoryMapping(): failed to persist user category mapping.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setUserCategoryMapping(): failed to persist user category mapping.  producerEntityId=" + producerEntityId, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowedUserProfileMapping(String producerEntityId, Map allowedUserProfileMap) throws WSRPConsumerException {
        HashSet<String> cupSet = new HashSet<String>();
        Iterator i = allowedUserProfileMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            StringBuffer buf = new StringBuffer();
            buf.append(key).append("|").append(allowedUserProfileMap.get(key));
            cupSet.add(buf.toString());
        }
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setAllowedUserProfileMapping(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            HashMap<String, HashSet<String>> attrs = new HashMap<String, HashSet<String>>();
            attrs.put("sunPortalWSRPConsumerAllowedUserProfileMapping", cupSet);
            peou.setAttributes(attrs);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setAllowedUserProfileMapping(): failed to persist allowed user profile mapping.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setAllowedUserProfileMapping(): failed to persist allowed user profile mapping.  producerEntityId=" + producerEntityId, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomUserProfileMapping(String producerEntityId, Map customUserProfileMap) throws WSRPConsumerException {
        HashSet<String> cupSet = new HashSet<String>();
        Iterator i = customUserProfileMap.keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            StringBuffer buf = new StringBuffer();
            buf.append(key).append("|").append(customUserProfileMap.get(key));
            cupSet.add(buf.toString());
        }
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setCustomUserProfileMapping(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            HashMap<String, HashSet<String>> attrs = new HashMap<String, HashSet<String>>();
            attrs.put("sunPortalWSRPConsumerCustomUserProfileMapping", cupSet);
            peou.setAttributes(attrs);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setCustomUserProfileMapping(): failed to persist custom user profile mapping.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.setCustomUserProfileMapping(): failed to persist custom user profile mapping.  producerEntityId=" + producerEntityId, se);
        }
        Map map = producerEntities;
        synchronized (map) {
            producerEntities.remove(producerEntityId);
        }
    }

    public void setStandardUserProfileMapping(Map standardUserProfileMap) throws WSRPConsumerException {
        HashSet<String> supSet = null;
        if (standardUserProfileMap != null && standardUserProfileMap.size() > 0) {
            supSet = new HashSet<String>();
            Iterator i = standardUserProfileMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                StringBuffer buf = new StringBuffer();
                buf.append(key).append("|").append(standardUserProfileMap.get(key));
                supSet.add(buf.toString());
            }
        }
        this.setGlobalAttribute("sunPortalWSRPConsumerUserProfileMapping", supSet);
    }

    public void setDefaultRegistrationData(RegistrationData rd) throws WSRPConsumerException {
        HashSet<String> rdSet = null;
        if (rd != null) {
            rdSet = new HashSet<String>();
            String rdXML = null;
            try {
                rdXML = this.getWSRPFactory().getRegistrationDataXML(rd);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityImpl.setDefaultRegistrationData(): failed to marshal registration data.", we);
            }
            rdSet.add(rdXML);
        }
        this.setGlobalAttribute("sunPortalWSRPConsumerDefaultRegistrationData", rdSet);
    }

    protected ProducerEntity createProducerEntity(String producerEntityId, String producerName, URL producerURL, String markupEndpoint, ProducerEntityStatus status, RegistrationData regData, RegistrationContext regContext, ServiceDescription serviceDesc, Map userCategories, Map allowedUserProfiles, Map customUserProfiles, long serviceDescLastModified, String lastModified, String identityPropagationType) throws WSRPConsumerException {
        ProducerEntityImpl pe = new ProducerEntityImpl(producerEntityId, producerName, producerURL, markupEndpoint, status, regData, regContext, serviceDesc, userCategories, allowedUserProfiles, customUserProfiles, serviceDescLastModified, lastModified, identityPropagationType);
        return pe;
    }

    protected ProducerEntity loadProducerEntity(String producerEntityId) throws WSRPConsumerException {
        AMOrganizationalUnit peou;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0005", producerEntityId);
        }
        if ((peou = this.getProducerEntityOU(producerEntityId, ProducerEntityManagerImpl.getAdminConnection())) == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to load producer entity.  id=" + producerEntityId);
        }
        String id = null;
        String name = null;
        String urlString = null;
        String markupEndpoint = null;
        String identityPropagationType = null;
        ProducerEntityStatus status = null;
        String rdXML = null;
        String rcXML = null;
        String sdXML = null;
        String ucXML = null;
        Set aups = null;
        Set cups = null;
        long sdLastModified = -1L;
        String lastModified = null;
        try {
            id = peou.getStringAttribute("sunPortalWSRPConsumerProducerId");
            name = peou.getStringAttribute("sunPortalWSRPConsumerProducerName");
            urlString = peou.getStringAttribute("sunPortalWSRPConsumerProducerURL");
            markupEndpoint = peou.getStringAttribute("sunPortalWSRPConsumerProducerMarkupEndpoint");
            identityPropagationType = peou.getStringAttribute("sunPortalWSRPConsumerIdentityPropagationType");
            String statusString = peou.getStringAttribute("sunPortalWSRPConsumerProducerStatus");
            status = ProducerEntityStatus.getProducerEntityStatus(statusString);
            rdXML = peou.getStringAttribute("sunPortalWSRPConsumerRegistrationData");
            rcXML = peou.getStringAttribute("sunPortalWSRPConsumerRegistrationContext");
            sdXML = peou.getStringAttribute("sunPortalWSRPConsumerServiceDescription");
            ucXML = peou.getStringAttribute("sunPortalWSRPConsumerUserCategoryMapping");
            aups = peou.getAttribute("sunPortalWSRPConsumerAllowedUserProfileMapping");
            cups = peou.getAttribute("sunPortalWSRPConsumerCustomUserProfileMapping");
            String sdLastModifiedString = peou.getStringAttribute("sunPortalWSRPConsumerServiceDescriptionLastModified");
            if (sdLastModifiedString != null && sdLastModifiedString.length() > 0) {
                sdLastModified = Long.parseLong(sdLastModifiedString);
            }
            lastModified = peou.getStringAttribute("modifytimestamp");
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to retrieve producer entity.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to retrieve producer entity.  producerEntityId=" + producerEntityId, se);
        }
        catch (NumberFormatException nfe) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to retrieve producer entity.  producerEntityId=" + producerEntityId, nfe);
        }
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException mfue) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to create URL urlString=" + urlString, mfue);
        }
        RegistrationData rd = null;
        if (rdXML != null && rdXML.length() > 0) {
            try {
                rd = this.getWSRPFactory().getRegistrationData(rdXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to unserialize registration data.  xml=" + rdXML, we);
            }
        }
        RegistrationContext rc = null;
        if (rcXML != null && rcXML.length() > 0) {
            try {
                rc = this.getWSRPFactory().getRegistrationContext(rcXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to unserialize registration context.  xml=" + rcXML, we);
            }
        }
        ServiceDescription sd = null;
        if (sdXML != null) {
            try {
                sd = this.getWSRPFactory().getServiceDescription(sdXML);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.loadProducerEntity(): failed to unserialize service description.  xml=" + sdXML, we);
            }
        }
        Map ucMap = this.getConsumerObjectFactory().getMap(ucXML);
        HashMap<String, String> aupMap = new HashMap<String, String>();
        if (aups != null && aups.size() > 0) {
            Iterator i = aups.iterator();
            while (i.hasNext()) {
                String aup = (String)i.next();
                int index = aup.indexOf("|");
                aupMap.put(aup.substring(0, index), aup.substring(index + 1));
            }
        }
        HashMap<String, String> cupMap = new HashMap<String, String>();
        if (cups != null && cups.size() > 0) {
            Iterator i = cups.iterator();
            while (i.hasNext()) {
                String cup = (String)i.next();
                int index = cup.indexOf("|");
                cupMap.put(cup.substring(0, index), cup.substring(index + 1));
            }
        }
        ProducerEntityImpl pe = new ProducerEntityImpl(id, name, url, markupEndpoint, status, rd, rc, sd, ucMap, aupMap, cupMap, sdLastModified, lastModified, identityPropagationType);
        return pe;
    }

    protected String getProducerEntityLastModified(String producerEntityId) throws WSRPConsumerException {
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, ProducerEntityManagerImpl.getAdminConnection());
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityLastModified(): failed to load producer entity.  id=" + producerEntityId);
        }
        String lastModified = null;
        try {
            lastModified = peou.getStringAttribute("modifytimestamp");
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityLastModified(): failed to retrieve producer entity.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityLastModified(): failed to retrieve producer entity.  producerEntityId=" + producerEntityId, se);
        }
        return lastModified;
    }

    protected void storeProducerEntity(ProducerEntity pe) throws WSRPConsumerException {
        AMOrganizationalUnit peou;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0006", pe);
        }
        String producerEntityId = pe.getId();
        RegistrationData rd = pe.getRegistrationData();
        String rdXML = null;
        if (rd != null) {
            try {
                rdXML = this.getWSRPFactory().getRegistrationDataXML(rd);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to serialize registration data.  rd=" + rd, we);
            }
        }
        RegistrationContext rc = pe.getRegistrationContext();
        String rcXML = null;
        if (rc != null) {
            try {
                rcXML = this.getWSRPFactory().getRegistrationContextXML(rc);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to serialize registration context.  rc=" + rc, we);
            }
        }
        ServiceDescription sd = pe.getServiceDescription();
        String sdXML = null;
        if (sd != null) {
            try {
                sdXML = this.getWSRPFactory().getServiceDescriptionXML(sd);
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to serialize service description.  sd=" + sd, we);
            }
        }
        Map ucMap = pe.getUserCategoryMapping();
        String ucXML = null;
        if (ucMap != null && ucMap.size() > 0) {
            ucXML = this.getConsumerObjectFactory().getMultiValueMapXML(ucMap);
        }
        Map aupMap = pe.getAllowedUserProfileMapping();
        HashSet<String> aupSet = null;
        if (aupMap != null && aupMap.size() > 0) {
            aupSet = new HashSet<String>();
            Iterator i = aupMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                StringBuffer buf = new StringBuffer();
                buf.append(key).append("|").append(aupMap.get(key));
                aupSet.add(buf.toString());
            }
        }
        Map cupMap = pe.getCustomUserProfileMapping();
        HashSet<String> cupSet = null;
        if (cupMap != null && cupMap.size() > 0) {
            cupSet = new HashSet<String>();
            Iterator i = cupMap.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                StringBuffer buf = new StringBuffer();
                buf.append(key).append("|").append(cupMap.get(key));
                cupSet.add(buf.toString());
            }
        }
        if ((peou = this.getProducerEntityOU(producerEntityId, this.userConnection)) == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to load producer entity.  id=" + producerEntityId);
        }
        try {
            peou.setStringAttribute("sunPortalWSRPConsumerProducerId", producerEntityId);
            peou.setStringAttribute("sunPortalWSRPConsumerProducerName", pe.getName());
            peou.setStringAttribute("sunPortalWSRPConsumerProducerURL", pe.getURL().toString());
            peou.setStringAttribute("sunPortalWSRPConsumerIdentityPropagationType", pe.getIdentityPropagationType());
            peou.setStringAttribute("sunPortalWSRPConsumerProducerMarkupEndpoint", pe.getMarkupEndpoint());
            peou.setStringAttribute("sunPortalWSRPConsumerProducerStatus", Short.toString(pe.getStatus().getValue()));
            peou.setStringAttribute("sunPortalWSRPConsumerRegistrationData", rdXML);
            peou.setStringAttribute("sunPortalWSRPConsumerRegistrationContext", rcXML);
            peou.setStringAttribute("sunPortalWSRPConsumerServiceDescription", sdXML);
            long sdLastModified = pe.getServiceDescriptionLastModified();
            peou.setStringAttribute("sunPortalWSRPConsumerServiceDescriptionLastModified", Long.toString(sdLastModified));
            peou.setStringAttribute("sunPortalWSRPConsumerUserCategoryMapping", ucXML);
            HashMap<String, HashSet<String>> attrs = new HashMap<String, HashSet<String>>();
            if (aupSet != null) {
                attrs.put("sunPortalWSRPConsumerAllowedUserProfileMapping", aupSet);
            }
            if (cupSet != null) {
                attrs.put("sunPortalWSRPConsumerCustomUserProfileMapping", cupSet);
            }
            peou.setAttributes(attrs);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to persist producer entity.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.storeProducerEntity(): failed to persist producer entity.  producerEntityId=" + producerEntityId, se);
        }
    }

    protected void purgeProducerEntity(String producerEntityId) throws WSRPConsumerException {
        AMOrganizationalUnit peou = this.getProducerEntityOU(producerEntityId, this.userConnection);
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.purgeProducerEntity(): invalid producerEntityId=" + producerEntityId);
        }
        try {
            peou.delete(true);
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.purgeProducerEntity(): failed to remove producer entity.  producerEntityId=" + producerEntityId, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.purgeProducerEntity(): failed to remove producer entity.  producerEntityId=" + producerEntityId, se);
        }
    }

    protected AMOrganization getConsumerOrganization() throws WSRPConsumerException {
        boolean isCoValid = false;
        try {
            isCoValid = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(this.consumerOrgDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOrganization(): failed to validate dn.  dn= " + this.consumerOrgDN, se);
        }
        if (!isCoValid) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOrganization(): not a valid entry in IS.  dn=" + this.consumerOrgDN);
        }
        AMOrganization co = null;
        try {
            co = ProducerEntityManagerImpl.getAdminConnection().getOrganization(this.consumerOrgDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOrganization(): failed to access organizational.  dn=" + this.consumerOrgDN, se);
        }
        return co;
    }

    protected boolean existsConsumerOU() throws WSRPConsumerException {
        ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
        String couDN = iscmpc.MP_RDN_CONSUMER + "," + this.consumerOrgDN;
        boolean couValid = false;
        try {
            couValid = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(couDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.existsConsumerOU(): failed to validate dn.  dn= " + couDN, se);
        }
        return couValid;
    }

    protected AMOrganizationalUnit createConsumerOU() throws WSRPConsumerException {
        ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
        String couDN = iscmpc.MP_RDN_CONSUMER + "," + this.consumerOrgDN;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCPI0007", couDN);
        }
        boolean isValidEntry = false;
        try {
            isValidEntry = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(couDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createConsumerOU(): failed to validate entry.  dn=" + couDN, se);
        }
        if (isValidEntry) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createConsumerOU(): producer entity organizational unit already exists.  dn=" + couDN);
        }
        AMOrganization co = this.getConsumerOrganization();
        HashSet<String> ous = new HashSet<String>();
        ous.add(iscmpc.MP_CONSUMER);
        try {
            co.createOrganizationalUnits(ous);
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createConsumerOU(): failed to create organizational unit under dn=" + this.consumerOrgDN, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createConsumerOU(): failed to create organizational unit under dn=" + this.consumerOrgDN, se);
        }
        AMOrganizationalUnit cou = null;
        try {
            cou = ProducerEntityManagerImpl.getAdminConnection().getOrganizationalUnit(couDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createConsumerOU(): failed to get newly created organizational unit.  dn=" + couDN, se);
        }
        if (cou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createConsumerOU(): failed to get newly created organizational unit.  dn=" + couDN);
        }
        return cou;
    }

    protected AMOrganizationalUnit getConsumerOU(AMStoreConnection connection) throws WSRPConsumerException {
        AMOrganization co = this.getConsumerOrganization();
        ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
        Set serviceNames = null;
        try {
            serviceNames = co.getRegisteredServiceNames();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOU(): failed to access service names.  dn=" + this.consumerOrgDN, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOU(): failed to access service names.  dn=" + this.consumerOrgDN, se);
        }
        if (!serviceNames.contains(iscmpc.MP_SERVICE_WSRP_CONSUMER)) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOU(): " + iscmpc.MP_SERVICE_WSRP_CONSUMER + " is not registered for dn=" + this.consumerOrgDN);
        }
        String couDN = iscmpc.MP_RDN_CONSUMER + "," + this.consumerOrgDN;
        boolean couValid = false;
        try {
            couValid = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(couDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOU(): failed to validate dn.  dn= " + couDN, se);
        }
        if (!couValid) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOU(): invalid entry.  DN=" + couDN);
        }
        AMOrganizationalUnit cou = null;
        try {
            cou = connection.getOrganizationalUnit(couDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getConsumerOU(): failed to access organizational unit.  dn=" + couDN, se);
        }
        return cou;
    }

    protected AMOrganizationalUnit createProducerEntityOU(String producerEntityId) throws WSRPConsumerException {
        AMOrganizationalUnit cou = this.getConsumerOU(this.userConnection);
        String peouDN = "ou=" + producerEntityId + "," + cou.getDN();
        boolean isValidEntry = false;
        try {
            isValidEntry = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(peouDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to validate entry.  dn=" + peouDN, se);
        }
        if (isValidEntry) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): producer entity organizational unit already exists.  dn=" + peouDN);
        }
        HashSet<String> ous = new HashSet<String>();
        ous.add(producerEntityId);
        try {
            cou.createSubOrganizationalUnits(ous);
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to create organizational unit under dn=" + cou.getDN(), ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to create organizational unit under dn=" + cou.getDN(), se);
        }
        AMOrganizationalUnit peou = null;
        try {
            peou = cou.getSubOrganizationalUnit(peouDN);
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to get newly created organizational unit.  dn=" + peouDN, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to get newly created organizational unit.  dn=" + peouDN, se);
        }
        if (peou == null) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to create producer entity organizational unit .  dn=" + peouDN);
        }
        try {
            Set ocs = peou.getAttribute("objectclass");
            ocs.add("sunPortalWSRPConsumerProducerEntity");
            HashMap<String, Set> attrMap = new HashMap<String, Set>();
            attrMap.put("objectclass", ocs);
            peou.setAttributes(attrMap);
            peou.store();
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to register objectclass to the newly created organizational unit.  dn=" + peouDN + ", objectclass=" + "sunPortalWSRPConsumerProducerEntity", ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.createProducerEntityOU(): failed to registerobjectclass to the newly created organizational unit.  dn=" + peouDN + ", objectclass=" + "sunPortalWSRPConsumerProducerEntity", se);
        }
        return peou;
    }

    protected AMOrganizationalUnit getProducerEntityOU(String producerEntityId, AMStoreConnection connection) throws WSRPConsumerException {
        AMOrganizationalUnit peou = null;
        AMOrganizationalUnit cou = this.getConsumerOU(connection);
        String peouDN = "ou=" + producerEntityId + "," + cou.getDN();
        boolean isValidEntry = false;
        try {
            isValidEntry = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(peouDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityOU(): failed to validate entry.  dn=" + peouDN, se);
        }
        if (isValidEntry) {
            try {
                peou = cou.getSubOrganizationalUnit(peouDN);
            }
            catch (AMException ae) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityOU(): failed to get organizational unit.  dn=" + peouDN, ae);
            }
            catch (SSOException se) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getProducerEntityOU(): failed to get organizational unit.  dn=" + peouDN, se);
            }
        }
        return peou;
    }

    protected WSRPFactory getWSRPFactory() throws WSRPConsumerException {
        if (factory == null) {
            try {
                factory = WSRPFactory.getInstance();
            }
            catch (WSRPException we) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getWSRPFactory(): failed to get an instance of WSRPFactory.", we);
            }
        }
        return factory;
    }

    protected ConsumerObjectFactory getConsumerObjectFactory() throws WSRPConsumerException {
        if (cofactory == null) {
            cofactory = ConsumerObjectFactory.getInstance();
        }
        return cofactory;
    }

    protected AMTemplate getOrganizationServiceTemplate(AMStoreConnection connection) throws WSRPConsumerException {
        ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
        boolean isOrgValid = false;
        try {
            isOrgValid = ProducerEntityManagerImpl.getAdminConnection().isValidEntry(this.consumerOrgDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getOrganizationServiceTemplate(): failed to validate dn.  dn= " + this.consumerOrgDN, se);
        }
        if (!isOrgValid) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getOrganizationServiceTemplate(): invalid dn.  dn=" + this.consumerOrgDN);
        }
        AMOrganization org = null;
        try {
            org = connection.getOrganization(this.consumerOrgDN);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getOrganizationServiceTemplate(): failed to get organization.  dn= " + this.consumerOrgDN, se);
        }
        AMTemplate serviceTemplate = null;
        try {
            if (org.orgTemplateExists(iscmpc.MP_SERVICE_WSRP_CONSUMER)) {
                serviceTemplate = org.getTemplate(iscmpc.MP_SERVICE_WSRP_CONSUMER, 302);
            }
        }
        catch (AMException ae) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getOrganizationServiceTemplate(): failed retrieve WSRP Consumer service template.  dn= " + this.consumerOrgDN, ae);
        }
        catch (SSOException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getOrganizationServiceTemplate(): failed retrieve WSRP Consumer service template.  dn= " + this.consumerOrgDN, se);
        }
        return serviceTemplate;
    }

    protected Set getGlobalAttribute(String attrName) throws WSRPConsumerException {
        ServiceSchema schema = null;
        try {
            schema = this.getServiceSchemaManager().getGlobalSchema();
        }
        catch (SMSException se) {
            ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getGlobalAttribute(): failed to retrieve global schema for service=" + iscmpc.MP_SERVICE_WSRP_CONSUMER, se);
        }
        Map attrMap = schema.getReadOnlyAttributeDefaults();
        return (Set)attrMap.get(attrName);
    }

    protected String getGlobalStringAttribute(String attrName) throws WSRPConsumerException {
        Set set = this.getGlobalAttribute(attrName);
        if (set != null && set.size() > 0) {
            return (String)set.iterator().next();
        }
        return null;
    }

    protected void setGlobalAttribute(String attrName, Set value) throws WSRPConsumerException {
        ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
        ServiceSchema schema = null;
        HashMap<String, Set> attrMap = new HashMap<String, Set>();
        attrMap.put(attrName, value);
        try {
            schema = this.getServiceSchemaManager().getGlobalSchema();
        }
        catch (SMSException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getGlobalAttribute(): failed to retrieve global schema for service=" + iscmpc.MP_SERVICE_WSRP_CONSUMER, se);
        }
        try {
            schema.setAttributeDefaults(attrMap);
        }
        catch (SMSException se) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getGlobalAttribute(): failed to set global attribute.  service=" + iscmpc.MP_SERVICE_WSRP_CONSUMER + ", attrName=" + attrName, se);
        }
        catch (SSOException sse) {
            throw new WSRPConsumerException("ProducerEntityManagerImpl.getGlobalAttribute(): failed to set global attribute.  service=" + iscmpc.MP_SERVICE_WSRP_CONSUMER + ", attrName=" + attrName, sse);
        }
    }

    private static AMStoreConnection getAdminConnection() throws WSRPConsumerException {
        if (adminConnection == null) {
            try {
                SSOToken sso = ProducerEntityManagerImpl.getAdminSSOToken();
                adminConnection = new AMStoreConnection(sso);
            }
            catch (SSOException se) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getAdminConnection(): ", se);
            }
        }
        return adminConnection;
    }

    private static SSOToken getAdminSSOToken() throws WSRPConsumerException {
        if (adminSSOToken == null) {
            adminSSOToken = SSOUtil.getAdminSSOToken();
        }
        return adminSSOToken;
    }

    private ServiceSchemaManager getServiceSchemaManager() throws WSRPConsumerException {
        ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance(portalId);
        if (serviceSchemaMgr == null) {
            try {
                serviceSchemaMgr = new ServiceSchemaManager(ProducerEntityManagerImpl.getAdminSSOToken(), iscmpc.MP_SERVICE_WSRP_CONSUMER, "1.0");
            }
            catch (SSOException se) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getServiceSchemaManager(): ", se);
            }
            catch (SMSException sme) {
                throw new WSRPConsumerException("ProducerEntityManagerImpl.getServiceSchemaManager(): ", sme);
            }
        }
        return serviceSchemaMgr;
    }

    protected static String getConsumerAgent() {
        if (consumerAgent == null) {
            ResourceBundle prodRB = PropertyResourceBundle.getBundle("PSversion");
            StringBuffer caBuffer = new StringBuffer();
            caBuffer.append(prodRB.getString("productname")).append(".").append(prodRB.getString("productversion"));
            consumerAgent = caBuffer.toString();
        }
        return consumerAgent;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

