/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.producermanager.impl;

import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.WSRPFactory;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ConsumerObjectFactory;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import java.io.Serializable;
import java.net.URL;
import java.util.Date;
import java.util.Map;

public class ProducerEntityImpl
implements ProducerEntity,
Serializable {
    private String id = null;
    private String name = null;
    private URL url = null;
    private String markupEndpoint = null;
    private ProducerEntityStatus status = null;
    private RegistrationData regData = null;
    private RegistrationContext regContext = null;
    private ServiceDescription serviceDescription = null;
    private Map userCategoryMapping = null;
    private Map allowedUserProfileMapping = null;
    private Map customUserProfileMapping = null;
    private long serviceDescriptionLastModified = -1L;
    private String lastModified = null;
    private String identityPropagationType = "com.sun.portal.wsrp.identity.none";

    public ProducerEntityImpl(String id, String name, URL url, String markupEndpoint, ProducerEntityStatus status, RegistrationData regData, RegistrationContext regContext, ServiceDescription serviceDescription, Map userCategoryMapping, Map allowedUserProfileMapping, Map customUserProfileMapping, long serviceDescriptionLastModified, String lastModified, String identityPropagationType) {
        this.id = id;
        this.name = name;
        this.url = url;
        this.markupEndpoint = markupEndpoint;
        this.status = status;
        this.regData = regData;
        this.regContext = regContext;
        this.serviceDescription = serviceDescription;
        this.userCategoryMapping = userCategoryMapping;
        this.allowedUserProfileMapping = allowedUserProfileMapping;
        this.customUserProfileMapping = customUserProfileMapping;
        this.serviceDescriptionLastModified = serviceDescriptionLastModified;
        this.lastModified = lastModified;
        if (identityPropagationType != null && identityPropagationType.trim().length() != 0) {
            this.identityPropagationType = identityPropagationType;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public URL getURL() {
        return this.url;
    }

    public String getMarkupEndpoint() {
        return this.markupEndpoint;
    }

    public RegistrationData getRegistrationData() {
        return this.regData;
    }

    public RegistrationContext getRegistrationContext() {
        return this.regContext;
    }

    public Map getUserCategoryMapping() {
        return this.userCategoryMapping;
    }

    public Map getAllowedUserProfileMapping() {
        return this.allowedUserProfileMapping;
    }

    public Map getCustomUserProfileMapping() {
        return this.customUserProfileMapping;
    }

    public ProducerEntityStatus getStatus() {
        return this.status;
    }

    public ServiceDescription getServiceDescription() {
        return this.serviceDescription;
    }

    public PortletDescription getPortletDescription(String portletHandle) {
        PortletDescription pd = null;
        PortletDescription[] pds = this.serviceDescription.getOfferedPortlets();
        for (int i = 0; i < pds.length; ++i) {
            if (!pds[i].getPortletHandle().equals(portletHandle)) continue;
            pd = pds[i];
            break;
        }
        return pd;
    }

    public long getServiceDescriptionLastModified() {
        return this.serviceDescriptionLastModified;
    }

    public String getLastModified() {
        return this.lastModified;
    }

    public String getIdentityPropagationType() {
        return this.identityPropagationType;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ID: ").append(this.id).append("\nName: ").append(this.name).append("\nWSDL URL: ").append(this.url).append("\nMarkup Endpoint: ").append(this.markupEndpoint).append("\nStatus: ").append(this.status).append("\nIdentityPropagationType: ").append(this.identityPropagationType);
        WSRPFactory factory = null;
        ConsumerObjectFactory cofactory = null;
        try {
            factory = WSRPFactory.getInstance();
            buf.append("\nRegistration Data: ").append(factory.getRegistrationDataXML(this.regData, true)).append("\nRegistration Context: ").append(factory.getRegistrationContextXML(this.regContext, true)).append("\nService Description: ").append(factory.getServiceDescriptionXML(this.serviceDescription, true));
        }
        catch (WSRPException we) {
            buf.append("[ERROR]");
        }
        try {
            cofactory = ConsumerObjectFactory.getInstance();
            buf.append("\nUser Category Mapping: ").append(cofactory.getMultiValueMapXML(this.userCategoryMapping, true));
        }
        catch (WSRPConsumerException wce) {
            buf.append("[ERROR]");
        }
        buf.append("\nAllowed User Profile Mapping: ").append(this.allowedUserProfileMapping != null ? this.allowedUserProfileMapping.toString() : "null").append("\nCustom User Profile Mapping: ").append(this.customUserProfileMapping != null ? this.customUserProfileMapping.toString() : "null").append("\nService Description Last Modified on: ").append(new Date(this.serviceDescriptionLastModified)).append("\nLast Modified on: ").append(this.lastModified);
        return buf.toString();
    }
}

