/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.producermanager;

import com.iplanet.sso.SSOToken;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerConfig;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ProducerEntityManagerFactory {
    private static ProducerEntityManagerFactory pemFactory = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$producermanager$ProducerEntityManagerFactory == null ? (class$com$sun$portal$wsrp$consumer$producermanager$ProducerEntityManagerFactory = ProducerEntityManagerFactory.class$("com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory")) : class$com$sun$portal$wsrp$consumer$producermanager$ProducerEntityManagerFactory));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$producermanager$ProducerEntityManagerFactory;

    private ProducerEntityManagerFactory() {
    }

    public static void init() {
        pemFactory = new ProducerEntityManagerFactory();
    }

    public static ProducerEntityManagerFactory getInstance() {
        if (pemFactory == null) {
            ProducerEntityManagerFactory.init();
        }
        return pemFactory;
    }

    public ProducerEntityManager getProducerEntityManager(String consumerId, HttpServletRequest request) throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"consumerId", consumerId};
            logger.log(Level.FINEST, "PSWS_CSPWCP00001", param);
        }
        WSRPConsumerConfig config = WSRPConsumerConfig.getInstance();
        String pemClassname = config.getProducerEntityManagerClassname();
        ProducerEntityManager pem = this.loadProducerEntityManagerClass(pemClassname);
        pem.init(consumerId, request);
        return pem;
    }

    public ProducerEntityManager getProducerEntityManager(String consumerId, String username, String password) throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"consumerId", consumerId};
            logger.log(Level.FINEST, "PSWS_CSPWCP00001", param);
            param[0] = "username";
            param[1] = username;
            logger.log(Level.FINEST, "PSWS_CSPWCP00001", param);
        }
        WSRPConsumerConfig config = WSRPConsumerConfig.getInstance();
        String pemClassname = config.getProducerEntityManagerClassname();
        ProducerEntityManager pem = this.loadProducerEntityManagerClass(pemClassname);
        pem.init(consumerId, username, password);
        return pem;
    }

    public ProducerEntityManager getProducerEntityManager(SSOToken ssoToken, String portalId, String consumerId) throws WSRPConsumerException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] param = new String[]{"portalId", portalId};
            logger.log(Level.FINEST, "PSWS_CSPWCP00001", param);
            param[0] = "consumerId";
            param[1] = consumerId;
            logger.log(Level.FINEST, "PSWS_CSPWCP00001", param);
        }
        WSRPConsumerConfig config = WSRPConsumerConfig.getInstance();
        String pemClassname = config.getProducerEntityManagerClassname();
        ProducerEntityManager pem = this.loadProducerEntityManagerClass(pemClassname);
        pem.init(ssoToken, portalId, consumerId);
        return pem;
    }

    protected ProducerEntityManager loadProducerEntityManagerClass(String classname) throws WSRPConsumerException {
        ProducerEntityManager pem = null;
        try {
            pem = (ProducerEntityManager)Class.forName(classname).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new WSRPConsumerException("ProducerEntityManagerFactory.loadProducerEntityMangerClass(): failed to load PEM class.", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new WSRPConsumerException("ProducerEntityManagerFactory.loadProducerEntityMangerClass(): failed to load PEM class.", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new WSRPConsumerException("ProducerEntityManagerFactory.loadProducerEntityMangerClass(): failed to load PEM class.", iae);
        }
        catch (ClassCastException cce) {
            throw new WSRPConsumerException("ProducerEntityManagerFactory.loadProducerEntityMangerClass(): failed to load PEM class.", cce);
        }
        catch (InstantiationException ie) {
            throw new WSRPConsumerException("ProducerEntityManagerFactory.loadProducerEntityMangerClass(): failed to load PEM class.", ie);
        }
        catch (SecurityException se) {
            throw new WSRPConsumerException("ProducerEntityManagerFactory.loadProducerEntityMangerClass(): failed to load PEM class.", se);
        }
        return pem;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

