/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContentException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.stubs.Contact;
import com.sun.portal.wsrp.common.stubs.EmployerInfo;
import com.sun.portal.wsrp.common.stubs.Online;
import com.sun.portal.wsrp.common.stubs.PersonName;
import com.sun.portal.wsrp.common.stubs.Postal;
import com.sun.portal.wsrp.common.stubs.Telecom;
import com.sun.portal.wsrp.common.stubs.TelephoneNum;
import com.sun.portal.wsrp.common.stubs.UserContext;
import com.sun.portal.wsrp.common.stubs.UserProfile;
import com.sun.portal.wsrp.consumer.common.Compare;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import com.sun.portal.wsrp.consumer.markup.UserContextManager;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupUtil;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UserContextManagerImpl
implements UserContextManager {
    private static final String USER_CONTEXT_CACHE_KEY = "user_context_cache_key";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$markup$impl$UserContextManagerImpl == null ? (class$com$sun$portal$wsrp$consumer$markup$impl$UserContextManagerImpl = UserContextManagerImpl.class$("com.sun.portal.wsrp.consumer.markup.impl.UserContextManagerImpl")) : class$com$sun$portal$wsrp$consumer$markup$impl$UserContextManagerImpl));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$markup$impl$UserContextManagerImpl;

    public boolean isUserContextCacheValid(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        if (request.getUserID() == null) {
            return false;
        }
        Map currentUserInfo = request.getUserInfo();
        List currentRoles = request.getRoles();
        UserContextCache userContextCache = this.getUserContextCache(request);
        if (userContextCache != null && userContextCache.match(currentUserInfo, currentRoles)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0018", request.getEntityID());
            }
            return true;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCMI0019", request.getEntityID());
        }
        if (userContextCache != null) {
            this.invalidateUserContextCache(request);
        }
        return false;
    }

    public UserContext getUserContext(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        UserContext userContext = null;
        if (request.getUserID() != null) {
            UserContextCache userContextCache = this.getUserContextCache(request);
            if (userContext != null) {
                userContext = userContextCache.getUserContext();
            }
        }
        if (userContext == null) {
            userContext = this.getFreshUserContext(markupConfig, request);
            if (request.getUserID() != null) {
                this.putUserContextCache(request, new UserContextCache(userContext, request.getUserInfo(), request.getRoles()));
            }
        }
        return userContext;
    }

    private UserContext getFreshUserContext(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        UserContext context = new UserContext();
        if (request.getUserID() == null) {
            context.setUserContextKey("wsrp:minimal");
        } else {
            context.setUserContextKey(request.getUserID());
        }
        List roles = request.getRoles();
        if (roles != null) {
            String[] userCategories = new String[roles.size()];
            roles.toArray(userCategories);
            context.setUserCategories(userCategories);
        }
        context.setProfile(this.getUserProfile(markupConfig, request));
        return context;
    }

    private UserProfile getUserProfile(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        String[] keys = markupConfig.getPortletDescription().getUserProfileItems();
        Map userInfo = request.getUserInfo();
        if (keys.length == 0 || userInfo == null || userInfo.size() == 0) {
            return null;
        }
        UserProfile userProfile = this.getEmptyUserProfile();
        for (int i = 0; i < keys.length; ++i) {
            if (keys[i] == null) {
                throw new ContainerException("Found an empty user profile key");
            }
            String value = (String)userInfo.get(keys[i]);
            if (keys[i].equals("name/prefix")) {
                userProfile.getName().setPrefix(value);
                continue;
            }
            if (keys[i].equals("name/given")) {
                userProfile.getName().setGiven(value);
                continue;
            }
            if (keys[i].equals("name/family")) {
                userProfile.getName().setFamily(value);
                continue;
            }
            if (keys[i].equals("name/middle")) {
                userProfile.getName().setMiddle(value);
                continue;
            }
            if (keys[i].equals("name/suffix")) {
                userProfile.getName().setSuffix(value);
                continue;
            }
            if (keys[i].equals("name/nickname")) {
                userProfile.getName().setNickname(value);
                continue;
            }
            if (keys[i].equals("bdate")) continue;
            if (keys[i].equals("gender")) {
                userProfile.setGender(value);
                continue;
            }
            if (keys[i].equals("employerInfo/employer")) {
                userProfile.getEmployerInfo().setEmployer(value);
                continue;
            }
            if (keys[i].equals("employerInfo/department")) {
                userProfile.getEmployerInfo().setDepartment(value);
                continue;
            }
            if (keys[i].equals("employerInfo/jobtitle")) {
                userProfile.getEmployerInfo().setJobtitle(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/name")) {
                userProfile.getHomeInfo().getPostal().setName(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/street")) {
                userProfile.getHomeInfo().getPostal().setStreet(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/city")) {
                userProfile.getHomeInfo().getPostal().setCity(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/stateprov")) {
                userProfile.getHomeInfo().getPostal().setStateprov(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/postalcode")) {
                userProfile.getHomeInfo().getPostal().setPostalcode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/country")) {
                userProfile.getHomeInfo().getPostal().setCountry(value);
                continue;
            }
            if (keys[i].equals("homeInfo/postal/organization")) {
                userProfile.getHomeInfo().getPostal().setOrganization(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/telephone/intcode")) {
                userProfile.getHomeInfo().getTelecom().getTelephone().setIntcode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/telephone/loccode")) {
                userProfile.getHomeInfo().getTelecom().getTelephone().setLoccode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/telephone/number")) {
                userProfile.getHomeInfo().getTelecom().getTelephone().setNumber(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/telephone/ext")) {
                userProfile.getHomeInfo().getTelecom().getTelephone().setExt(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/telephone/comment")) {
                userProfile.getHomeInfo().getTelecom().getTelephone().setComment(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/fax/intcode")) {
                userProfile.getHomeInfo().getTelecom().getFax().setIntcode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/fax/loccode")) {
                userProfile.getHomeInfo().getTelecom().getFax().setLoccode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/fax/number")) {
                userProfile.getHomeInfo().getTelecom().getFax().setNumber(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/fax/ext")) {
                userProfile.getHomeInfo().getTelecom().getFax().setExt(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/fax/comment")) {
                userProfile.getHomeInfo().getTelecom().getFax().setComment(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/mobile/intcode")) {
                userProfile.getHomeInfo().getTelecom().getMobile().setIntcode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/mobile/loccode")) {
                userProfile.getHomeInfo().getTelecom().getMobile().setLoccode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/mobile/number")) {
                userProfile.getHomeInfo().getTelecom().getMobile().setNumber(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/mobile/ext")) {
                userProfile.getHomeInfo().getTelecom().getMobile().setExt(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/mobile/comment")) {
                userProfile.getHomeInfo().getTelecom().getMobile().setComment(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/pager/intcode")) {
                userProfile.getHomeInfo().getTelecom().getPager().setIntcode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/pager/loccode")) {
                userProfile.getHomeInfo().getTelecom().getPager().setLoccode(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/pager/number")) {
                userProfile.getHomeInfo().getTelecom().getPager().setNumber(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/pager/ext")) {
                userProfile.getHomeInfo().getTelecom().getPager().setExt(value);
                continue;
            }
            if (keys[i].equals("homeInfo/telecom/pager/comment")) {
                userProfile.getHomeInfo().getTelecom().getPager().setComment(value);
                continue;
            }
            if (keys[i].equals("homeInfo/online/email")) {
                userProfile.getHomeInfo().getOnline().setEmail(value);
                continue;
            }
            if (!keys[i].equals("homeInfo/online/uri")) continue;
            userProfile.getHomeInfo().getOnline().setUri(value);
        }
        return userProfile;
    }

    private UserProfile getEmptyUserProfile() {
        UserProfile userProfile = new UserProfile();
        userProfile.setEmployerInfo(new EmployerInfo());
        userProfile.setHomeInfo(this.getEmptyContact());
        userProfile.setBusinessInfo(this.getEmptyContact());
        userProfile.setName(new PersonName());
        return userProfile;
    }

    private Contact getEmptyContact() {
        Contact contact = new Contact();
        contact.setPostal(new Postal());
        contact.setTelecom(this.getEmptyTelecom());
        contact.setOnline(new Online());
        return contact;
    }

    private Telecom getEmptyTelecom() {
        Telecom telecom = new Telecom();
        telecom.setTelephone(new TelephoneNum());
        telecom.setFax(new TelephoneNum());
        telecom.setMobile(new TelephoneNum());
        telecom.setPager(new TelephoneNum());
        return telecom;
    }

    private UserContextCache getUserContextCache(ContainerRequest request) {
        return (UserContextCache)MarkupUtil.getProviderContext(request).getSessionProperty(USER_CONTEXT_CACHE_KEY + request.getEntityID());
    }

    private void putUserContextCache(ContainerRequest request, UserContextCache userContextCache) {
        MarkupUtil.getProviderContext(request).setSessionProperty(USER_CONTEXT_CACHE_KEY + request.getEntityID(), (Object)userContextCache);
    }

    private void invalidateUserContextCache(ContainerRequest request) {
        MarkupUtil.getProviderContext(request).setSessionProperty(USER_CONTEXT_CACHE_KEY + request.getEntityID(), null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class UserContextCache {
        private Map _userInfo;
        private List _roles;
        private UserContext _userContext;

        UserContextCache(UserContext userContext, Map userInfo, List roles) {
            this._userContext = userContext;
            this._userInfo = userInfo;
            this._roles = roles;
        }

        Map getUserInfo() {
            return this._userInfo;
        }

        List getRoles() {
            return this._roles;
        }

        UserContext getUserContext() {
            return this._userContext;
        }

        boolean match(Map newUserInfo, List newRoles) {
            return Compare.isMapSame(newUserInfo, this._userInfo) && Compare.isListSame(newRoles, this._roles);
        }
    }
}

