/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContentException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.stubs.AccessDeniedFault;
import com.sun.portal.wsrp.common.stubs.CookieProtocol;
import com.sun.portal.wsrp.common.stubs.Fault;
import com.sun.portal.wsrp.common.stubs.InitCookie;
import com.sun.portal.wsrp.common.stubs.InvalidRegistrationFault;
import com.sun.portal.wsrp.common.stubs.OperationFailedFault;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.SessionContext;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_Markup_PortType;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManager;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerErrorCode;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import com.sun.portal.wsrp.consumer.markup.MarkupContentException;
import com.sun.portal.wsrp.consumer.markup.ProducerSessionManager;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupUtil;
import com.sun.portal.wsrp.consumer.markup.impl.ProducerSessionInfo;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import com.sun.xml.rpc.client.http.CookieJar;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.rpc.Stub;

public class ProducerSessionManagerInitCookie
implements ProducerSessionManager {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$markup$impl$ProducerSessionManagerInitCookie == null ? (class$com$sun$portal$wsrp$consumer$markup$impl$ProducerSessionManagerInitCookie = ProducerSessionManagerInitCookie.class$("com.sun.portal.wsrp.consumer.markup.impl.ProducerSessionManagerInitCookie")) : class$com$sun$portal$wsrp$consumer$markup$impl$ProducerSessionManagerInitCookie));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$markup$impl$ProducerSessionManagerInitCookie;

    public void processSessionContext(MarkupConfig markupConfig, ContainerRequest request, SessionContext sessionContext) throws ContainerException, ContentException {
        CookieJar cookieJar;
        ProducerSessionInfo producerSessionInfo = this.getProducerSessionInfo(markupConfig, request);
        if (sessionContext != null) {
            producerSessionInfo.setSessionId(request.getEntityID(), sessionContext.getSessionID());
        }
        if ((cookieJar = (CookieJar)((Stub)producerSessionInfo.getMarkupPort())._getProperty("com.sun.xml.rpc.client.http.CookieJar")) != null) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0012", this.getCookieHandleKey(markupConfig, request));
            }
            request.getHttpServletRequest().getSession(true).setAttribute(this.getCookieHandleKey(markupConfig, request), (Object)cookieJar);
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCMI0012", this.getCookieHandleKey(markupConfig, request));
        }
    }

    public String getProducerSessionId(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        ProducerSessionInfo authProducerSessionInfo = this.getProducerSessionInfo(markupConfig, request);
        return authProducerSessionInfo.getSessionId(request.getEntityID());
    }

    public void resetSessionId(String invalidSessionId, MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        ProducerSessionInfo authProducerSessionInfo = this.getProducerSessionInfo(markupConfig, request);
        authProducerSessionInfo.releaseSessionId(request.getEntityID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSRP_v1_Markup_PortType getMarkupPortType(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        ProducerSessionInfo authProducerSessionInfo = this.getProducerSessionInfo(markupConfig, request);
        WSRP_v1_Markup_PortType port = authProducerSessionInfo.getMarkupPort();
        if (port == null) {
            ProducerSessionInfo producerSessionInfo = authProducerSessionInfo;
            synchronized (producerSessionInfo) {
                port = authProducerSessionInfo.getMarkupPort();
                if (port == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSWS_CSPWCMI0014", markupConfig.getProducerEntityId());
                    }
                    port = this.obtainMarkupPort(markupConfig);
                    authProducerSessionInfo.setMarkupPort(port);
                }
            }
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetMarkupPortType(WSRP_v1_Markup_PortType invalidPortType, MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        ProducerSessionInfo authProducerSessionInfo = this.getProducerSessionInfo(markupConfig, request);
        WSRP_v1_Markup_PortType port = authProducerSessionInfo.getMarkupPort();
        if (port == invalidPortType) {
            ProducerSessionInfo producerSessionInfo = authProducerSessionInfo;
            synchronized (producerSessionInfo) {
                port = authProducerSessionInfo.getMarkupPort();
                if (port == invalidPortType) {
                    authProducerSessionInfo.setMarkupPort(null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProducerSessionInfo getProducerSessionInfo(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        String key = this.getSessionInfoKey(markupConfig);
        ProducerSessionInfo session = (ProducerSessionInfo)MarkupUtil.getSessionProperty(markupConfig, request, key);
        if (session == null) {
            HttpServletRequest httpServletRequest = request.getHttpServletRequest();
            synchronized (httpServletRequest) {
                session = (ProducerSessionInfo)MarkupUtil.getSessionProperty(markupConfig, request, key);
                if (session == null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSWS_CSPWCMI0015", key);
                    }
                    session = new ProducerSessionInfo(markupConfig.getProducerEntityId(), markupConfig.getPortletDescription().getGroupID(), null);
                    MarkupUtil.setSessionProperty(markupConfig, request, key, session);
                }
            }
        }
        return session;
    }

    private WSRP_v1_Markup_PortType obtainMarkupPort(MarkupConfig markupConfig) throws ContainerException, ContentException {
        WSRP_v1_Markup_PortType markupPortType = null;
        URL producerURL = markupConfig.getProducerEntity().getURL();
        RemoteServiceStubManager rssm = markupConfig.getRemoteServiceStubManager();
        CookieProtocol cookieProtocol = markupConfig.getServiceDescription().getRequiresInitCookie();
        try {
            String endpoint = markupConfig.getProducerEntity().getMarkupEndpoint();
            if (cookieProtocol == null || cookieProtocol.equals((Object)CookieProtocol.none)) {
                markupPortType = rssm.getMarkupPortType(endpoint, false);
            } else {
                markupPortType = rssm.getMarkupPortType(endpoint, true);
                ((Stub)markupPortType)._setProperty("javax.xml.rpc.session.maintain", (Object)Boolean.TRUE);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "PSWS_CSPWCMI0016");
                }
                RegistrationContext registrationContext = markupConfig.getProducerEntity().getRegistrationContext();
                InitCookie initCookie = new InitCookie();
                initCookie.setRegistrationContext(registrationContext);
                markupPortType.initCookie(initCookie);
            }
        }
        catch (InvalidRegistrationFault fault) {
            try {
                markupConfig.getProducerEntityManager().setStatus(markupConfig.getProducerEntityId(), ProducerEntityStatus.BAD_REGISTRATION);
            }
            catch (WSRPConsumerException ex) {
                throw new ContainerException("Bad Registration:failed to disable producer:" + fault.toString(), (Throwable)((Object)ex));
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (AccessDeniedFault fault) {
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (OperationFailedFault fault) {
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (RemoteException ex) {
            throw new MarkupContentException(WSRPConsumerErrorCode.REMOTE_EXCEPTION, "RemoteException from producer:" + ex.toString(), ex);
        }
        catch (WSRPConsumerException ex) {
            throw new ContainerException("RemoteException from producer:" + ex.toString(), (Throwable)((Object)ex));
        }
        return markupPortType;
    }

    public String getCookieHandleKey(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException {
        return this.getSessionInfoKey(markupConfig) + "_cookieHandle";
    }

    private String getSessionInfoKey(MarkupConfig markupConfig) {
        CookieProtocol cookieProtocol = markupConfig.getServiceDescription().getRequiresInitCookie();
        if (CookieProtocol.perGroup.equals((Object)cookieProtocol)) {
            return markupConfig.getProducerEntityId() + "_" + markupConfig.getPortletDescription().getGroupID();
        }
        return markupConfig.getProducerEntityId();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

