/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContentException;
import com.sun.portal.wsrp.common.stubs.SessionContext;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_Markup_PortType;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerConfig;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import com.sun.portal.wsrp.consumer.markup.ProducerSessionManager;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupUtil;
import com.sun.portal.wsrp.consumer.markup.impl.ProducerSessionManagerInitCookie;
import com.sun.portal.wsrp.consumer.markup.impl.ProducerSessionManagerNoInitCookie;

public class ProducerSessionManagerImpl
implements ProducerSessionManager {
    private ProducerSessionManager _anonProducerSessionManager = null;
    private ProducerSessionManager _authProducerSessionManager = new ProducerSessionManagerInitCookie();

    public ProducerSessionManagerImpl() {
        this._anonProducerSessionManager = WSRPConsumerConfig.getInstance().doesAnonSupportInitCookie() ? this._authProducerSessionManager : new ProducerSessionManagerNoInitCookie();
    }

    public void processSessionContext(MarkupConfig markupConfig, ContainerRequest request, SessionContext sessionContext) throws ContainerException, ContentException {
        if (MarkupUtil.isAuthless(request)) {
            this._anonProducerSessionManager.processSessionContext(markupConfig, request, sessionContext);
        } else {
            this._authProducerSessionManager.processSessionContext(markupConfig, request, sessionContext);
        }
    }

    public String getProducerSessionId(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        if (MarkupUtil.isAuthless(request)) {
            return this._anonProducerSessionManager.getProducerSessionId(markupConfig, request);
        }
        return this._authProducerSessionManager.getProducerSessionId(markupConfig, request);
    }

    public void resetSessionId(String invalidSessionId, MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        if (MarkupUtil.isAuthless(request)) {
            this._anonProducerSessionManager.resetSessionId(invalidSessionId, markupConfig, request);
        } else {
            this._authProducerSessionManager.resetSessionId(invalidSessionId, markupConfig, request);
        }
    }

    public WSRP_v1_Markup_PortType getMarkupPortType(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        if (MarkupUtil.isAuthless(request)) {
            return this._anonProducerSessionManager.getMarkupPortType(markupConfig, request);
        }
        return this._authProducerSessionManager.getMarkupPortType(markupConfig, request);
    }

    public void resetMarkupPortType(WSRP_v1_Markup_PortType invalidPortType, MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        if (MarkupUtil.isAuthless(request)) {
            this._anonProducerSessionManager.resetMarkupPortType(invalidPortType, markupConfig, request);
        } else {
            this._authProducerSessionManager.resetMarkupPortType(invalidPortType, markupConfig, request);
        }
    }

    public String getCookieHandleKey(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException {
        if (MarkupUtil.isAuthless(request)) {
            return this._anonProducerSessionManager.getCookieHandleKey(markupConfig, request);
        }
        return this._authProducerSessionManager.getCookieHandleKey(markupConfig, request);
    }
}

