/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.wsrp.common.stubs.CookieProtocol;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MarkupUtil {
    private static Map _authTypeMap = MarkupUtil.initAuthTypeMap();

    static boolean isAuthless(ContainerRequest request) {
        boolean authlessUser = request.getUserID() == null;
        return authlessUser;
    }

    static ProviderContext getProviderContext(ContainerRequest request) {
        HttpServletRequest req = request.getHttpServletRequest();
        return (ProviderContext)req.getAttribute("provider_context");
    }

    static boolean requiresSession(MarkupConfig markupConfig, ContainerRequest request) {
        CookieProtocol cookieProtocol = markupConfig.getServiceDescription().getRequiresInitCookie();
        return cookieProtocol != null && !cookieProtocol.equals((Object)CookieProtocol.none);
    }

    static void setSessionProperty(MarkupConfig markupConfig, ContainerRequest request, String key, Object value) throws ContainerException {
        if (MarkupUtil.isAuthless(request)) {
            request.getHttpServletRequest().getSession(true).setAttribute(key, value);
        } else {
            MarkupUtil.getProviderContext(request).setSessionProperty(key, value);
        }
    }

    static Object getSessionProperty(MarkupConfig markupConfig, ContainerRequest request, String key) {
        if (MarkupUtil.isAuthless(request)) {
            return request.getHttpServletRequest().getSession(true).getAttribute(key);
        }
        return MarkupUtil.getProviderContext(request).getSessionProperty(key);
    }

    static String getAuthType(ContainerRequest request) {
        String providerContextAuthType = MarkupUtil.getProviderContext(request).getAuthenticationType();
        String authType = (String)_authTypeMap.get(providerContextAuthType);
        if (authType == null) {
            authType = providerContextAuthType;
        }
        return authType;
    }

    private static Map initAuthTypeMap() {
        HashMap<String, String> authMap = new HashMap<String, String>();
        authMap.put("desktop.authless", "wsrp:none");
        authMap.put("Anonymous", "wsrp:none");
        authMap.put("Cert", "wsrp:certificate");
        authMap.put("HTTPBasic", "wsrp:password");
        authMap.put("LDAP", "wsrp:password");
        authMap.put("Membership", "wsrp:password");
        authMap.put("NT", "wsrp:password");
        authMap.put("Radius", "wsrp:password");
        authMap.put("SafeWord", "wsrp:password");
        authMap.put("SecureID", "wsrp:password");
        authMap.put("Unix", "wsrp:password");
        return authMap;
    }
}

