/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import com.sun.portal.container.ChannelMode;
import com.sun.portal.container.Container;
import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContainerResponse;
import com.sun.portal.container.ContentException;
import com.sun.portal.container.ExecuteActionRequest;
import com.sun.portal.container.ExecuteActionResponse;
import com.sun.portal.container.GetMarkupRequest;
import com.sun.portal.container.GetMarkupResponse;
import com.sun.portal.container.GetResourceRequest;
import com.sun.portal.container.GetResourceResponse;
import com.sun.portal.container.WindowState;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.ContainerToString;
import com.sun.portal.wsrp.common.WSRPToContainerMap;
import com.sun.portal.wsrp.common.WSRPUtility;
import com.sun.portal.wsrp.common.stubs.BlockingInteractionResponse;
import com.sun.portal.wsrp.common.stubs.CacheControl;
import com.sun.portal.wsrp.common.stubs.ClientData;
import com.sun.portal.wsrp.common.stubs.Extension;
import com.sun.portal.wsrp.common.stubs.Fault;
import com.sun.portal.wsrp.common.stubs.GetMarkup;
import com.sun.portal.wsrp.common.stubs.InteractionParams;
import com.sun.portal.wsrp.common.stubs.InvalidCookieFault;
import com.sun.portal.wsrp.common.stubs.InvalidRegistrationFault;
import com.sun.portal.wsrp.common.stubs.InvalidSessionFault;
import com.sun.portal.wsrp.common.stubs.LocalizedString;
import com.sun.portal.wsrp.common.stubs.MarkupContext;
import com.sun.portal.wsrp.common.stubs.MarkupParams;
import com.sun.portal.wsrp.common.stubs.MarkupResponse;
import com.sun.portal.wsrp.common.stubs.NamedString;
import com.sun.portal.wsrp.common.stubs.PerformBlockingInteraction;
import com.sun.portal.wsrp.common.stubs.PortletContext;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.ResourceList;
import com.sun.portal.wsrp.common.stubs.RuntimeContext;
import com.sun.portal.wsrp.common.stubs.SessionContext;
import com.sun.portal.wsrp.common.stubs.StateChange;
import com.sun.portal.wsrp.common.stubs.Templates;
import com.sun.portal.wsrp.common.stubs.UpdateResponse;
import com.sun.portal.wsrp.common.stubs.UploadContext;
import com.sun.portal.wsrp.common.stubs.UserContext;
import com.sun.portal.wsrp.common.stubs.WSRP_v1_Markup_PortType;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerConfig;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerErrorCode;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerRewriter;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerRewriterException;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerUtil;
import com.sun.portal.wsrp.consumer.markup.CacheEntry;
import com.sun.portal.wsrp.consumer.markup.CacheManager;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import com.sun.portal.wsrp.consumer.markup.MarkupConfigManager;
import com.sun.portal.wsrp.consumer.markup.MarkupContent;
import com.sun.portal.wsrp.consumer.markup.MarkupContentException;
import com.sun.portal.wsrp.consumer.markup.ProducerSessionManager;
import com.sun.portal.wsrp.consumer.markup.UserContextManager;
import com.sun.portal.wsrp.consumer.markup.impl.CacheManagerImpl;
import com.sun.portal.wsrp.consumer.markup.impl.CommonRequestParams;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupConfigManagerImpl;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupUtil;
import com.sun.portal.wsrp.consumer.markup.impl.ProducerSessionManagerImpl;
import com.sun.portal.wsrp.consumer.markup.impl.UserContextManagerImpl;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import org.apache.commons.fileupload.DefaultFileItemFactory;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.FileUploadBase;
import org.apache.commons.fileupload.FileUploadException;

public class MarkupManagerImpl
implements Container {
    private static List reservedParams = MarkupManagerImpl.getReservedParams();
    private CacheManager _cacheManager;
    private ProducerSessionManager _producerSessionManager;
    private UserContextManager _userContextManager;
    private MarkupConfigManager _markupConfigManager = new MarkupConfigManagerImpl();
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$markup$impl$MarkupManagerImpl == null ? (class$com$sun$portal$wsrp$consumer$markup$impl$MarkupManagerImpl = MarkupManagerImpl.class$("com.sun.portal.wsrp.consumer.markup.impl.MarkupManagerImpl")) : class$com$sun$portal$wsrp$consumer$markup$impl$MarkupManagerImpl));
    private static final String SSOTOKEN_STRING = "sso_token";
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$markup$impl$MarkupManagerImpl;

    public MarkupManagerImpl() throws WSRPConsumerException {
        this._cacheManager = new CacheManagerImpl();
        this._producerSessionManager = new ProducerSessionManagerImpl();
        this._userContextManager = new UserContextManagerImpl();
    }

    public void getMarkup(GetMarkupRequest request, GetMarkupResponse response) throws ContainerException, ContentException {
        MarkupParams markupParams;
        CacheEntry cacheEntry;
        MarkupConfig markupConfig = this._markupConfigManager.getMarkupConfig((ContainerRequest)request);
        String navigationalState = null;
        String[] navigationalStateTemp = (String[])request.getRenderParameters().get("wsrp-navigationalState");
        if (navigationalStateTemp != null && navigationalStateTemp.length > 0 && navigationalStateTemp[0].length() > 0) {
            navigationalState = navigationalStateTemp[0];
        }
        if ((cacheEntry = this._cacheManager.getCacheEntry(markupConfig, (ContainerRequest)request, markupParams = this.getMarkupParams(markupConfig, (ContainerRequest)request, navigationalState))) != null && "wsrp:perUser".equals(cacheEntry.getUserScope()) && !this._userContextManager.isUserContextCacheValid(markupConfig, (ContainerRequest)request)) {
            this._cacheManager.invalidateCacheEntry(markupConfig, (ContainerRequest)request);
            cacheEntry = null;
        }
        if (!request.getIsTarget() && cacheEntry != null && cacheEntry.isValid()) {
            this.getCachedMarkup(markupConfig, request, response, cacheEntry);
        } else {
            if (cacheEntry != null) {
                String validateTag = cacheEntry.getValidateTag();
                markupParams.setValidateTag(validateTag);
            }
            this.getFreshMarkup(markupConfig, request, response, cacheEntry, markupParams, false, false);
        }
    }

    public void executeAction(ExecuteActionRequest request, ExecuteActionResponse response) throws ContainerException, ContentException {
        this.executeActionInternal(request, response, false, false);
    }

    private void executeActionInternal(ExecuteActionRequest request, ExecuteActionResponse response, boolean resetAfterSessionFault, boolean resetAfterCookieFault) throws ContainerException, ContentException {
        CommonRequestParams commonRequestParams = null;
        MarkupConfig markupConfig = null;
        WSRP_v1_Markup_PortType markupPortType = null;
        try {
            MarkupParams markupParams;
            CacheEntry origCacheEntry;
            boolean onlySecure;
            if (logger.isLoggable(Level.FINEST)) {
                Object[] param = new String[]{"ExecuteActionRequest", ContainerToString.toStringExecuteActionRequest((ExecuteActionRequest)request)};
                logger.log(Level.FINEST, "PSWS_CSPWCMI0007", param);
            }
            if ((onlySecure = Boolean.TRUE.equals((markupConfig = this._markupConfigManager.getMarkupConfig((ContainerRequest)request)).getPortletDescription().getOnlySecure())) && !request.getHttpServletRequest().isSecure()) {
                throw new MarkupContentException(WSRPConsumerErrorCode.RUNTIME_NOT_IN_SECURE_MODE, "Not in secure mode");
            }
            markupPortType = this._producerSessionManager.getMarkupPortType(markupConfig, (ContainerRequest)request);
            String navigationalState = null;
            String[] navigationalStateTemp = (String[])request.getActionParameters().get("wsrp-navigationalState");
            if (navigationalStateTemp != null && navigationalStateTemp.length > 0 && navigationalStateTemp[0].length() > 0) {
                navigationalState = navigationalStateTemp[0];
            }
            if ((origCacheEntry = this._cacheManager.getCacheEntry(markupConfig, (ContainerRequest)request, markupParams = this.getMarkupParams(markupConfig, (ContainerRequest)request, navigationalState))) != null) {
                boolean valid = true;
                if ("wsrp:perUser".equals(origCacheEntry.getUserScope()) && !this._userContextManager.isUserContextCacheValid(markupConfig, (ContainerRequest)request)) {
                    valid = false;
                }
                if (valid) {
                    String validateTag = origCacheEntry.getValidateTag();
                    markupParams.setValidateTag(validateTag);
                }
                this._cacheManager.invalidateCacheEntry(markupConfig, (ContainerRequest)request);
            }
            commonRequestParams = this.getCommonRequestParams(markupConfig, (ContainerRequest)request, (ContainerResponse)response);
            InteractionParams interactionParams = this.getInteractionParams(markupConfig, request);
            PerformBlockingInteraction blockingInteractionRequest = new PerformBlockingInteraction(commonRequestParams.getRegistrationContext(), commonRequestParams.getPortletContext(), commonRequestParams.getRuntimeContext(), commonRequestParams.getUserContext(), markupParams, interactionParams);
            BlockingInteractionResponse blockingInteractionResponse = markupPortType.performBlockingInteraction(blockingInteractionRequest);
            String redirectURL = blockingInteractionResponse.getRedirectURL();
            if (redirectURL == null || redirectURL.length() == 0) {
                UpdateResponse updateResponse = blockingInteractionResponse.getUpdateResponse();
                SessionContext sessionContext = updateResponse.getSessionContext();
                this._producerSessionManager.processSessionContext(markupConfig, (ContainerRequest)request, sessionContext);
                MarkupContext markupContext = updateResponse.getMarkupContext();
                String wsrpMode = updateResponse.getNewMode();
                String wsrpWindowState = updateResponse.getNewWindowState();
                ChannelMode mode = request.getChannelMode();
                WindowState windowState = request.getWindowState();
                if (wsrpMode != null) {
                    mode = WSRPToContainerMap.mapChannelModeToContainer((String)updateResponse.getNewMode());
                    response.setNewChannelMode(mode);
                }
                if (wsrpWindowState != null) {
                    windowState = WSRPToContainerMap.mapWindowStateToContainer((String)updateResponse.getNewWindowState());
                    response.setNewWindowState(windowState);
                }
                markupParams.setMode(WSRPToContainerMap.mapChannelModeToWSRP((ChannelMode)mode));
                markupParams.setWindowState(WSRPToContainerMap.mapWindowStateToWSRP((WindowState)windowState));
                markupParams.setNavigationalState(updateResponse.getNavigationalState());
                this.processMarkupContext(markupConfig, (ContainerRequest)request, markupContext, origCacheEntry, markupParams);
                this._markupConfigManager.processPortletContext((ContainerRequest)request, updateResponse.getPortletContext());
                HashMap<String, String[]> map = new HashMap<String, String[]>();
                String navigationState = updateResponse.getNavigationalState();
                if (navigationState != null) {
                    map.put("wsrp-navigationalState", new String[]{navigationState});
                }
                response.setRenderParameters(map);
            } else {
                response.setRedirectURL(new URL(redirectURL));
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0008");
            }
        }
        catch (InvalidSessionFault fault) {
            this._producerSessionManager.resetSessionId(commonRequestParams.getRuntimeContext().getSessionID(), markupConfig, (ContainerRequest)request);
            if (!resetAfterSessionFault) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "PSWS_CSPWCMI0009", fault.toString());
                }
                this.executeActionInternal(request, response, true, resetAfterCookieFault);
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCMI0010", fault);
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (InvalidCookieFault fault) {
            this._producerSessionManager.resetMarkupPortType(markupPortType, markupConfig, (ContainerRequest)request);
            if (!resetAfterCookieFault) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "PSWS_CSPWCMI0009", fault.toString());
                }
                this.executeActionInternal(request, response, resetAfterSessionFault, true);
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (InvalidRegistrationFault fault) {
            try {
                markupConfig.getProducerEntityManager().setStatus(markupConfig.getProducerEntityId(), ProducerEntityStatus.BAD_REGISTRATION);
            }
            catch (WSRPConsumerException ex) {
                throw new ContainerException("Bad Registration:failed to disable producer:" + fault.toString(), (Throwable)((Object)ex));
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (Fault fault) {
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode(fault), "Fault from producer:" + fault.toString(), fault);
        }
        catch (MalformedURLException ex) {
            throw new MarkupContentException(WSRPConsumerErrorCode.BAD_REDIRECT_URL, "Bad redirect URL:" + ex.toString(), ex);
        }
        catch (RemoteException ex) {
            throw new MarkupContentException(WSRPConsumerErrorCode.REMOTE_EXCEPTION, ex.toString(), ex);
        }
    }

    public void getResources(GetResourceRequest request, GetResourceResponse response) throws ContainerException {
        throw new ContainerException("getResources: Not Supported");
    }

    private void getFreshMarkup(MarkupConfig markupConfig, GetMarkupRequest request, GetMarkupResponse response, CacheEntry origCacheEntry, MarkupParams markupParams, boolean resetAfterSessionFault, boolean resetAfterCookieFault) throws ContainerException, ContentException {
        CommonRequestParams commonRequestParams = null;
        WSRP_v1_Markup_PortType markupPortType = null;
        try {
            if (logger.isLoggable(Level.FINEST)) {
                String[] param = new String[]{"MarkupRequest", ContainerToString.toStringGetMarkupRequest((GetMarkupRequest)request)};
                logger.log(Level.FINEST, "PSWS_CSPWCMI0007");
            }
            boolean onlySecure = Boolean.TRUE.equals(markupConfig.getPortletDescription().getOnlySecure());
            boolean defaultMarkupSecure = Boolean.TRUE.equals(markupConfig.getPortletDescription().getDefaultMarkupSecure());
            if ((onlySecure || defaultMarkupSecure) && !request.getHttpServletRequest().isSecure()) {
                throw new MarkupContentException(WSRPConsumerErrorCode.RUNTIME_NOT_IN_SECURE_MODE, "Not running in secure mode");
            }
            markupPortType = this._producerSessionManager.getMarkupPortType(markupConfig, (ContainerRequest)request);
            commonRequestParams = this.getCommonRequestParams(markupConfig, (ContainerRequest)request, (ContainerResponse)response);
            UserContext userCtx = commonRequestParams.getUserContext();
            if (markupConfig.getProducerEntity().getIdentityPropagationType().equals("com.sun.portal.wsrp.identity.ssotoken")) {
                this.addExtensions(userCtx, request);
            }
            MarkupResponse markupResponse = null;
            GetMarkup markupRequest = new GetMarkup(commonRequestParams.getRegistrationContext(), commonRequestParams.getPortletContext(), commonRequestParams.getRuntimeContext(), userCtx, markupParams);
            markupResponse = markupPortType.getMarkup(markupRequest);
            SessionContext sessionContext = markupResponse.getSessionContext();
            this._producerSessionManager.processSessionContext(markupConfig, (ContainerRequest)request, sessionContext);
            MarkupContext markupContext = markupResponse.getMarkupContext();
            MarkupContent content = this.processMarkupContext(markupConfig, (ContainerRequest)request, markupContext, origCacheEntry, markupParams);
            String markupString = content.getContent();
            if (content.needRewrite()) {
                WSRPConsumerRewriter rewriter = this.getWSRPConsumerRewriter(markupConfig, (ContainerRequest)request);
                markupString = rewriter.rewrite(markupString, request.getHttpServletRequest());
            }
            response.setMarkup(new StringBuffer(markupString));
            response.setTitle(content.getTitleResource());
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0008");
            }
            return;
        }
        catch (InvalidSessionFault ex) {
            this._producerSessionManager.resetSessionId(commonRequestParams.getRuntimeContext().getSessionID(), markupConfig, (ContainerRequest)request);
            if (!resetAfterSessionFault) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "PSWS_CSPWCMI0009", ex);
                }
                this.getFreshMarkup(markupConfig, request, response, origCacheEntry, markupParams, true, resetAfterCookieFault);
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)ex)), "Fault from producer:" + ex.toString(), ex);
        }
        catch (InvalidCookieFault ex) {
            this._producerSessionManager.resetMarkupPortType(markupPortType, markupConfig, (ContainerRequest)request);
            if (!resetAfterCookieFault) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "PSWS_CSPWCMI0009", ex);
                }
                this.getFreshMarkup(markupConfig, request, response, origCacheEntry, markupParams, resetAfterSessionFault, true);
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)ex)), "Fault from producer:" + ex.toString(), ex);
        }
        catch (InvalidRegistrationFault fault) {
            try {
                markupConfig.getProducerEntityManager().setStatus(markupConfig.getProducerEntityId(), ProducerEntityStatus.BAD_REGISTRATION);
            }
            catch (WSRPConsumerException ex) {
                throw new ContainerException("Bad Registration:failed to disable producer:", (Throwable)((Object)ex));
            }
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode((Fault)((Object)fault)), "Fault from producer:" + fault.toString(), fault);
        }
        catch (Fault fault) {
            throw new MarkupContentException(MarkupContentException.getFaultErrorCode(fault), "Fault from producer:" + fault.toString(), fault);
        }
        catch (WSRPConsumerRewriterException ex) {
            throw new MarkupContentException(WSRPConsumerErrorCode.INVALID_REMOTE_CONTENT, "Rewriter Exception", (Throwable)((Object)ex));
        }
        catch (RemoteException ex) {
            throw new MarkupContentException(WSRPConsumerErrorCode.REMOTE_EXCEPTION, ex.toString(), ex);
        }
    }

    private void getCachedMarkup(MarkupConfig markupConfig, GetMarkupRequest request, GetMarkupResponse response, CacheEntry cacheEntry) throws ContainerException, ContentException {
        if (logger.isLoggable(Level.FINEST)) {
            String[] param = new String[]{"MarkupRequest", ContainerToString.toStringGetMarkupRequest((GetMarkupRequest)request)};
            logger.log(Level.FINEST, "PSWS_CSPWCMI0007");
        }
        String markupString = cacheEntry.getMarkupContent().getContent();
        if (cacheEntry.getMarkupContent().needRewrite()) {
            WSRPConsumerRewriter rewriter = this.getWSRPConsumerRewriter(markupConfig, (ContainerRequest)request);
            try {
                markupString = rewriter.rewrite(markupString, request.getHttpServletRequest());
            }
            catch (WSRPConsumerRewriterException ex) {
                throw new MarkupContentException(WSRPConsumerErrorCode.INVALID_REMOTE_CONTENT, "Rewriter Exception", (Throwable)((Object)ex));
            }
        }
        response.setMarkup(new StringBuffer(markupString));
        String title = cacheEntry.getMarkupContent().getTitleResource();
        if (title == null) {
            title = this.getTitleFromPortletDescription(markupConfig, (ContainerRequest)request);
        }
        response.setTitle(title);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCMI0008");
        }
    }

    private CommonRequestParams getCommonRequestParams(MarkupConfig markupConfig, ContainerRequest request, ContainerResponse response) throws ContainerException, ContentException {
        RegistrationContext registrationContext = null;
        if (markupConfig.getServiceDescription().isRequiresRegistration() && (registrationContext = markupConfig.getProducerEntity().getRegistrationContext()) == null) {
            throw new ContainerException("Registration required.");
        }
        PortletContext portletContext = markupConfig.getPortletContext();
        RuntimeContext runtimeContext = this.getRuntimeContext(markupConfig, request);
        UserContext userContext = this._userContextManager.getUserContext(markupConfig, request);
        return new CommonRequestParams(registrationContext, portletContext, runtimeContext, userContext);
    }

    private RuntimeContext getRuntimeContext(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException, ContentException {
        String userAuthentication = MarkupUtil.getAuthType(request);
        String portletInstanceKey = markupConfig.getPortletInstanceKey();
        String namespacePrefix = markupConfig.getNamespacePrefix();
        Templates templates = null;
        if (Boolean.TRUE.equals(markupConfig.getPortletDescription().getDoesUrlTemplateProcessing())) {
            WSRPConsumerRewriter rewriter = this.getWSRPConsumerRewriter(markupConfig, request);
            templates = rewriter.getTemplates(request.getHttpServletRequest());
        }
        String sessionId = this._producerSessionManager.getProducerSessionId(markupConfig, request);
        return new RuntimeContext(userAuthentication, portletInstanceKey, namespacePrefix, templates, sessionId, (Extension[])null);
    }

    private MarkupParams getMarkupParams(MarkupConfig markupConfig, ContainerRequest request, String navigationalState) {
        boolean secureClientCommunication = request.getHttpServletRequest().isSecure();
        ClientData clientData = new ClientData(request.getHttpServletRequest().getHeader("User-Agent"), (Extension[])null);
        String[] locales = new String[]{MarkupUtil.getProviderContext(request).getLocaleString()};
        List mimetypes = request.getAllowableContentType();
        String[] mimes = new String[mimetypes.size()];
        mimetypes.toArray(mimes);
        String mode = WSRPToContainerMap.mapChannelModeToWSRP((ChannelMode)request.getChannelMode());
        String windowState = WSRPToContainerMap.mapWindowStateToWSRP((WindowState)request.getWindowState());
        String[] allowedWindowStates = WSRPToContainerMap.mapWindowStateToWSRP((List)request.getAllowableWindowState());
        String[] allowedPortletModes = WSRPToContainerMap.mapChannelModeToWSRP((List)request.getAllowableChannelMode());
        String[] markupCharacterSets = new String[]{request.getCharacterEncoding()};
        return new MarkupParams(secureClientCommunication, locales, mimes, mode, windowState, clientData, navigationalState, markupCharacterSets, null, allowedPortletModes, allowedWindowStates, (Extension[])null);
    }

    private MarkupContent processMarkupContext(MarkupConfig markupConfig, ContainerRequest request, MarkupContext markupContext, CacheEntry origCacheEntry, MarkupParams markupParams) throws ContainerException, ContentException {
        MarkupContent markupContent = null;
        CacheEntry newCacheEntry = null;
        if (markupContext == null) {
            this._cacheManager.invalidateCacheEntry(markupConfig, request);
            return null;
        }
        boolean needRewrite = Boolean.TRUE.equals(markupContext.getRequiresUrlRewriting());
        CacheControl cacheControl = markupContext.getCacheControl();
        if (Boolean.TRUE.equals(markupContext.getUseCachedMarkup())) {
            if (cacheControl != null) {
                newCacheEntry = new CacheEntry(origCacheEntry.getMarkupContent(), cacheControl, markupParams);
                this._cacheManager.putCacheEntry(markupConfig, request, newCacheEntry);
            }
            markupContent = origCacheEntry.getMarkupContent();
        } else {
            String markupString = this.getMarkupString(markupContext);
            String title = markupContext.getPreferredTitle();
            if (title == null) {
                title = this.getTitleFromPortletDescription(markupConfig, request);
            }
            if (cacheControl != null) {
                if (markupString != null && cacheControl.getUserScope() == "perUser" && needRewrite) {
                    WSRPConsumerRewriter rewriter = this.getWSRPConsumerRewriter(markupConfig, request);
                    try {
                        markupString = rewriter.rewrite(markupString, request.getHttpServletRequest());
                    }
                    catch (WSRPConsumerRewriterException ex) {
                        throw new MarkupContentException(WSRPConsumerErrorCode.INVALID_REMOTE_CONTENT, "Rewriter Exception", (Throwable)((Object)ex));
                    }
                    needRewrite = false;
                }
                markupContent = new MarkupContent(markupString, title, needRewrite);
                newCacheEntry = new CacheEntry(markupContent, cacheControl, markupParams);
                this._cacheManager.putCacheEntry(markupConfig, request, newCacheEntry);
            } else {
                this._cacheManager.invalidateCacheEntry(markupConfig, request);
                markupContent = new MarkupContent(markupString, title, needRewrite);
            }
        }
        return markupContent;
    }

    private InteractionParams getInteractionParams(MarkupConfig markupConfig, ExecuteActionRequest request) throws ContainerException, ContentException {
        String interactionState = null;
        String[] interactionStateTemp = (String[])request.getActionParameters().get("wsrp-interactionState");
        if (interactionStateTemp != null && interactionStateTemp.length > 0 && interactionStateTemp[0].length() > 0) {
            interactionState = interactionStateTemp[0];
        }
        NamedString[] formParameters = WSRPUtility.convertToNamedStrings((Map)request.getActionParameters(), (List)reservedParams);
        StateChange portletStateChange = null;
        portletStateChange = MarkupUtil.isAuthless((ContainerRequest)request) ? StateChange.readOnly : (markupConfig.isPortletHandleDefault() ? StateChange.cloneBeforeWrite : StateChange.readWrite);
        HttpServletRequest req = request.getHttpServletRequest();
        String contentType = req.getContentType();
        UploadContext[] uploadContexts = null;
        if (contentType != null && !contentType.equals("application/x-www-form-urlencoded") && req.getContentLength() > 0) {
            ArrayList<NamedString> formParamList = new ArrayList<NamedString>();
            ArrayList<UploadContext> uploadContextList = new ArrayList<UploadContext>();
            int maxSize = WSRPConsumerConfig.getInstance().getFileUploadMaxSize();
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0011", "" + req.getContentLength());
            }
            try {
                List fileItemList;
                FileUpload fileUpload = new FileUpload((FileItemFactory)new DefaultFileItemFactory());
                if (maxSize != -1) {
                    fileUpload.setSizeMax((long)maxSize);
                }
                if ((fileItemList = fileUpload.parseRequest(request.getHttpServletRequest())) != null) {
                    for (int i = 0; i < fileItemList.size(); ++i) {
                        FileItem item = (FileItem)fileItemList.get(i);
                        if (item.isFormField()) {
                            NamedString formParam = new NamedString();
                            formParam.setName(item.getFieldName());
                            formParam.setValue(item.getString());
                            formParamList.add(formParam);
                            continue;
                        }
                        UploadContext uploadContext = this.getUploadContext(item);
                        uploadContextList.add(uploadContext);
                    }
                }
                formParameters = new NamedString[formParamList.size()];
                formParamList.toArray(formParameters);
                uploadContexts = new UploadContext[uploadContextList.size()];
                uploadContextList.toArray(uploadContexts);
            }
            catch (FileUploadBase.SizeLimitExceededException ex) {
                throw new MarkupContentException(WSRPConsumerErrorCode.READING_UPLOAD_SIZE_LIMIT, "request more than configured upload limit:" + maxSize, ex);
            }
            catch (FileUploadException ex) {
                throw new MarkupContentException(WSRPConsumerErrorCode.ERROR_IN_READING_UPLOAD, "Error in file upload", ex);
            }
        }
        return new InteractionParams(portletStateChange, interactionState, formParameters, uploadContexts, (Extension[])null);
    }

    private UploadContext getUploadContext(FileItem item) throws ContainerException {
        UploadContext uploadContext = new UploadContext();
        uploadContext.setMimeType(item.getContentType());
        NamedString[] mimeAttributes = new NamedString[2];
        mimeAttributes[0] = new NamedString();
        mimeAttributes[0].setName("Content-disposition");
        mimeAttributes[0].setValue("form-data; name=\"" + item.getFieldName() + "\";" + " filename=\"" + item.getName() + "\"");
        mimeAttributes[1] = new NamedString();
        mimeAttributes[1].setName("Content-type");
        mimeAttributes[1].setValue(item.getContentType());
        uploadContext.setMimeAttributes(mimeAttributes);
        uploadContext.setUploadData(item.get());
        return uploadContext;
    }

    private static List getReservedParams() {
        ArrayList<String> excludeParams = new ArrayList<String>();
        excludeParams.add("wsrp-navigationalState");
        excludeParams.add("wsrp-interactionState");
        return excludeParams;
    }

    private String getPortalServerURLPrefix(ContainerRequest request) {
        HttpServletRequest httpRequest = request.getHttpServletRequest();
        return MarkupUtil.getProviderContext(request).getRequestServer(httpRequest) + httpRequest.getContextPath();
    }

    private WSRPConsumerRewriter getWSRPConsumerRewriter(MarkupConfig markupConfig, ContainerRequest request) throws ContainerException {
        WSRPConsumerRewriter rewriter = new WSRPConsumerRewriter(request.getChannelURLFactory(), this.getPortalServerURLPrefix(request), this._producerSessionManager.getCookieHandleKey(markupConfig, request), markupConfig.getNamespacePrefix());
        return rewriter;
    }

    private String getTitleFromPortletDescription(MarkupConfig markupConfig, ContainerRequest request) {
        String resourceName;
        ResourceList resourceList;
        String titleResource;
        String locale = MarkupUtil.getProviderContext(request).getLocaleString();
        String xmlLocale = WSRPConsumerUtil.getXMLLocale(locale);
        PortletDescription portletDescription = markupConfig.getPortletDescription();
        LocalizedString localizedTitle = portletDescription.getTitle();
        String title = localizedTitle.getValue();
        if (!localizedTitle.getLang().equals(xmlLocale) && (titleResource = WSRPConsumerUtil.getResource(resourceList = markupConfig.getServiceDescription().getResourceList(), resourceName = localizedTitle.getResourceName(), xmlLocale)) != null) {
            title = titleResource;
        }
        return title;
    }

    String getMarkupString(MarkupContext markupContext) throws ContentException {
        String markupString = markupContext.getMarkupString();
        if (markupString != null) {
            return markupString;
        }
        byte[] markupBinary = markupContext.getMarkupBinary();
        String mimeType = markupContext.getMimeType();
        int charsetIndex = mimeType.indexOf("charset=");
        if (markupBinary != null && charsetIndex != -1) {
            int valueIndex = mimeType.indexOf("=") + 1;
            String charset = mimeType.substring(valueIndex);
            try {
                return new String(markupBinary, charset);
            }
            catch (UnsupportedEncodingException ex) {
                throw new MarkupContentException(WSRPConsumerErrorCode.BINARY_CONTENT_NOT_SUPPORTED, "Binary content not supported", ex);
            }
        }
        return null;
    }

    private void addExtensions(UserContext ctx, GetMarkupRequest request) {
        block4: {
            try {
                String userId = request.getUserID();
                HttpServletRequest req = request.getHttpServletRequest();
                SSOToken ssoToken = (SSOToken)req.getAttribute(SSOTOKEN_STRING);
                SSOTokenManager tokenManager = SSOTokenManager.getInstance();
                tokenManager.validateToken(ssoToken);
                SSOTokenID id = ssoToken.getTokenID();
                SOAPFactory sf = SOAPFactory.newInstance();
                SOAPElement se = sf.createElement("com.sun.portal.SSOTokenElement");
                se.setAttribute("com.sun.portal.SSOToken", id.toString());
                Extension ssoTokenExtn = new Extension();
                ssoTokenExtn.set_any(se);
                Extension[] ext = new Extension[]{ssoTokenExtn};
                ctx.setExtensions(ext);
            }
            catch (SSOException se) {
                if (logger.isLoggable(Level.SEVERE)) {
                    logger.log(Level.SEVERE, "PSWS_CSPWCMI0020", se);
                }
            }
            catch (SOAPException soe) {
                if (!logger.isLoggable(Level.SEVERE)) break block4;
                logger.log(Level.SEVERE, "PSWS_CSPWCMI0020", soe);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

