/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.sun.portal.container.ContainerException;
import com.sun.portal.container.ContainerRequest;
import com.sun.portal.container.ContentException;
import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.desktop.encode.EncoderException;
import com.sun.portal.desktop.encode.TypeEncoder;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.providers.context.ProviderContextException;
import com.sun.portal.wsrp.common.stubs.PortletContext;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManager;
import com.sun.portal.wsrp.consumer.common.RemoteServiceStubManagerFactory;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerErrorCode;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import com.sun.portal.wsrp.consumer.markup.MarkupConfigManager;
import com.sun.portal.wsrp.consumer.markup.MarkupContentException;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupUtil;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import java.io.UnsupportedEncodingException;

public class MarkupConfigManagerImpl
implements MarkupConfigManager {
    private TypeEncoder _namespaceEncoder;

    public MarkupConfigManagerImpl() throws WSRPConsumerException {
        try {
            this._namespaceEncoder = Encoder.get((String)"com.sun.portal.desktop.encode.FormNameEncoder");
        }
        catch (EncoderException ex) {
            throw new WSRPConsumerException("Failed encoder initialization:", ex);
        }
    }

    public MarkupConfig getMarkupConfig(ContainerRequest request) throws ContainerException, ContentException {
        return new MarkupConfig(request.getEntityID(), this.getProducerEntityId(request), this.getPortletId(request), this.getConsumerId(request), this.getProducerEntity(request), this.getProducerEntityManager(request), this.getRemoteServiceStubManager(request), this.getServiceDescription(request), this.getPortletDescription(request), this.getPortletContext(request), this.getPortletInstanceKey(request), this.getNamespacePrefix(request));
    }

    protected String getChannelName(ContainerRequest request) throws ContainerException {
        return request.getEntityID();
    }

    protected String getProducerEntityId(ContainerRequest request) throws ContainerException {
        return this.getConfiguredProperty(request, "producerEntityID");
    }

    protected String getPortletId(ContainerRequest request) throws ContainerException {
        return this.getConfiguredProperty(request, "portletID");
    }

    protected String getConsumerId(ContainerRequest request) throws ContainerException {
        return this.getConfiguredProperty(request, "consumerID");
    }

    protected PortletContext getPortletContext(ContainerRequest request) throws ContainerException {
        PortletContext portletContext = new PortletContext();
        String portletHandle = this.getConfiguredProperty(request, "portletHandle");
        portletContext.setPortletHandle(portletHandle);
        String portletState = this.getConfiguredProperty(request, "portletState");
        if (portletState != null && portletState.length() > 0) {
            try {
                portletContext.setPortletState(portletState.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException ex) {
                throw new ContainerException("Failed to decode portletState ", (Throwable)ex);
            }
        }
        return portletContext;
    }

    public void processPortletContext(ContainerRequest request, PortletContext portletContext) throws ContainerException, ContentException {
        if (portletContext == null) {
            return;
        }
        byte[] portletState = portletContext.getPortletState();
        String newPortletHandle = portletContext.getPortletHandle();
        String oldPortletHandle = this.getConfiguredProperty(request, "portletHandle");
        if (MarkupUtil.isAuthless(request) && (portletState != null || !newPortletHandle.equals(oldPortletHandle))) {
            throw new MarkupContentException(WSRPConsumerErrorCode.ANONYMOUS_NOTALLOWED_STATECHANGE, "Anonymous user not allowed state change.");
        }
        if (!newPortletHandle.equals(oldPortletHandle)) {
            this.setConfiguredProperty(request, "portletHandle", newPortletHandle);
        }
        if (portletState != null) {
            try {
                String portletStateStr = new String(portletState, "UTF-8");
                this.setConfiguredProperty(request, "portletState", portletStateStr);
            }
            catch (UnsupportedEncodingException ex) {
                throw new ContainerException("Failed to encode portletState ", (Throwable)ex);
            }
        }
    }

    protected String getPortletInstanceKey(ContainerRequest request) throws ContainerException {
        return "P_" + this._namespaceEncoder.encode(request.getEntityID());
    }

    protected String getNamespacePrefix(ContainerRequest request) throws ContainerException {
        return "N_" + this._namespaceEncoder.encode(request.getEntityID());
    }

    protected PortletDescription getPortletDescription(ContainerRequest request) throws ContainerException, ContentException {
        return this.getProducerEntity(request).getPortletDescription(this.getPortletId(request));
    }

    protected ServiceDescription getServiceDescription(ContainerRequest request) throws ContainerException, ContentException {
        return this.getProducerEntity(request).getServiceDescription();
    }

    protected ProducerEntity getProducerEntity(ContainerRequest request) throws ContainerException, ContentException {
        ProducerEntity producerEntity;
        try {
            producerEntity = this.getProducerEntityManager(request).getProducerEntity(this.getProducerEntityId(request));
            if (!producerEntity.getStatus().equals(ProducerEntityStatus.OK)) {
                throw new MarkupContentException(WSRPConsumerErrorCode.PRODUCER_STATUS_NOT_OK, "Producer status not ok :" + producerEntity.getStatus());
            }
        }
        catch (WSRPConsumerException ex) {
            throw new ContainerException("Problem reading producerEntityId", (Throwable)((Object)ex));
        }
        return producerEntity;
    }

    protected String getConfiguredProperty(ContainerRequest request, String key) throws ContainerException {
        try {
            ProviderContext context = MarkupUtil.getProviderContext(request);
            return context.getStringProperty(this.getChannelName(request), key);
        }
        catch (ProviderContextException e) {
            throw new ContainerException("From ProviderContext, failed to get value of " + key, (Throwable)e);
        }
    }

    protected void setConfiguredProperty(ContainerRequest request, String key, String value) throws ContainerException {
        try {
            MarkupUtil.getProviderContext(request).setStringProperty(this.getChannelName(request), key, value);
        }
        catch (ProviderContextException e) {
            throw new ContainerException("From ProviderContext, failed to set value of " + key, (Throwable)e);
        }
    }

    protected ProducerEntityManager getProducerEntityManager(ContainerRequest request) throws ContainerException {
        try {
            ProducerEntityManagerFactory pemf = ProducerEntityManagerFactory.getInstance();
            return pemf.getProducerEntityManager(this.getConsumerId(request), request.getHttpServletRequest());
        }
        catch (WSRPConsumerException ex) {
            throw new ContainerException("Error in getting PEM:", (Throwable)((Object)ex));
        }
    }

    protected RemoteServiceStubManager getRemoteServiceStubManager(ContainerRequest request) throws ContainerException {
        return RemoteServiceStubManagerFactory.getRemoteServiceStubManager();
    }
}

