/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup.impl;

import com.sun.portal.container.ContainerRequest;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.providers.context.ProviderContext;
import com.sun.portal.wsrp.common.stubs.MarkupParams;
import com.sun.portal.wsrp.consumer.markup.CacheEntry;
import com.sun.portal.wsrp.consumer.markup.CacheManager;
import com.sun.portal.wsrp.consumer.markup.MarkupConfig;
import com.sun.portal.wsrp.consumer.markup.impl.MarkupUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CacheManagerImpl
implements CacheManager {
    public static final String CACHED_PORTLETS = "wsrp.cacheEntryMap";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$markup$impl$CacheManagerImpl == null ? (class$com$sun$portal$wsrp$consumer$markup$impl$CacheManagerImpl = CacheManagerImpl.class$("com.sun.portal.wsrp.consumer.markup.impl.CacheManagerImpl")) : class$com$sun$portal$wsrp$consumer$markup$impl$CacheManagerImpl));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$markup$impl$CacheManagerImpl;

    public CacheEntry getCacheEntry(MarkupConfig markupConfig, ContainerRequest request, MarkupParams markupParams) {
        CacheEntry cacheEntry = null;
        if (!MarkupUtil.isAuthless(request)) {
            String entityId = request.getEntityID();
            Map cachedPortlets = this.getCachedPortletsMap(request);
            cacheEntry = (CacheEntry)cachedPortlets.get(entityId);
            if (cacheEntry != null) {
                if (!this.sameMarkupParams(markupParams, cacheEntry.getMarkupParams())) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSWS_CSPWCMI0001", request.getEntityID());
                    }
                    cachedPortlets.remove(entityId);
                    cacheEntry = null;
                } else if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "PSWS_CSPWCMI0002", request.getEntityID());
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0003", request.getEntityID());
            }
        }
        return cacheEntry;
    }

    public void putCacheEntry(MarkupConfig markupConfig, ContainerRequest request, CacheEntry cacheEntry) {
        if (!MarkupUtil.isAuthless(request)) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0004", request.getEntityID());
            }
            Map cachedPortlets = this.getCachedPortletsMap(request);
            cachedPortlets.put(request.getEntityID(), cacheEntry);
        }
    }

    public void invalidateCacheEntry(MarkupConfig markupConfig, ContainerRequest request) {
        Map cachedPortlets;
        if (!MarkupUtil.isAuthless(request) && (cachedPortlets = this.getCachedPortletsMap(request)).containsKey(request.getEntityID())) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCMI0005", request.getEntityID());
            }
            cachedPortlets.remove(request.getEntityID());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getCachedPortletsMap(ContainerRequest request) {
        ProviderContext pc = MarkupUtil.getProviderContext(request);
        Map cachedPortlets = (Map)pc.getSessionProperty(CACHED_PORTLETS);
        if (cachedPortlets == null) {
            ProviderContext providerContext = pc;
            synchronized (providerContext) {
                cachedPortlets = (Map)pc.getSessionProperty(CACHED_PORTLETS);
                if (cachedPortlets == null) {
                    cachedPortlets = Collections.synchronizedMap(new HashMap());
                    pc.setSessionProperty(CACHED_PORTLETS, cachedPortlets);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSWS_CSPWCMI0006");
                    }
                }
            }
        }
        return cachedPortlets;
    }

    private boolean sameMarkupParams(MarkupParams first, MarkupParams second) {
        boolean same = false;
        if (!CacheManagerImpl.strSame(first.getWindowState(), second.getWindowState())) {
            return false;
        }
        if (!CacheManagerImpl.strSame(first.getMode(), second.getMode())) {
            return false;
        }
        if (!CacheManagerImpl.strSame(first.getNavigationalState(), second.getNavigationalState())) {
            return false;
        }
        if (first.isSecureClientCommunication() != second.isSecureClientCommunication()) {
            return false;
        }
        if (!CacheManagerImpl.listSame(first.getValidNewWindowStates(), second.getValidNewWindowStates())) {
            return false;
        }
        if (!CacheManagerImpl.listSame(first.getMimeTypes(), second.getMimeTypes())) {
            return false;
        }
        if (!CacheManagerImpl.listSame(first.getValidNewModes(), second.getValidNewModes())) {
            return false;
        }
        if (!CacheManagerImpl.listSame(first.getLocales(), second.getLocales())) {
            return false;
        }
        if (!CacheManagerImpl.listSame(first.getMimeTypes(), second.getMimeTypes())) {
            return false;
        }
        if (!CacheManagerImpl.listSame(first.getMarkupCharacterSets(), second.getMarkupCharacterSets())) {
            return false;
        }
        return CacheManagerImpl.strSame(first.getClientData().getUserAgent(), second.getClientData().getUserAgent());
    }

    private static boolean strSame(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        return a != null && a.equals(b);
    }

    private static boolean listSame(String[] a, String[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            if (a.length == b.length) {
                for (int i = 0; i < a.length; ++i) {
                    if (CacheManagerImpl.strSame(a[i], b[i])) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

