/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup;

import com.sun.portal.container.Container;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerConfig;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;

public class MarkupManagerFactory {
    private static Container _markupManager;

    public static Container getInstance() {
        return _markupManager;
    }

    public static void init() throws WSRPConsumerException {
        if (_markupManager != null) {
            throw new WSRPConsumerException("MarkupManagerFactory:Init can be called only once.");
        }
        WSRPConsumerConfig config = WSRPConsumerConfig.getInstance();
        String mmClassname = config.getMarkupManagerClassname();
        _markupManager = MarkupManagerFactory.loadMarkupManagerClass(mmClassname);
    }

    protected static Container loadMarkupManagerClass(String classname) throws WSRPConsumerException {
        Container markupManager = null;
        try {
            markupManager = (Container)Class.forName(classname).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new WSRPConsumerException("MarkupManagerFactory.loadMarkupManagerClass(): failed to load MarkupManager class.", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new WSRPConsumerException("MarkupManagerFactory.loadMarkupManagerClass(): failed to load MarkupManager class.", ncdfe);
        }
        catch (IllegalAccessException iae) {
            throw new WSRPConsumerException("MarkupManagerFactory.loadMarkupManagerClass(): failed to load MarkupManager class.", iae);
        }
        catch (ClassCastException cce) {
            throw new WSRPConsumerException("MarkupManagerFactory.loadMarkupManagerClass(): failed to load MarkupManager class.", cce);
        }
        catch (InstantiationException ie) {
            throw new WSRPConsumerException("MarkupManagerFactory.loadMarkupManagerClass(): failed to load MarkupManager class.", ie);
        }
        catch (SecurityException se) {
            throw new WSRPConsumerException("MarkupManagerFactory.loadMarkupManagerClass(): failed to load MarkupManager class.", se);
        }
        return markupManager;
    }
}

