/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup;

import com.sun.portal.container.ContentException;
import com.sun.portal.container.ErrorCode;
import com.sun.portal.wsrp.common.stubs.AccessDeniedFault;
import com.sun.portal.wsrp.common.stubs.Fault;
import com.sun.portal.wsrp.common.stubs.InvalidCookieFault;
import com.sun.portal.wsrp.common.stubs.InvalidSessionFault;
import com.sun.portal.wsrp.common.stubs.MissingParametersFault;
import com.sun.portal.wsrp.common.stubs.OperationFailedFault;
import com.sun.portal.wsrp.common.stubs.PortletStateChangeRequiredFault;
import com.sun.portal.wsrp.common.stubs.UnsupportedLocaleFault;
import com.sun.portal.wsrp.common.stubs.UnsupportedMimeTypeFault;
import com.sun.portal.wsrp.common.stubs.UnsupportedModeFault;
import com.sun.portal.wsrp.common.stubs.UnsupportedWindowStateFault;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerErrorCode;

public class MarkupContentException
extends ContentException {
    public MarkupContentException(WSRPConsumerErrorCode code, String msg) {
        super(msg, (ErrorCode)code);
    }

    public MarkupContentException(WSRPConsumerErrorCode code, String msg, Throwable e) {
        super(msg, (ErrorCode)code, e);
    }

    public static WSRPConsumerErrorCode getFaultErrorCode(Fault ex) {
        if (ex == null) {
            throw new IllegalArgumentException("Null param");
        }
        if (ex instanceof AccessDeniedFault) {
            return WSRPConsumerErrorCode.ACCESS_DENIED_FAULT;
        }
        if (ex instanceof InvalidSessionFault) {
            return WSRPConsumerErrorCode.INVALID_SESSION_FAULT;
        }
        if (ex instanceof InvalidCookieFault) {
            return WSRPConsumerErrorCode.INVALID_COOKIE_FAULT;
        }
        if (ex instanceof MissingParametersFault) {
            return WSRPConsumerErrorCode.MISSING_PARAMETERS_FAULT;
        }
        if (ex instanceof OperationFailedFault) {
            return WSRPConsumerErrorCode.OPERATION_FAILED_FAULT;
        }
        if (ex instanceof PortletStateChangeRequiredFault) {
            return WSRPConsumerErrorCode.PORTLET_STATE_CHANGE_REQUIRED_FAULT;
        }
        if (ex instanceof UnsupportedLocaleFault) {
            return WSRPConsumerErrorCode.UNSUPPORTED_LOCALE_FAULT;
        }
        if (ex instanceof UnsupportedMimeTypeFault) {
            return WSRPConsumerErrorCode.UNSUPPORTED_MIME_TYPE_FAULT;
        }
        if (ex instanceof UnsupportedModeFault) {
            return WSRPConsumerErrorCode.UNSUPPORTED_MODE_FAULT;
        }
        if (ex instanceof UnsupportedWindowStateFault) {
            return WSRPConsumerErrorCode.UNSUPPORTED_WINDOW_STATE_FAULT;
        }
        return WSRPConsumerErrorCode.GENERIC_CONTENT_EXCEPTION;
    }
}

