/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.markup;

import com.sun.portal.wsrp.common.stubs.CacheControl;
import com.sun.portal.wsrp.common.stubs.MarkupParams;
import com.sun.portal.wsrp.consumer.markup.MarkupContent;

public class CacheEntry {
    private MarkupContent _markupContent = null;
    private CacheControl _cacheControl = null;
    private MarkupParams _markupParams;
    long _expireTime = -1L;

    public CacheEntry(MarkupContent content, CacheControl control, MarkupParams markupParams) {
        this._markupContent = content;
        this._cacheControl = control;
        this._markupParams = markupParams;
        if (this._cacheControl != null) {
            this._expireTime = this._cacheControl.getExpires();
            if (this._expireTime != -1L) {
                this._expireTime = this._expireTime * 1000L + System.currentTimeMillis();
            }
        }
    }

    public MarkupContent getMarkupContent() {
        return this._markupContent;
    }

    public CacheControl getCacheControl() {
        return this._cacheControl;
    }

    public String getValidateTag() {
        if (this._cacheControl != null) {
            return this._cacheControl.getValidateTag();
        }
        return null;
    }

    public boolean isValid() {
        long now = System.currentTimeMillis();
        return this._expireTime == -1L || this._expireTime > now;
    }

    public MarkupParams getMarkupParams() {
        return this._markupParams;
    }

    public String getUserScope() {
        if (this._cacheControl != null) {
            return this._cacheControl.getUserScope();
        }
        return null;
    }
}

