/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.common;

import com.sun.portal.container.ChannelURL;
import com.sun.portal.container.ChannelURLFactory;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.Boyer;
import com.sun.portal.wsrp.common.WSRPSpecKeys;
import com.sun.portal.wsrp.common.WSRPToContainerMap;
import com.sun.portal.wsrp.common.stubs.Templates;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerRewriterException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class WSRPConsumerRewriter {
    public static String PROXY_SERVLET_MAPPING = "/wsrpconsumer/resourceproxy";
    public static final String PROXY_RESOURCE_URL = "wsrp_url";
    public static final String PROXY_RESOURCE_REWRITE = "wsrp_rewrite";
    public static final String PROXY_COOKIE_KEY = "cookie_key";
    public static final String PROXY_PORTAL_SERVER_URL = "portal_server_url";
    public static final String PROXY_NAMESPACE = "namespace";
    private ChannelURLFactory _channelURLFactory;
    private String _portalServerURLPrefix;
    private String _cookieKey;
    private String _namespace;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$common$WSRPConsumerRewriter == null ? (class$com$sun$portal$wsrp$consumer$common$WSRPConsumerRewriter = WSRPConsumerRewriter.class$("com.sun.portal.wsrp.consumer.common.WSRPConsumerRewriter")) : class$com$sun$portal$wsrp$consumer$common$WSRPConsumerRewriter));
    private static final String AMP = "&";
    private static final String AMP1 = "&#38;";
    private static final String AMP2 = "&amp;";
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$common$WSRPConsumerRewriter;

    public WSRPConsumerRewriter(ChannelURLFactory channelURLFactory, String portalServerURLPrefix, String cookieKey, String namespace) {
        this._channelURLFactory = channelURLFactory;
        this._portalServerURLPrefix = portalServerURLPrefix;
        this._cookieKey = cookieKey;
        this._namespace = namespace;
    }

    public WSRPConsumerRewriter(String portalServerURLPrefix, String cookieKey, String namespace) {
        this._portalServerURLPrefix = portalServerURLPrefix;
        this._cookieKey = cookieKey;
        this._namespace = namespace;
    }

    public String rewrite(String content, HttpServletRequest request) throws WSRPConsumerRewriterException {
        int currentStart = 0;
        int endTokenPosition = 0;
        int beginTokenPosition = 0;
        StringBuffer buffer = new StringBuffer(content.length() + 100);
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCC0002");
        }
        while (currentStart < content.length() && (beginTokenPosition = this.searchToken(content, PROXY_RESOURCE_REWRITE, currentStart)) != -1 && beginTokenPosition + PROXY_RESOURCE_REWRITE.length() != content.length()) {
            String token = content.substring(beginTokenPosition, beginTokenPosition + PROXY_RESOURCE_REWRITE.length() + 1);
            if (token.equals("wsrp_rewrite_")) {
                buffer.append(content.substring(currentStart, beginTokenPosition));
                buffer.append(this._namespace);
                currentStart = beginTokenPosition + "wsrp_rewrite_".length();
                continue;
            }
            if (token.equals("wsrp_rewrite?")) {
                endTokenPosition = this.searchToken(content, "/wsrp_rewrite", currentStart);
                if (endTokenPosition != -1) {
                    buffer.append(content.substring(currentStart, beginTokenPosition));
                    String wsrpBasedURL = content.substring(beginTokenPosition + "wsrp_rewrite?".length(), endTokenPosition);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSWS_CSPWCC0003", wsrpBasedURL);
                    }
                    String providerBasedURL = this.getProviderBasedURL(wsrpBasedURL, request);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "PSWS_CSPWCC0004", providerBasedURL);
                    }
                    if (providerBasedURL != null) {
                        buffer.append(providerBasedURL);
                    }
                    currentStart = endTokenPosition + "/wsrp_rewrite".length();
                    continue;
                }
                throw new WSRPConsumerRewriterException("Invalid WSRP tokens in the content.  Couldn't find ending token /wsrp_rewrite.");
            }
            buffer.append(content.substring(currentStart, beginTokenPosition));
            buffer.append(PROXY_RESOURCE_REWRITE);
            currentStart = beginTokenPosition + PROXY_RESOURCE_REWRITE.length();
        }
        buffer.append(content.substring(currentStart));
        return buffer.toString();
    }

    private String getProviderBasedURL(String wsrpBasedURL, HttpServletRequest request) throws WSRPConsumerRewriterException {
        String finalURL = null;
        Map allMap = this.getParamMapFromURIStyleString(wsrpBasedURL);
        String wsrp_urlType = (String)allMap.get("wsrp-urlType");
        String wsrp_secureURL = (String)allMap.get("wsrp-secureURL");
        if (wsrp_secureURL != null && wsrp_secureURL.equals(Boolean.TRUE.toString()) && !request.isSecure()) {
            return this._channelURLFactory.getSecurityErrorURL();
        }
        if ("render".equals(wsrp_urlType) || "blockingAction".equals(wsrp_urlType)) {
            if (this._channelURLFactory == null) {
                throw new WSRPConsumerRewriterException(" Content to be written by proxy has  render/blockingaction urls.");
            }
            String portletMode = (String)allMap.get("wsrp-mode");
            String windowState = (String)allMap.get("wsrp-windowState");
            String fragmentID = (String)allMap.get("wsrp-fragmentID");
            ChannelURL channelURL = this._channelURLFactory.createChannelURL();
            channelURL.setChannelMode(WSRPToContainerMap.mapChannelModeToContainer((String)portletMode));
            channelURL.setWindowState(WSRPToContainerMap.mapWindowStateToContainer((String)windowState));
            channelURL.setURLType(WSRPToContainerMap.mapURLTypeToContainer((String)wsrp_urlType));
            channelURL.setParameters((Map)allMap.get("parameters"));
            finalURL = channelURL.toString();
            if (fragmentID != null && fragmentID.length() > 0) {
                finalURL = finalURL + "#" + fragmentID;
            }
        } else if ("resource".equals(wsrp_urlType)) {
            String wsrp_url = (String)allMap.get("wsrp-url");
            String wsrp_requiresRewrite = (String)allMap.get("wsrp-requiresRewrite");
            StringBuffer proxyURL = new StringBuffer();
            if (wsrp_url != null) {
                proxyURL.append(this._portalServerURLPrefix + PROXY_SERVLET_MAPPING + "?" + PROXY_RESOURCE_URL + "=" + URLEncoder.encode(wsrp_url));
                if (wsrp_requiresRewrite != null) {
                    proxyURL.append("&wsrp_rewrite=" + wsrp_requiresRewrite);
                    if (this._namespace != null) {
                        proxyURL.append("&namespace=" + this._namespace);
                    }
                    proxyURL.append("&portal_server_url=" + URLEncoder.encode(this._portalServerURLPrefix));
                }
                if (this._cookieKey != null) {
                    proxyURL.append("&cookie_key=" + this._cookieKey);
                }
            }
            finalURL = proxyURL.toString();
        }
        return finalURL;
    }

    private int searchToken(String content, String pattern, int start) {
        return Boyer.indexOf((String)content, (String)pattern, (int)start);
    }

    private Map getParamMapFromURIStyleString(String wsrpurl) {
        String key;
        String tempStr;
        String paramString = tempStr = this.decodeAmpersand(wsrpurl);
        HashMap<String, Object> allMap = new HashMap<String, Object>();
        HashMap<String, ArrayList<String>> paramMap = new HashMap<String, ArrayList<String>>();
        StringTokenizer paramtokenizer = new StringTokenizer(paramString, AMP);
        while (paramtokenizer.hasMoreTokens()) {
            String keyValue = paramtokenizer.nextToken();
            StringTokenizer keyTokenizer = new StringTokenizer(keyValue, "=");
            if (keyTokenizer.countTokens() != 2) continue;
            key = keyTokenizer.nextToken();
            String value = URLDecoder.decode(keyTokenizer.nextToken());
            if (WSRPSpecKeys.isReservedKey((String)key)) {
                allMap.put(key, value);
                continue;
            }
            ArrayList<String> valueList = (ArrayList<String>)paramMap.get(key);
            if (valueList == null) {
                valueList = new ArrayList<String>();
            }
            valueList.add(value);
            paramMap.put(key, valueList);
        }
        HashMap<String, String[]> paramMapWithArray = new HashMap<String, String[]>(paramMap.size());
        Iterator iter = paramMap.keySet().iterator();
        while (iter.hasNext()) {
            key = (String)iter.next();
            List listValue = (List)paramMap.get(key);
            String[] values = new String[listValue.size()];
            listValue.toArray(values);
            paramMapWithArray.put(key, values);
        }
        allMap.put("parameters", paramMapWithArray);
        return allMap;
    }

    private String decodeAmpersand(String url) {
        url = this.decode(url, AMP1, AMP);
        url = this.decode(url, AMP2, AMP);
        return url;
    }

    private String decode(String url, String from, String to) {
        int i;
        while ((i = url.indexOf(from)) >= 0) {
            url = url.substring(0, i) + to + url.substring(i + from.length());
        }
        return url;
    }

    public Templates getTemplates(HttpServletRequest request) {
        Templates templates = new Templates();
        templates.setDefaultTemplate(null);
        templates.setRenderTemplate(this._channelURLFactory.getRenderTemplate());
        templates.setBlockingActionTemplate(this._channelURLFactory.getActionTemplate());
        templates.setResourceTemplate(this.getResourceTemplate());
        if (request.isSecure()) {
            templates.setSecureRenderTemplate(this._channelURLFactory.getRenderTemplate());
            templates.setSecureBlockingActionTemplate(this._channelURLFactory.getActionTemplate());
            templates.setSecureResourceTemplate(this.getResourceTemplate());
            templates.setSecureDefaultTemplate(null);
        } else {
            StringBuffer buf = new StringBuffer();
            buf.append(this._channelURLFactory.getSecurityErrorURL());
            buf.append(AMP);
            buf.append("wsrp-urlType={wsrp-urlType}");
            buf.append("&windowstate={wsrp-windowState}");
            buf.append("&channelMode={wsrp-mode}");
            buf.append("&wsrp-navigationalState={wsrp-navigationalState}");
            buf.append("&wsrp-interactionState={wsrp-interactionState}");
            buf.append("&wsrp-url={wsrp-url}");
            buf.append("&wsrp-requiresRewrite={wsrp-requiresRewrite}");
            templates.setSecureDefaultTemplate(buf.toString());
        }
        return templates;
    }

    private String getResourceTemplate() {
        StringBuffer proxyURL = new StringBuffer();
        proxyURL.append(this._portalServerURLPrefix + PROXY_SERVLET_MAPPING + "?" + PROXY_RESOURCE_URL + "=" + "{wsrp-url}");
        proxyURL.append("&wsrp_rewrite={wsrp-requiresRewrite}");
        if (this._namespace != null) {
            proxyURL.append("&namespace=" + this._namespace);
        }
        proxyURL.append("&portal_server_url=" + URLEncoder.encode(this._portalServerURLPrefix));
        if (this._cookieKey != null) {
            proxyURL.append("&cookie_key=" + this._cookieKey);
        }
        return proxyURL.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

