/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.common;

import com.sun.portal.util.ResourceLoader;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletContext;

public class WSRPConsumerConfig {
    public static final String WSRP_CONSUMER_CONFIG_FILE = "wsrpconsumerconfig.properties";
    public static final String PERF_LOGLEVEL_KEY = "perfLogLevel";
    public static final String SOAP_DEBUG_METHOD = "soapDebugMethod";
    public static final String MM_CLASSNAME = "mmClassname";
    public static final String PEM_CLASSNAME = "pemClassname";
    public static final String RSSM_CLASSNAME = "rssmClassname";
    public static final String ANON_SUPPORTS_INIT_COOKIE = "anonSupportsInitCookie";
    public static final String FILE_UPLOAD_MAX_SIZE = "fileUploadMaxSize";
    public static final String DEFAULT_MM_CLASSNAME = "com.sun.portal.wsrp.consumer.markup.impl.MarkupManagerImpl";
    public static final String DEFAULT_PEM_CLASSNAME = "com.sun.portal.wsrp.consumer.producermanager.impl.ProducerEntityManagerImpl";
    public static final String DEFAULT_RSSM_CLASSNAME = "com.sun.portal.wsrp.consumer.common.impl.StaticRemoteServiceStubManagerImpl";
    public static final String DEFAULT_SOAP_DUMP_FILENAME = "/tmp/psWSRPConsumerSOAPDump";
    public static final int SOAP_DEBUG_NONE = 0;
    public static final int SOAP_DEBUG_TUNNEL = 1;
    public static final int SOAP_DEBUG_DUMP = 2;
    public static final String SOAP_DUMP_FILENAME = "soapDumpFile";
    public static final String TUNNEL_PREFIX = "tunnel_";
    public static final String TUNNEL_RSSM_CLASSNAME = "com.sun.portal.wsrp.consumer.common.impl.TunnelRemoteServiceStubManagerImpl";
    protected static Map tunnelMap = null;
    protected static int soapDebugMethod = 0;
    protected static Properties properties = null;
    protected static WSRPConsumerConfig config = null;

    protected WSRPConsumerConfig() {
    }

    public static void init(ServletContext sc) throws WSRPConsumerException {
        WSRPConsumerConfig.init(WSRP_CONSUMER_CONFIG_FILE, null);
    }

    public static void init(String filename, String portalId) throws WSRPConsumerException {
        config = new WSRPConsumerConfig();
        if (filename == null || filename.length() <= 0) {
            throw new WSRPConsumerException("WSRPConsumerConfig.init(): properties file name not found.");
        }
        config.doInit(filename, portalId);
    }

    public static WSRPConsumerConfig getInstance() {
        return config;
    }

    protected void doInit(String filename, String portalId) throws WSRPConsumerException {
        ResourceLoader resourceLoader = null;
        resourceLoader = portalId == null ? ResourceLoader.getInstance((Properties)System.getProperties()) : ResourceLoader.getInstance((String)portalId);
        try {
            properties = resourceLoader.getProperties(filename);
        }
        catch (FileNotFoundException fnfe) {
            throw new WSRPConsumerException("WSRPConsumerConfig.doInit(): ", fnfe);
        }
        catch (IOException ioe) {
            throw new WSRPConsumerException("WSRPConsumerConfig.doInit(): ", ioe);
        }
        soapDebugMethod = this.initSOAPDebugMethod();
        tunnelMap = this.initTunnelMap();
    }

    protected int initSOAPDebugMethod() throws WSRPConsumerException {
        String soapDebugMethod = properties.getProperty(SOAP_DEBUG_METHOD);
        int method = 0;
        if (soapDebugMethod.equals("tunnel")) {
            method = 1;
        } else if (soapDebugMethod.equals("dump")) {
            method = 0;
        }
        return method;
    }

    public int getSOAPDebugMethod() {
        return soapDebugMethod;
    }

    protected Map initTunnelMap() throws WSRPConsumerException {
        HashMap<String, String> tMap = new HashMap<String, String>();
        Enumeration<?> i = properties.propertyNames();
        while (i.hasMoreElements()) {
            String key = (String)i.nextElement();
            if (!key.startsWith(TUNNEL_PREFIX) || key.length() <= TUNNEL_PREFIX.length()) continue;
            String tunnelKey = key.substring(TUNNEL_PREFIX.length());
            tMap.put(tunnelKey, properties.getProperty(key));
        }
        return tMap;
    }

    public Map getTunnelMap() {
        return tunnelMap;
    }

    public String getSOAPDumpFilename() throws WSRPConsumerException {
        String filename = properties.getProperty(SOAP_DUMP_FILENAME);
        if (filename != null && filename.length() > 0) {
            return filename;
        }
        return DEFAULT_SOAP_DUMP_FILENAME;
    }

    public boolean doesAnonSupportInitCookie() {
        String support = properties.getProperty(ANON_SUPPORTS_INIT_COOKIE);
        return support != null && support.equals("true");
    }

    public int getFileUploadMaxSize() {
        String fileUploadSizeLimit = properties.getProperty(FILE_UPLOAD_MAX_SIZE);
        if (fileUploadSizeLimit == null) {
            return -1;
        }
        try {
            return Integer.parseInt(fileUploadSizeLimit);
        }
        catch (NumberFormatException ex) {
            return -1;
        }
    }

    public String getMarkupManagerClassname() {
        String mmClassname = properties.getProperty(MM_CLASSNAME);
        if (mmClassname == null) {
            mmClassname = DEFAULT_MM_CLASSNAME;
        }
        return mmClassname;
    }

    public String getProducerEntityManagerClassname() {
        String pemClassname = properties.getProperty(PEM_CLASSNAME);
        if (pemClassname == null) {
            pemClassname = DEFAULT_PEM_CLASSNAME;
        }
        return pemClassname;
    }

    public String getRemoteServiceStubManagerClassname() throws WSRPConsumerException {
        String rssmClassname = null;
        rssmClassname = this.getSOAPDebugMethod() == 1 ? TUNNEL_RSSM_CLASSNAME : properties.getProperty(RSSM_CLASSNAME);
        if (rssmClassname == null) {
            rssmClassname = DEFAULT_RSSM_CLASSNAME;
        }
        return rssmClassname;
    }
}

