/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

class PEAUtil {
    public static final String RESOURCE_BASE = "wsrpPEA";
    public static ResourceBundle rb = PropertyResourceBundle.getBundle("wsrpPEA", Locale.getDefault());
    public static final int CONTEXT_LINE_NUM = 5;

    PEAUtil() {
    }

    public static void setLocale(Locale locale) {
        rb = PropertyResourceBundle.getBundle(RESOURCE_BASE, locale);
    }

    public static String getLocalizedString(String key) {
        return rb.getString(key);
    }

    public static String getLocalizedString(String key, Object[] objs) {
        if (objs != null && objs.length > 0) {
            MessageFormat mf = new MessageFormat("");
            mf.setLocale(rb.getLocale());
            mf.applyPattern(rb.getString(key));
            return mf.format(objs);
        }
        return rb.getString(key);
    }

    public static void debug(String key) {
        PEAUtil.debug(key, null);
    }

    public static void debug(String key, Object[] tokens) {
        String msg = PEAUtil.getLocalizedString(key, tokens);
        Object[] toks = new Object[]{msg};
        System.err.println(PEAUtil.getLocalizedString("msgDebug", toks));
    }

    public static void warning(String key) {
        PEAUtil.warning(key, null);
    }

    public static void warning(String key, Object[] tokens) {
        String msg = PEAUtil.getLocalizedString(key, tokens);
        Object[] toks = new Object[]{msg};
        System.err.println(PEAUtil.getLocalizedString("msgWarning", toks));
    }

    public static void error(String key) {
        PEAUtil.error(key, null);
    }

    public static void error(String key, Object[] tokens) {
        String msg = PEAUtil.getLocalizedString(key, tokens);
        Object[] toks = new Object[]{msg};
        System.err.println(PEAUtil.getLocalizedString("msgError", toks));
    }

    public static String getLines(Reader reader, int linenum) {
        StringBuffer buf = new StringBuffer();
        String line = null;
        BufferedReader br = new BufferedReader(reader);
        try {
            int i = 1;
            int beg = linenum - 5;
            int end = linenum + 5;
            buf.append("\n");
            while ((line = br.readLine()) != null) {
                if (i == linenum) {
                    buf.append("(*)").append(line).append("\n");
                } else if (i >= beg && i <= end) {
                    buf.append("   ").append(line).append("\n");
                }
                ++i;
            }
            buf.append("\n");
        }
        catch (IOException ioe) {
            return "";
        }
        return buf.toString();
    }
}

