/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.WSRPFactory;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.consumer.cli.PEACommand;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ConsumerObjectFactory;
import com.sun.portal.wsrp.consumer.producermanager.InbandRegistrationNotSupportedException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

class PEAUpdate {
    public static final int TYPE_NAME = 0;
    public static final int TYPE_URL = 1;
    public static final int TYPE_STATUS = 2;
    public static final int TYPE_SERVICE_DESCRIPTION = 3;
    public static final int TYPE_REGISTRATION = 4;
    public static final int TYPE_ALLOWED_USER_PROFILE_MAPPING = 5;
    public static final int TYPE_CUSTOM_USER_PROFILE_MAPPING = 6;
    public static final int TYPE_USER_CATEGORY_MAPPING = 7;
    public static final int TYPE_DEFAULT_REGISTRATION = 8;
    public static final int TYPE_STANDARD_USER_PROFILE_MAPPING = 9;
    public static final int TYPE_CONSUMER_NAME = 10;
    protected static int type = -1;
    private static WSRPFactory factory = null;
    private static ConsumerObjectFactory cofactory = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEAUpdate == null ? (class$com$sun$portal$wsrp$consumer$cli$PEAUpdate = PEAUpdate.class$("com.sun.portal.wsrp.consumer.cli.PEAUpdate")) : class$com$sun$portal$wsrp$consumer$cli$PEAUpdate));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEAUpdate;

    PEAUpdate() {
    }

    public void process(ProducerEntityManager pem, String dn, String pid, String uType, String input, boolean verbose) throws PEAException {
        if (uType.toLowerCase().equals("name")) {
            type = 0;
        } else if (uType.toLowerCase().equals("status")) {
            type = 2;
        } else if (uType.toLowerCase().equals("service_description")) {
            type = 3;
        } else if (uType.toLowerCase().equals("registration")) {
            type = 4;
        } else if (uType.toLowerCase().equals("default_registration")) {
            type = 8;
        } else if (uType.toLowerCase().equals("user_category_map")) {
            type = 7;
        } else if (uType.toLowerCase().equals("consumer_name")) {
            type = 10;
        } else {
            Object[] tokens = new Object[]{uType};
            throw new PEAException("errorInvalidType", tokens);
        }
        if (type != 8 && type != 9 && type != 10 && pid == null) {
            Object[] tokens = new Object[]{uType};
            throw new PEAException("errorNoPID", tokens);
        }
        if (type != 3 && (input == null || input.length() == 0)) {
            Object[] tokens = new Object[]{uType};
            throw new PEAException("errorInputRequired", tokens);
        }
        switch (type) {
            case 0: {
                this.updateName(pem, pid, input, verbose);
                break;
            }
            case 1: {
                this.updateURL(pem, pid, input, verbose);
                break;
            }
            case 2: {
                this.updateStatus(pem, pid, input, verbose);
                break;
            }
            case 3: {
                this.updateServiceDescription(pem, pid, verbose);
                break;
            }
            case 4: {
                String fileInput = PEACommand.getFileInput(input);
                this.updateRegistration(dn, pem, pid, fileInput, verbose);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: {
                String fileInput = PEACommand.getFileInput(input);
                this.updateMapping(pem, pid, type, fileInput, verbose);
                break;
            }
            case 8: {
                String fileInput = PEACommand.getFileInput(input);
                this.updateDefaultRegistration(pem, fileInput, verbose);
                break;
            }
            case 10: {
                this.updateConsumerName(pem, input, verbose);
            }
        }
    }

    protected void updateName(ProducerEntityManager pem, String pid, String name, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{pid, name};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0021", tokens);
        }
        try {
            pem.setName(pid, name);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{pid, name};
            throw new PEAException("errorUpdateName", (Throwable)((Object)wce), tokens);
        }
    }

    protected void updateURL(ProducerEntityManager pem, String pid, String url, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{pid, url};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0022", tokens);
        }
        URL u = null;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException mue) {
            Object[] tokens = new Object[]{pid, url};
            throw new PEAException("errorInvalidURL", mue, tokens);
        }
    }

    protected void updateStatus(ProducerEntityManager pem, String pid, String status, boolean verbose) throws PEAException {
        ProducerEntityStatus ps = ProducerEntityStatus.getProducerEntityStatus(status);
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{pid, ps.toString()};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0023", tokens);
        }
        try {
            pem.setStatus(pid, ps);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{pid, status};
            throw new PEAException("errorUpdateStatus", (Throwable)((Object)wce), tokens);
        }
    }

    protected void updateServiceDescription(ProducerEntityManager pem, String pid, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{pid};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0024", tokens);
        }
        try {
            pem.updateServiceDescription(pid);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{pid};
            throw new PEAException("errorUpdateSD", (Throwable)((Object)wce), tokens);
        }
    }

    protected void updateRegistration(String dn, ProducerEntityManager pem, String pid, String rdXML, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{pid};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0025", tokens);
        }
        ProducerEntity pe = null;
        try {
            pe = pem.getProducerEntity(pid);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens);
        }
        if (pe == null) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorInvalidPID", tokens);
        }
        try {
            RegistrationData registrationData = this.getWSRPFactory().getRegistrationData(rdXML);
            pem.modifyRegistration(pid, registrationData);
        }
        catch (InbandRegistrationNotSupportedException irnse) {
            Object[] tokens = new Object[]{dn, pe.getURL()};
            throw new PEAException("errorNoInband", (Throwable)((Object)irnse), tokens);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{pid};
            throw new PEAException("errorUpdateReg", (Throwable)((Object)wce), tokens);
        }
        catch (WSRPException we) {
            Object[] tokens = new Object[]{rdXML};
            throw new PEAException("errorParseReg", we, tokens);
        }
    }

    protected void updateMapping(ProducerEntityManager pem, String pid, int type, String mapString, boolean verbose) throws PEAException {
        if (type == 7) {
            Map ucMap = null;
            try {
                ucMap = this.getConsumerObjectFactory().getMap(mapString);
            }
            catch (WSRPConsumerException wce) {
                throw new PEAException("errorParseXML", (Throwable)((Object)wce));
            }
            if (ucMap != null && ucMap.size() > 0) {
                try {
                    pem.setUserCategoryMapping(pid, ucMap);
                }
                catch (WSRPConsumerException wce) {
                    Object[] tokens = new Object[]{pid, ucMap};
                    throw new PEAException("errorSetUC", (Throwable)((Object)wce), tokens);
                }
            }
        }
    }

    protected void updateDefaultRegistration(ProducerEntityManager pem, String rdXML, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCCL0026");
        }
        try {
            RegistrationData defRegistrationData = this.getWSRPFactory().getRegistrationData(rdXML);
            pem.setDefaultRegistrationData(defRegistrationData);
        }
        catch (WSRPConsumerException wce) {
            throw new PEAException("errorUpdateRegData", (Throwable)((Object)wce));
        }
        catch (WSRPException we) {
            Object[] tokens = new Object[]{rdXML};
            throw new PEAException("errorParseReg", we, tokens);
        }
    }

    protected void updateConsumerName(ProducerEntityManager pem, String name, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{name};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0027");
        }
        try {
            pem.setConsumerName(name);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{name};
            throw new PEAException("errorUpdateConsumerName", (Throwable)((Object)wce), tokens);
        }
    }

    private WSRPFactory getWSRPFactory() throws WSRPException {
        if (factory == null) {
            factory = WSRPFactory.getInstance();
        }
        return factory;
    }

    private ConsumerObjectFactory getConsumerObjectFactory() throws WSRPConsumerException {
        if (cofactory == null) {
            cofactory = ConsumerObjectFactory.getInstance();
        }
        return cofactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

