/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.cli.PEAUtil;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.InbandRegistrationNotSupportedException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import java.util.logging.Level;
import java.util.logging.Logger;

class PEARemove {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEARemove == null ? (class$com$sun$portal$wsrp$consumer$cli$PEARemove = PEARemove.class$("com.sun.portal.wsrp.consumer.cli.PEARemove")) : class$com$sun$portal$wsrp$consumer$cli$PEARemove));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEARemove;

    PEARemove() {
    }

    public void process(ProducerEntityManager pem, String dn, String pid, boolean verbose) throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            Object[] tokens = new Object[]{pid};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0020", tokens);
        }
        ProducerEntity pe = null;
        try {
            pe = pem.getProducerEntity(pid);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens);
        }
        if (pe == null) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorInvalidPID", tokens);
        }
        boolean outofband = false;
        try {
            outofband = !pem.isInbandRegistrationSupported(pe.getURL());
        }
        catch (WSRPConsumerException wce) {
            throw new PEAException((Throwable)((Object)wce));
        }
        if (!outofband) {
            try {
                pem.removeProducerEntity(pid);
            }
            catch (InbandRegistrationNotSupportedException irnse) {
                Object[] tokens = new Object[]{dn, pe.getURL()};
                throw new PEAException("errorNoInband", (Throwable)((Object)irnse), tokens);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{dn, pid};
                throw new PEAException("errorRemovePE", (Throwable)((Object)wce), tokens);
            }
        }
        RegistrationContext regContext = pe.getRegistrationContext();
        if (regContext == null) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorGetRegContext", tokens);
        }
        String regHandle = regContext.getRegistrationHandle();
        if (regHandle == null) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorGetRegHandle", tokens);
        }
        try {
            pem.eliminateProducerEntity(pid);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorRemovePE", (Throwable)((Object)wce), tokens);
        }
        if (verbose) {
            Object[] tokens = new Object[]{dn, pe.getURL(), regHandle};
            PEAUtil.warning("warnDeregister", tokens);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

