/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.consumer.cli.CLIPParser;
import com.sun.portal.wsrp.consumer.cli.PEACommand;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.cli.PEAUtil;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerBootstrap;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class PEAMain {
    public static final String COMMANDNAME = "wcadmin";
    public static final String COMMANDVERSION = "1.0";
    private static Debug debug = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEAMain == null ? (class$com$sun$portal$wsrp$consumer$cli$PEAMain = PEAMain.class$("com.sun.portal.wsrp.consumer.cli.PEAMain")) : class$com$sun$portal$wsrp$consumer$cli$PEAMain));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEAMain;

    PEAMain(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-l") && !args[i].equals("--locale") || i >= args.length - 1) continue;
            java.util.Locale locale = Locale.getLocale((String)args[i + 1]);
            PEAException.setLocale(locale);
            PEAUtil.setLocale(locale);
        }
        String propertiesFile = System.getProperty("wsrp.consumer.propertiesFile");
        if (propertiesFile == null) {
            System.err.println(PEAUtil.getLocalizedString("errorPropertiesFile"));
            System.exit(1);
        }
        WSRPConsumerBootstrap.cliInitialized(propertiesFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map getBatchInput(String batchFile) throws PEAException {
        File f = new File(batchFile);
        TreeMap<Long, String> batch = new TreeMap<Long, String>();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(batchFile));
                String line = null;
                long lineNum = 1L;
                while ((line = br.readLine()) != null) {
                    if (line.length() > 0) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(line + "\n");
                        batch.put(new Long(lineNum), buf.toString());
                    }
                    ++lineNum;
                }
                Object var9_9 = null;
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{batchFile};
                throw new PEAException("errorFileRead", ioe, tokens);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{batchFile};
                throw new PEAException("errorFileRead", ioe, tokens);
            }
        }
        try {}
        catch (IOException ioe) {
            Object[] tokens = new Object[]{batchFile};
            throw new PEAException("errorFileRead", ioe, tokens);
        }
        br.close();
        if (batch.size() != 0) return batch;
        throw new PEAException("errorEmptyBatch");
    }

    public static void main(String[] args) {
        PEAMain pea = new PEAMain(args);
        CLIPParser cp = null;
        try {
            cp = PEACommand.getCLIPParser(false);
            PEACommand cmd = new PEACommand(cp, args, false, debug);
            if (!cmd.isBatch()) {
                cmd.runCommand(debug);
            } else {
                ProducerEntityManager pem = null;
                DSAMEAdminDPContext dadc = null;
                boolean isPreAuthorized = false;
                if (cmd.isAuthProvided()) {
                    pem = cmd.getProducerEntityManager();
                    dadc = cmd.getDPContext();
                    isPreAuthorized = true;
                }
                Map batch = PEAMain.getBatchInput(cmd.batchFile);
                CLIPParser bcp = PEACommand.getCLIPParser(true);
                Set keySet = batch.keySet();
                Iterator i = keySet.iterator();
                while (i.hasNext()) {
                    Long key = (Long)i.next();
                    String cmdline = (String)batch.get(key);
                    if (logger.isLoggable(Level.FINEST)) {
                        Object[] tokens = new Object[]{key, cmdline};
                        logger.log(Level.FINEST, "PSWS_CSPWCCL0018", tokens);
                    }
                    try {
                        PEACommand c = new PEACommand(bcp, cmdline, true, isPreAuthorized, debug);
                        if (isPreAuthorized) {
                            c.runCommand(pem, dadc, debug);
                            continue;
                        }
                        c.runCommand(debug);
                    }
                    catch (PEAException peaex) {
                        Object[] tokens;
                        String wrappedMsg = peaex.getWrappedMessage();
                        if (wrappedMsg != null && wrappedMsg.length() > 0) {
                            tokens = new Object[]{peaex.getLocalizedMessage(), key, wrappedMsg};
                            System.err.println(PEAUtil.getLocalizedString("msgWrappedErrorLine", tokens));
                        } else {
                            tokens = new Object[]{peaex.getLocalizedMessage(), key};
                            System.err.println(PEAUtil.getLocalizedString("msgErrorLine", tokens));
                        }
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, "", peaex);
                        }
                        if (cmd.cont) continue;
                        System.exit(1);
                    }
                    catch (Throwable th) {
                        Object[] tokens = new Object[]{th.getMessage(), key};
                        System.err.println(PEAUtil.getLocalizedString("msgErrorLine", tokens));
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, "", th);
                        }
                        if (cmd.cont) continue;
                        System.exit(1);
                    }
                }
            }
            System.exit(0);
        }
        catch (PEAException peaex) {
            String wrappedMsg = peaex.getWrappedMessage();
            if (wrappedMsg != null && wrappedMsg.length() > 0) {
                Object[] tokens = new Object[]{peaex.getLocalizedMessage(), wrappedMsg};
                System.err.println(PEAUtil.getLocalizedString("msgWrappedError", tokens));
            } else {
                Object[] tokens = new Object[]{peaex.getLocalizedMessage()};
                System.err.println(PEAUtil.getLocalizedString("msgError", tokens));
            }
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "", peaex);
            }
            System.exit(1);
        }
        catch (Throwable th) {
            Object[] tokens = new Object[]{th.getMessage()};
            System.err.println(PEAUtil.getLocalizedString("msgError", tokens));
            if (logger.isLoggable(Level.SEVERE)) {
                LogRecord rec = new LogRecord(Level.SEVERE, "PSWS_CSPWCCL0019");
                rec.setLoggerName(logger.getName());
                rec.setThrown(th);
                rec.setParameters(tokens);
                logger.log(rec);
            }
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

