/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.WSRPFactory;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class PEAList {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEAList == null ? (class$com$sun$portal$wsrp$consumer$cli$PEAList = PEAList.class$("com.sun.portal.wsrp.consumer.cli.PEAList")) : class$com$sun$portal$wsrp$consumer$cli$PEAList));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEAList;

    PEAList() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String process(ProducerEntityManager pem, String dn, String pid, String purl, boolean verbose) throws PEAException {
        if (pid != null && purl != null) {
            throw new PEAException("errorBothPIDPURL");
        }
        if (verbose) {
            Object[] tokens;
            if (pid != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{pid};
                    logger.log(Level.FINEST, "PSWS_CSPWCCL0015", tokens);
                }
            } else if (purl != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{purl};
                    logger.log(Level.FINEST, "PSWS_CSPWCCL0016", tokens);
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "PSWS_CSPWCCL0017");
            }
        }
        StringBuffer buf = new StringBuffer();
        if (pid != null) {
            ProducerEntity pe = null;
            try {
                pe = pem.getProducerEntity(pid);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{dn, pid};
                throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens);
            }
            if (pe != null) {
                buf.append(((Object)pe).toString());
                return buf.toString();
            }
            Object[] tokens = new Object[]{dn, pid};
            throw new PEAException("errorInvalidPID", tokens);
        }
        if (purl != null) {
            URL url = null;
            try {
                url = new URL(purl);
            }
            catch (MalformedURLException mue) {
                Object[] tokens = new Object[]{purl};
                throw new PEAException("errorInvalidURL", mue, tokens);
            }
            String sdXML = null;
            try {
                WSRPFactory factory = WSRPFactory.getInstance();
                ServiceDescription sd = pem.getServiceDescription(url);
                sdXML = factory.getServiceDescriptionXML(sd, true);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{purl};
                throw new PEAException("errorGetSD", (Throwable)((Object)wce), tokens);
            }
            catch (WSRPException we) {
                Object[] tokens = new Object[]{purl};
                throw new PEAException("errorGetSD", we, tokens);
            }
            buf.append(sdXML);
            return buf.toString();
        }
        Set peIds = null;
        try {
            peIds = pem.getProducerEntityIds();
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{dn};
            throw new PEAException("errorGetPEs", (Throwable)((Object)wce), tokens);
        }
        if (peIds == null || peIds.size() <= 0) return buf.toString();
        Iterator i = peIds.iterator();
        while (i.hasNext()) {
            ProducerEntity pe = null;
            String peId = (String)i.next();
            try {
                pe = pem.getProducerEntity(peId);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{dn, peId};
                throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens);
            }
            if (pe == null) {
                Object[] tokens = new Object[]{dn, peId};
                throw new PEAException("errorGetPE", tokens);
            }
            buf.append(pe.getId()).append("|").append(pe.getName()).append("|").append(pe.getURL()).append("|").append(pe.getStatus().toString()).append("\n");
        }
        return buf.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

