/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.iplanet.am.util.Debug;
import com.sun.portal.desktop.context.DPContext;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPError;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.desktop.dp.xml.XMLDPFactory;
import com.sun.portal.desktop.dp.xml.XMLDPRoot;
import com.sun.portal.desktop.encode.Encoder;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.cli.PEAUtil;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.common.WSRPProviderConstants;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xml.sax.SAXParseException;

class PEADeploy
implements WSRPProviderConstants {
    StringBuffer chnames = new StringBuffer();
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEADeploy == null ? (class$com$sun$portal$wsrp$consumer$cli$PEADeploy = PEADeploy.class$("com.sun.portal.wsrp.consumer.cli.PEADeploy")) : class$com$sun$portal$wsrp$consumer$cli$PEADeploy));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEADeploy;

    PEADeploy() {
    }

    public String process(ProducerEntityManager pem, DSAMEAdminDPContext dadc, String dn, String pid, String rid, String chname, boolean cont, boolean verbose, boolean dryrun, Debug debug) throws PEAException {
        Object[] tokens;
        if (pid == null && rid != null) {
            throw new PEAException("errorNoPIDWithRID");
        }
        if (rid == null && chname != null) {
            throw new PEAException("errorNoRIDWithCh");
        }
        if (verbose) {
            if (rid != null) {
                if (logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{dn, pid, rid};
                    logger.log(Level.FINEST, "PSWS_CSPWCCL0007", tokens);
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                tokens = new Object[]{dn};
                logger.log(Level.FINEST, "PSWS_CSPWCCL0008", tokens);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            tokens = new Object[]{dn};
            logger.log(Level.FINE, "PSWS_CSPWCCL0009", tokens);
        }
        String doc = null;
        try {
            doc = dadc.getDPDocumentByDN(dn);
        }
        catch (Throwable ex) {
            Object[] tokens2 = new Object[]{dn};
            throw new PEAException("errorRetrieveDP", ex, tokens2);
        }
        DPRoot dpr = null;
        XMLDPFactory dpf = XMLDPFactory.getInstance();
        try {
            dpr = doc != null && doc.length() > 0 ? dpf.createRoot((DPContext)dadc, doc) : dpf.createRoot((DPContext)dadc);
            Set names = dadc.getDPDocumentNames(dn);
            dpr = dpf.addMergers((DPContext)dadc, dpr, names, new HashMap());
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{dn};
            throw new PEAException("errorCreateDPRoot", ex, tokens3);
        }
        if (pid != null) {
            ProducerEntity pe = null;
            try {
                pe = pem.getProducerEntity(pid);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens4 = new Object[]{dn, pid};
                throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens4);
            }
            if (rid != null) {
                int i;
                PortletDescription[] pds = pe.getServiceDescription().getOfferedPortlets();
                boolean found = false;
                for (i = 0; i < pds.length; ++i) {
                    if (!pds[i].getPortletHandle().equals(rid)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Object[] tokens5 = new Object[]{dn, pid, rid};
                    throw new PEAException("errorInvalidRID", tokens5);
                }
                this.deployPortlet(dpr, dadc, dn, pds[i], pe, rid, chname, verbose);
            } else {
                this.deployAllPortlets(dpr, dadc, dn, pe, cont, verbose, debug);
            }
        } else {
            Set pidSet = null;
            try {
                pidSet = pem.getProducerEntityIds();
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens6 = new Object[]{dn};
                throw new PEAException("errorGetPEs", (Throwable)((Object)wce), tokens6);
            }
            if (pidSet.size() > 0) {
                Iterator i = pidSet.iterator();
                while (i.hasNext()) {
                    ProducerEntity pe = null;
                    try {
                        pe = pem.getProducerEntity((String)i.next());
                    }
                    catch (WSRPConsumerException wce) {
                        Object[] tokens7 = new Object[]{dn, pid};
                        throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens7);
                    }
                    this.deployAllPortlets(dpr, dadc, dn, pe, cont, verbose, debug);
                }
            }
        }
        this.writeDP(dpr, dadc, dn, verbose, dryrun);
        return this.chnames.toString();
    }

    protected void deployAllPortlets(DPRoot dpr, DSAMEAdminDPContext dadc, String dn, ProducerEntity pe, boolean cont, boolean verbose, Debug debug) throws PEAException {
        String pid = pe.getId();
        PortletDescription[] pds = pe.getServiceDescription().getOfferedPortlets();
        for (int i = 0; i < pds.length; ++i) {
            String rid = pds[i].getPortletHandle();
            if (cont) {
                try {
                    this.deployPortlet(dpr, dadc, dn, pds[i], pe, rid, null, verbose);
                }
                catch (Throwable th) {
                    if (!logger.isLoggable(Level.SEVERE)) continue;
                    Object[] tokens = new Object[]{dn, pid, rid};
                    logger.log(Level.SEVERE, "PSWS_CSPWCCL0010", tokens);
                    logger.log(Level.SEVERE, "PSWS_CSPWCCL0011", th);
                }
                continue;
            }
            this.deployPortlet(dpr, dadc, dn, pds[i], pe, rid, null, verbose);
        }
    }

    public DPRoot deployPortlet(DPRoot dpr, DSAMEAdminDPContext dadc, String dn, PortletDescription pd, ProducerEntity pe, String rid, String chname, boolean verbose) throws PEAException {
        Object[] tokens;
        String pid = pe.getId();
        if (pd.getUsesMethodGet().booleanValue()) {
            Object[] tokens2 = new Object[]{dn, pid, rid};
            throw new PEAException("errorMethodGetOn", tokens2);
        }
        if (logger.isLoggable(Level.FINEST)) {
            tokens = new Object[]{dn, pid, rid};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0012", tokens);
        }
        if (chname == null) {
            String pname = pe.getName();
            String pnameEsc = Encoder.FORMNAME_ENCODER.encode(pname);
            String ridEsc = Encoder.FORMNAME_ENCODER.encode(rid);
            chname = pnameEsc + "_" + ridEsc;
        }
        if (logger.isLoggable(Level.FINEST)) {
            tokens = new Object[]{dn, chname};
            logger.log(Level.FINEST, "PSWS_CSPWCCL0013", tokens);
        }
        boolean dupFound = false;
        XMLDPRoot xdpr = (XMLDPRoot)dpr;
        try {
            boolean bl = dupFound = xdpr.getChannelFromThis(chname) != null;
            if (!dupFound) {
                dupFound = xdpr.getProviderFromThis(chname) != null;
            }
        }
        catch (Throwable ex) {
            Object[] tokens3 = new Object[]{dn, chname};
            throw new PEAException("errorCheckDup", ex, tokens3);
        }
        if (dupFound) {
            Object[] tokens4 = new Object[]{dn, chname};
            throw new PEAException("errorDupFound", tokens4);
        }
        DPChannel ch = null;
        try {
            XMLDPFactory dpf = XMLDPFactory.getInstance();
            ch = dpf.createChannel((DPContext)dadc, dpr, xdpr.getDocument(), chname, "_WSRPProvider");
            ch = dpr.addChannel(ch);
            ch.getProperties().setString("consumerID", dn);
            ch.getProperties().setString("producerEntityID", pid);
            ch.getProperties().setString("portletID", rid);
            ch.getProperties().setString("portletHandle", rid);
        }
        catch (Throwable ex) {
            Object[] tokens5 = new Object[]{dn, chname};
            throw new PEAException("errorAddCh", ex, tokens5);
        }
        if (ch != null) {
            this.chnames.append(ch.getName()).append("\n");
        }
        return dpr;
    }

    protected void writeDP(DPRoot dpr, DSAMEAdminDPContext dadc, String dn, boolean verbose, boolean dryrun) throws PEAException {
        String dpDoc = null;
        try {
            if (dpr.isDirty()) {
                dpr.setDirty(false);
            }
            dpDoc = dpr.toString();
            XMLDPFactory dpf = XMLDPFactory.getInstance();
            dpf.createRoot((DPContext)dadc, dpDoc);
        }
        catch (DPError de) {
            Throwable wrapped = de.getCause();
            if (wrapped != null && wrapped instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)wrapped;
                int linenum = spe.getLineNumber();
                Object[] tokens = new Object[]{PEAUtil.getLines(new StringReader(dpDoc), linenum)};
                throw new PEAException("errorInvalidXMLText", de, tokens);
            }
        }
        catch (Throwable ex) {
            throw new PEAException("errorInvalidXML", ex);
        }
        if (!dryrun) {
            if (logger.isLoggable(Level.FINEST)) {
                Object[] tokens = new Object[]{dn};
                logger.log(Level.FINEST, "", tokens);
            }
            try {
                StringBuffer sb = new StringBuffer(256);
                dpr.toXML(sb, 0);
                dadc.storeDPDocumentByDN(dn, sb.toString());
            }
            catch (Throwable ex) {
                Object[] tokens = new Object[]{dn};
                throw new PEAException("ErrorStoreDP", ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

