/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.iplanet.am.util.Debug;
import com.sun.portal.desktop.context.ContextError;
import com.sun.portal.desktop.context.DSAMEAdminDPContext;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.ResourceLoader;
import com.sun.portal.wsrp.consumer.cli.CLIPException;
import com.sun.portal.wsrp.consumer.cli.CLIPParser;
import com.sun.portal.wsrp.consumer.cli.PEAAdd;
import com.sun.portal.wsrp.consumer.cli.PEADeploy;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.cli.PEAList;
import com.sun.portal.wsrp.consumer.cli.PEARemove;
import com.sun.portal.wsrp.consumer.cli.PEAUpdate;
import com.sun.portal.wsrp.consumer.cli.PEAUtil;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

class PEACommand {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_ADD = "add";
    private static final String SUBCMD_UPDATE = "update";
    private static final String SUBCMD_REMOVE = "remove";
    private static final String SUBCMD_DEPLOY = "deploy";
    private static final String SUBCMD_BATCH = "batch";
    private static final int LIST = 1;
    private static final int ADD = 2;
    private static final int UPDATE = 3;
    private static final int REMOVE = 4;
    private static final int DEPLOY = 5;
    private static final int BATCH = 6;
    protected static final String OPT_HELP = "help";
    protected static final String OPT_UID = "runasdn";
    protected static final String OPT_PASSWORD = "password";
    protected static final String OPT_DN = "dn";
    protected static final String OPT_PID = "pid";
    protected static final String OPT_PURL = "purl";
    protected static final String OPT_PNAME = "pname";
    protected static final String OPT_REGHANDLE = "reghandle";
    protected static final String OPT_TYPE = "type";
    protected static final String OPT_RID = "rid";
    protected static final String OPT_CHNAME = "chname";
    protected static final String OPT_VERBOSE = "verbose";
    protected static final String OPT_VERSION = "version";
    protected static final String OPT_LOCALE = "locale";
    protected static final String OPT_DRYRUN = "dry-run";
    protected static final String OPT_CONT = "continue";
    protected static final String OPT_FILE = "file";
    public static final String OPT_DEFAULT = "*";
    public static final String LOCALE_DEFAULT = Locale.getDefault().toString();
    protected int subcmd = -1;
    protected String uid = null;
    protected String password = null;
    protected String dn = null;
    protected String pid = null;
    protected String purl = null;
    protected String pname = null;
    protected String identityPropagationType = null;
    protected String reghandle = null;
    protected String rid = null;
    protected String type = null;
    protected String chname = null;
    protected String input = null;
    protected boolean dryrun = false;
    protected boolean verbose = false;
    protected Locale locale = Locale.getDefault();
    protected boolean cont = false;
    protected String batchFile = null;
    protected boolean batchMode = false;
    protected boolean isPreAuthorized = false;
    private ProducerEntityManager pem = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEACommand == null ? (class$com$sun$portal$wsrp$consumer$cli$PEACommand = PEACommand.class$("com.sun.portal.wsrp.consumer.cli.PEACommand")) : class$com$sun$portal$wsrp$consumer$cli$PEACommand));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEACommand;

    PEACommand(CLIPParser cp, String[] args, boolean batchMode, Debug debug) throws PEAException {
        this.batchMode = batchMode;
        this.parse(cp, args);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    PEACommand(CLIPParser cp, String cmdEntry, boolean batchMode, boolean isPreAuthorized, Debug debug) throws PEAException {
        String cmd = null;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new StringReader(cmdEntry));
                cmd = br.readLine();
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{cmdEntry};
                throw new PEAException("errorParseBatch", ioe, tokens);
            }
            Object var11_8 = null;
        }
        catch (Throwable throwable) {
            Object var11_9 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{cmdEntry};
                throw new PEAException("errorParseBatch", ioe, tokens);
            }
        }
        try {}
        catch (IOException ioe) {
            Object[] tokens = new Object[]{cmdEntry};
            throw new PEAException("errorParseBatch", ioe, tokens);
        }
        br.close();
        ArrayList<String> cmdList = new ArrayList<String>();
        StringBuffer tokenBuf = new StringBuffer();
        boolean isQuoted = false;
        for (int i = 0; i < cmd.length(); ++i) {
            if (cmd.charAt(i) == '\"') {
                isQuoted = !isQuoted;
                continue;
            }
            if (!isQuoted && cmd.charAt(i) == ' ') {
                if (tokenBuf.length() > 0) {
                    cmdList.add(tokenBuf.toString());
                }
                tokenBuf = new StringBuffer();
                continue;
            }
            tokenBuf.append(cmd.charAt(i));
        }
        if (tokenBuf.length() > 0) {
            cmdList.add(tokenBuf.toString());
        }
        if (isQuoted) {
            Object[] tokens = new Object[]{cmdEntry};
            throw new PEAException("errorUnmatchedQuote", tokens);
        }
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        this.batchMode = batchMode;
        this.isPreAuthorized = isPreAuthorized;
        this.parse(cp, cmdArray);
    }

    protected void parse(CLIPParser cp, String[] argv) throws PEAException {
        String[] purls;
        String[] pids;
        if (cp.needsVersion(argv)) {
            System.err.println(this.getVersionInfo());
            System.exit(0);
        }
        if (cp.needsHelp(argv)) {
            System.err.println(cp.getHelp(argv));
            System.exit(0);
        }
        Map options = null;
        try {
            options = cp.getOptions(argv);
        }
        catch (CLIPException ce) {
            throw new PEAException("errorCLIPParseError", ce);
        }
        try {
            cp.verifyArguments(argv);
        }
        catch (CLIPException ce) {
            throw new PEAException("errorCLIPParseError", ce);
        }
        this.verbose = ((String[])options.get(OPT_VERBOSE))[0].equals("true");
        String sc = null;
        try {
            sc = cp.getSubCommand(argv);
        }
        catch (CLIPException ce) {
            Object[] tokens = new Object[]{sc};
            throw new PEAException("errorInvalidSubCmd", ce, tokens);
        }
        if (sc.equals(SUBCMD_LIST)) {
            this.subcmd = 1;
        } else if (sc.equals(SUBCMD_ADD)) {
            this.subcmd = 2;
        } else if (sc.equals(SUBCMD_UPDATE)) {
            this.subcmd = 3;
        } else if (sc.equals(SUBCMD_REMOVE)) {
            this.subcmd = 4;
        } else if (sc.equals(SUBCMD_DEPLOY)) {
            this.subcmd = 5;
        } else if (sc.equals(SUBCMD_BATCH)) {
            this.subcmd = 6;
        }
        this.uid = ((String[])options.get(OPT_UID))[0];
        this.password = ((String[])options.get(OPT_PASSWORD))[0];
        if (this.subcmd != 6) {
            if (this.batchMode && !this.isAuthProvided() && !this.isPreAuthorized) {
                throw new PEAException("errorNoAuth");
            }
            this.dn = ((String[])options.get(OPT_DN))[0];
        } else {
            this.batchFile = ((String[])options.get(OPT_FILE))[0];
        }
        if ((this.subcmd == 1 || this.subcmd == 3 || this.subcmd == 4 || this.subcmd == 5) && (pids = (String[])options.get(OPT_PID)) != null & pids.length > 0 && !pids[0].equals(OPT_DEFAULT)) {
            this.pid = pids[0];
        }
        if (this.subcmd == 1 && (purls = (String[])options.get(OPT_PURL)) != null & purls.length > 0 && !purls[0].equals(OPT_DEFAULT)) {
            this.purl = purls[0];
        }
        if (this.subcmd == 2) {
            String[] reghandles;
            String[] pnames;
            purls = (String[])options.get(OPT_PURL);
            if (purls != null & purls.length > 0) {
                this.purl = purls[0];
            }
            if ((pnames = (String[])options.get(OPT_PNAME)) != null & pnames.length > 0 && !pnames[0].equals(OPT_DEFAULT)) {
                this.pname = pnames[0];
            }
            if ((reghandles = (String[])options.get(OPT_REGHANDLE)) != null & reghandles.length > 0 && !reghandles[0].equals(OPT_DEFAULT)) {
                this.reghandle = reghandles[0];
            }
        }
        if (this.subcmd == 3) {
            this.type = ((String[])options.get(OPT_TYPE))[0];
        }
        if (this.subcmd == 5) {
            String[] chnames;
            String[] rids = (String[])options.get(OPT_RID);
            if (rids != null & rids.length > 0 && !rids[0].equals(OPT_DEFAULT)) {
                this.rid = rids[0];
            }
            if ((chnames = (String[])options.get(OPT_CHNAME)) != null & chnames.length > 0 && !chnames[0].equals(OPT_DEFAULT)) {
                this.chname = chnames[0];
            }
        }
        if (this.subcmd == 5 || this.subcmd == 6) {
            this.cont = ((String[])options.get(OPT_CONT))[0].equals("true");
        }
        if (this.subcmd == 2 || this.subcmd == 5) {
            this.dryrun = ((String[])options.get(OPT_DRYRUN))[0].equals("true");
        }
        if (this.subcmd == 2 || this.subcmd == 3) {
            String[] operands = null;
            try {
                operands = cp.getOperands(argv);
            }
            catch (CLIPException ce) {
                throw new PEAException("errorCLIPParseError", ce);
            }
            if (operands != null && operands.length > 0) {
                this.input = operands[0];
            }
            if (this.subcmd == 2) {
                this.input = PEACommand.getFileInput(this.input);
            }
        }
    }

    protected boolean isBatch() {
        return this.subcmd == 6;
    }

    protected boolean isAuthProvided() {
        boolean authProvided = !this.uid.equals(OPT_DEFAULT) && !this.password.equals(OPT_DEFAULT);
        return authProvided;
    }

    protected void runCommand(Debug debug) throws PEAException {
        ProducerEntityManager pem = this.getProducerEntityManager();
        DSAMEAdminDPContext dadc = this.getDPContext();
        this.runCommand(pem, dadc, debug);
    }

    protected void runCommand(ProducerEntityManager pem, DSAMEAdminDPContext dadc, Debug debug) throws PEAException {
        if (this.batchMode && this.isAuthProvided()) {
            pem = this.getProducerEntityManager();
        }
        switch (this.subcmd) {
            case 1: {
                PEAList peal = new PEAList();
                String res = peal.process(pem, this.dn, this.pid, this.purl, this.verbose);
                System.out.println(res);
                break;
            }
            case 2: {
                PEAAdd peaa = new PEAAdd();
                String peId = peaa.process(pem, this.dn, this.purl, this.pname, this.identityPropagationType, this.input, this.reghandle, this.verbose, this.dryrun);
                if (!this.dryrun) {
                    if (this.verbose) {
                        Object[] tokens = new Object[]{peId};
                        System.out.println(PEAUtil.getLocalizedString("msgSuccessAdd", tokens));
                        break;
                    }
                    System.out.println(peId);
                    break;
                }
                if (!this.verbose) break;
                System.out.println(PEAUtil.getLocalizedString("msgDryrunSuccess"));
                break;
            }
            case 3: {
                PEAUpdate peau = new PEAUpdate();
                peau.process(pem, this.dn, this.pid, this.type, this.input, this.verbose);
                if (!this.verbose) break;
                System.out.println(PEAUtil.getLocalizedString("msgSuccess"));
                break;
            }
            case 4: {
                PEARemove pear = new PEARemove();
                pear.process(pem, this.dn, this.pid, this.verbose);
                if (!this.verbose) break;
                System.out.println(PEAUtil.getLocalizedString("msgSuccess"));
                break;
            }
            case 5: {
                PEADeploy pead = new PEADeploy();
                String chnames = pead.process(pem, dadc, this.dn, this.pid, this.rid, this.chname, this.cont, this.verbose, this.dryrun, debug);
                if (!this.dryrun) {
                    if (this.verbose) {
                        Object[] tokens = new Object[]{chnames};
                        System.out.println(PEAUtil.getLocalizedString("msgSuccessDeploy", tokens));
                        break;
                    }
                    System.out.println(chnames);
                    break;
                }
                if (!this.verbose) break;
                System.out.println(PEAUtil.getLocalizedString("msgDryrunSuccess"));
                break;
            }
            default: {
                Object[] tokens = new Object[]{new Integer(this.subcmd)};
                throw new PEAException("errorInvalidSubCmd", tokens);
            }
        }
    }

    protected ProducerEntityManager getProducerEntityManager() throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCCL0005");
        }
        ProducerEntityManager pem = null;
        try {
            pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.dn, this.uid, this.password);
        }
        catch (WSRPConsumerException wce) {
            throw new PEAException("errorInitPEM", (Throwable)((Object)wce));
        }
        return pem;
    }

    protected DSAMEAdminDPContext getDPContext() throws PEAException {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "PSWS_CSPWCCL0006");
        }
        DSAMEAdminDPContext dadc = null;
        String propertiesFile = System.getProperty("desktop.propertiesFile");
        if (propertiesFile == null) {
            throw new PEAException("errorDesktopPropertiesFile");
        }
        try {
            dadc = new DSAMEAdminDPContext();
            dadc.init(this.uid, this.password, propertiesFile, ResourceLoader.getInstance((Properties)System.getProperties()).getPortalId());
        }
        catch (ContextError ce) {
            throw new PEAException("errorInitDPCxt", ce);
        }
        return dadc;
    }

    protected static CLIPParser getCLIPParser(boolean batchMode) throws CLIPException {
        CLIPParser.SubCommand[] subCmds = null;
        CLIPParser.Option[] optsList = new CLIPParser.Option[]{new CLIPParser.Option(OPT_HELP, "?", 0, "false", PEAUtil.getLocalizedString("optHelp")), new CLIPParser.Option(OPT_UID, "u", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgUID"), PEAUtil.getLocalizedString("optUID")), new CLIPParser.Option(OPT_PASSWORD, "w", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgPassword"), PEAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(OPT_DN, "d", 1, null, PEAUtil.getLocalizedString("optArgDN"), PEAUtil.getLocalizedString("optDN")), new CLIPParser.Option(OPT_PID, "p", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgPID"), PEAUtil.getLocalizedString("optPID")), new CLIPParser.Option(OPT_PURL, "r", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgPURL"), PEAUtil.getLocalizedString("optPURL")), new CLIPParser.Option(OPT_VERBOSE, "b", 0, "false", PEAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(OPT_VERSION, "V", 0, "false", PEAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(OPT_LOCALE, "l", 1, LOCALE_DEFAULT, PEAUtil.getLocalizedString("optArgLocale"), PEAUtil.getLocalizedString("optLocale"))};
        CLIPParser.SubCommand scList = new CLIPParser.SubCommand(SUBCMD_LIST, optsList, 0, 0, PEAUtil.getLocalizedString("helpList"), "");
        CLIPParser.Option[] optsAdd = new CLIPParser.Option[]{new CLIPParser.Option(OPT_HELP, "?", 0, "false", PEAUtil.getLocalizedString("optHelp")), new CLIPParser.Option(OPT_UID, "u", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgUID"), PEAUtil.getLocalizedString("optUID")), new CLIPParser.Option(OPT_PASSWORD, "w", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgPassword"), PEAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(OPT_DN, "d", 1, null, PEAUtil.getLocalizedString("optArgDN"), PEAUtil.getLocalizedString("optDN")), new CLIPParser.Option(OPT_PURL, "r", 1, null, PEAUtil.getLocalizedString("optArgPURL"), PEAUtil.getLocalizedString("optPURL")), new CLIPParser.Option(OPT_PNAME, "n", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgPName"), PEAUtil.getLocalizedString("optPName")), new CLIPParser.Option(OPT_REGHANDLE, "g", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgRegHandle"), PEAUtil.getLocalizedString("optRegHandle")), new CLIPParser.Option(OPT_VERBOSE, "b", 0, "false", PEAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(OPT_VERSION, "V", 0, "false", PEAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(OPT_LOCALE, "l", 1, LOCALE_DEFAULT, PEAUtil.getLocalizedString("optArgLocale"), PEAUtil.getLocalizedString("optLocale")), new CLIPParser.Option(OPT_DRYRUN, "y", 0, "false", PEAUtil.getLocalizedString("optDryrun"))};
        CLIPParser.SubCommand scAdd = new CLIPParser.SubCommand(SUBCMD_ADD, optsAdd, 0, 1, PEAUtil.getLocalizedString("helpAdd"), "");
        CLIPParser.Option[] optsUpdate = new CLIPParser.Option[]{new CLIPParser.Option(OPT_HELP, "?", 0, "false", PEAUtil.getLocalizedString("optHelp")), new CLIPParser.Option(OPT_UID, "u", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgUID"), PEAUtil.getLocalizedString("optUID")), new CLIPParser.Option(OPT_PASSWORD, "w", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgPassword"), PEAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(OPT_DN, "d", 1, null, PEAUtil.getLocalizedString("optArgDN"), PEAUtil.getLocalizedString("optDN")), new CLIPParser.Option(OPT_PID, "p", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgPID"), PEAUtil.getLocalizedString("optPID")), new CLIPParser.Option(OPT_TYPE, "t", 1, null, PEAUtil.getLocalizedString("optArgType"), PEAUtil.getLocalizedString("optType")), new CLIPParser.Option(OPT_VERBOSE, "b", 0, "false", PEAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(OPT_VERSION, "V", 0, "false", PEAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(OPT_LOCALE, "l", 1, LOCALE_DEFAULT, PEAUtil.getLocalizedString("optArgLocale"), PEAUtil.getLocalizedString("optLocale"))};
        CLIPParser.SubCommand scUpdate = new CLIPParser.SubCommand(SUBCMD_UPDATE, optsUpdate, 0, 1, PEAUtil.getLocalizedString("helpUpdate"), "");
        CLIPParser.Option[] optsRemove = new CLIPParser.Option[]{new CLIPParser.Option(OPT_HELP, "?", 0, "false", PEAUtil.getLocalizedString("optHelp")), new CLIPParser.Option(OPT_UID, "u", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgUID"), PEAUtil.getLocalizedString("optUID")), new CLIPParser.Option(OPT_PASSWORD, "w", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgPassword"), PEAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(OPT_DN, "d", 1, null, PEAUtil.getLocalizedString("optArgDN"), PEAUtil.getLocalizedString("optDN")), new CLIPParser.Option(OPT_PID, "p", 1, null, PEAUtil.getLocalizedString("optArgPID"), PEAUtil.getLocalizedString("optPID")), new CLIPParser.Option(OPT_VERBOSE, "b", 0, "false", PEAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(OPT_VERSION, "V", 0, "false", PEAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(OPT_LOCALE, "l", 1, LOCALE_DEFAULT, PEAUtil.getLocalizedString("optArgLocale"), PEAUtil.getLocalizedString("optLocale"))};
        CLIPParser.SubCommand scRemove = new CLIPParser.SubCommand(SUBCMD_REMOVE, optsRemove, 0, 0, PEAUtil.getLocalizedString("helpRemove"), "");
        CLIPParser.Option[] optsDeploy = new CLIPParser.Option[]{new CLIPParser.Option(OPT_HELP, "?", 0, "false", PEAUtil.getLocalizedString("optHelp")), new CLIPParser.Option(OPT_UID, "u", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgUID"), PEAUtil.getLocalizedString("optUID")), new CLIPParser.Option(OPT_PASSWORD, "w", 1, batchMode ? OPT_DEFAULT : null, PEAUtil.getLocalizedString("optArgPassword"), PEAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(OPT_DN, "d", 1, null, PEAUtil.getLocalizedString("optArgDN"), PEAUtil.getLocalizedString("optDN")), new CLIPParser.Option(OPT_PID, "p", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgPID"), PEAUtil.getLocalizedString("optPID")), new CLIPParser.Option(OPT_RID, "o", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgRID"), PEAUtil.getLocalizedString("optRID")), new CLIPParser.Option(OPT_CHNAME, "n", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgChName"), PEAUtil.getLocalizedString("optChName")), new CLIPParser.Option(OPT_CONT, "c", 0, "false", PEAUtil.getLocalizedString("optCont")), new CLIPParser.Option(OPT_VERBOSE, "b", 0, "false", PEAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(OPT_VERSION, "V", 0, "false", PEAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(OPT_LOCALE, "l", 1, LOCALE_DEFAULT, PEAUtil.getLocalizedString("optArgLocale"), PEAUtil.getLocalizedString("optLocale")), new CLIPParser.Option(OPT_DRYRUN, "y", 0, "false", PEAUtil.getLocalizedString("optDryrun"))};
        CLIPParser.SubCommand scDeploy = new CLIPParser.SubCommand(SUBCMD_DEPLOY, optsDeploy, 0, 0, PEAUtil.getLocalizedString("helpDeploy"), "");
        if (!batchMode) {
            CLIPParser.Option[] optsBatch = new CLIPParser.Option[]{new CLIPParser.Option(OPT_HELP, "?", 0, "false", PEAUtil.getLocalizedString("optHelp")), new CLIPParser.Option(OPT_UID, "u", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgUID"), PEAUtil.getLocalizedString("optUID")), new CLIPParser.Option(OPT_PASSWORD, "w", 1, OPT_DEFAULT, PEAUtil.getLocalizedString("optArgPassword"), PEAUtil.getLocalizedString("optPassword")), new CLIPParser.Option(OPT_CONT, "c", 0, "false", PEAUtil.getLocalizedString("optCont")), new CLIPParser.Option(OPT_FILE, "f", 1, null, PEAUtil.getLocalizedString("optArgFile"), PEAUtil.getLocalizedString("optFile")), new CLIPParser.Option(OPT_VERBOSE, "b", 0, "false", PEAUtil.getLocalizedString("optVerbose")), new CLIPParser.Option(OPT_VERSION, "V", 0, "false", PEAUtil.getLocalizedString("optVersion")), new CLIPParser.Option(OPT_LOCALE, "l", 1, LOCALE_DEFAULT, PEAUtil.getLocalizedString("optArgLocale"), PEAUtil.getLocalizedString("optLocale"))};
            CLIPParser.SubCommand scBatch = new CLIPParser.SubCommand(SUBCMD_BATCH, optsBatch, 0, 0, PEAUtil.getLocalizedString("helpBatch"), "");
            CLIPParser.SubCommand[] sc = new CLIPParser.SubCommand[]{scList, scAdd, scUpdate, scRemove, scDeploy};
            subCmds = sc;
        } else {
            CLIPParser.SubCommand[] sc;
            subCmds = sc = new CLIPParser.SubCommand[]{scList, scAdd, scRemove};
        }
        return new CLIPParser("wcadmin", subCmds, PEAUtil.getLocalizedString("helpCmd"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileInput(String filename) throws PEAException {
        String in = null;
        if (filename == null) return in;
        File f = new File(filename);
        StringBuffer buf = new StringBuffer();
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new FileReader(filename));
                String line = null;
                while ((line = br.readLine()) != null) {
                    buf.append(line + "\n");
                }
                Object var8_7 = null;
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{filename};
                throw new PEAException("errorFileRead", ioe, tokens);
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                br.close();
                throw throwable;
            }
            catch (IOException ioe) {
                Object[] tokens = new Object[]{filename};
                throw new PEAException("errorFileRead", ioe, tokens);
            }
        }
        try {}
        catch (IOException ioe) {
            Object[] tokens = new Object[]{filename};
            throw new PEAException("errorFileRead", ioe, tokens);
        }
        br.close();
        return buf.toString();
    }

    private String getVersionInfo() {
        ResourceBundle prodRB = PropertyResourceBundle.getBundle("PSversion");
        StringBuffer vinfo = new StringBuffer();
        vinfo.append("wcadmin").append(" (").append(prodRB.getString("productname")).append(" ").append(prodRB.getString("productversion")).append(") ").append("1.0");
        vinfo.append("\n").append(prodRB.getString("copyright"));
        return vinfo.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

