/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.WSRPFactory;
import com.sun.portal.wsrp.common.stubs.ItemDescription;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.cli.PEAException;
import com.sun.portal.wsrp.consumer.cli.PEAUtil;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.InbandRegistrationNotSupportedException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

class PEAAdd {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$cli$PEAAdd == null ? (class$com$sun$portal$wsrp$consumer$cli$PEAAdd = PEAAdd.class$("com.sun.portal.wsrp.consumer.cli.PEAAdd")) : class$com$sun$portal$wsrp$consumer$cli$PEAAdd));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$cli$PEAAdd;

    PEAAdd() {
    }

    public String process(ProducerEntityManager pem, String dn, String purl, String pname, String identityPropagationType, String regDataXML, String regHandle, boolean verbose, boolean dryrun) throws PEAException {
        URL url = null;
        try {
            url = new URL(purl);
        }
        catch (MalformedURLException mue) {
            Object[] tokens = new Object[]{purl};
            throw new PEAException("errorInvalidURL", mue, tokens);
        }
        boolean outofband = false;
        if (regHandle != null && regHandle.length() > 0) {
            outofband = true;
        }
        if (outofband && regDataXML != null && regDataXML.length() > 0) {
            Object[] tokens = new Object[]{dn, purl};
            throw new PEAException("errorNoRegData", tokens);
        }
        if (pname == null) {
            pname = purl.toString();
        }
        if (pname.indexOf(124) > -1) {
            Object[] tokens = new Object[]{pname};
            throw new PEAException("errorInvalidPName", tokens);
        }
        if (verbose) {
            Object[] tokens;
            if (!outofband) {
                if (logger.isLoggable(Level.FINEST)) {
                    tokens = new Object[]{purl, pname};
                    logger.log(Level.FINEST, "PSWS_CSPWCCL0001", tokens);
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                tokens = new Object[]{purl, pname, regHandle};
                logger.log(Level.FINEST, "PSWS_CSPWCCL0002", tokens);
            }
        }
        String peId = null;
        peId = !outofband ? this.processInband(pem, dn, url, pname, identityPropagationType, regDataXML, verbose, dryrun) : this.processOutofband(pem, dn, url, pname, identityPropagationType, regHandle, verbose, dryrun);
        if (!dryrun) {
            this.setUserMappings(pem, dn, peId, verbose);
        }
        return peId;
    }

    private String processInband(ProducerEntityManager pem, String dn, URL url, String pname, String identityPropagationType, String regDataXML, boolean verbose, boolean dryrun) throws PEAException {
        ServiceDescription sd = null;
        try {
            sd = pem.getServiceDescription(url);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{url};
            throw new PEAException("errorGetSD", (Throwable)((Object)wce), tokens);
        }
        RegistrationData regData = null;
        if (sd.isRequiresRegistration()) {
            if (regDataXML != null && regDataXML.length() > 0) {
                try {
                    WSRPFactory factory = WSRPFactory.getInstance();
                    regData = factory.getRegistrationData(regDataXML);
                }
                catch (WSRPException we) {
                    throw new PEAException("errorParseXML", we);
                }
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "PSWS_CSPWCCL0003");
            }
            try {
                regData = pem.getDefaultRegistrationData();
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{dn};
                throw new PEAException("errorGetDefReg", (Throwable)((Object)wce), tokens);
            }
        }
        String peId = null;
        if (!dryrun) {
            try {
                peId = pem.addProducerEntity(pname, url, identityPropagationType, regData, null, null, null);
            }
            catch (InbandRegistrationNotSupportedException irnse) {
                Object[] tokens = new Object[]{dn, url};
                throw new PEAException("errorNoInband", (Throwable)((Object)irnse), tokens);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{dn, url};
                throw new PEAException("errorAddPE", (Throwable)((Object)wce), tokens);
            }
        }
        return peId;
    }

    private String processOutofband(ProducerEntityManager pem, String dn, URL url, String pname, String identityPropagationType, String regHandle, boolean verbose, boolean dryrun) throws PEAException {
        String peId = null;
        if (!dryrun) {
            try {
                peId = pem.addProducerEntity(pname, url, identityPropagationType, regHandle, null, null, null);
            }
            catch (WSRPConsumerException wce) {
                Object[] tokens = new Object[]{dn, url};
                throw new PEAException("errorAddPE", (Throwable)((Object)wce), tokens);
            }
        }
        return peId;
    }

    private void setUserMappings(ProducerEntityManager pem, String dn, String peId, boolean verbose) throws PEAException {
        ProducerEntity pe = null;
        try {
            pe = pem.getProducerEntity(peId);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{dn, peId};
            throw new PEAException("errorGetPE", (Throwable)((Object)wce), tokens);
        }
        if (pe == null) {
            Object[] tokens = new Object[]{peId};
            throw new PEAException("errorInvalidPID", tokens);
        }
        ServiceDescription sd = pe.getServiceDescription();
        ItemDescription[] ucs = sd.getUserCategoryDescriptions();
        if (ucs != null && ucs.length > 0 && verbose) {
            Object[] tokens = new Object[]{peId};
            PEAUtil.warning("warnUpdateUC", tokens);
        }
        Map stdMap = null;
        try {
            stdMap = pem.getStandardUserProfileMapping();
        }
        catch (WSRPConsumerException wce) {
            throw new PEAException("errorGetStdUserProfile", (Throwable)((Object)wce));
        }
        if (stdMap == null) {
            throw new PEAException("errorGetStdUserProfile");
        }
        Set stdKeys = stdMap.keySet();
        if (logger.isLoggable(Level.FINE)) {
            Object[] tokens = new Object[]{peId};
            logger.log(Level.FINE, "PSWS_CSPWCCL0004", tokens);
        }
        try {
            pem.setAllowedUserProfileMapping(peId, stdMap);
        }
        catch (WSRPConsumerException wce) {
            Object[] tokens = new Object[]{peId, stdMap};
            throw new PEAException("errorSetAUP", (Throwable)((Object)wce), tokens);
        }
        ItemDescription[] cups = sd.getCustomUserProfileItemDescriptions();
        if (cups != null && cups.length > 0 && verbose) {
            Object[] tokens = new Object[]{peId};
            PEAUtil.warning("warnUpdateCUP", tokens);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

