/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.cli;

import com.sun.portal.wsrp.consumer.cli.CLIPException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class CLIPParser {
    private static final String OPTION_PREFIX = "-";
    private static final String SHORT_OPTION = "-";
    private static final String LONG_OPTION = "--";
    private static final String NEGATE_OPTION = "--no-";
    private static final String NO_MORE_OPTIONS = "--";
    private static final String ADD_TO_COLLECTION_OPTION = "--add-";
    private static final String REMOVE_FROM_COLLECTION_OPTION = "--remove-";
    public static final int BOOLEAN = 0;
    public static final int REGULAR = 1;
    public static final int COLLECTION = 2;
    private String _commandName;
    private String _commandHelpMessage;
    private Map _subCommands = new HashMap();
    private List _orderedSubCommands = new ArrayList();

    private static void verifyName(String name, String exceptionMsgPrefix) {
        if (name == null || name.length() < 2) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " has to be at least 2 chars long");
        }
        if (name.equals("--")) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " can not be '--'");
        }
        if (name.startsWith("-") || name.endsWith("-")) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " can not start or end with '-'");
        }
        if (!name.equals(name.toLowerCase())) {
            throw new IllegalArgumentException(exceptionMsgPrefix + " has to be in lower case");
        }
    }

    private CLIPParser() {
    }

    public CLIPParser(String commandName, SubCommand[] subCommands, String commandHelpMessage) throws IllegalArgumentException {
        this();
        this._commandName = commandName;
        this._commandHelpMessage = commandHelpMessage;
        if (subCommands == null || subCommands.length == 0) {
            throw new IllegalArgumentException("CLIPParser - sub command array can not be null or empty");
        }
        for (int i = 0; i < subCommands.length; ++i) {
            if (subCommands[i]._subCommandName == null) {
                throw new IllegalArgumentException("CLIPParser - Sub command can not be null");
            }
            this.addSubCommand(subCommands[i]);
        }
    }

    public CLIPParser(String commandName, Option[] options, int minOperands, int maxOperands, String commandHelpMessage, String operandsHelp) throws IllegalArgumentException {
        this();
        this._commandName = commandName;
        this._commandHelpMessage = commandHelpMessage;
        SubCommand subCommand = new SubCommand(null, options, minOperands, maxOperands, this._commandHelpMessage, operandsHelp);
        this.addSubCommand(subCommand);
    }

    private void addSubCommand(SubCommand subCommand) throws IllegalArgumentException {
        if (subCommand._subCommandName != null) {
            CLIPParser.verifyName(subCommand._subCommandName, "CLIPParser - Sub command");
        }
        if (this._subCommands.containsKey(subCommand._subCommandName)) {
            throw new IllegalArgumentException("CLIPParser - Sub command '" + subCommand._subCommandName + "', sub command already defined");
        }
        this._subCommands.put(subCommand._subCommandName, subCommand);
        this._orderedSubCommands.add(subCommand);
    }

    public void verifyArguments(String[] args) throws CLIPException {
        boolean skip;
        boolean bl = skip = args.length == 1 && (args[0].equals("--help") || args[0].equals("-?"));
        if (!skip) {
            this.getSubCommand(args);
            boolean bl2 = skip = args.length == 2 && (args[1].equals("--help") || args[0].equals("-?"));
            if (!skip) {
                this.getOptions(args);
                this.getOperands(args);
            }
        }
    }

    public String getSubCommand(String[] args) throws CLIPException {
        boolean hasSubCommands = !this._subCommands.containsKey(null);
        String firstArgument = args.length > 0 && hasSubCommands ? args[0] : null;
        SubCommand subCommand = (SubCommand)this._subCommands.get(firstArgument);
        if (subCommand == null) {
            throw new CLIPException("Invalid sub command: " + firstArgument, 0);
        }
        return firstArgument;
    }

    public Map getOptions(String[] args) throws CLIPException {
        SubCommand subCommand = (SubCommand)this._subCommands.get(this.getSubCommand(args));
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator i = subCommand._defaultOptionValues.keySet().iterator();
        while (i.hasNext()) {
            String optionName = (String)i.next();
            List optionValues = (List)subCommand._defaultOptionValues.get(optionName);
            map.put(optionName, ((ArrayList)optionValues).clone());
        }
        int argumentIndex = this.processOptions(args, map);
        i = subCommand._validOptions.keySet().iterator();
        while (i.hasNext()) {
            String optionName = (String)i.next();
            Option option = (Option)subCommand._validOptions.get(optionName);
            if (option._defaultValues != null || map.containsKey(option._longName)) continue;
            throw new CLIPException("Missing mandatory option: " + option._longName, argumentIndex);
        }
        return this.massageOptions(map);
    }

    public String[] getOperands(String[] args) throws CLIPException {
        SubCommand subCommand = (SubCommand)this._subCommands.get(this.getSubCommand(args));
        int i = this.processOptions(args, new HashMap());
        int numberOfOperands = args.length - i;
        if (subCommand._minOperands > numberOfOperands || numberOfOperands > subCommand._maxOperands) {
            throw new CLIPException("Invalid number of operands", i);
        }
        for (int j = i; j < args.length; ++j) {
            if (!args[j].equals("--")) continue;
            throw new CLIPException("'--' can not be an operand", j);
        }
        String[] operands = new String[numberOfOperands];
        if (args.length > 0) {
            System.arraycopy(args, i, operands, 0, numberOfOperands);
        }
        return operands;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int processOptions(String[] args, Map map) throws CLIPException {
        int i;
        SubCommand subCommand = (SubCommand)this._subCommands.get(this.getSubCommand(args));
        boolean allOptionsProcessed = false;
        int n = i = subCommand._subCommandName != null ? 1 : 0;
        while (!allOptionsProcessed && i < args.length) {
            List values;
            String optionValue;
            String token;
            StringTokenizer tokens;
            String optionValue2;
            List values2;
            Option option;
            String optionName;
            if (args[i].startsWith(ADD_TO_COLLECTION_OPTION)) {
                optionName = args[i].substring(ADD_TO_COLLECTION_OPTION.length());
                option = (Option)subCommand._validOptions.get(optionName);
                if (optionName.length() < 2 || option == null) {
                    throw new CLIPException("Invalid option: " + optionName, i);
                }
                if (option._type != 2) {
                    throw new CLIPException("Not a collection option: " + optionName, i);
                }
                values2 = this.getOptionValues(subCommand, map, optionName);
                if (i + 1 == args.length) {
                    throw new CLIPException("Missing collection values to add to option: " + optionName, i);
                }
                tokens = new StringTokenizer(optionValue2, (optionValue2 = args[++i]).indexOf(" ") > -1 ? " " : ",");
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    values2.add(token);
                }
            } else if (args[i].startsWith(REMOVE_FROM_COLLECTION_OPTION)) {
                optionName = args[i].substring(REMOVE_FROM_COLLECTION_OPTION.length());
                option = (Option)subCommand._validOptions.get(optionName);
                if (optionName.length() < 2 || option == null) {
                    throw new CLIPException("Invalid option: " + optionName, i);
                }
                if (option._type != 2) {
                    throw new CLIPException("Not a collection option: " + optionName, i);
                }
                if (i + 1 == args.length) {
                    throw new CLIPException("Missing collection values to delete from option: " + optionName, i);
                }
                values2 = this.getOptionValues(subCommand, map, optionName);
                tokens = new StringTokenizer(optionValue2, (optionValue2 = args[++i]).indexOf(" ") > -1 ? " " : ",");
                while (tokens.hasMoreTokens()) {
                    token = tokens.nextToken();
                    if (values2.contains(token)) {
                        values2.remove(token);
                        continue;
                    }
                    for (int j = 0; j < values2.size(); ++j) {
                        String v = (String)values2.get(j);
                        if (!v.startsWith(token + "=")) continue;
                        values2.remove(j);
                    }
                }
            } else if (args[i].equals("--")) {
                ++i;
                allOptionsProcessed = true;
            } else if (args[i].startsWith(NEGATE_OPTION)) {
                optionName = args[i].substring(NEGATE_OPTION.length());
                option = (Option)subCommand._validOptions.get(optionName);
                if (option == null) {
                    throw new CLIPException("Invalid option: " + optionName, i);
                }
                if (option._type != 0) {
                    throw new CLIPException("Not a boolean option: " + optionName, i);
                }
                optionValue = "false";
                values = this.getOptionValues(subCommand, map, optionName);
                values.clear();
                values.add(optionValue);
            } else if (args[i].startsWith("--")) {
                optionName = args[i].substring("--".length());
                option = (Option)subCommand._validOptions.get(optionName);
                if (option == null) {
                    throw new CLIPException("Invalid option: " + optionName, i);
                }
                if (option._type == 0) {
                    optionValue = "true";
                    values = this.getOptionValues(subCommand, map, optionName);
                    values.clear();
                    values.add(optionValue);
                } else if (option._type == 1) {
                    if (i + 1 == args.length) {
                        throw new CLIPException("Missing value for regular option: " + optionName, i);
                    }
                    optionValue = args[++i];
                    values = this.getOptionValues(subCommand, map, optionName);
                    values.clear();
                    values.add(optionValue);
                } else {
                    if (option._type != 2) throw new CLIPException("CLIPParser - Internal error", i);
                    if (i + 1 == args.length) {
                        throw new CLIPException("Missing value for collection option: " + optionName, i);
                    }
                    optionValue = args[++i];
                    values = this.getOptionValues(subCommand, map, optionName);
                    values.clear();
                    tokens = new StringTokenizer(optionValue, optionValue.indexOf(" ") > -1 ? " " : ",");
                    while (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        values.add(token);
                    }
                }
            } else if (args[i].startsWith("-")) {
                optionName = args[i].substring("-".length());
                for (int j = 0; j < optionName.length() - 1; ++j) {
                    String shortOptionName = "" + optionName.charAt(j);
                    Option option2 = (Option)subCommand._validOptions.get(shortOptionName);
                    if (option2 == null) {
                        throw new CLIPException("Invalid option: " + shortOptionName, i);
                    }
                    if (option2._type != 0) {
                        throw new CLIPException("Not an boolean option: " + shortOptionName, i);
                    }
                    String optionValue3 = "true";
                    List values3 = this.getOptionValues(subCommand, map, shortOptionName);
                    values3.clear();
                    values3.add(optionValue3);
                }
                optionName = "" + optionName.charAt(optionName.length() - 1);
                option = (Option)subCommand._validOptions.get(optionName);
                if (option == null) {
                    throw new CLIPException("Invalid option: " + optionName, i);
                }
                if (option._type == 0) {
                    optionValue = "true";
                    values = this.getOptionValues(subCommand, map, optionName);
                    values.clear();
                    values.add(optionValue);
                } else {
                    if (option._type != 1) throw new CLIPException("CLIPParser - Internal error", i);
                    if (i + 1 == args.length) {
                        throw new CLIPException("Missing value for regular option: " + optionName, i);
                    }
                    optionValue = args[++i];
                    values = this.getOptionValues(subCommand, map, optionName);
                    values.clear();
                    values.add(optionValue);
                }
            } else {
                allOptionsProcessed = true;
            }
            ++i;
        }
        if (!allOptionsProcessed) return i;
        --i;
        return i;
    }

    private List getOptionValues(SubCommand subCommand, Map map, String optionName) {
        Option option = (Option)subCommand._validOptions.get(optionName);
        String longName = option._longName;
        ArrayList list = (ArrayList)map.get(longName);
        if (list == null) {
            list = new ArrayList();
            map.put(longName, list);
        }
        return list;
    }

    private Map massageOptions(Map map) {
        Iterator i = map.keySet().iterator();
        while (i.hasNext()) {
            String option = (String)i.next();
            List values = (List)map.get(option);
            String[] arrayValues = new String[values.size()];
            values.toArray(arrayValues);
            map.put(option, arrayValues);
        }
        return map;
    }

    public static String getName(String element) {
        String name = element;
        int index = element.indexOf("=");
        if (index > -1) {
            name = element.substring(0, index);
        }
        return name;
    }

    public static String getValue(String element) {
        String value = null;
        int index = element.indexOf("=");
        if (index > -1) {
            value = element.substring(index + 1);
        }
        return value;
    }

    public String toString(String[] args) throws CLIPException {
        StringBuffer sb = new StringBuffer(1024);
        String subCmd = this.getSubCommand(args);
        Map options = this.getOptions(args);
        String[] operands = this.getOperands(args);
        sb.append("\n").append("Sub-command: ").append(subCmd).append("\n").append("\n").append("Options: ").append("\n");
        Iterator i = options.keySet().iterator();
        while (i.hasNext()) {
            String option = (String)i.next();
            String[] values = (String[])options.get(option);
            sb.append(("  " + option + "              ").substring(0, 12) + ": ");
            for (int j = 0; j < values.length; ++j) {
                sb.append(values[j]).append(" ");
            }
            sb.append("\n");
        }
        sb.append("\n").append("Operands: ").append("\n");
        for (int j = 0; j < operands.length; ++j) {
            sb.append("  ").append(operands[j]).append("\n");
        }
        sb.append("\n");
        return sb.toString();
    }

    public boolean needsHelp(String[] args) {
        boolean help = false;
        try {
            this.verifyArguments(args);
            Map options = this.getOptions(args);
            help = options.containsKey("help") && ((String[])options.get("help"))[0].equals("true");
        }
        catch (CLIPException ex) {
            help = true;
        }
        return help;
    }

    public String getHelp(String[] args) {
        SubCommand subCommand;
        boolean fullHelp = false;
        String firstArgument = args.length > 0 ? args[0] : null;
        boolean bl = fullHelp = !this._subCommands.containsKey(firstArgument);
        if (!fullHelp) {
            subCommand = (SubCommand)this._subCommands.get(firstArgument);
        } else {
            subCommand = (SubCommand)this._subCommands.get(null);
            fullHelp = subCommand == null || subCommand._subCommandName != null;
        }
        StringBuffer sb = new StringBuffer(2048);
        if (fullHelp) {
            sb.append("Usage: " + this._commandName + " SUBCOMMAND ARGUMENTS\n\n");
            sb.append(this._commandHelpMessage).append("\n\n");
            sb.append("The accepted values for SUBCOMMAND are:\n\n");
            int size = this._orderedSubCommands.size();
            for (int i = 0; i < size; ++i) {
                subCommand = (SubCommand)this._orderedSubCommands.get(i);
                String name = subCommand._subCommandName;
                name = name == null ? "<NO SUB COMMAND>  " : name + "\t";
                sb.append(name).append(subCommand._subCommandHelp).append(".\n");
            }
        } else {
            sb.append("Usage: " + this._commandName + " " + subCommand._subCommandName + " [OPTIONS...]\n\n");
            sb.append(subCommand._subCommandHelp).append(".\n\n");
            this.doOptionsHelp(sb, "", subCommand._orderedOptions);
            if (subCommand._maxOperands > 0) {
                if (subCommand._maxOperands == 1) {
                    sb.append("\nOPERAND\n");
                } else {
                    sb.append("\nOPERANDS\n");
                }
                sb.append("  ").append(subCommand._operandsHelp).append("\n");
            }
        }
        return sb.toString();
    }

    public boolean needsVersion(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals("-V") && !args[i].equals("--version")) continue;
            return true;
        }
        return false;
    }

    private void doOptionsHelp(StringBuffer sb, String padding, List options) {
        int size = options.size();
        for (int i = 0; i < size; ++i) {
            Option option = (Option)options.get(i);
            sb.append(padding);
            if (option._shortName != null) {
                sb.append('-').append(option._shortName);
                if (option._argName != null) {
                    sb.append(" ").append(option._argName);
                }
                sb.append(", ");
            }
            sb.append("--").append(option._longName);
            if (option._argName != null) {
                sb.append("=").append(option._argName).append("\n\t");
            }
            sb.append("\t").append(option._helpMessage).append(" (");
            if (option._defaultValues == null) {
                sb.append("none");
            } else {
                for (int j = 0; j < option._defaultValues.length; ++j) {
                    if (j > 0) {
                        sb.append(' ');
                    }
                    sb.append(option._defaultValues[j]);
                }
            }
            sb.append(")\n\n");
        }
    }

    public static class SubCommand {
        private String _subCommandName;
        private List _orderedOptions;
        private Map _validOptions;
        private Map _defaultOptionValues;
        private int _minOperands;
        private int _maxOperands;
        private String _subCommandHelp;
        private String _operandsHelp;

        public SubCommand(String name, Option[] options, int minOperands, int maxOperands, String subCommandHelp, String operandsHelp) throws IllegalArgumentException {
            int i;
            if (name != null) {
                CLIPParser.verifyName(name, "CLIPParser - Sub command");
            }
            this._subCommandName = name;
            this._validOptions = new HashMap();
            this._orderedOptions = new ArrayList();
            if (options != null) {
                for (i = 0; i < options.length; ++i) {
                    if (options[i] == null) {
                        throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', option instances can not be NULL");
                    }
                    if (this._validOptions.containsKey(options[i]._longName)) {
                        throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', option long names can not be duplicated within a CLIPParser instance");
                    }
                    this._validOptions.put(options[i]._longName, options[i]);
                    this._orderedOptions.add(options[i]);
                    if (options[i]._shortName == null) continue;
                    if (this._validOptions.containsKey(options[i]._shortName)) {
                        throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', option short names can not be duplicated within a CLIPParser instance");
                    }
                    this._validOptions.put(options[i]._shortName, options[i]);
                }
            }
            this._defaultOptionValues = new HashMap();
            if (options != null) {
                for (i = 0; i < options.length; ++i) {
                    String[] defaultValues = options[i]._defaultValues;
                    if (defaultValues == null) continue;
                    ArrayList<String> l = new ArrayList<String>();
                    for (int j = 0; j < defaultValues.length; ++j) {
                        l.add(defaultValues[j]);
                    }
                    this._defaultOptionValues.put(options[i]._longName, l);
                }
            }
            if (minOperands < 0) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', minimum number of operands can not be less than zero");
            }
            this._minOperands = minOperands;
            if (minOperands > maxOperands) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', maximum number of operands can not be less than minimum number of operands");
            }
            this._maxOperands = maxOperands;
            if (subCommandHelp == null) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', sub command help can not be NULL");
            }
            this._subCommandHelp = subCommandHelp;
            if (operandsHelp == null) {
                throw new IllegalArgumentException("CLIPParser.SubCommand - Sub command '" + name + "', operands help can not be NULL");
            }
            this._operandsHelp = operandsHelp;
        }
    }

    public static class Option {
        private String _longName;
        private String _shortName;
        private boolean _mandatory;
        private int _type;
        private String _argName = null;
        private String[] _defaultValues;
        private String _helpMessage;

        public Option(String longName, String shortName, int type, String defaultValues, String argName, String helpMessage) throws IllegalArgumentException {
            CLIPParser.verifyName(longName, "CLIPParser.Option - Option's long name");
            this._longName = longName;
            if (shortName != null && shortName.length() > 1) {
                throw new IllegalArgumentException("CLIPParser.Option - Option's short name has to be undefined (NULL) or one character long");
            }
            if (shortName != null && shortName.equals("-")) {
                throw new IllegalArgumentException("CLIPParser.Option - Option's short name can not be '-'");
            }
            this._shortName = shortName;
            this._mandatory = defaultValues == null;
            this._argName = argName;
            if (helpMessage == null) {
                throw new IllegalArgumentException("CLIPParser.Option - Option's help can not be NULL");
            }
            this._helpMessage = helpMessage;
            this._type = type;
            switch (type) {
                case 0: {
                    if (defaultValues == null) break;
                    if (!defaultValues.equals("true") && !defaultValues.equals("false")) {
                        throw new IllegalArgumentException("CLIPParser.Option - Boolean default value has to be 'true' or 'false'");
                    }
                    this._defaultValues = new String[1];
                    this._defaultValues[0] = defaultValues;
                    break;
                }
                case 1: {
                    if (defaultValues == null) break;
                    this._defaultValues = new String[1];
                    this._defaultValues[0] = defaultValues;
                    break;
                }
                case 2: {
                    if (shortName != null) {
                        throw new IllegalArgumentException("CLIPParser.Option - Collection options can not have short names");
                    }
                    if (defaultValues == null) break;
                    ArrayList<String> l = new ArrayList<String>();
                    String tokenSeparator = defaultValues.indexOf(" ") > -1 ? " " : ",";
                    StringTokenizer tokens = new StringTokenizer(defaultValues, tokenSeparator);
                    while (tokens.hasMoreTokens()) {
                        String token = tokens.nextToken();
                        l.add(token);
                    }
                    this._defaultValues = new String[l.size()];
                    l.toArray(this._defaultValues);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("CLIPParser.Option - Invalid type");
                }
            }
        }

        public Option(String longName, String shortName, int type, String defaultValues, String helpMessage) throws IllegalArgumentException {
            this(longName, shortName, type, defaultValues, null, helpMessage);
        }
    }
}

