/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.admin.model;

import com.iplanet.am.console.base.model.AMConsoleException;
import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.sso.SSOException;
import com.sun.identity.sm.SchemaType;
import com.sun.portal.wsrp.consumer.admin.model.WSRPConsumerServiceModel;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import com.sun.portal.wsrp.consumer.producermanager.impl.ISConsumerMultiPortalConstants;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class WSRPConsumerServiceModelImpl
extends AMModelBase
implements WSRPConsumerServiceModel {
    public static final String CLASS_NAME = "WSRPConsumerServiceModelImpl.";
    public static final String LOAD_PRODUCER = "WSRPConsumerServiceModelImpl.loadProducer(): ";
    public static final String HAS_TEMPLATE = "WSRPConsumerServiceModelImpl.hasTemplate(): ";
    public static final String STORE = "WSRPConsumerServiceModelImpl.store(): ";
    protected HttpServletRequest request = null;
    protected String consumerName = "WSRP Consumer";
    protected boolean status = false;
    ProducerEntityManager pem = null;

    public WSRPConsumerServiceModelImpl(HttpServletRequest req, String rbName, Map map) throws AMConsoleException {
        super(req, rbName, map);
        this.request = req;
        this.loadConsumer(req);
    }

    private void loadConsumer(HttpServletRequest req) {
        try {
            this.pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getLocationDN(), req);
            this.consumerName = this.pem.getConsumerName();
        }
        catch (Exception e) {
            this.debugError(LOAD_PRODUCER, e);
        }
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }

    public boolean hasTemplate() {
        AMTemplate template = null;
        try {
            ISConsumerMultiPortalConstants iscmpc = ISConsumerMultiPortalConstants.getInstance();
            template = this.getServiceTemplate(iscmpc.MP_SERVICE_WSRP_CONSUMER, SchemaType.ORGANIZATION);
        }
        catch (AMException e) {
            this.debugError(HAS_TEMPLATE, (Exception)((Object)e));
        }
        catch (SSOException e) {
            this.debugError(HAS_TEMPLATE, (Exception)((Object)e));
        }
        return template != null;
    }

    public void setConsumerName(String name) throws AMConsoleException {
        this.consumerName = name;
    }

    public void setConsumerStatus(boolean enable) throws AMConsoleException {
        this.status = enable;
    }

    public String getConsumerName() throws AMConsoleException {
        return this.consumerName;
    }

    public boolean getConsumerStatus() throws AMConsoleException {
        return this.status;
    }

    public void store() throws AMConsoleException {
        try {
            this.pem.setConsumerName(this.consumerName);
        }
        catch (Exception e) {
            this.debugError(STORE, e);
            throw new AMConsoleException((Throwable)e);
        }
    }
}

