/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.admin.model;

import com.iplanet.am.console.base.model.AMModelBase;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.sso.SSOException;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.stubs.ItemDescription;
import com.sun.portal.wsrp.common.stubs.LocalizedString;
import com.sun.portal.wsrp.common.stubs.ModelDescription;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.Property;
import com.sun.portal.wsrp.common.stubs.PropertyDescription;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.admin.model.ProducerModel;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ProducerModelImpl
extends AMModelBase
implements ProducerModel {
    public static final String ROLE_MAP = "roleMap";
    public static final String CLASS_NAME = "ProducerModelImpl.";
    public static final String GET_NAME = "ProducerModelImpl.getName(): ";
    public static final String GET_STATUS = "ProducerModelImpl.getStatus(): ";
    public static final String GET_WSDL = "ProducerModelImpl.getWSDL(): ";
    public static final String GET_ID = "ProducerModelImpl.getID(): ";
    public static final String GET_PE_STATUS = "ProducerModelImpl.getPEStatus(): ";
    public static final String SET_PE_STATUS = "ProducerModelImpl.setPEStatus(): ";
    public static final String LOAD_PRODUCER = "ProducerModelImpl.loadProducer(): ";
    public static final String RELOAD_PRODUCER = "ProducerModelImpl.reloadProducer(): ";
    public static final String IS_INBAND_REGISTRATION_SUPPORTED = "ProducerModelImpl.isInbandRegistrationSupported(): ";
    public static final String UPDATE_SERVICE_DESCRIPTION = "ProducerModelImpl.updateServiceDescription(): ";
    public static final String GET_ALL_ROLES = "ProducerModelImpl.getAllRoles(): ";
    public static final String SET_USER_CATEGORY_MAPPING = "ProducerModelImpl.setUserCategoryMapping(): ";
    public static final String SET_REGISTRATION_PROPERTIES = "ProducerModelImpl.setRegistrationProperties(): ";
    private Map pageSessionAttributes = null;
    private ProducerEntityManager pem = null;
    private ProducerEntity pe = null;
    String[] portletNames = null;
    String[] portletHandlers = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$admin$model$ProducerModelImpl == null ? (class$com$sun$portal$wsrp$consumer$admin$model$ProducerModelImpl = ProducerModelImpl.class$("com.sun.portal.wsrp.consumer.admin.model.ProducerModelImpl")) : class$com$sun$portal$wsrp$consumer$admin$model$ProducerModelImpl));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$admin$model$ProducerModelImpl;

    public ProducerModelImpl(HttpServletRequest req, String rbName, Map map) {
        super(req, rbName, map);
        this.loadProducer(req, map);
    }

    public ProducerModelImpl(HttpServletRequest req, String rbName, Map map, String producerHandle) {
        super(req, rbName, map);
        this.loadProducer(req, producerHandle);
    }

    private void loadProducer(HttpServletRequest req, Map map) {
        String id = req.getParameter("ProducerID");
        if (id == null) {
            id = (String)map.get("ProducerID");
        }
        this.loadProducer(req, id);
        this.pageSessionAttributes = map;
    }

    private void loadProducer(HttpServletRequest req, String id) {
        block6: {
            try {
                this.pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(this.getAMObject(this.getLocationDN()).getOrganizationDN(), req);
                if (id != null) {
                    if (logger.isLoggable(Level.FINEST)) {
                        Object[] param = new String[]{"ProducerID", id};
                        logger.log(Level.FINEST, "PSWS_CSPWCAM0003", param);
                    }
                    this.pe = this.pem.getProducerEntity(id);
                } else if (logger.isLoggable(Level.FINEST)) {
                    Object[] param = new String[]{"ProducerID", "null"};
                    logger.log(Level.FINEST, "PSWS_CSPWCAM0003", param);
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.SEVERE)) break block6;
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0008", e);
            }
        }
    }

    private void reloadProducer(String id) {
        block2: {
            try {
                this.pe = this.pem.getProducerEntity(id);
            }
            catch (WSRPConsumerException e) {
                this.pe = null;
                if (!logger.isLoggable(Level.SEVERE)) break block2;
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0009", (Throwable)((Object)e));
            }
        }
    }

    public String getHelpAnchorTag(String key) {
        return super.getHelpAnchorTag(key);
    }

    public String getName() throws ModelControlException {
        try {
            if (this.pe != null) {
                return this.pe.getName();
            }
            return "";
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0004", e);
            }
            throw new ModelControlException(e.getMessage());
        }
    }

    public String getStatus() throws ModelControlException {
        try {
            if (this.pe != null) {
                return this.pe.getStatus().toString();
            }
            return "";
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0005", e);
            }
            throw new ModelControlException(e.getMessage());
        }
    }

    public String getWSDL() throws ModelControlException {
        try {
            if (this.pe != null) {
                return this.pe.getURL().toString();
            }
            return "";
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0010", e);
            }
            throw new ModelControlException(e.getMessage());
        }
    }

    public String getID() throws ModelControlException {
        try {
            if (this.pe != null) {
                return this.pe.getId();
            }
            return "!!NEW";
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0006", e);
            }
            throw new ModelControlException(e.getMessage());
        }
    }

    public String getPEStatus() throws ModelControlException {
        try {
            if (this.pe != null) {
                return this.pe.getStatus().equals(ProducerEntityStatus.OK) ? "true" : "false";
            }
            return "false";
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "PSWS_CSPWCAM0005", e);
            }
            throw new ModelControlException(e.getMessage());
        }
    }

    public void setPEStatus(String status) throws ModelControlException {
        ProducerEntityStatus peStatus = Boolean.valueOf(status) != false ? ProducerEntityStatus.OK : ProducerEntityStatus.DISABLED;
        try {
            String id = this.getID();
            this.pem.setStatus(id, peStatus);
            this.reloadProducer(id);
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.INFO, "PSWS_CSPWCAM0013", (Throwable)((Object)e));
            throw new ModelControlException(e.getMessage());
        }
    }

    public boolean requiresRegistration() {
        boolean result = false;
        if (this.pe != null) {
            result = this.pe.getServiceDescription().isRequiresRegistration();
        }
        return result;
    }

    public boolean isInbandRegistrationSupported() {
        boolean result = false;
        if (this.pe != null) {
            try {
                result = this.pem.isInbandRegistrationSupported(this.pe.getURL());
            }
            catch (WSRPConsumerException e) {
                logger.log(Level.INFO, "PSWS_CSPWCAM0013", (Throwable)((Object)e));
                result = false;
            }
        }
        return result;
    }

    public String getServiceDescriptionLastUpdated() {
        long time = 0L;
        if (this.pe != null) {
            time = this.pe.getServiceDescriptionLastModified();
        }
        DateFormat df = DateFormat.getDateTimeInstance(0, 0, this.getUserLocale());
        return df.format(new Date(time));
    }

    public void updateServiceDescription() throws ModelControlException {
        try {
            String id = this.getID();
            this.pem.updateServiceDescription(id);
            this.reloadProducer(id);
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.INFO, "PSWS_CSPWCAM0013", (Throwable)((Object)e));
            throw new ModelControlException(e.getMessage());
        }
    }

    public String[] getAllRoles() throws ModelControlException {
        try {
            AMOrganization org = (AMOrganization)this.getAMObject(this.getLocationDN());
            Set roles = org.getRoles(1);
            return roles.toArray(new String[0]);
        }
        catch (AMException e) {
            logger.log(Level.INFO, "PSWS_CSPWCAM0013", e);
            throw new ModelControlException(e.getMessage());
        }
        catch (SSOException e) {
            logger.log(Level.INFO, "PSWS_CSPWCAM0013", e);
            throw new ModelControlException(e.getMessage());
        }
    }

    public Map getUserCategoryMapping() {
        ServiceDescription sd;
        ItemDescription[] ucs;
        HashMap<ItemDescription, Object> result = null;
        if (this.pageSessionAttributes != null) {
            result = (HashMap<ItemDescription, Object>)this.pageSessionAttributes.get(ROLE_MAP);
        }
        if (result == null && this.pe != null && (ucs = (sd = this.pe.getServiceDescription()).getUserCategoryDescriptions()) != null && ucs.length > 0) {
            Map ucMap = this.pe.getUserCategoryMapping();
            result = new HashMap<ItemDescription, Object>(ucs.length);
            for (int i = 0; i < ucs.length; ++i) {
                if (ucs[i] == null) continue;
                String uc = ucs[i].getItemName();
                result.put(ucs[i], ucMap == null ? null : (Object)ucMap.get(uc));
            }
        }
        return result;
    }

    public void setUserCategoryMapping(Map map) throws ModelControlException {
        HashMap ucMap = null;
        if (map != null) {
            ucMap = new HashMap(map.size());
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                ItemDescription uc = (ItemDescription)i.next();
                ucMap.put(uc.getItemName(), map.get(uc));
            }
        }
        try {
            String id = this.getID();
            this.pem.setUserCategoryMapping(id, ucMap);
            this.reloadProducer(id);
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.INFO, "PSWS_CSPWCAM0013", (Throwable)((Object)e));
            throw new ModelControlException(e.getMessage());
        }
    }

    public HashMap getRegistrationPropertyDescription() {
        PropertyDescription[] pds;
        ServiceDescription sd;
        ModelDescription md;
        HashMap<String, String> result = null;
        if (this.pe != null && (md = (sd = this.pe.getServiceDescription()).getRegistrationPropertyDescription()) != null && (pds = md.getPropertyDescriptions()) != null && pds.length > 0) {
            result = new HashMap<String, String>(pds.length);
            for (int i = 0; i < pds.length; ++i) {
                LocalizedString hint = pds[i].getHint();
                String desc = hint == null ? null : hint.getValue();
                result.put(pds[i].getName(), desc);
            }
        }
        return result;
    }

    public String getRegistrationHandle() {
        RegistrationContext rc;
        String result = null;
        if (this.pe != null && (rc = this.pe.getRegistrationContext()) != null) {
            result = rc.getRegistrationHandle();
        }
        return result;
    }

    public HashMap getRegistrationProperties() {
        Property[] properties;
        RegistrationData rd;
        HashMap<String, String> result = null;
        if (this.pe != null && (rd = this.pe.getRegistrationData()) != null && (properties = rd.getRegistrationProperties()) != null && properties.length > 0) {
            result = new HashMap<String, String>();
            for (int i = 0; i < properties.length; ++i) {
                result.put(properties[i].getName(), properties[i].getStringValue());
            }
        }
        return result;
    }

    public void setRegistrationProperties(Map map) throws ModelControlException {
        if (this.pe != null && map != null && map.size() > 0) {
            String lang = this.getUserLocale().toString().replace('_', '-');
            Property[] properties = new Property[map.size()];
            int index = 0;
            Iterator i = map.keySet().iterator();
            while (i.hasNext()) {
                String name = (String)i.next();
                String value = (String)map.get(name);
                properties[index] = new Property(name, lang, value, null);
                ++index;
            }
            try {
                RegistrationData regData = this.pe.getRegistrationData();
                if (regData == null) {
                    regData = this.pem.getDefaultRegistrationData();
                }
                regData.setRegistrationProperties(properties);
                String id = this.getID();
                this.pem.modifyRegistration(id, regData);
                this.reloadProducer(id);
            }
            catch (WSRPConsumerException e) {
                logger.log(Level.INFO, "PSWS_CSPWCAM0013", (Throwable)((Object)e));
                throw new ModelControlException(e.getMessage());
            }
        }
    }

    private void getPortlet() {
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> handlers = new ArrayList<String>();
        if (this.pe != null) {
            ServiceDescription sd = this.pe.getServiceDescription();
            PortletDescription[] portlets = sd.getOfferedPortlets();
            logger.log(Level.FINER, "PSWS_CSPWCAM0011", Integer.toString(portlets.length));
            for (int i = 0; i < portlets.length; ++i) {
                Boolean usesMethodGet = portlets[i].getUsesMethodGet();
                if (usesMethodGet != null && usesMethodGet.booleanValue()) continue;
                LocalizedString name = portlets[i].getDisplayName();
                String handle = portlets[i].getPortletHandle();
                if (name != null && name.getValue() != null) {
                    logger.log(Level.FINER, "PSWS_CSPWCAM0012", name.getValue());
                    names.add(name.getValue());
                } else {
                    names.add(handle);
                }
                handlers.add(handle);
            }
            this.portletNames = names.toArray(new String[0]);
            this.portletHandlers = handlers.toArray(new String[0]);
        }
    }

    public String[] getPortletNames() {
        if (this.portletNames == null) {
            this.getPortlet();
        }
        return this.portletNames;
    }

    public String[] getPortletHandlers() {
        if (this.portletHandlers == null) {
            this.getPortlet();
        }
        return this.portletHandlers;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

