/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.admin.mbeans;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.ResourceLoader;
import com.sun.portal.wsrp.WSRPException;
import com.sun.portal.wsrp.common.registry.RegistryConfiguration;
import com.sun.portal.wsrp.common.registry.RegistryManager;
import com.sun.portal.wsrp.common.registry.RegistryManagerFactory;
import com.sun.portal.wsrp.common.registry.RegistryQueryManager;
import com.sun.portal.wsrp.common.registry.ebxml.TypeConverter;
import com.sun.portal.wsrp.consumer.admin.mbeans.RegistrySearchMBean;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import com.sun.ssoadapter.SSOAdapterFactory;
import com.sun.ssoadapter.SSOAdapterSession;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RegistrySearch
extends PSResource
implements RegistrySearchMBean {
    private String portalId = null;
    public static final char TAB = '\t';
    private Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$admin$mbeans$RegistrySearch == null ? (class$com$sun$portal$wsrp$consumer$admin$mbeans$RegistrySearch = RegistrySearch.class$("com.sun.portal.wsrp.consumer.admin.mbeans.RegistrySearch")) : class$com$sun$portal$wsrp$consumer$admin$mbeans$RegistrySearch));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$admin$mbeans$RegistrySearch;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.portalId = (String)path.get(1);
    }

    public Set searchProducer(String name, String description) throws PSMBeanException {
        this.setClassLoader();
        try {
            RegistryManager rm = this.getRegistryManager();
            RegistryQueryManager rqm = rm.getRegistryQueryManager();
            List results = rqm.searchProducer(name, description);
            return TypeConverter.convertProducerToBasic((List)results);
        }
        catch (WSRPException we) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0030", we);
            throw new PSMBeanException(we.getMessage());
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0030", t);
            throw new PSMBeanException(t.getMessage());
        }
    }

    public Set searchPortlet(String name, String description) throws PSMBeanException {
        this.setClassLoader();
        try {
            RegistryManager rm = this.getRegistryManager();
            RegistryQueryManager rqm = rm.getRegistryQueryManager();
            List results = rqm.searchPortlet(name, description);
            return TypeConverter.convertPortletToBasic((List)results);
        }
        catch (WSRPException we) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0030", we);
            throw new PSMBeanException(we.getMessage());
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0030", t);
            throw new PSMBeanException(t.getMessage());
        }
    }

    public Set searchOrganization(String name, String description) throws PSMBeanException {
        this.setClassLoader();
        try {
            RegistryManager rm = this.getRegistryManager();
            RegistryQueryManager rqm = rm.getRegistryQueryManager();
            List results = rqm.searchOrganization(name, description);
            return TypeConverter.convertOrgToBasic((List)results);
        }
        catch (WSRPException we) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0030", we);
            throw new PSMBeanException(we.getMessage());
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0030", t);
            throw new PSMBeanException(t.getMessage());
        }
    }

    public Set searchOrganization(Properties orgdata) throws PSMBeanException {
        String name = null;
        String description = null;
        Object value = orgdata.get("organization.name");
        if (value != null) {
            name = value.toString();
        }
        if ((value = orgdata.get("organization.description")) != null) {
            description = value.toString();
        }
        return this.searchOrganization(name, description);
    }

    public Set searchPortlet(Properties portletdata) throws PSMBeanException {
        String name = null;
        String description = null;
        Object value = portletdata.get("portlet.name");
        if (value != null) {
            name = value.toString();
        }
        if ((value = portletdata.get("portlet.description")) != null) {
            description = value.toString();
        }
        return this.searchPortlet(name, description);
    }

    public Set searchProducer(Properties producerdata) throws PSMBeanException {
        String name = null;
        String description = null;
        Object value = producerdata.get("producer.name");
        if (value != null) {
            name = value.toString();
        }
        if ((value = producerdata.get("producer.description")) != null) {
            description = value.toString();
        }
        return this.searchProducer(name, description);
    }

    private RegistryManager getRegistryManager() throws Exception {
        RegistryManagerFactory rf = RegistryManagerFactory.getInstance();
        Properties resource = this.getRegistryResource();
        RegistryConfiguration config = new RegistryConfiguration(resource);
        return rf.getRegistryManager("ebXML", config);
    }

    private Properties getRegistryProperties() throws WSRPException {
        ResourceLoader resourceLoader = null;
        Properties properties = null;
        resourceLoader = this.portalId == null ? ResourceLoader.getInstance((Properties)System.getProperties()) : ResourceLoader.getInstance((String)this.portalId);
        try {
            properties = resourceLoader.getProperties("wsrpregistry.properties");
        }
        catch (FileNotFoundException fnfe) {
            throw new WSRPException("Registry Config not found: ", (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw new WSRPException("Cannot load registry config file: ", (Throwable)ioe);
        }
        return properties;
    }

    private Properties getRegistryResource() throws WSRPException {
        Properties prop = null;
        try {
            prop = this.getRegistryProperties();
            SSOToken token = AdminServerUtil.getSSOToken();
            SSOAdapterSession session = new SSOAdapterSession(token);
            SSOAdapterFactory ssoFact = SSOAdapterFactory.getInstance();
            SSOAdapter adapter = ssoFact.getSSOAdapter("sunRegistryServer", session);
            prop.putAll((Map<?, ?>)adapter.getProperties());
        }
        catch (SSOAdapterException e) {
            this.logger.log(Level.SEVERE, "PSWS_CSPWCAB0031", e);
            throw new WSRPException("Cannot load registry config file: ", (Throwable)e);
        }
        return prop;
    }

    private void setClassLoader() {
        ClassLoader cl = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

