/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.admin.mbeans;

import com.iplanet.am.util.Locale;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.fabric.common.GenericDSAMEAttributeHandler;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.wsrp.common.stubs.ItemDescription;
import com.sun.portal.wsrp.common.stubs.LocalizedString;
import com.sun.portal.wsrp.common.stubs.ModelDescription;
import com.sun.portal.wsrp.common.stubs.Property;
import com.sun.portal.wsrp.common.stubs.PropertyDescription;
import com.sun.portal.wsrp.common.stubs.RegistrationContext;
import com.sun.portal.wsrp.common.stubs.RegistrationData;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.admin.mbeans.AMHelper;
import com.sun.portal.wsrp.consumer.admin.mbeans.ConsumerAttributes;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerBootstrap;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConsumerAttributeHandler
extends GenericDSAMEAttributeHandler {
    public static final String LANG = Locale.getDefaultLocale().toString().replace('_', '-');
    private static ProducerEntityManagerFactory pemFactory = ProducerEntityManagerFactory.getInstance();
    private String wsrpConsumerConfigFileName = "wsrpconsumerconfig.properties";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$admin$mbeans$ConsumerAttributeHandler == null ? (class$com$sun$portal$wsrp$consumer$admin$mbeans$ConsumerAttributeHandler = ConsumerAttributeHandler.class$("com.sun.portal.wsrp.consumer.admin.mbeans.ConsumerAttributeHandler")) : class$com$sun$portal$wsrp$consumer$admin$mbeans$ConsumerAttributeHandler));
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$admin$mbeans$ConsumerAttributeHandler;

    public void init(String component, String domainId, String portalId) throws PSMBeanException {
        if (portalId == null) {
            logger.severe("PSWS_CSPWCAB0029");
            throw new PSMBeanException("Missing portal Id.");
        }
        super.init(component, domainId, portalId);
        WSRPConsumerBootstrap.cliInitialized(this.wsrpConsumerConfigFileName, portalId);
    }

    public String getAttributeName(String userFriendlyName) {
        return "sunPortalWSRPConsumer" + userFriendlyName;
    }

    public String getComponentName(String userFriendlyName) {
        return "SunPortal" + this.portalId + "WSRPConsumerService";
    }

    public List getAttribute(Map optionsMap) throws PSMBeanException {
        String name = (String)optionsMap.get("attribute-name");
        optionsMap.put("attribute-names", Collections.singleton(name));
        return (List)this.getAttributes(optionsMap).get(name);
    }

    public Map getAttributes(Map optionsMap) throws PSMBeanException {
        String producerID = (String)optionsMap.get("producer");
        if (producerID == null) {
            return this.getConsumerAttributes(optionsMap);
        }
        return this.getPEAttributes(optionsMap, producerID);
    }

    public void setAttribute(List values, Map optionsMap) throws PSMBeanException {
        String name = (String)optionsMap.get("attribute-name");
        this.setAttributes(Collections.singletonMap(name, values), optionsMap);
    }

    public void setAttributes(Map nameValues, Map optionsMap) throws PSMBeanException {
        String producerID = (String)optionsMap.get("producer");
        if (producerID == null) {
            this.setConsumerAttributes(nameValues, optionsMap);
        } else {
            this.setPEAttributes(nameValues, optionsMap, producerID);
        }
    }

    public Map listAttributes(Map optionsMap) throws PSMBeanException {
        String cp = (String)optionsMap.get("configuredproducer");
        if (Boolean.valueOf(cp).booleanValue()) {
            return ConsumerAttributes.PE_MAP;
        }
        return ConsumerAttributes.CONSUMER_MAP;
    }

    private Map getConsumerAttributes(Map optionsMap) throws PSMBeanException {
        Set names = (Set)optionsMap.get("attribute-names");
        HashMap<String, List> result = new HashMap<String, List>(names.size());
        Iterator i = names.iterator();
        while (i.hasNext()) {
            String name = (String)i.next();
            optionsMap.put("attribute-name", name);
            if (name.equals("IsDisabled")) {
                optionsMap.put("global", Boolean.TRUE.toString());
            } else if (name.equals("UserProfileMapping")) {
                optionsMap.put("global", Boolean.TRUE.toString());
            } else if (name.equals("Name")) {
                optionsMap.put("org", Boolean.TRUE.toString());
            } else {
                logger.log(Level.WARNING, "PSWS_CSPWCAB0016", name);
                throw new PSMBeanException("No such consumer attribute: " + name);
            }
            result.put(name, super.getAttribute(optionsMap));
        }
        return result;
    }

    private Map getPEAttributes(Map optionsMap, String producerID) throws PSMBeanException {
        Set names = (Set)optionsMap.get("attribute-names");
        HashMap<String, List<String>> result = new HashMap<String, List<String>>(names.size());
        String orgDN = (String)optionsMap.get("dn");
        if (orgDN == null) {
            logger.severe("PSWS_CSPWCAB0017");
            throw new PSMBeanException("Missing organization DN.");
        }
        ProducerEntityManager pem = this.getPEM(orgDN);
        ProducerEntity pe = null;
        try {
            pe = pem.getProducerEntity(producerID);
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0018", (Throwable)((Object)e));
            throw new PSMBeanException("getPE error", e.getMessage());
        }
        Iterator i = names.iterator();
        while (i.hasNext()) {
            Map.Entry entry;
            String name = (String)i.next();
            if (name.equals("Name")) {
                result.put(name, Collections.singletonList(pe.getName()));
                continue;
            }
            if (name.equals("Enabled")) {
                ProducerEntityStatus status = pe.getStatus();
                boolean enabled = status.equals(ProducerEntityStatus.OK);
                result.put(name, Collections.singletonList(Boolean.toString(enabled)));
                continue;
            }
            if (name.equals("WSDL_URL")) {
                result.put(name, Collections.singletonList(pe.getURL().toString()));
                continue;
            }
            if (name.equals("ServiceDescriptionLastUpdated")) {
                long time = pe.getServiceDescriptionLastModified();
                result.put(name, Collections.singletonList(Long.toString(time)));
                continue;
            }
            if (name.equals("IdentityPropagationType")) {
                result.put(name, Collections.singletonList(pe.getIdentityPropagationType()));
                continue;
            }
            if (name.equals("AllRoles")) {
                try {
                    Map allRoles = AMHelper.getAllRoles(orgDN);
                    Set entrySet = allRoles.entrySet();
                    ArrayList<String> roles = new ArrayList<String>(entrySet.size());
                    Iterator j = entrySet.iterator();
                    while (j.hasNext()) {
                        StringBuffer sb = new StringBuffer();
                        entry = j.next();
                        sb.append(entry.getKey());
                        sb.append(":");
                        sb.append(entry.getValue());
                        roles.add(sb.toString());
                    }
                    result.put(name, roles);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSWS_CSPWCAB0019", e);
                    throw new PSMBeanException("wsrp.consumer", e.getMessage());
                }
            }
            if (name.equals("UserCategoryDescriptions")) {
                ArrayList<String> userCategoryDescriptions = new ArrayList<String>();
                ServiceDescription sd = pe.getServiceDescription();
                ItemDescription[] ucds = sd.getUserCategoryDescriptions();
                if (ucds != null) {
                    for (int j = 0; j < ucds.length; ++j) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(ucds[j].getItemName());
                        sb.append("=");
                        LocalizedString description = ucds[j].getDescription();
                        if (description != null) {
                            sb.append(description.getValue());
                        }
                        userCategoryDescriptions.add(sb.toString());
                    }
                }
                result.put(name, userCategoryDescriptions);
                continue;
            }
            if (name.equals("UserCategoryMapping")) {
                ArrayList<String> ucm = Collections.EMPTY_LIST;
                Map userCategoryMapping = pe.getUserCategoryMapping();
                if (userCategoryMapping != null) {
                    Set entrySet = userCategoryMapping.entrySet();
                    ucm = new ArrayList<String>(entrySet.size());
                    Iterator j = entrySet.iterator();
                    while (j.hasNext()) {
                        StringBuffer sb = new StringBuffer();
                        entry = j.next();
                        sb.append(entry.getKey());
                        sb.append("=");
                        List values = (List)entry.getValue();
                        if (values != null && values.size() > 0) {
                            sb.append(values.get(0));
                            for (int k = 1; k < values.size(); ++k) {
                                sb.append("|");
                                sb.append(values.get(k));
                            }
                        }
                        ucm.add(sb.toString());
                    }
                }
                result.put(name, ucm);
                continue;
            }
            if (name.equals("RegistrationRequired")) {
                boolean required = pe.getServiceDescription().isRequiresRegistration();
                result.put(name, Collections.singletonList(Boolean.toString(required)));
                continue;
            }
            if (name.equals("RegistrationHandle")) {
                String handle = null;
                RegistrationContext rc = pe.getRegistrationContext();
                if (rc != null) {
                    handle = rc.getRegistrationHandle();
                }
                result.put(name, Collections.singletonList(handle == null ? "" : handle));
                continue;
            }
            if (name.equals("RegistrationPropertyDescription")) {
                PropertyDescription[] pds;
                ArrayList<String> rpds = new ArrayList<String>();
                ServiceDescription sd = pe.getServiceDescription();
                ModelDescription md = sd.getRegistrationPropertyDescription();
                if (md != null && (pds = md.getPropertyDescriptions()) != null) {
                    for (int j = 0; j < pds.length; ++j) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(pds[j].getName());
                        sb.append("=");
                        LocalizedString hint = pds[j].getHint();
                        if (hint != null) {
                            sb.append(hint.getValue());
                        }
                        rpds.add(sb.toString());
                    }
                }
                result.put(name, rpds);
                continue;
            }
            if (name.equals("RegistrationProperties")) {
                Property[] rps;
                ArrayList<String> registrationProperties = Collections.EMPTY_LIST;
                RegistrationData regData = pe.getRegistrationData();
                if (regData != null && (rps = regData.getRegistrationProperties()) != null) {
                    registrationProperties = new ArrayList<String>(rps.length);
                    for (int j = 0; j < rps.length; ++j) {
                        StringBuffer sb = new StringBuffer();
                        sb.append(rps[j].getName());
                        sb.append("=");
                        sb.append(rps[j].getStringValue());
                        registrationProperties.add(sb.toString());
                    }
                }
                result.put(name, registrationProperties);
                continue;
            }
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0020", name);
            throw new PSMBeanException("No such configured producer attribute: " + name);
        }
        return result;
    }

    private void setConsumerAttributes(Map nameValues, Map optionsMap) throws PSMBeanException {
        Iterator i = nameValues.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry attribute = i.next();
            String name = (String)attribute.getKey();
            List values = (List)attribute.getValue();
            if (name.equals("IsDisabled")) {
                optionsMap.put("global", Boolean.TRUE.toString());
            } else if (name.equals("UserProfileMapping")) {
                optionsMap.put("global", Boolean.TRUE.toString());
            } else if (name.equals("Name")) {
                optionsMap.put("org", Boolean.TRUE.toString());
            } else {
                logger.log(Level.SEVERE, "PSWS_CSPWCAB0021", name);
                throw new PSMBeanException("No such consumer attribute: " + name);
            }
            super.setAttribute(values, optionsMap);
        }
    }

    private void setPEAttributes(Map nameValues, Map optionsMap, String producerID) throws PSMBeanException {
        boolean add = optionsMap.containsKey("add");
        boolean remove = optionsMap.containsKey("remove");
        boolean set = !add && !remove;
        String orgDN = (String)optionsMap.get("dn");
        if (orgDN == null) {
            throw new PSMBeanException("Missing organization DN.");
        }
        ProducerEntityManager pem = this.getPEM(orgDN);
        try {
            Iterator i = nameValues.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry attribute = i.next();
                String name = (String)attribute.getKey();
                List values = (List)attribute.getValue();
                if (name.equals("Name")) {
                    this.checkSingleton(name, values, set);
                    pem.setName(producerID, (String)values.get(0));
                    continue;
                }
                if (name.equals("IdentityPropagationType")) {
                    this.checkSingleton(name, values, set);
                    pem.setIdentityPropagationType(producerID, (String)values.get(0));
                    continue;
                }
                if (name.equals("Enabled")) {
                    boolean enabled = Boolean.valueOf((String)values.get(0));
                    ProducerEntityStatus status = enabled ? ProducerEntityStatus.OK : ProducerEntityStatus.DISABLED;
                    pem.setStatus(producerID, status);
                    continue;
                }
                if (name.equals("WSDL_URL")) {
                    throw new PSMBeanException("WSDL_URL is a read-only attribute.");
                }
                if (name.equals("ServiceDescriptionLastUpdated")) {
                    throw new PSMBeanException("ServiceDescriptionLastUpdated is a read-only attribute.");
                }
                if (name.equals("AllRoles")) {
                    throw new PSMBeanException("AllRoles is a read-only attribute.");
                }
                if (name.equals("UserCategoryDescriptions")) {
                    throw new PSMBeanException("UserCategoryDescriptions is a read-only attribute.");
                }
                if (name.equals("UserCategoryMapping")) {
                    HashMap<String, ArrayList<Object>> userCategoryMap = null;
                    ProducerEntity pe = pem.getProducerEntity(producerID);
                    ServiceDescription sd = pe.getServiceDescription();
                    ItemDescription[] ucds = sd.getUserCategoryDescriptions();
                    if (ucds != null && ucds.length > 0) {
                        userCategoryMap = new HashMap<String, ArrayList<Object>>();
                        block3: for (int j = 0; j < ucds.length; ++j) {
                            String uc = ucds[j].getItemName();
                            for (int k = 0; k < values.size(); ++k) {
                                String ucm = (String)values.get(k);
                                if (!ucm.startsWith(uc)) continue;
                                int index = ucm.indexOf("=");
                                String roles = ucm.substring(index + 1);
                                StringTokenizer st = new StringTokenizer(roles, "|");
                                userCategoryMap.put(uc, Collections.list(st));
                                continue block3;
                            }
                        }
                    }
                    pem.setUserCategoryMapping(producerID, userCategoryMap);
                    continue;
                }
                if (name.equals("RegistrationRequired")) {
                    throw new PSMBeanException("RegistrationRequired is a read-only attribute.");
                }
                if (name.equals("RegistrationHandle")) {
                    throw new PSMBeanException("RegistrationHandle is a read-only attribute.");
                }
                if (name.equals("RegistrationPropertyDescription")) {
                    throw new PSMBeanException("RegistrationPropertyDescription is a read-only attribute.");
                }
                if (name.equals("RegistrationProperties")) {
                    this.setRegProp(values, optionsMap, set, pem, producerID);
                    continue;
                }
                logger.log(Level.SEVERE, "PSWS_CSPWCAB0022", name);
                throw new PSMBeanException("No such configured producer attribute: " + name);
            }
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0023", (Throwable)((Object)e));
            throw new PSMBeanException("PE error", e.getMessage());
        }
    }

    private ProducerEntityManager getPEM(String orgDN) throws PSMBeanException {
        try {
            return pemFactory.getProducerEntityManager(AdminServerUtil.getSSOToken(), this.portalId, orgDN);
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0024", (Throwable)((Object)e));
            throw new PSMBeanException("Can't get PEM.", e.getMessage());
        }
    }

    private void checkSingleton(String attributeName, List values, boolean set) throws PSMBeanException {
        if (!set) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0025", attributeName);
            throw new PSMBeanException(attributeName + " does not allow add or remove.");
        }
        if (values.size() != 1) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0026", attributeName);
            throw new PSMBeanException(attributeName + " requires one and only one value specified.");
        }
    }

    private void setRegProp(List values, Map optionsMap, boolean set, ProducerEntityManager pem, String producerID) throws WSRPConsumerException {
        PropertyDescription[] pds;
        ProducerEntity pe = pem.getProducerEntity(producerID);
        RegistrationData regData = pe.getRegistrationData();
        if (regData == null) {
            regData = pem.getDefaultRegistrationData();
        }
        Property[] oldValues = regData.getRegistrationProperties();
        Property[] newValues = null;
        ServiceDescription sd = pe.getServiceDescription();
        ModelDescription md = sd.getRegistrationPropertyDescription();
        if (md != null && (pds = md.getPropertyDescriptions()) != null) {
            newValues = new Property[pds.length];
            for (int i = 0; i < pds.length; ++i) {
                String name = pds[i].getName();
                String value = null;
                if (oldValues != null) {
                    for (int j = 0; j < oldValues.length; ++j) {
                        if (!oldValues[j].getName().equals(name)) continue;
                        value = oldValues[j].getStringValue();
                        break;
                    }
                }
                if (set) {
                    value = this.getLastValueForName(name, values);
                } else {
                    String v;
                    List removeValues;
                    String v2;
                    List addValues = (List)optionsMap.get("add");
                    if (addValues != null && (v2 = this.getLastValueForName(name, addValues)) != null) {
                        value = v2;
                    }
                    if ((removeValues = (List)optionsMap.get("remove")) != null && (v = this.getLastValueForName(name, removeValues)) != null) {
                        value = null;
                    }
                }
                newValues[i] = new Property(name, LANG, value, null);
            }
        }
        regData.setRegistrationProperties(newValues);
        pem.modifyRegistration(producerID, regData);
    }

    private String getLastValueForName(String name, List properties) {
        String result = null;
        for (int i = 0; i < properties.size(); ++i) {
            String n = null;
            String v = null;
            String property = (String)properties.get(i);
            int index = property.indexOf("=");
            if (index >= 0) {
                n = property.substring(0, index).trim();
                v = property.substring(index + 1).trim();
            } else {
                n = property.trim();
                v = "";
            }
            if (!n.equals(name)) continue;
            result = v;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

