/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.wsrp.consumer.admin.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.taskadmin.ChannelTaskAdmin;
import com.sun.portal.wsrp.common.stubs.LocalizedString;
import com.sun.portal.wsrp.common.stubs.PortletDescription;
import com.sun.portal.wsrp.common.stubs.ServiceDescription;
import com.sun.portal.wsrp.consumer.admin.mbeans.AMHelper;
import com.sun.portal.wsrp.consumer.admin.mbeans.ConfiguredProducerMBean;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerBootstrap;
import com.sun.portal.wsrp.consumer.common.WSRPConsumerException;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntity;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManager;
import com.sun.portal.wsrp.consumer.producermanager.ProducerEntityManagerFactory;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ConfiguredProducer
extends PSResource
implements ConfiguredProducerMBean {
    private String portalId = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$wsrp$consumer$admin$mbeans$ConfiguredProducer == null ? (class$com$sun$portal$wsrp$consumer$admin$mbeans$ConfiguredProducer = ConfiguredProducer.class$("com.sun.portal.wsrp.consumer.admin.mbeans.ConfiguredProducer")) : class$com$sun$portal$wsrp$consumer$admin$mbeans$ConfiguredProducer));
    private String wsrpConsumerConfigFileName = "wsrpconsumerconfig.properties";
    static /* synthetic */ Class class$com$sun$portal$wsrp$consumer$admin$mbeans$ConfiguredProducer;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.portalId = (String)path.get(2);
    }

    public void updateServiceDescription(String orgDN, String producerId) throws PSMBeanException {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            WSRPConsumerBootstrap.cliInitialized(this.wsrpConsumerConfigFileName, this.portalId);
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(AdminServerUtil.getSSOToken(), this.portalId, orgDN);
            try {
                pem.updateServiceDescription(producerId);
            }
            catch (WSRPConsumerException e) {
                logger.log(Level.SEVERE, "PSWS_CSPWCAB0027", (Throwable)((Object)e));
                throw new PSMBeanException("wsrp.consumer", e.getMessage());
            }
        }
        catch (WSRPConsumerException e) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0003", (Throwable)((Object)e));
            throw new PSMBeanException("wsrp.consumer", e.getMessage());
        }
    }

    public Map getPortlets(String dn) throws PSMBeanException {
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            String orgDN = AMHelper.getOrganizationDN(dn);
            WSRPConsumerBootstrap.cliInitialized(this.wsrpConsumerConfigFileName, this.portalId);
            ProducerEntityManager pem = ProducerEntityManagerFactory.getInstance().getProducerEntityManager(AdminServerUtil.getSSOToken(), this.portalId, orgDN);
            ProducerEntity pe = pem.getProducerEntity(this.getID());
            ServiceDescription sd = pe.getServiceDescription();
            PortletDescription[] portlets = sd.getOfferedPortlets();
            for (int i = 0; portlets != null && i < portlets.length; ++i) {
                String handle;
                Boolean usesMethodGet = portlets[i].getUsesMethodGet();
                if (usesMethodGet != null && usesMethodGet.booleanValue()) continue;
                String displayName = handle = portlets[i].getPortletHandle();
                LocalizedString name = portlets[i].getDisplayName();
                if (name != null && name.getValue() != null) {
                    displayName = name.getValue();
                }
                result.put(handle, displayName);
            }
            return result;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSWS_CSPWCAB0028", e);
            throw new PSMBeanException("wsrp.consumer", e.getMessage());
        }
    }

    public void createRemoteChannel(String dn, String channelName, String portletHandle) throws PSMBeanException {
        try {
            String orgDN = AMHelper.getOrganizationDN(dn);
            ChannelTaskAdmin cta = new ChannelTaskAdmin(AdminServerUtil.getSSOToken(), dn, this.portalId);
            cta.createChannel(channelName, "_WSRPProvider");
            cta.setStringProperty(channelName, "consumerID", orgDN, null);
            cta.setStringProperty(channelName, "producerEntityID", this.getID(), null);
            cta.setStringProperty(channelName, "portletID", portletHandle, null);
            cta.setStringProperty(channelName, "portletHandle", portletHandle, null);
            cta.store();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
            throw new PSMBeanException("wsrp.consumer", e.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

